/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.unmarshalling.sse;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.impl.settings.ServerSentEventSettingsImpl$;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.sse.ServerSentEvent;
import org.apache.pekko.http.scaladsl.settings.ServerSentEventSettings;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$EnhancedFromEntityUnmarshaller$;
import org.apache.pekko.http.scaladsl.unmarshalling.sse.EventStreamParser$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.runtime.ScalaRunTime$;

@ApiMayChange
public interface EventStreamUnmarshalling {
    public static void $init$(EventStreamUnmarshalling $this) {
        $this.org$apache$pekko$http$scaladsl$unmarshalling$sse$EventStreamUnmarshalling$_setter_$fromEventStream_$eq($this.fromEventsStream($this.maxEventSize(), $this.maxLineSize(), false));
    }

    public static int maxLineSize$(EventStreamUnmarshalling $this) {
        return $this.maxLineSize();
    }

    default public int maxLineSize() {
        return 4096;
    }

    public static int maxEventSize$(EventStreamUnmarshalling $this) {
        return $this.maxEventSize();
    }

    default public int maxEventSize() {
        return 8192;
    }

    public Unmarshaller<HttpEntity, Source<ServerSentEvent, NotUsed>> fromEventStream();

    public void org$apache$pekko$http$scaladsl$unmarshalling$sse$EventStreamUnmarshalling$_setter_$fromEventStream_$eq(Unmarshaller var1);

    public static Unmarshaller fromEventsStream$(EventStreamUnmarshalling $this, ActorSystem system) {
        return $this.fromEventsStream(system);
    }

    default public Unmarshaller<HttpEntity, Source<ServerSentEvent, NotUsed>> fromEventsStream(ActorSystem system) {
        return this.fromEventsStream((ServerSentEventSettings)ServerSentEventSettingsImpl$.MODULE$.apply(system));
    }

    public static Unmarshaller fromEventsStream$(EventStreamUnmarshalling $this, ServerSentEventSettings settings) {
        return $this.fromEventsStream(settings);
    }

    default public Unmarshaller<HttpEntity, Source<ServerSentEvent, NotUsed>> fromEventsStream(ServerSentEventSettings settings) {
        return this.fromEventsStream(settings.maxLineSize(), settings.maxEventSize(), settings.emitEmptyEvents());
    }

    private Unmarshaller<HttpEntity, Source<ServerSentEvent, NotUsed>> fromEventsStream(int maxLineSize, int maxEventSize, boolean emitEmptyEvents) {
        Flow<ByteString, ServerSentEvent, NotUsed> eventStreamParser = EventStreamParser$.MODULE$.apply(maxLineSize, maxEventSize, emitEmptyEvents);
        Unmarshaller unmarshaller = Unmarshaller$.MODULE$.EnhancedFromEntityUnmarshaller(Unmarshaller$.MODULE$.strict((Function1<HttpEntity, Source> & Serializable)entity -> EventStreamUnmarshalling.unmarshal$1(eventStreamParser, entity)));
        return Unmarshaller$EnhancedFromEntityUnmarshaller$.MODULE$.forContentTypes$extension(unmarshaller, ScalaRunTime$.MODULE$.wrapRefArray(new ContentTypeRange[]{ContentTypeRange$.MODULE$.apply(MediaTypes$.MODULE$.text$divevent$minusstream())}));
    }

    private static Source unmarshal$1(Flow eventStreamParser$1, HttpEntity entity) {
        return entity.withoutSizeLimit().dataBytes().viaMat((Graph)eventStreamParser$1, Keep$.MODULE$.none());
    }
}

