/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.unmarshalling;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.FormData;
import org.apache.pekko.http.scaladsl.model.FormData$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.IllegalUriException;
import org.apache.pekko.http.scaladsl.model.IllegalUriException$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.unmarshalling.MultipartUnmarshallers;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$EnhancedFromEntityUnmarshaller$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$EnhancedUnmarshaller$;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.parboiled2.ParserInput$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public interface PredefinedFromEntityUnmarshallers
extends MultipartUnmarshallers {
    public static Unmarshaller byteStringUnmarshaller$(PredefinedFromEntityUnmarshallers $this) {
        return $this.byteStringUnmarshaller();
    }

    default public Unmarshaller<HttpEntity, ByteString> byteStringUnmarshaller() {
        return Unmarshaller$.MODULE$.withMaterializer((Function1<ExecutionContext, Function1> & Serializable)_$1 -> (Function1<Materializer, Function1> & Serializable)mat -> (Function1<HttpEntity, Future> & Serializable)x$1 -> {
            HttpEntity httpEntity = x$1;
            if (httpEntity instanceof HttpEntity.Strict) {
                ByteString byteString;
                HttpEntity.Strict strict = HttpEntity$Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
                ContentType contentType = strict._1();
                ByteString data = byteString = strict._2();
                return FastFuture$.MODULE$.successful().apply(data);
            }
            HttpEntity entity = httpEntity;
            return entity.dataBytes().runFold(ByteString$.MODULE$.empty(), (Function2<ByteString, ByteString, ByteString> & Serializable)(_$2, _$3) -> _$2.$plus$plus((ByteString)_$3), (Materializer)mat);
        });
    }

    public static Unmarshaller byteArrayUnmarshaller$(PredefinedFromEntityUnmarshallers $this) {
        return $this.byteArrayUnmarshaller();
    }

    default public Unmarshaller<HttpEntity, byte[]> byteArrayUnmarshaller() {
        return this.byteStringUnmarshaller().map((Function1<ByteString, byte[]> & Serializable)_$4 -> (byte[])_$4.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static Unmarshaller charArrayUnmarshaller$(PredefinedFromEntityUnmarshallers $this) {
        return $this.charArrayUnmarshaller();
    }

    default public Unmarshaller<HttpEntity, char[]> charArrayUnmarshaller() {
        Unmarshaller unmarshaller = Unmarshaller$.MODULE$.EnhancedUnmarshaller(this.byteStringUnmarshaller());
        return Unmarshaller$EnhancedUnmarshaller$.MODULE$.mapWithInput$extension(unmarshaller, (Function2<HttpEntity, ByteString, char[]> & Serializable)(entity, bytes) -> {
            if (entity.isKnownEmpty()) {
                return Array$.MODULE$.emptyCharArray();
            }
            CharBuffer charBuffer = Unmarshaller$.MODULE$.bestUnmarshallingCharsetFor((HttpEntity)entity).nioCharset().decode(bytes.asByteBuffer());
            char[] array = new char[charBuffer.length()];
            charBuffer.get(array);
            return array;
        });
    }

    public static Unmarshaller stringUnmarshaller$(PredefinedFromEntityUnmarshallers $this) {
        return $this.stringUnmarshaller();
    }

    default public Unmarshaller<HttpEntity, String> stringUnmarshaller() {
        Unmarshaller unmarshaller = Unmarshaller$.MODULE$.EnhancedUnmarshaller(this.byteStringUnmarshaller());
        return Unmarshaller$EnhancedUnmarshaller$.MODULE$.mapWithInput$extension(unmarshaller, (Function2<HttpEntity, ByteString, String> & Serializable)(entity, bytes) -> {
            if (entity.isKnownEmpty()) {
                return "";
            }
            return bytes.decodeString(Unmarshaller$.MODULE$.bestUnmarshallingCharsetFor((HttpEntity)entity).nioCharset());
        });
    }

    public static Unmarshaller defaultUrlEncodedFormDataUnmarshaller$(PredefinedFromEntityUnmarshallers $this) {
        return $this.defaultUrlEncodedFormDataUnmarshaller();
    }

    default public Unmarshaller<HttpEntity, FormData> defaultUrlEncodedFormDataUnmarshaller() {
        return this.urlEncodedFormDataUnmarshaller(ScalaRunTime$.MODULE$.wrapRefArray(new ContentTypeRange[]{ContentTypeRange$.MODULE$.apply(MediaTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded())}));
    }

    public static Unmarshaller urlEncodedFormDataUnmarshaller$(PredefinedFromEntityUnmarshallers $this, Seq ranges) {
        return $this.urlEncodedFormDataUnmarshaller(ranges);
    }

    default public Unmarshaller<HttpEntity, FormData> urlEncodedFormDataUnmarshaller(Seq<ContentTypeRange> ranges) {
        Unmarshaller unmarshaller = Unmarshaller$.MODULE$.EnhancedFromEntityUnmarshaller(this.stringUnmarshaller());
        Unmarshaller unmarshaller2 = Unmarshaller$.MODULE$.EnhancedUnmarshaller(Unmarshaller$EnhancedFromEntityUnmarshaller$.MODULE$.forContentTypes$extension(unmarshaller, ranges));
        return Unmarshaller$EnhancedUnmarshaller$.MODULE$.mapWithInput$extension(unmarshaller2, (Function2<HttpEntity, String, FormData> & Serializable)(entity, string2) -> {
            FormData formData;
            if (entity.isKnownEmpty()) {
                return FormData$.MODULE$.Empty();
            }
            try {
                formData = FormData$.MODULE$.apply(Uri$Query$.MODULE$.apply(ParserInput$.MODULE$.apply((String)string2), Unmarshaller$.MODULE$.bestUnmarshallingCharsetFor((HttpEntity)entity).nioCharset(), Uri$Query$.MODULE$.apply$default$3()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalUriException) {
                    ErrorInfo errorInfo;
                    IllegalUriException illegalUriException = IllegalUriException$.MODULE$.unapply((IllegalUriException)throwable2);
                    ErrorInfo info = errorInfo = illegalUriException._1();
                    throw new IllegalArgumentException(info.formatPretty().replace("Query,", "form content,"));
                }
                throw throwable;
            }
            return formData;
        });
    }
}

