/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.unmarshalling;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.NoLogging$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$BodyPartStart$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$ParseError$;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaRanges$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.Multipart$ByteRanges$;
import org.apache.pekko.http.scaladsl.model.Multipart$ByteRanges$Strict$;
import org.apache.pekko.http.scaladsl.model.Multipart$FormData$;
import org.apache.pekko.http.scaladsl.model.Multipart$FormData$Strict$;
import org.apache.pekko.http.scaladsl.model.Multipart$General$;
import org.apache.pekko.http.scaladsl.model.Multipart$General$BodyPart$;
import org.apache.pekko.http.scaladsl.model.Multipart$General$BodyPart$Strict$;
import org.apache.pekko.http.scaladsl.model.Multipart$General$Strict$;
import org.apache.pekko.http.scaladsl.model.ParsingException$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$UnsupportedContentTypeException$;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.ActorMaterializerHelper$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.SubFlow;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public interface MultipartUnmarshallers {
    public static Unmarshaller defaultMultipartGeneralUnmarshaller$(MultipartUnmarshallers $this, LoggingAdapter log, ParserSettings parserSettings) {
        return $this.defaultMultipartGeneralUnmarshaller(log, parserSettings);
    }

    default public Unmarshaller<HttpEntity, Multipart.General> defaultMultipartGeneralUnmarshaller(LoggingAdapter log, ParserSettings parserSettings) {
        return this.multipartGeneralUnmarshaller(HttpCharsets$.MODULE$.UTF$minus8(), log, parserSettings);
    }

    public static LoggingAdapter defaultMultipartGeneralUnmarshaller$default$1$(MultipartUnmarshallers $this) {
        return $this.defaultMultipartGeneralUnmarshaller$default$1();
    }

    default public LoggingAdapter defaultMultipartGeneralUnmarshaller$default$1() {
        return NoLogging$.MODULE$;
    }

    public static ParserSettings defaultMultipartGeneralUnmarshaller$default$2$(MultipartUnmarshallers $this) {
        return $this.defaultMultipartGeneralUnmarshaller$default$2();
    }

    default public ParserSettings defaultMultipartGeneralUnmarshaller$default$2() {
        return null;
    }

    public static Unmarshaller multipartGeneralUnmarshaller$(MultipartUnmarshallers $this, HttpCharset defaultCharset, LoggingAdapter log, ParserSettings parserSettings) {
        return $this.multipartGeneralUnmarshaller(defaultCharset, log, parserSettings);
    }

    default public Unmarshaller<HttpEntity, Multipart.General> multipartGeneralUnmarshaller(HttpCharset defaultCharset, LoggingAdapter log, ParserSettings parserSettings) {
        return this.multipartUnmarshaller(MediaRanges$.MODULE$.multipart$div$times(), MediaTypes$.MODULE$.text$divplain().withCharset(defaultCharset), (Function2<BodyPartEntity, List, Multipart.General.BodyPart> & Serializable)(_$1, _$2) -> Multipart$General$BodyPart$.MODULE$.apply((BodyPartEntity)_$1, (scala.collection.immutable.Seq<HttpHeader>)_$2), (Function2<MediaType.Multipart, Source, Multipart.General> & Serializable)(_$3, _$4) -> Multipart$General$.MODULE$.apply((MediaType.Multipart)_$3, (Source<Multipart.General.BodyPart, Object>)_$4), (Function2<HttpEntity.Strict, List, Multipart.General.BodyPart.Strict> & Serializable)(entity, headers) -> Multipart$General$BodyPart$Strict$.MODULE$.apply((HttpEntity.Strict)entity, (scala.collection.immutable.Seq<HttpHeader>)headers), (Function2<MediaType.Multipart, scala.collection.immutable.Seq, Multipart.General> & Serializable)(mediaType, strictParts) -> Multipart$General$Strict$.MODULE$.apply((MediaType.Multipart)mediaType, (scala.collection.immutable.Seq<Multipart.General.BodyPart.Strict>)strictParts), log, parserSettings);
    }

    public static LoggingAdapter multipartGeneralUnmarshaller$default$2$(MultipartUnmarshallers $this, HttpCharset defaultCharset) {
        return $this.multipartGeneralUnmarshaller$default$2(defaultCharset);
    }

    default public LoggingAdapter multipartGeneralUnmarshaller$default$2(HttpCharset defaultCharset) {
        return NoLogging$.MODULE$;
    }

    public static ParserSettings multipartGeneralUnmarshaller$default$3$(MultipartUnmarshallers $this, HttpCharset defaultCharset) {
        return $this.multipartGeneralUnmarshaller$default$3(defaultCharset);
    }

    default public ParserSettings multipartGeneralUnmarshaller$default$3(HttpCharset defaultCharset) {
        return null;
    }

    public static Unmarshaller multipartFormDataUnmarshaller$(MultipartUnmarshallers $this, LoggingAdapter log, ParserSettings parserSettings) {
        return $this.multipartFormDataUnmarshaller(log, parserSettings);
    }

    default public Unmarshaller<HttpEntity, Multipart.FormData> multipartFormDataUnmarshaller(LoggingAdapter log, ParserSettings parserSettings) {
        return this.multipartUnmarshaller(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.multipart$divform$minusdata()), ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), (Function2<BodyPartEntity, List, Multipart.FormData.BodyPart> & Serializable)(entity, headers) -> Multipart$General$BodyPart$.MODULE$.apply((BodyPartEntity)entity, (scala.collection.immutable.Seq<HttpHeader>)headers).toFormDataBodyPart().get(), (Function2<MediaType.Multipart, Source, Multipart.FormData> & Serializable)(_$5, parts) -> Multipart$FormData$.MODULE$.apply((Source<Multipart.FormData.BodyPart, Object>)parts), (Function2<HttpEntity.Strict, List, Multipart.FormData.BodyPart.Strict> & Serializable)(entity, headers) -> Multipart$General$BodyPart$Strict$.MODULE$.apply((HttpEntity.Strict)entity, (scala.collection.immutable.Seq<HttpHeader>)headers).toFormDataBodyPart().get(), (Function2<MediaType.Multipart, scala.collection.immutable.Seq, Multipart.FormData> & Serializable)(_$6, parts) -> Multipart$FormData$Strict$.MODULE$.apply((scala.collection.immutable.Seq<Multipart.FormData.BodyPart.Strict>)parts), log, parserSettings);
    }

    public static LoggingAdapter multipartFormDataUnmarshaller$default$1$(MultipartUnmarshallers $this) {
        return $this.multipartFormDataUnmarshaller$default$1();
    }

    default public LoggingAdapter multipartFormDataUnmarshaller$default$1() {
        return NoLogging$.MODULE$;
    }

    public static ParserSettings multipartFormDataUnmarshaller$default$2$(MultipartUnmarshallers $this) {
        return $this.multipartFormDataUnmarshaller$default$2();
    }

    default public ParserSettings multipartFormDataUnmarshaller$default$2() {
        return null;
    }

    public static Unmarshaller defaultMultipartByteRangesUnmarshaller$(MultipartUnmarshallers $this, LoggingAdapter log, ParserSettings parserSettings) {
        return $this.defaultMultipartByteRangesUnmarshaller(log, parserSettings);
    }

    default public Unmarshaller<HttpEntity, Multipart.ByteRanges> defaultMultipartByteRangesUnmarshaller(LoggingAdapter log, ParserSettings parserSettings) {
        return this.multipartByteRangesUnmarshaller(HttpCharsets$.MODULE$.UTF$minus8(), log, parserSettings);
    }

    public static LoggingAdapter defaultMultipartByteRangesUnmarshaller$default$1$(MultipartUnmarshallers $this) {
        return $this.defaultMultipartByteRangesUnmarshaller$default$1();
    }

    default public LoggingAdapter defaultMultipartByteRangesUnmarshaller$default$1() {
        return NoLogging$.MODULE$;
    }

    public static ParserSettings defaultMultipartByteRangesUnmarshaller$default$2$(MultipartUnmarshallers $this) {
        return $this.defaultMultipartByteRangesUnmarshaller$default$2();
    }

    default public ParserSettings defaultMultipartByteRangesUnmarshaller$default$2() {
        return null;
    }

    public static Unmarshaller multipartByteRangesUnmarshaller$(MultipartUnmarshallers $this, HttpCharset defaultCharset, LoggingAdapter log, ParserSettings parserSettings) {
        return $this.multipartByteRangesUnmarshaller(defaultCharset, log, parserSettings);
    }

    default public Unmarshaller<HttpEntity, Multipart.ByteRanges> multipartByteRangesUnmarshaller(HttpCharset defaultCharset, LoggingAdapter log, ParserSettings parserSettings) {
        return this.multipartUnmarshaller(MediaRange$.MODULE$.apply(MediaTypes$.MODULE$.multipart$divbyteranges()), MediaTypes$.MODULE$.text$divplain().withCharset(defaultCharset), (Function2<BodyPartEntity, List, Multipart.ByteRanges.BodyPart> & Serializable)(entity, headers) -> Multipart$General$BodyPart$.MODULE$.apply((BodyPartEntity)entity, (scala.collection.immutable.Seq<HttpHeader>)headers).toByteRangesBodyPart().get(), (Function2<MediaType.Multipart, Source, Multipart.ByteRanges> & Serializable)(_$7, parts) -> Multipart$ByteRanges$.MODULE$.apply((Source<Multipart.ByteRanges.BodyPart, Object>)parts), (Function2<HttpEntity.Strict, List, Multipart.ByteRanges.BodyPart.Strict> & Serializable)(entity, headers) -> Multipart$General$BodyPart$Strict$.MODULE$.apply((HttpEntity.Strict)entity, (scala.collection.immutable.Seq<HttpHeader>)headers).toByteRangesBodyPart().get(), (Function2<MediaType.Multipart, scala.collection.immutable.Seq, Multipart.ByteRanges> & Serializable)(_$8, parts) -> Multipart$ByteRanges$Strict$.MODULE$.apply((scala.collection.immutable.Seq<Multipart.ByteRanges.BodyPart.Strict>)parts), log, parserSettings);
    }

    public static LoggingAdapter multipartByteRangesUnmarshaller$default$2$(MultipartUnmarshallers $this, HttpCharset defaultCharset) {
        return $this.multipartByteRangesUnmarshaller$default$2(defaultCharset);
    }

    default public LoggingAdapter multipartByteRangesUnmarshaller$default$2(HttpCharset defaultCharset) {
        return NoLogging$.MODULE$;
    }

    public static ParserSettings multipartByteRangesUnmarshaller$default$3$(MultipartUnmarshallers $this, HttpCharset defaultCharset) {
        return $this.multipartByteRangesUnmarshaller$default$3(defaultCharset);
    }

    default public ParserSettings multipartByteRangesUnmarshaller$default$3(HttpCharset defaultCharset) {
        return null;
    }

    public static Unmarshaller multipartUnmarshaller$(MultipartUnmarshallers $this, MediaRange mediaRange, ContentType defaultContentType, Function2 createBodyPart, Function2 createStreamed, Function2 createStrictBodyPart, Function2 createStrict, LoggingAdapter log, ParserSettings parserSettings) {
        return $this.multipartUnmarshaller(mediaRange, defaultContentType, createBodyPart, createStreamed, createStrictBodyPart, createStrict, log, parserSettings);
    }

    default public <T extends Multipart, BP extends Multipart.BodyPart, BPS extends Multipart.BodyPart.Strict> Unmarshaller<HttpEntity, T> multipartUnmarshaller(MediaRange mediaRange, ContentType defaultContentType, Function2<BodyPartEntity, List<HttpHeader>, BP> createBodyPart, Function2<MediaType.Multipart, Source<BP, Object>, T> createStreamed, Function2<HttpEntity.Strict, List<HttpHeader>, BPS> createStrictBodyPart, Function2<MediaType.Multipart, scala.collection.immutable.Seq<BPS>, T> createStrict, LoggingAdapter log, ParserSettings parserSettings) {
        return Unmarshaller$.MODULE$.withMaterializer((Function1<ExecutionContext, Function1> & Serializable)ec -> (Function1<Materializer, Function1> & Serializable)mat -> (Function1<HttpEntity, Future> & Serializable)entity -> {
            if (entity.contentType().mediaType().isMultipart() && mediaRange.matches(entity.contentType().mediaType())) {
                Option option = entity.contentType().mediaType().params().get("boundary");
                if (None$.MODULE$.equals(option)) {
                    return FastFuture$.MODULE$.failed().apply(new RuntimeException("Content-Type with a multipart media type must have a 'boundary' parameter"));
                }
                if (option instanceof Some) {
                    String boundary2 = (String)((Some)option).value();
                    ParserSettings effectiveParserSettings = (ParserSettings)Option$.MODULE$.apply(parserSettings).getOrElse(() -> MultipartUnmarshallers.$anonfun$1(mat));
                    BodyPartParser parser = new BodyPartParser(defaultContentType, boundary2, log, effectiveParserSettings);
                    HttpEntity httpEntity = entity;
                    if (httpEntity instanceof HttpEntity.Strict) {
                        Tuple2<MediaType, Option<HttpCharset>> tuple2;
                        MediaType mediaType;
                        Option<Tuple2<MediaType, Option<HttpCharset>>> option2;
                        HttpEntity.Strict strict = HttpEntity$Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
                        ContentType contentType = strict._1();
                        ByteString byteString = strict._2();
                        if (contentType != null && !(option2 = ContentType$.MODULE$.unapply(contentType)).isEmpty() && (mediaType = (tuple2 = option2.get())._1()) instanceof MediaType.Multipart) {
                            MediaType.Multipart mediaType2 = (MediaType.Multipart)mediaType;
                            ByteString data = byteString;
                            return ((Source)Source$.MODULE$.single(data).via((Graph)parser)).runFold(new VectorBuilder(), (Function2<VectorBuilder, BodyPartParser.Output, VectorBuilder> & Serializable)(builder, output) -> {
                                BodyPartParser.Output output2 = output;
                                if (output2 instanceof BodyPartParser.BodyPartStart) {
                                    BodyPartParser.BodyPartStart bodyPartStart = BodyPartParser$BodyPartStart$.MODULE$.unapply((BodyPartParser.BodyPartStart)output2);
                                    List<HttpHeader> list = bodyPartStart._1();
                                    Function1<Source<BodyPartParser.Output, NotUsed>, BodyPartEntity> function1 = bodyPartStart._2();
                                    List<HttpHeader> headers = list;
                                    Function1<Source<BodyPartParser.Output, NotUsed>, BodyPartEntity> createEntity = function1;
                                    BodyPartEntity bodyPartEntity = createEntity.apply(Source$.MODULE$.empty());
                                    if (!(bodyPartEntity instanceof HttpEntity.Strict)) {
                                        BodyPartEntity x = bodyPartEntity;
                                        throw new IllegalStateException(new StringBuilder(51).append("Unexpected entity type from strict BodyPartParser: ").append(x).toString());
                                    }
                                    HttpEntity.Strict x = (HttpEntity.Strict)bodyPartEntity;
                                    HttpEntity.Strict entity = x;
                                    return (VectorBuilder)builder.$plus$eq(createStrictBodyPart.apply(entity, headers));
                                }
                                if (output2 instanceof BodyPartParser.ParseError) {
                                    ErrorInfo errorInfo;
                                    BodyPartParser.ParseError parseError = BodyPartParser$ParseError$.MODULE$.unapply((BodyPartParser.ParseError)output2);
                                    ErrorInfo errorInfo2 = errorInfo = parseError._1();
                                    throw ParsingException$.MODULE$.apply(errorInfo2);
                                }
                                BodyPartParser.Output x = output2;
                                throw new IllegalStateException(new StringBuilder(48).append("Unexpected BodyPartParser result ").append(x).append(" in strict case").toString());
                            }, (Materializer)mat).map((Function1<VectorBuilder, Multipart> & Serializable)builder -> (Multipart)createStrict.apply(mediaType2, (scala.collection.immutable.Seq)builder.result()), (ExecutionContext)ec);
                        }
                    }
                    Source bodyParts = (Source)((SubFlow)((Source)entity.dataBytes().via((Graph)parser)).splitWhen((Function1<BodyPartParser.Output, boolean> & Serializable)_$9 -> _$9 instanceof BodyPartParser.PartStart).prefixAndTail(1).collect(new Serializable(createBodyPart, (Materializer)mat){
                        private final Function2 createBodyPart$4;
                        private final Materializer mat$3;
                        {
                            this.createBodyPart$4 = createBodyPart$5;
                            this.mat$3 = mat$4;
                        }

                        public final boolean isDefinedAt(Tuple2 x) {
                            Tuple2 tuple2 = x;
                            if (tuple2 != null) {
                                SeqOps<A, Seq, Seq<A>> seqOps;
                                scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple2._1();
                                Source source = (Source)tuple2._2();
                                if (seq != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq), 1) == 0) {
                                    BodyPartParser.Output output = (BodyPartParser.Output)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                                    if (output instanceof BodyPartParser.BodyPartStart) {
                                        BodyPartParser.BodyPartStart bodyPartStart = BodyPartParser$BodyPartStart$.MODULE$.unapply((BodyPartParser.BodyPartStart)output);
                                        List<HttpHeader> list = bodyPartStart._1();
                                        Function1<Source<BodyPartParser.Output, NotUsed>, BodyPartEntity> function1 = bodyPartStart._2();
                                        List<HttpHeader> headers = list;
                                        Function1<Source<BodyPartParser.Output, NotUsed>, BodyPartEntity> createEntity = function1;
                                        Source entityParts = source;
                                        return true;
                                    }
                                    if (output instanceof BodyPartParser.ParseError) {
                                        ErrorInfo errorInfo;
                                        BodyPartParser.ParseError parseError = BodyPartParser$ParseError$.MODULE$.unapply((BodyPartParser.ParseError)output);
                                        ErrorInfo errorInfo2 = errorInfo = parseError._1();
                                        Source rest = source;
                                        return true;
                                    }
                                }
                            }
                            return false;
                        }

                        public final Object applyOrElse(Tuple2 x, Function1 function1) {
                            Tuple2 tuple2 = x;
                            if (tuple2 != null) {
                                SeqOps<A, Seq, Seq<A>> seqOps;
                                scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple2._1();
                                Source source = (Source)tuple2._2();
                                if (seq != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq), 1) == 0) {
                                    BodyPartParser.Output output = (BodyPartParser.Output)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                                    if (output instanceof BodyPartParser.BodyPartStart) {
                                        BodyPartParser.BodyPartStart bodyPartStart = BodyPartParser$BodyPartStart$.MODULE$.unapply((BodyPartParser.BodyPartStart)output);
                                        List<HttpHeader> list = bodyPartStart._1();
                                        Function1<Source<BodyPartParser.Output, NotUsed>, BodyPartEntity> function12 = bodyPartStart._2();
                                        List<HttpHeader> headers = list;
                                        Function1<Source<BodyPartParser.Output, NotUsed>, BodyPartEntity> createEntity = function12;
                                        Source entityParts = source;
                                        return this.createBodyPart$4.apply(createEntity.apply(entityParts), headers);
                                    }
                                    if (output instanceof BodyPartParser.ParseError) {
                                        ErrorInfo errorInfo;
                                        BodyPartParser.ParseError parseError = BodyPartParser$ParseError$.MODULE$.unapply((BodyPartParser.ParseError)output);
                                        ErrorInfo errorInfo2 = errorInfo = parseError._1();
                                        Source rest = source;
                                        StreamUtils$.MODULE$.cancelSource(rest, this.mat$3);
                                        throw ParsingException$.MODULE$.apply(errorInfo2);
                                    }
                                }
                            }
                            return function1.apply(x);
                        }
                    })).concatSubstreams();
                    return FastFuture$.MODULE$.successful().apply(createStreamed.apply((MediaType.Multipart)entity.contentType().mediaType(), bodyParts));
                }
                throw new MatchError(option);
            }
            return FastFuture$.MODULE$.failed().apply(Unmarshaller$UnsupportedContentTypeException$.MODULE$.apply(Some$.MODULE$.apply(entity.contentType()), ScalaRunTime$.MODULE$.wrapRefArray(new ContentTypeRange[]{ContentTypeRange$.MODULE$.apply(mediaRange)})));
        });
    }

    public static LoggingAdapter multipartUnmarshaller$default$7$(MultipartUnmarshallers $this, MediaRange mediaRange, ContentType defaultContentType, Function2 createBodyPart, Function2 createStreamed, Function2 createStrictBodyPart, Function2 createStrict) {
        return $this.multipartUnmarshaller$default$7(mediaRange, defaultContentType, createBodyPart, createStreamed, createStrictBodyPart, createStrict);
    }

    default public <T extends Multipart, BP extends Multipart.BodyPart, BPS extends Multipart.BodyPart.Strict> LoggingAdapter multipartUnmarshaller$default$7(MediaRange mediaRange, ContentType defaultContentType, Function2<BodyPartEntity, List<HttpHeader>, BP> createBodyPart, Function2<MediaType.Multipart, Source<BP, Object>, T> createStreamed, Function2<HttpEntity.Strict, List<HttpHeader>, BPS> createStrictBodyPart, Function2<MediaType.Multipart, scala.collection.immutable.Seq<BPS>, T> createStrict) {
        return NoLogging$.MODULE$;
    }

    public static ParserSettings multipartUnmarshaller$default$8$(MultipartUnmarshallers $this, MediaRange mediaRange, ContentType defaultContentType, Function2 createBodyPart, Function2 createStreamed, Function2 createStrictBodyPart, Function2 createStrict) {
        return $this.multipartUnmarshaller$default$8(mediaRange, defaultContentType, createBodyPart, createStreamed, createStrictBodyPart, createStrict);
    }

    default public <T extends Multipart, BP extends Multipart.BodyPart, BPS extends Multipart.BodyPart.Strict> ParserSettings multipartUnmarshaller$default$8(MediaRange mediaRange, ContentType defaultContentType, Function2<BodyPartEntity, List<HttpHeader>, BP> createBodyPart, Function2<MediaType.Multipart, Source<BP, Object>, T> createStreamed, Function2<HttpEntity.Strict, List<HttpHeader>, BPS> createStrictBodyPart, Function2<MediaType.Multipart, scala.collection.immutable.Seq<BPS>, T> createStrict) {
        return null;
    }

    private static ParserSettings $anonfun$1(Materializer mat$2) {
        return (ParserSettings)ParserSettings$.MODULE$.apply(ActorMaterializerHelper$.MODULE$.downcast(mat$2).system());
    }
}

