/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.pekko.Done$;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$HttpEntityScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.MissingFormFieldRejection;
import org.apache.pekko.http.scaladsl.server.MissingFormFieldRejection$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.RouteResult$Rejected$;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.FileInfo;
import org.apache.pekko.http.scaladsl.server.directives.FileInfo$;
import org.apache.pekko.http.scaladsl.server.directives.FutureDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.MarshallingDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.OnSuccessMagnet$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.Tupler$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.FlowOpsMat;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.Tuple1;
import scala.Tuple1$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public interface FileUploadDirectives {
    public static Directive storeUploadedFile$(FileUploadDirectives $this, String fieldName, Function1 destFn) {
        return $this.storeUploadedFile(fieldName, destFn);
    }

    @ApiMayChange
    default public Directive<Tuple2<FileInfo, File>> storeUploadedFile(String fieldName, Function1<FileInfo, File> destFn) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequestContext());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<RequestContext, Directive> & Serializable)ctx -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(this.fileUpload(fieldName));
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<Tuple2, Directive> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    FileInfo fileInfo = (FileInfo)tuple2._1();
                    Source bytes = (Source)tuple2._2();
                    File dest = (File)destFn.apply(fileInfo);
                    Future<Tuple2<FileInfo, File>> uploadedF = bytes.runWith(FileIO$.MODULE$.toPath(dest.toPath(), FileIO$.MODULE$.toPath$default$2()), ctx.materializer()).flatMap((Function1<IOResult, Future> & Serializable)ioResult -> StreamUtils$.MODULE$.handleIOResult((IOResult)ioResult), ctx.executionContext()).map((Function1<IOResult, Tuple2> & Serializable)_$1 -> Tuple2$.MODULE$.apply(fileInfo, dest), ctx.executionContext()).recoverWith(new Serializable(dest){
                        private final File dest$2;
                        {
                            this.dest$2 = dest$4;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable;
                            Throwable ex = throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable;
                            Throwable ex = throwable = x;
                            this.dest$2.delete();
                            throw ex;
                        }
                    }, ctx.executionContext());
                    return FutureDirectives$.MODULE$.onSuccess(OnSuccessMagnet$.MODULE$.apply(() -> FileUploadDirectives.storeUploadedFile$$anonfun$1$$anonfun$1$$anonfun$1(uploadedF), Tupler$.MODULE$.forTuple(Tuple$.MODULE$.forTuple2())));
                }
                throw new MatchError(tuple2);
            }, Tuple$.MODULE$.forTuple2());
        }, Tuple$.MODULE$.forTuple2());
    }

    public static Directive storeUploadedFiles$(FileUploadDirectives $this, String fieldName, Function1 destFn) {
        return $this.storeUploadedFiles(fieldName, destFn);
    }

    @ApiMayChange
    default public Directive<Tuple1<Seq<Tuple2<FileInfo, File>>>> storeUploadedFiles(String fieldName, Function1<FileInfo, File> destFn) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(MarshallingDirectives$.MODULE$.entity(MarshallingDirectives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$1(), Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$2())))));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<Multipart.FormData, Directive> & Serializable)formData -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequestContext());
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<RequestContext, Directive> & Serializable)ctx -> {
                Materializer mat = ctx.materializer();
                ExecutionContextExecutor ec = ctx.executionContext();
                Source uploaded = (Source)formData.parts().mapConcat((Function1<Multipart.FormData.BodyPart, IterableOnce> & Serializable)part -> {
                    if (part.filename().isDefined()) {
                        String string2 = part.name();
                        String string3 = fieldName;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            return package$.MODULE$.Nil().$colon$colon(part);
                        }
                    }
                    HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar(part.entity()), mat);
                    return package$.MODULE$.Nil();
                }).mapAsync(1, (Function1<Multipart.FormData.BodyPart, Future> & Serializable)part -> {
                    FileInfo fileInfo = FileInfo$.MODULE$.apply(part.name(), part.filename().get(), part.entity().contentType());
                    File dest = (File)destFn.apply(fileInfo);
                    return part.entity().dataBytes().runWith(FileIO$.MODULE$.toPath(dest.toPath(), FileIO$.MODULE$.toPath$default$2()), mat).flatMap((Function1<IOResult, Future> & Serializable)ioResult -> StreamUtils$.MODULE$.handleIOResult((IOResult)ioResult), ec).map((Function1<IOResult, Tuple2> & Serializable)_$2 -> Tuple2$.MODULE$.apply(fileInfo, dest), ec);
                });
                Future uploadedF = uploaded.runWith(Sink$.MODULE$.seq(), mat);
                return FutureDirectives$.MODULE$.onSuccess(OnSuccessMagnet$.MODULE$.apply(() -> FileUploadDirectives.storeUploadedFiles$$anonfun$1$$anonfun$1$$anonfun$1(uploadedF), Tupler$.MODULE$.forAnyRef()));
            }, Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1());
    }

    public static Directive fileUpload$(FileUploadDirectives $this, String fieldName) {
        return $this.fileUpload(fieldName);
    }

    default public Directive<Tuple1<Tuple2<FileInfo, Source<ByteString, Object>>>> fileUpload(String fieldName) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(MarshallingDirectives$.MODULE$.entity(MarshallingDirectives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$1(), Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$2())))));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<Multipart.FormData, Directive> & Serializable)formData -> Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> {
            Promise done = Promise$.MODULE$.apply();
            ((Source)formData.parts().mapAsync(1, (Function1<Multipart.FormData.BodyPart, Future> & Serializable)x$1 -> {
                Multipart.FormData.BodyPart bodyPart;
                Multipart.FormData.BodyPart part = bodyPart = x$1;
                if (!done.isCompleted() && part.filename().isDefined()) {
                    String string2 = part.name();
                    String string3 = fieldName;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        Tuple2<FileInfo, Source<ByteString, Object>> data = Tuple2$.MODULE$.apply(FileInfo$.MODULE$.apply(part.name(), part.filename().get(), part.entity().contentType()), part.entity().dataBytes());
                        return ((Future)((Function1)inner.apply(Tuple1$.MODULE$.apply(data))).apply(ctx)).map((Function1<RouteResult, Promise> & Serializable)result -> done.success(result), ctx.executionContext());
                    }
                }
                Multipart.FormData.BodyPart part2 = bodyPart;
                return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar(part2.entity()), ctx.materializer()).future();
            })).runWith(Sink$.MODULE$.ignore(), ctx.materializer()).onComplete((Function1<Try, Object> & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success && Done$.MODULE$.equals(((Success)try_).value())) {
                    if (done.isCompleted()) {
                        return BoxedUnit.UNIT;
                    }
                    MissingFormFieldRejection missingFormFieldRejection = MissingFormFieldRejection$.MODULE$.apply(fieldName);
                    return done.success(RouteResult$Rejected$.MODULE$.apply(package$.MODULE$.Nil().$colon$colon(missingFormFieldRejection)));
                }
                if (try_ instanceof Failure) {
                    Throwable cause = ((Failure)try_).exception();
                    if (done.isCompleted()) {
                        return BoxedUnit.UNIT;
                    }
                    return done.failure(cause);
                }
                throw new MatchError(try_);
            }, ctx.executionContext());
            return done.future();
        }, Tuple$.MODULE$.forTuple1()), Tuple$.MODULE$.forTuple1());
    }

    public static Directive fileUploadAll$(FileUploadDirectives $this, String fieldName) {
        return $this.fileUploadAll(fieldName);
    }

    @ApiMayChange
    default public Directive<Tuple1<Seq<Tuple2<FileInfo, Source<ByteString, Object>>>>> fileUploadAll(String fieldName) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequestContext());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<RequestContext, Directive> & Serializable)ctx -> {
            ExecutionContextExecutor ec = ctx.executionContext();
            Directive directive = Directive$.MODULE$.SingleValueTransformers(this.storeUploadedFiles(fieldName, (Function1<FileInfo, File> & Serializable)fileInfo -> FileUploadDirectives.tempDest$1(fileInfo)));
            return Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1<Seq, Seq> & Serializable)files -> (Seq)files.map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    FileInfo fileInfo = (FileInfo)tuple2._1();
                    File src = (File)tuple2._2();
                    FlowOpsMat byteSource = FileIO$.MODULE$.fromPath(src.toPath(), FileIO$.MODULE$.fromPath$default$2()).mapMaterializedValue(f -> f.onComplete((Function1<Try, boolean> & Serializable)_$3 -> src.delete(), ec));
                    return Tuple2$.MODULE$.apply(fileInfo, byteSource);
                }
                throw new MatchError(tuple2);
            }), Tupler$.MODULE$.forAnyRef());
        }, Tuple$.MODULE$.forTuple1());
    }

    private static Future storeUploadedFile$$anonfun$1$$anonfun$1$$anonfun$1(Future uploadedF$1) {
        return uploadedF$1;
    }

    public static Directive storeUploadedFile$$anonfun$1$(FileUploadDirectives $this, String fieldName$1, Function1 destFn$1, RequestContext ctx) {
        return $this.storeUploadedFile$$anonfun$1(fieldName$1, destFn$1, ctx);
    }

    private static Future storeUploadedFiles$$anonfun$1$$anonfun$1$$anonfun$1(Future uploadedF$2) {
        return uploadedF$2;
    }

    private static File tempDest$1(FileInfo fileInfo) {
        File dest = Files.createTempFile("pekko-http-upload", ".tmp", new FileAttribute[0]).toFile();
        dest.deleteOnExit();
        return dest;
    }
}

