/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import java.io.Serializable;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.scaladsl.marshalling.ContentTypeOverrider$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.model.DateTime$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.server.directives.DirectoryListing;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class DirectoryListing$
implements Mirror.Product,
Serializable {
    private static final String[] html;
    public static final DirectoryListing$ MODULE$;

    private DirectoryListing$() {
    }

    static {
        MODULE$ = new DirectoryListing$();
        html = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(EnhancedString$.MODULE$.stripMarginWithNewline$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("<html>\n      |<head><title>Index of $</title></head>\n      |<body>\n      |<h1>Index of $</h1>\n      |<hr>\n      |<pre>\n      |$</pre>\n      |<hr>$\n      |<div style=\"width:100%;text-align:right;color:gray\">\n      |<small>rendered by <a href=\"https://pekko.apache.org\">Pekko Http</a> on $</small>\n      |</div>$\n      |</body>\n      |</html>\n      |"), "\n")), '$');
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DirectoryListing$.class);
    }

    public DirectoryListing apply(String path, boolean isRoot, Seq<File> files) {
        return new DirectoryListing(path, isRoot, files);
    }

    public DirectoryListing unapply(DirectoryListing x$1) {
        return x$1;
    }

    public Marshaller<DirectoryListing, RequestEntity> directoryMarshaller(boolean renderVanityFooter) {
        return Marshaller$.MODULE$.StringMarshaller().wrap(MediaTypes$.MODULE$.text$divhtml(), (Function1<DirectoryListing, String> & Serializable)listing -> {
            DirectoryListing directoryListing = listing;
            if (directoryListing == null) {
                throw new MatchError(directoryListing);
            }
            DirectoryListing directoryListing2 = this.unapply(directoryListing);
            String string2 = directoryListing2._1();
            boolean bl = directoryListing2._2();
            Seq<File> seq = directoryListing2._3();
            String path = string2;
            boolean isRoot = bl;
            Seq<File> files = seq;
            Tuple3<String, Boolean, Seq<File>> tuple3 = Tuple3$.MODULE$.apply(path, BoxesRunTime.boxToBoolean(isRoot), files);
            String path2 = tuple3._1();
            boolean isRoot2 = BoxesRunTime.unboxToBoolean(tuple3._2());
            Seq<File> files2 = tuple3._3();
            Seq filesAndNames = (Seq)((SeqOps)files2.map((Function1<File, Tuple2> & Serializable)file -> {
                File file2 = Predef$.MODULE$.ArrowAssoc(file);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(file2, file.getName());
            })).sortBy((Function1<Tuple2, String> & Serializable)_$5 -> (String)_$5._2(), Ordering$String$.MODULE$);
            Seq deduped = (Seq)((IterableOps)filesAndNames.zipWithIndex()).flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> {
                Tuple2 tuple2;
                block2: {
                    block4: {
                        Tuple2 fan;
                        block3: {
                            Tuple2 tuple22;
                            tuple2 = x$1;
                            if (tuple2 == null || (tuple22 = (Tuple2)tuple2._1()) == null) break block2;
                            File file = (File)tuple22._1();
                            String name = (String)tuple22._2();
                            fan = tuple22;
                            int ix = BoxesRunTime.unboxToInt(tuple2._2());
                            if (ix == 0) break block3;
                            Object T2 = ((Tuple2)filesAndNames.apply(ix - 1))._2();
                            String string2 = name;
                            if (!(T2 == null ? string2 != null : !T2.equals(string2))) break block4;
                        }
                        return Some$.MODULE$.apply(fan);
                    }
                    return None$.MODULE$;
                }
                throw new MatchError(tuple2);
            });
            Tuple2 tuple2 = deduped.partition((Function1<Tuple2, boolean> & Serializable)_$6 -> ((File)_$6._1()).isDirectory());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq directoryFilesAndNames = (Seq)tuple2._1();
            Seq fileFilesAndNames = (Seq)tuple2._2();
            Tuple2<Seq, Seq> tuple22 = Tuple2$.MODULE$.apply(directoryFilesAndNames, fileFilesAndNames);
            Seq directoryFilesAndNames2 = tuple22._1();
            Seq fileFilesAndNames2 = tuple22._2();
            int maxNameLen = package$.MODULE$.max(this.maxNameLength$1(directoryFilesAndNames2) + 1, this.maxNameLength$1(fileFilesAndNames2));
            StringBuilder sb = new StringBuilder();
            sb.append(html[0]).append(path2).append(html[1]).append(path2).append(html[2]);
            if (!isRoot2) {
                int secondToLastSlash = path2.lastIndexOf(47, path2.lastIndexOf(47, path2.length() - 1) - 1);
                sb.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<a href=\"%s/\">../</a>\n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{path2.substring(0, secondToLastSlash)})));
            }
            directoryFilesAndNames2.withFilter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1<Tuple2, StringBuilder> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return this.renderDirectory$1(sb, path2, maxNameLen, file, name);
                }
                throw new MatchError(tuple2);
            });
            fileFilesAndNames2.withFilter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1<Tuple2, StringBuilder> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    return this.renderFile$1(sb, path2, maxNameLen, file, name);
                }
                throw new MatchError(tuple2);
            });
            if (isRoot2 && files2.isEmpty()) {
                sb.append("(no files)\n");
            }
            sb.append(html[3]);
            if (renderVanityFooter) {
                sb.append(html[4]).append(DateTime$.MODULE$.now().toIsoLikeDateTimeString()).append(html[5]);
            }
            return sb.append(html[6]).toString();
        }, ContentTypeOverrider$.MODULE$.forEntity());
    }

    @Override
    public DirectoryListing fromProduct(Product x$0) {
        return new DirectoryListing((String)x$0.productElement(0), BoxesRunTime.unboxToBoolean(x$0.productElement(1)), (Seq)x$0.productElement(2));
    }

    private final int maxNameLength$1(Seq seq) {
        if (seq.isEmpty()) {
            return 0;
        }
        return BoxesRunTime.unboxToInt(((IterableOnceOps)seq.map((Function1<Tuple2, int> & Serializable)_$7 -> ((String)_$7._2()).length())).max(Ordering$Int$.MODULE$));
    }

    private final String lastModified$2(File file) {
        return DateTime$.MODULE$.apply(file.lastModified()).toIsoLikeDateTimeString();
    }

    private final StringBuilder start$1(StringBuilder sb$1, String path$3, int maxNameLen$1, String name) {
        return sb$1.append("<a href=\"").append(new StringBuilder(0).append(path$3).append(name).toString()).append("\">").append(name).append("</a>").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxNameLen$1 - name.length()));
    }

    private final StringBuilder renderDirectory$1(StringBuilder sb$3, String path$5, int maxNameLen$3, File file, String name) {
        return this.start$1(sb$3, path$5, maxNameLen$3, new StringBuilder(11).append(name).append('/').toString()).append("        ").append(this.lastModified$2(file)).append('\n');
    }

    private final StringBuilder renderFile$1(StringBuilder sb$2, String path$4, int maxNameLen$2, File file, String name) {
        String size = org.apache.pekko.http.impl.util.package$.MODULE$.humanReadableByteCount(file.length(), true);
        this.start$1(sb$2, path$4, maxNameLen$2, name).append("        ").append(this.lastModified$2(file));
        return sb$2.append("                ".substring(size.length())).append(size).append('\n');
    }
}

