/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.EntityStreamException;
import org.apache.pekko.http.scaladsl.model.EntityStreamException$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.IllegalRequestException$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.RouteResult$Complete$;
import org.apache.pekko.http.scaladsl.server.RouteResult$Rejected$;
import org.apache.pekko.http.scaladsl.server.TransformationRejection$;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.util.Tuple;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps$Join$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.RoutingSettings;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.http.scaladsl.util.FastFuture$EnhancedFuture$;
import org.apache.pekko.stream.ActorMaterializerHelper$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple1$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public interface BasicDirectives {
    public static Directive mapInnerRoute$(BasicDirectives $this, Function1 f) {
        return $this.mapInnerRoute(f);
    }

    default public Directive<BoxedUnit> mapInnerRoute(Function1<Function1<RequestContext, Future<RouteResult>>, Function1<RequestContext, Future<RouteResult>>> f) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1)f.apply((Function1<RequestContext, Future<RouteResult>>)inner.apply(BoxedUnit.UNIT)), Tuple$.MODULE$.forUnit());
    }

    public static Directive mapRequestContext$(BasicDirectives $this, Function1 f) {
        return $this.mapRequestContext(f);
    }

    default public Directive<BoxedUnit> mapRequestContext(Function1<RequestContext, RequestContext> f) {
        return this.mapInnerRoute((Function1<Function1<RequestContext, Future<RouteResult>>, Function1<RequestContext, Future<RouteResult>>>)(Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> (Future)inner.apply(f.apply((RequestContext)ctx)));
    }

    public static Directive mapRequest$(BasicDirectives $this, Function1 f) {
        return $this.mapRequest(f);
    }

    default public Directive<BoxedUnit> mapRequest(Function1<HttpRequest, HttpRequest> f) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)_$1 -> _$1.mapRequest(f));
    }

    public static Directive mapRouteResultFuture$(BasicDirectives $this, Function1 f) {
        return $this.mapRouteResultFuture(f);
    }

    default public Directive<BoxedUnit> mapRouteResultFuture(Function1<Future<RouteResult>, Future<RouteResult>> f) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> {
            Future<Nothing$> future;
            try {
                future = (Future<Nothing$>)((Function1)inner.apply(BoxedUnit.UNIT)).apply(ctx);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = option.get();
                    future = FastFuture$.MODULE$.failed().apply(ex);
                }
                throw throwable;
            }
            Future<Nothing$> innerResult = future;
            return (Future)f.apply(innerResult);
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive mapRouteResult$(BasicDirectives $this, Function1 f) {
        return $this.mapRouteResult(f);
    }

    default public Directive<BoxedUnit> mapRouteResult(Function1<RouteResult, RouteResult> f) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> {
            Future future = FastFuture$.MODULE$.EnhancedFuture((Future)((Function1)inner.apply(BoxedUnit.UNIT)).apply(ctx));
            Future future2 = new FastFuture(FastFuture$EnhancedFuture$.MODULE$.fast$extension(future)).future();
            return FastFuture$.MODULE$.map$extension(future2, f, ctx.executionContext());
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive mapRouteResultWith$(BasicDirectives $this, Function1 f) {
        return $this.mapRouteResultWith(f);
    }

    default public Directive<BoxedUnit> mapRouteResultWith(Function1<RouteResult, Future<RouteResult>> f) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> {
            Future future = FastFuture$.MODULE$.EnhancedFuture((Future)((Function1)inner.apply(BoxedUnit.UNIT)).apply(ctx));
            Future future2 = new FastFuture(FastFuture$EnhancedFuture$.MODULE$.fast$extension(future)).future();
            return FastFuture$.MODULE$.flatMap$extension(future2, f, ctx.executionContext());
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive mapRouteResultPF$(BasicDirectives $this, PartialFunction f) {
        return $this.mapRouteResultPF(f);
    }

    default public Directive<BoxedUnit> mapRouteResultPF(PartialFunction<RouteResult, RouteResult> f) {
        return this.mapRouteResult((Function1<RouteResult, RouteResult> & Serializable)_$2 -> (RouteResult)f.applyOrElse(_$2, (Function1<RouteResult, RouteResult> & Serializable)x -> Predef$.MODULE$.identity(x)));
    }

    public static Directive mapRouteResultWithPF$(BasicDirectives $this, PartialFunction f) {
        return $this.mapRouteResultWithPF(f);
    }

    default public Directive<BoxedUnit> mapRouteResultWithPF(PartialFunction<RouteResult, Future<RouteResult>> f) {
        return this.mapRouteResultWith((Function1<RouteResult, Future<RouteResult>>)(Function1<RouteResult, Future> & Serializable)_$3 -> f.applyOrElse(_$3, FastFuture$.MODULE$.successful()));
    }

    public static Directive recoverRejections$(BasicDirectives $this, Function1 f) {
        return $this.recoverRejections(f);
    }

    default public Directive<BoxedUnit> recoverRejections(Function1<Seq<Rejection>, RouteResult> f) {
        return this.mapRouteResultPF((PartialFunction<RouteResult, RouteResult>)((Object)new Serializable(f){
            private final Function1 f$13;
            {
                this.f$13 = f$24;
            }

            public final boolean isDefinedAt(RouteResult x) {
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Rejected) {
                    Seq<Rejection> seq;
                    RouteResult.Rejected rejected = RouteResult$Rejected$.MODULE$.unapply((RouteResult.Rejected)routeResult);
                    Seq<Rejection> rejections = seq = rejected._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(RouteResult x, Function1 function1) {
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Rejected) {
                    Seq<Rejection> seq;
                    RouteResult.Rejected rejected = RouteResult$Rejected$.MODULE$.unapply((RouteResult.Rejected)routeResult);
                    Seq<Rejection> rejections = seq = rejected._1();
                    return this.f$13.apply(rejections);
                }
                return function1.apply(x);
            }
        }));
    }

    public static Directive recoverRejectionsWith$(BasicDirectives $this, Function1 f) {
        return $this.recoverRejectionsWith(f);
    }

    default public Directive<BoxedUnit> recoverRejectionsWith(Function1<Seq<Rejection>, Future<RouteResult>> f) {
        return this.mapRouteResultWithPF((PartialFunction<RouteResult, Future<RouteResult>>)((Object)new Serializable(f){
            private final Function1 f$14;
            {
                this.f$14 = f$25;
            }

            public final boolean isDefinedAt(RouteResult x) {
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Rejected) {
                    Seq<Rejection> seq;
                    RouteResult.Rejected rejected = RouteResult$Rejected$.MODULE$.unapply((RouteResult.Rejected)routeResult);
                    Seq<Rejection> rejections = seq = rejected._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(RouteResult x, Function1 function1) {
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Rejected) {
                    Seq<Rejection> seq;
                    RouteResult.Rejected rejected = RouteResult$Rejected$.MODULE$.unapply((RouteResult.Rejected)routeResult);
                    Seq<Rejection> rejections = seq = rejected._1();
                    return this.f$14.apply(rejections);
                }
                return function1.apply(x);
            }
        }));
    }

    public static Directive mapRejections$(BasicDirectives $this, Function1 f) {
        return $this.mapRejections(f);
    }

    default public Directive<BoxedUnit> mapRejections(Function1<Seq<Rejection>, Seq<Rejection>> f) {
        return this.recoverRejections((Function1<Seq<Rejection>, RouteResult>)(Function1<Seq, RouteResult> & Serializable)rejections -> RouteResult$Rejected$.MODULE$.apply((Seq)f.apply((Seq<Rejection>)rejections)));
    }

    public static Directive mapResponse$(BasicDirectives $this, Function1 f) {
        return $this.mapResponse(f);
    }

    default public Directive<BoxedUnit> mapResponse(Function1<HttpResponse, HttpResponse> f) {
        return this.mapRouteResultPF((PartialFunction<RouteResult, RouteResult>)((Object)new Serializable(f){
            private final Function1 f$16;
            {
                this.f$16 = f$26;
            }

            public final boolean isDefinedAt(RouteResult x) {
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Complete) {
                    HttpResponse httpResponse;
                    RouteResult.Complete complete = RouteResult$Complete$.MODULE$.unapply((RouteResult.Complete)routeResult);
                    HttpResponse response = httpResponse = complete._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(RouteResult x, Function1 function1) {
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Complete) {
                    HttpResponse httpResponse;
                    RouteResult.Complete complete = RouteResult$Complete$.MODULE$.unapply((RouteResult.Complete)routeResult);
                    HttpResponse response = httpResponse = complete._1();
                    return RouteResult$Complete$.MODULE$.apply((HttpResponse)this.f$16.apply(response));
                }
                return function1.apply(x);
            }
        }));
    }

    public static Directive mapResponseEntity$(BasicDirectives $this, Function1 f) {
        return $this.mapResponseEntity(f);
    }

    default public Directive<BoxedUnit> mapResponseEntity(Function1<ResponseEntity, ResponseEntity> f) {
        return this.mapResponse((Function1<HttpResponse, HttpResponse> & Serializable)_$4 -> _$4.mapEntity(f));
    }

    public static Directive mapResponseHeaders$(BasicDirectives $this, Function1 f) {
        return $this.mapResponseHeaders(f);
    }

    default public Directive<BoxedUnit> mapResponseHeaders(Function1<Seq<HttpHeader>, Seq<HttpHeader>> f) {
        return this.mapResponse((Function1<HttpResponse, HttpResponse> & Serializable)_$5 -> (HttpResponse)_$5.mapHeaders((Function1)f));
    }

    public static Directive pass$(BasicDirectives $this) {
        return $this.pass();
    }

    default public Directive<BoxedUnit> pass() {
        return Directive$.MODULE$.Empty();
    }

    public static Directive provide$(BasicDirectives $this, Object value) {
        return $this.provide(value);
    }

    default public <T> Directive<Tuple1<T>> provide(T value) {
        return this.tprovide(Tuple1$.MODULE$.apply(value), Tuple$.MODULE$.forTuple1());
    }

    public static Directive tprovide$(BasicDirectives $this, Object values, Tuple evidence$1) {
        return $this.tprovide(values, evidence$1);
    }

    default public <L> Directive<L> tprovide(L values, Tuple<L> evidence$1) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)_$6 -> (Function1)_$6.apply(values), evidence$1);
    }

    public static Directive extract$(BasicDirectives $this, Function1 f) {
        return $this.extract(f);
    }

    default public <T> Directive<Tuple1<T>> extract(Function1<RequestContext, T> f) {
        return this.textract((Function1<RequestContext, Tuple1> & Serializable)ctx -> Tuple1$.MODULE$.apply(f.apply((RequestContext)ctx)), Tuple$.MODULE$.forTuple1());
    }

    public static Directive textract$(BasicDirectives $this, Function1 f, Tuple evidence$1) {
        return $this.textract(f, evidence$1);
    }

    default public <L> Directive<L> textract(Function1<RequestContext, L> f, Tuple<L> evidence$1) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> (Future)((Function1)inner.apply(f.apply((RequestContext)ctx))).apply(ctx), evidence$1);
    }

    public static Directive cancelRejection$(BasicDirectives $this, Rejection rejection) {
        return $this.cancelRejection(rejection);
    }

    default public Directive<BoxedUnit> cancelRejection(Rejection rejection) {
        return this.cancelRejections((Function1<Rejection, Object>)(Function1<Rejection, boolean> & Serializable)_$7 -> {
            Rejection rejection = _$7;
            Rejection rejection2 = rejection;
            return !(rejection != null ? !rejection.equals(rejection2) : rejection2 != null);
        });
    }

    public static Directive cancelRejections$(BasicDirectives $this, Seq classes) {
        return $this.cancelRejections(classes);
    }

    default public Directive<BoxedUnit> cancelRejections(Seq<Class<?>> classes) {
        return this.cancelRejections((Function1<Rejection, Object>)(Function1<Rejection, boolean> & Serializable)r -> classes.exists((Function1<Class, boolean> & Serializable)_$8 -> _$8.isInstance(r)));
    }

    public static Directive cancelRejections$(BasicDirectives $this, Function1 cancelFilter) {
        return $this.cancelRejections(cancelFilter);
    }

    default public Directive<BoxedUnit> cancelRejections(Function1<Rejection, Object> cancelFilter) {
        return this.mapRejections((Function1<Seq<Rejection>, Seq<Rejection>>)(Function1<Seq, Seq> & Serializable)_$9 -> (Seq)_$9.$colon$plus(TransformationRejection$.MODULE$.apply((Function1<Seq<Rejection>, Seq<Rejection>>)(Function1<Seq, Seq> & Serializable)_$10 -> (Seq)_$10.filterNot(cancelFilter))));
    }

    public static Directive mapUnmatchedPath$(BasicDirectives $this, Function1 f) {
        return $this.mapUnmatchedPath(f);
    }

    default public Directive<BoxedUnit> mapUnmatchedPath(Function1<Uri.Path, Uri.Path> f) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)_$11 -> _$11.mapUnmatchedPath(f));
    }

    public static Directive extractUnmatchedPath$(BasicDirectives $this) {
        return $this.extractUnmatchedPath();
    }

    default public Directive<Tuple1<Uri.Path>> extractUnmatchedPath() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractUnmatchedPath;
    }

    public static Directive extractMatchedPath$(BasicDirectives $this) {
        return $this.extractMatchedPath();
    }

    default public Directive<Tuple1<Uri.Path>> extractMatchedPath() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractMatchedPath;
    }

    public static Directive extractRequest$(BasicDirectives $this) {
        return $this.extractRequest();
    }

    default public Directive<Tuple1<HttpRequest>> extractRequest() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractRequest;
    }

    public static Directive extractUri$(BasicDirectives $this) {
        return $this.extractUri();
    }

    default public Directive<Tuple1<Uri>> extractUri() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractUri;
    }

    public static Directive withExecutionContext$(BasicDirectives $this, ExecutionContextExecutor ec) {
        return $this.withExecutionContext(ec);
    }

    default public Directive<BoxedUnit> withExecutionContext(ExecutionContextExecutor ec) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)_$12 -> _$12.withExecutionContext(ec));
    }

    public static Directive extractExecutionContext$(BasicDirectives $this) {
        return $this.extractExecutionContext();
    }

    default public Directive<Tuple1<ExecutionContextExecutor>> extractExecutionContext() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractExecutionContext;
    }

    public static Directive withMaterializer$(BasicDirectives $this, Materializer materializer) {
        return $this.withMaterializer(materializer);
    }

    default public Directive<BoxedUnit> withMaterializer(Materializer materializer) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)_$13 -> _$13.withMaterializer(materializer));
    }

    public static Directive extractMaterializer$(BasicDirectives $this) {
        return $this.extractMaterializer();
    }

    default public Directive<Tuple1<Materializer>> extractMaterializer() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractMaterializer;
    }

    public static Directive extractActorSystem$(BasicDirectives $this) {
        return $this.extractActorSystem();
    }

    default public Directive<Tuple1<ActorSystem>> extractActorSystem() {
        return this.extract((Function1<RequestContext, ActorSystem> & Serializable)ctx -> ActorMaterializerHelper$.MODULE$.downcast(ctx.materializer()).system());
    }

    public static Directive withLog$(BasicDirectives $this, LoggingAdapter log) {
        return $this.withLog(log);
    }

    default public Directive<BoxedUnit> withLog(LoggingAdapter log) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)_$14 -> _$14.withLog(log));
    }

    public static Directive extractLog$(BasicDirectives $this) {
        return $this.extractLog();
    }

    default public Directive<Tuple1<LoggingAdapter>> extractLog() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractLog;
    }

    public static Directive withSettings$(BasicDirectives $this, RoutingSettings settings) {
        return $this.withSettings(settings);
    }

    default public Directive<BoxedUnit> withSettings(RoutingSettings settings) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)_$15 -> _$15.withRoutingSettings(settings));
    }

    public static Directive mapSettings$(BasicDirectives $this, Function1 f) {
        return $this.mapSettings(f);
    }

    default public Directive<BoxedUnit> mapSettings(Function1<RoutingSettings, RoutingSettings> f) {
        return this.mapRequestContext((Function1<RequestContext, RequestContext> & Serializable)ctx -> ctx.withRoutingSettings((RoutingSettings)f.apply(ctx.settings())));
    }

    public static Directive extractSettings$(BasicDirectives $this) {
        return $this.extractSettings();
    }

    default public Directive<Tuple1<RoutingSettings>> extractSettings() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractSettings;
    }

    public static Directive extractParserSettings$(BasicDirectives $this) {
        return $this.extractParserSettings();
    }

    default public Directive<Tuple1<ParserSettings>> extractParserSettings() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractParserSettings;
    }

    public static Directive extractRequestContext$(BasicDirectives $this) {
        return $this.extractRequestContext();
    }

    default public Directive<Tuple1<RequestContext>> extractRequestContext() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractRequestContext;
    }

    public static Directive extractRequestEntity$(BasicDirectives $this) {
        return $this.extractRequestEntity();
    }

    default public Directive<Tuple1<RequestEntity>> extractRequestEntity() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractRequestEntity;
    }

    public static Directive extractDataBytes$(BasicDirectives $this) {
        return $this.extractDataBytes();
    }

    default public Directive<Tuple1<Source<ByteString, Object>>> extractDataBytes() {
        return BasicDirectives$.org$apache$pekko$http$scaladsl$server$directives$BasicDirectives$$$_extractDataBytes;
    }

    public static Directive extractStrictEntity$(BasicDirectives $this, FiniteDuration timeout) {
        return $this.extractStrictEntity(timeout);
    }

    default public Directive<Tuple1<HttpEntity.Strict>> extractStrictEntity(FiniteDuration timeout) {
        return (Directive)this.toStrictEntity(timeout).$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.extract((Function1<RequestContext, HttpEntity.Strict> & Serializable)_$16 -> (HttpEntity.Strict)_$16.request().entity()), TupleOps$Join$.MODULE$.join0P()));
    }

    public static Directive extractStrictEntity$(BasicDirectives $this, FiniteDuration timeout, long maxBytes) {
        return $this.extractStrictEntity(timeout, maxBytes);
    }

    default public Directive<Tuple1<HttpEntity.Strict>> extractStrictEntity(FiniteDuration timeout, long maxBytes) {
        return (Directive)this.toStrictEntity(timeout, maxBytes).$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.extract((Function1<RequestContext, HttpEntity.Strict> & Serializable)_$17 -> (HttpEntity.Strict)_$17.request().entity()), TupleOps$Join$.MODULE$.join0P()));
    }

    public static Directive toStrictEntity$(BasicDirectives $this, FiniteDuration timeout) {
        return $this.toStrictEntity(timeout);
    }

    default public Directive<BoxedUnit> toStrictEntity(FiniteDuration timeout) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(this.extractParserSettings());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1<ParserSettings, Directive> & Serializable)settings -> this.toStrictEntity(timeout, settings.maxToStrictBytes()), Tuple$.MODULE$.forUnit());
    }

    public static Directive toStrictEntity$(BasicDirectives $this, FiniteDuration timeout, long maxBytes) {
        return $this.toStrictEntity(timeout, maxBytes);
    }

    default public Directive<BoxedUnit> toStrictEntity(FiniteDuration timeout, long maxBytes) {
        return Directive$.MODULE$.apply((Function1<Function1, Function1> & Serializable)inner -> (Function1<RequestContext, Future> & Serializable)ctx -> ctx.request().entity().toStrict(timeout, maxBytes, ctx.materializer()).recover(new Serializable(timeout){
            private final FiniteDuration timeout$4;
            {
                this.timeout$4 = timeout$5;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof TimeoutException) {
                    return true;
                }
                if (throwable instanceof EntityStreamException) {
                    ErrorInfo errorInfo;
                    EntityStreamException entityStreamException = EntityStreamException$.MODULE$.unapply((EntityStreamException)throwable);
                    ErrorInfo info = errorInfo = entityStreamException._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof TimeoutException) {
                    throw IllegalRequestException$.MODULE$.apply(StatusCodes$.MODULE$.RequestTimeout(), ErrorInfo$.MODULE$.apply(new StringBuilder(54).append("Request timed out after ").append(this.timeout$4).append(" while waiting for entity data").toString(), "Consider increasing the timeout for toStrict"));
                }
                if (throwable instanceof EntityStreamException) {
                    ErrorInfo errorInfo;
                    EntityStreamException entityStreamException = EntityStreamException$.MODULE$.unapply((EntityStreamException)throwable);
                    ErrorInfo info = errorInfo = entityStreamException._1();
                    throw IllegalRequestException$.MODULE$.apply(StatusCodes$.MODULE$.BadRequest(), info);
                }
                return function1.apply(x);
            }
        }, ctx.executionContext()).flatMap((Function1<HttpEntity.Strict, Future> & Serializable)strictEntity -> {
            RequestContext newCtx = ctx.mapRequest((Function1<HttpRequest, HttpRequest> & Serializable)_$18 -> _$18.withEntity((RequestEntity)strictEntity));
            return (Future)((Function1)inner.apply(BoxedUnit.UNIT)).apply(newCtx);
        }, ctx.executionContext()), Tuple$.MODULE$.forUnit());
    }
}

