/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.marshalling.Marshal;
import org.apache.pekko.http.scaladsl.marshalling.Marshal$UnacceptableResponseContentTypeException$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRanges$;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.Accept;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.model.headers.Location;
import org.apache.pekko.http.scaladsl.model.headers.Location$;
import org.apache.pekko.http.scaladsl.server.ContentNegotiator;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RejectionError;
import org.apache.pekko.http.scaladsl.server.RejectionError$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.RouteResult$Complete$;
import org.apache.pekko.http.scaladsl.server.RouteResult$Rejected$;
import org.apache.pekko.http.scaladsl.server.UnacceptedResponseContentTypeRejection;
import org.apache.pekko.http.scaladsl.server.UnacceptedResponseContentTypeRejection$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.RoutingSettings;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.http.scaladsl.util.FastFuture$EnhancedFuture$;
import org.apache.pekko.stream.Materializer;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public class RequestContextImpl
implements RequestContext {
    private final HttpRequest request;
    private final Uri.Path unmatchedPath;
    private final ExecutionContextExecutor executionContext;
    private final Materializer materializer;
    private final LoggingAdapter log;
    private final RoutingSettings settings;
    private final ParserSettings parserSettings;

    public RequestContextImpl(HttpRequest request, Uri.Path unmatchedPath, ExecutionContextExecutor executionContext, Materializer materializer, LoggingAdapter log, RoutingSettings settings, ParserSettings parserSettings) {
        this.request = request;
        this.unmatchedPath = unmatchedPath;
        this.executionContext = executionContext;
        this.materializer = materializer;
        this.log = log;
        this.settings = settings;
        this.parserSettings = parserSettings;
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public Uri.Path unmatchedPath() {
        return this.unmatchedPath;
    }

    @Override
    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    @Override
    public Materializer materializer() {
        return this.materializer;
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public RoutingSettings settings() {
        return this.settings;
    }

    @Override
    public ParserSettings parserSettings() {
        return this.parserSettings;
    }

    public RequestContextImpl(HttpRequest request, LoggingAdapter log, RoutingSettings settings, ParserSettings parserSettings, ExecutionContextExecutor ec, Materializer materializer) {
        this(request, request.uri().path(), ec, materializer, log, settings, parserSettings);
    }

    @Override
    public RequestContext reconfigure(ExecutionContextExecutor executionContext, Materializer materializer, LoggingAdapter log, RoutingSettings settings) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), executionContext, materializer, log, settings, this.copy$default$7());
    }

    @Override
    public Future<RouteResult> complete(ToResponseMarshallable trm) {
        Future future = FastFuture$.MODULE$.EnhancedFuture(trm.apply(this.request(), this.executionContext()));
        Future future2 = new FastFuture(FastFuture$EnhancedFuture$.MODULE$.fast$extension(future)).future();
        Future future3 = FastFuture$.MODULE$.EnhancedFuture(FastFuture$.MODULE$.map$extension(future2, (Function1<HttpResponse, RouteResult.Complete> & Serializable)res -> RouteResult$Complete$.MODULE$.apply((HttpResponse)res), this.executionContext()));
        Future future4 = new FastFuture(FastFuture$EnhancedFuture$.MODULE$.fast$extension(future3)).future();
        return FastFuture$.MODULE$.recover$extension(future4, new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof Marshal.UnacceptableResponseContentTypeException) {
                    Set<ContentNegotiator.Alternative> set;
                    Marshal.UnacceptableResponseContentTypeException unacceptableResponseContentTypeException = Marshal$UnacceptableResponseContentTypeException$.MODULE$.unapply((Marshal.UnacceptableResponseContentTypeException)throwable);
                    Set<ContentNegotiator.Alternative> supported = set = unacceptableResponseContentTypeException._1();
                    return true;
                }
                if (throwable instanceof RejectionError) {
                    Rejection rejection;
                    RejectionError rejectionError = RejectionError$.MODULE$.unapply((RejectionError)throwable);
                    Rejection rej = rejection = rejectionError._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Marshal.UnacceptableResponseContentTypeException) {
                    Set<ContentNegotiator.Alternative> set;
                    Marshal.UnacceptableResponseContentTypeException unacceptableResponseContentTypeException = Marshal$UnacceptableResponseContentTypeException$.MODULE$.unapply((Marshal.UnacceptableResponseContentTypeException)throwable);
                    Set<ContentNegotiator.Alternative> supported = set = unacceptableResponseContentTypeException._1();
                    UnacceptedResponseContentTypeRejection unacceptedResponseContentTypeRejection = UnacceptedResponseContentTypeRejection$.MODULE$.apply(supported);
                    return RouteResult$Rejected$.MODULE$.apply(package$.MODULE$.Nil().$colon$colon(unacceptedResponseContentTypeRejection));
                }
                if (throwable instanceof RejectionError) {
                    Rejection rejection;
                    RejectionError rejectionError = RejectionError$.MODULE$.unapply((RejectionError)throwable);
                    Rejection rej = rejection = rejectionError._1();
                    return RouteResult$Rejected$.MODULE$.apply(package$.MODULE$.Nil().$colon$colon(rej));
                }
                return function1.apply(x);
            }
        }, this.executionContext());
    }

    @Override
    public Future<RouteResult> reject(Seq<Rejection> rejections) {
        return FastFuture$.MODULE$.successful().apply(RouteResult$Rejected$.MODULE$.apply(rejections.toList()));
    }

    @Override
    public Future<RouteResult> redirect(Uri uri, StatusCodes.Redirection redirectionType) {
        HttpEntity.Strict strict;
        Location location = Location$.MODULE$.apply(uri);
        List<HttpHeader> list = package$.MODULE$.Nil().$colon$colon(location);
        String string2 = redirectionType.htmlTemplate();
        if ("".equals(string2)) {
            strict = HttpEntity$.MODULE$.Empty();
        } else {
            String template = string2;
            strict = HttpEntity$.MODULE$.apply(ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(template), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{uri})));
        }
        return this.complete(ToResponseMarshallable$.MODULE$.apply(HttpResponse$.MODULE$.apply(redirectionType, list, strict, HttpResponse$.MODULE$.apply$default$4()), Marshaller$.MODULE$.fromResponse()));
    }

    @Override
    public Future<RouteResult> fail(Throwable error) {
        return FastFuture$.MODULE$.failed().apply(error);
    }

    @Override
    public RequestContext withRequest(HttpRequest request) {
        HttpRequest httpRequest = request;
        HttpRequest httpRequest2 = this.request();
        if (httpRequest == null ? httpRequest2 != null : !((Object)httpRequest).equals(httpRequest2)) {
            return this.copy(request, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }
        return this;
    }

    @Override
    public RequestContext withExecutionContext(ExecutionContextExecutor executionContext) {
        ExecutionContextExecutor executionContextExecutor = executionContext;
        ExecutionContextExecutor executionContextExecutor2 = this.executionContext();
        if (executionContextExecutor == null ? executionContextExecutor2 != null : !executionContextExecutor.equals(executionContextExecutor2)) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), executionContext, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }
        return this;
    }

    @Override
    public RequestContext withMaterializer(Materializer materializer) {
        Materializer materializer2 = materializer;
        Materializer materializer3 = this.materializer();
        if (materializer2 == null ? materializer3 != null : !materializer2.equals(materializer3)) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), materializer, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }
        return this;
    }

    @Override
    public RequestContext withLog(LoggingAdapter log) {
        LoggingAdapter loggingAdapter = log;
        LoggingAdapter loggingAdapter2 = this.log();
        if (loggingAdapter == null ? loggingAdapter2 != null : !loggingAdapter.equals(loggingAdapter2)) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), log, this.copy$default$6(), this.copy$default$7());
        }
        return this;
    }

    @Override
    public RequestContext withRoutingSettings(RoutingSettings routingSettings) {
        RoutingSettings routingSettings2 = routingSettings;
        RoutingSettings routingSettings3 = this.settings();
        if (routingSettings2 == null ? routingSettings3 != null : !routingSettings2.equals(routingSettings3)) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), routingSettings, this.copy$default$7());
        }
        return this;
    }

    @Override
    public RequestContext withParserSettings(ParserSettings parserSettings) {
        ParserSettings parserSettings2 = parserSettings;
        ParserSettings parserSettings3 = this.parserSettings();
        if (parserSettings2 == null ? parserSettings3 != null : !parserSettings2.equals(parserSettings3)) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), parserSettings);
        }
        return this;
    }

    @Override
    public RequestContext mapRequest(Function1<HttpRequest, HttpRequest> f) {
        return this.copy(f.apply(this.request()), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public RequestContext withUnmatchedPath(Uri.Path path) {
        Uri.Path path2 = path;
        Uri.Path path3 = this.unmatchedPath();
        if (path2 == null ? path3 != null : !path2.equals(path3)) {
            return this.copy(this.copy$default$1(), path, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }
        return this;
    }

    @Override
    public RequestContext mapUnmatchedPath(Function1<Uri.Path, Uri.Path> f) {
        Uri.Path path = f.apply(this.unmatchedPath());
        HttpRequest httpRequest = this.copy$default$1();
        ExecutionContextExecutor executionContextExecutor = this.copy$default$3();
        Materializer materializer = this.copy$default$4();
        LoggingAdapter loggingAdapter = this.copy$default$5();
        RoutingSettings routingSettings = this.copy$default$6();
        ParserSettings parserSettings = this.copy$default$7();
        return this.copy(httpRequest, path, executionContextExecutor, materializer, loggingAdapter, routingSettings, parserSettings);
    }

    @Override
    public RequestContext withAcceptAll() {
        Accept accept;
        Option option = this.request().header(ClassTag$.MODULE$.apply(Accept.class));
        if (option instanceof Some && (accept = (Accept)((Some)option).value()) != null) {
            Seq<MediaRange> seq;
            Accept accept2 = Accept$.MODULE$.unapply(accept);
            Seq<MediaRange> ranges = seq = accept2._1();
            Accept accept3 = accept;
            if (!accept3.acceptsAll()) {
                return this.mapRequest((Function1<HttpRequest, HttpRequest> & Serializable)_$1 -> (HttpRequest)_$1.mapHeaders((Function1<Seq, Seq> & Serializable)_$2 -> (Seq)_$2.map((Function1<HttpHeader, HttpHeader> & Serializable)x$1 -> {
                    HttpHeader httpHeader = x$1;
                    Accept accept = accept3;
                    HttpHeader httpHeader2 = httpHeader;
                    if (!(accept != null ? !((Object)accept).equals(httpHeader2) : httpHeader2 != null)) {
                        Seq acceptAll = ranges.exists((Function1<MediaRange, boolean> & Serializable)_$3 -> _$3.isWildcard()) ? (Seq)ranges.map((Function1<MediaRange, MediaRange> & Serializable)r -> {
                            if (r.isWildcard()) {
                                return MediaRanges$.MODULE$.$times$div$times$u003Bq$eqMIN();
                            }
                            return r;
                        }) : (Seq)ranges.$colon$plus(MediaRanges$.MODULE$.$times$div$times$u003Bq$eqMIN());
                        return accept3.copy(acceptAll);
                    }
                    HttpHeader x = httpHeader;
                    return x;
                })));
            }
        }
        return this;
    }

    private RequestContextImpl copy(HttpRequest request, Uri.Path unmatchedPath, ExecutionContextExecutor executionContext, Materializer materializer, LoggingAdapter log, RoutingSettings routingSettings, ParserSettings parserSettings) {
        return new RequestContextImpl(request, unmatchedPath, executionContext, materializer, log, routingSettings, parserSettings);
    }

    private HttpRequest copy$default$1() {
        return this.request();
    }

    private Uri.Path copy$default$2() {
        return this.unmatchedPath();
    }

    private ExecutionContextExecutor copy$default$3() {
        return this.executionContext();
    }

    private Materializer copy$default$4() {
        return this.materializer();
    }

    private LoggingAdapter copy$default$5() {
        return this.log();
    }

    private RoutingSettings copy$default$6() {
        return this.settings();
    }

    private ParserSettings copy$default$7() {
        return this.parserSettings();
    }

    public String toString() {
        return new StringBuilder(35).append("RequestContext(").append(this.request()).append(", ").append(this.unmatchedPath()).append(", [more settings])").toString();
    }
}

