/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.headers.Accept;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.math.Ordering$DeprecatedFloatOrdering$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class MediaTypeNegotiator {
    private final List acceptedMediaRanges;

    public MediaTypeNegotiator(Seq<HttpHeader> requestHeaders) {
        this.acceptedMediaRanges = ((IterableOnceOps)((SeqOps)requestHeaders.withFilter((Function1<HttpHeader, boolean> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Accept) {
                Seq<MediaRange> seq;
                Accept accept = Accept$.MODULE$.unapply((Accept)httpHeader);
                Seq<MediaRange> mediaRanges = seq = accept._1();
                return true;
            }
            return false;
        }).flatMap((Function1<HttpHeader, IterableOnce> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Accept) {
                Seq<MediaRange> seq;
                Accept accept = Accept$.MODULE$.unapply((Accept)httpHeader);
                Seq<MediaRange> mediaRanges = seq = accept._1();
                return (Seq)mediaRanges.map((Function1<MediaRange, MediaRange> & Serializable)range -> range);
            }
            throw new MatchError(httpHeader);
        })).sortBy((Function1<MediaRange, Tuple3> & Serializable)x$1 -> {
            MediaRange mediaRange = x$1;
            MediaRange x = mediaRange;
            if (x.isWildcard()) {
                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(2), BoxesRunTime.boxToInteger(-x.params().size()), BoxesRunTime.boxToFloat(-x.qValue()));
            }
            if (mediaRange instanceof MediaRange.One) {
                MediaRange.One one = (MediaRange.One)mediaRange;
                return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(-one.params().size()), BoxesRunTime.boxToFloat(-one.qValue()));
            }
            MediaRange range = mediaRange;
            return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(1), BoxesRunTime.boxToInteger(-range.params().size()), BoxesRunTime.boxToFloat(-range.qValue()));
        }, Ordering$.MODULE$.Tuple3(Ordering$Int$.MODULE$, Ordering$Int$.MODULE$, Ordering$DeprecatedFloatOrdering$.MODULE$))).toList();
    }

    public List<MediaRange> acceptedMediaRanges() {
        return this.acceptedMediaRanges;
    }

    public float qValueFor(MediaType mediaType) {
        List<MediaRange> list = this.acceptedMediaRanges();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<MediaRange> list2 = list;
        if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
            return 1.0f;
        }
        List<MediaRange> x = list;
        return BoxesRunTime.unboxToFloat(x.collectFirst(new Serializable(mediaType){
            private final MediaType mediaType$1;
            {
                this.mediaType$1 = mediaType$2;
            }

            public final boolean isDefinedAt(MediaRange x) {
                MediaRange mediaRange = x;
                MediaRange r = mediaRange;
                return r.matches(this.mediaType$1);
            }

            public final Object applyOrElse(MediaRange x, Function1 function1) {
                MediaRange mediaRange = x;
                MediaRange r = mediaRange;
                if (r.matches(this.mediaType$1)) {
                    return BoxesRunTime.boxToFloat(r.qValue());
                }
                return function1.apply(x);
            }
        }).getOrElse(MediaTypeNegotiator::qValueFor$$anonfun$1));
    }

    public boolean isAccepted(MediaType mediaType) {
        return this.qValueFor(mediaType) > 0.0f;
    }

    private static final float qValueFor$$anonfun$1() {
        return 0.0f;
    }
}

