/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Accept$minusLanguage;
import org.apache.pekko.http.scaladsl.model.headers.Accept$minusLanguage$;
import org.apache.pekko.http.scaladsl.model.headers.Language;
import org.apache.pekko.http.scaladsl.model.headers.LanguageRange;
import org.apache.pekko.http.scaladsl.model.headers.LanguageRange$;
import org.apache.pekko.http.scaladsl.server.LanguageNegotiator$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$DeprecatedFloatOrdering$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class LanguageNegotiator {
    private final List acceptedLanguageRanges;

    public static LanguageNegotiator apply(Seq<HttpHeader> seq) {
        return LanguageNegotiator$.MODULE$.apply(seq);
    }

    public LanguageNegotiator(Seq<HttpHeader> requestHeaders) {
        this.acceptedLanguageRanges = ((IterableOnceOps)((SeqOps)requestHeaders.withFilter((Function1<HttpHeader, boolean> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Accept$minusLanguage) {
                Seq<LanguageRange> seq;
                Accept$minusLanguage accept$minusLanguage = Accept$minusLanguage$.MODULE$.unapply((Accept$minusLanguage)httpHeader);
                Seq<LanguageRange> languageRanges = seq = accept$minusLanguage._1();
                return true;
            }
            return false;
        }).flatMap((Function1<HttpHeader, IterableOnce> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Accept$minusLanguage) {
                Seq<LanguageRange> seq;
                Accept$minusLanguage accept$minusLanguage = Accept$minusLanguage$.MODULE$.unapply((Accept$minusLanguage)httpHeader);
                Seq<LanguageRange> languageRanges = seq = accept$minusLanguage._1();
                return (Seq)languageRanges.map((Function1<LanguageRange, LanguageRange> & Serializable)range -> range);
            }
            throw new MatchError(httpHeader);
        })).sortBy((Function1<LanguageRange, float> & Serializable)x$1 -> {
            LanguageRange languageRange = x$1;
            if (languageRange instanceof LanguageRange$.times) {
                return 1.0f;
            }
            LanguageRange x = languageRange;
            return -((float)(2 * x.subTags().size()) + x.qValue());
        }, Ordering$DeprecatedFloatOrdering$.MODULE$)).toList();
    }

    public List<LanguageRange> acceptedLanguageRanges() {
        return this.acceptedLanguageRanges;
    }

    public float qValueFor(Language language2) {
        List<LanguageRange> list = this.acceptedLanguageRanges();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<LanguageRange> list2 = list;
        if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
            return 1.0f;
        }
        List<LanguageRange> x = list;
        return BoxesRunTime.unboxToFloat(x.collectFirst(new Serializable(language2){
            private final Language language$1;
            {
                this.language$1 = language$2;
            }

            public final boolean isDefinedAt(LanguageRange x) {
                LanguageRange languageRange = x;
                LanguageRange r = languageRange;
                return r.matches(this.language$1);
            }

            public final Object applyOrElse(LanguageRange x, Function1 function1) {
                LanguageRange languageRange = x;
                LanguageRange r = languageRange;
                if (r.matches(this.language$1)) {
                    return BoxesRunTime.boxToFloat(r.qValue());
                }
                return function1.apply(x);
            }
        }).getOrElse(LanguageNegotiator::qValueFor$$anonfun$4));
    }

    public boolean isAccepted(Language language2) {
        return this.qValueFor(language2) > 0.0f;
    }

    public Option<Language> pickLanguage(List<Language> alternatives) {
        return ((IterableOnceOps)((AbstractSeq)alternatives.map((Function1<Language, Tuple2> & Serializable)alt -> {
            Language language2 = Predef$.MODULE$.ArrowAssoc(alt);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(language2, BoxesRunTime.boxToFloat(this.qValueFor((Language)alt)));
        })).sortBy((Function1<Tuple2, float> & Serializable)_$4 -> -BoxesRunTime.unboxToFloat(_$4._2()), (Ordering)Ordering$DeprecatedFloatOrdering$.MODULE$)).collectFirst(new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Language alt = (Language)tuple2._1();
                    float q = BoxesRunTime.unboxToFloat(tuple2._2());
                    if (q > 0.0f) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Language alt = (Language)tuple2._1();
                    float q = BoxesRunTime.unboxToFloat(tuple2._2());
                    if (q > 0.0f) {
                        return alt;
                    }
                }
                return function1.apply(x);
            }
        });
    }

    private static final float qValueFor$$anonfun$4() {
        return 0.0f;
    }
}

