/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model.headers;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$DateTime$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.JavaMapping$StringIdentity$;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.S2JMapping$;
import org.apache.pekko.http.impl.util.ToStringRenderable;
import org.apache.pekko.http.scaladsl.model.DateTime;
import org.apache.pekko.http.scaladsl.model.headers.HttpCookie$;
import org.apache.pekko.http.scaladsl.model.headers.HttpCookiePair;
import org.apache.pekko.http.scaladsl.model.headers.HttpCookiePair$;
import org.apache.pekko.http.scaladsl.model.headers.SameSite;
import org.apache.pekko.util.OptionConverters$;
import org.apache.pekko.util.OptionConverters$RichOption$;
import org.apache.pekko.util.OptionConverters$RichOptional$;
import org.parboiled2.CharPredicate;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple9;
import scala.jdk.OptionShape$;
import scala.runtime.BoxesRunTime;

public final class HttpCookie
extends org.apache.pekko.http.javadsl.model.headers.HttpCookie
implements ToStringRenderable,
Product,
Serializable {
    private final String name;
    private final String value;
    private final Option expires;
    private final Option maxAge;
    private final Option domain;
    private final Option path;
    private final boolean secure;
    private final boolean httpOnly;
    private final Option extension;
    private final Option sameSite;

    public static HttpCookie apply(String string2, String string3, Option<DateTime> option, Option<Object> option2, Option<String> option3, Option<String> option4, boolean bl, boolean bl2, Option<String> option5) {
        return HttpCookie$.MODULE$.apply(string2, string3, option, option2, option3, option4, bl, bl2, option5);
    }

    public static CharPredicate domainChars() {
        return HttpCookie$.MODULE$.domainChars();
    }

    public static HttpCookie fromPair(HttpCookiePair httpCookiePair, Option<DateTime> option, Option<Object> option2, Option<String> option3, Option<String> option4, boolean bl, boolean bl2, Option<String> option5) {
        return HttpCookie$.MODULE$.fromPair(httpCookiePair, option, option2, option3, option4, bl, bl2, option5);
    }

    public static CharPredicate nameChars() {
        return HttpCookie$.MODULE$.nameChars();
    }

    public static CharPredicate pathOrExtChars() {
        return HttpCookie$.MODULE$.pathOrExtChars();
    }

    public static CharPredicate rawValueChars() {
        return HttpCookie$.MODULE$.rawValueChars();
    }

    public static Option<Tuple9<String, String, Option<DateTime>, Option<Object>, Option<String>, Option<String>, Object, Object, Option<String>>> unapply(HttpCookie httpCookie) {
        return HttpCookie$.MODULE$.unapply(httpCookie);
    }

    public static CharPredicate valueChars() {
        return HttpCookie$.MODULE$.valueChars();
    }

    public static Option<DateTime> fromPair$default$2() {
        return HttpCookie$.MODULE$.fromPair$default$2();
    }

    public static Option<DateTime> $lessinit$greater$default$3() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<DateTime> apply$default$3() {
        return HttpCookie$.MODULE$.apply$default$3();
    }

    public static Option<Object> fromPair$default$3() {
        return HttpCookie$.MODULE$.fromPair$default$3();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Object> apply$default$4() {
        return HttpCookie$.MODULE$.apply$default$4();
    }

    public static Option<String> fromPair$default$4() {
        return HttpCookie$.MODULE$.fromPair$default$4();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> apply$default$5() {
        return HttpCookie$.MODULE$.apply$default$5();
    }

    public static Option<String> fromPair$default$5() {
        return HttpCookie$.MODULE$.fromPair$default$5();
    }

    public static Option<String> $lessinit$greater$default$6() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<String> apply$default$6() {
        return HttpCookie$.MODULE$.apply$default$6();
    }

    public static boolean fromPair$default$6() {
        return HttpCookie$.MODULE$.fromPair$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean apply$default$7() {
        return HttpCookie$.MODULE$.apply$default$7();
    }

    public static boolean fromPair$default$7() {
        return HttpCookie$.MODULE$.fromPair$default$7();
    }

    public static boolean $lessinit$greater$default$8() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean apply$default$8() {
        return HttpCookie$.MODULE$.apply$default$8();
    }

    public static Option<String> fromPair$default$8() {
        return HttpCookie$.MODULE$.fromPair$default$8();
    }

    public static Option<String> $lessinit$greater$default$9() {
        return HttpCookie$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> apply$default$9() {
        return HttpCookie$.MODULE$.apply$default$9();
    }

    public HttpCookie(String name, String value, Option<DateTime> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Option<String> extension, Option<SameSite> sameSite) {
        this.name = name;
        this.value = value;
        this.expires = expires;
        this.maxAge = maxAge;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.extension = extension;
        this.sameSite = sameSite;
        HttpCookiePair$.MODULE$.validate(name, value);
        Predef$.MODULE$.require(domain.forall((Function1<String, Object>)(Function1<String, boolean> & Serializable)string2 -> HttpCookie$.MODULE$.domainChars().matchesAll((String)string2)), () -> HttpCookie.$init$$$anonfun$2(domain));
        Predef$.MODULE$.require(path.forall((Function1<String, Object>)(Function1<String, boolean> & Serializable)string2 -> HttpCookie$.MODULE$.pathOrExtChars().matchesAll((String)string2)), () -> HttpCookie.$init$$$anonfun$4(path));
        Predef$.MODULE$.require(extension.forall((Function1<String, Object>)(Function1<String, boolean> & Serializable)string2 -> HttpCookie$.MODULE$.pathOrExtChars().matchesAll((String)string2)), () -> HttpCookie.$init$$$anonfun$6(extension));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    public Option<DateTime> expires() {
        return this.expires;
    }

    public Option<Object> maxAge() {
        return this.maxAge;
    }

    public Option<String> domain() {
        return this.domain;
    }

    public Option<String> path() {
        return this.path;
    }

    @Override
    public boolean secure() {
        return this.secure;
    }

    @Override
    public boolean httpOnly() {
        return this.httpOnly;
    }

    public Option<String> extension() {
        return this.extension;
    }

    public Option<SameSite> sameSite() {
        return this.sameSite;
    }

    public HttpCookie(String name, String value, Option<DateTime> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Option<String> extension) {
        this(name, value, expires, maxAge, domain, path, secure, httpOnly, extension, None$.MODULE$);
    }

    public HttpCookie copy(String name, String value, Option<DateTime> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Option<String> extension) {
        return this.copy(name, value, expires, maxAge, domain, path, secure, httpOnly, extension, this.sameSite());
    }

    public HttpCookie copy(String name, String value, Option<DateTime> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Option<String> extension, Option<SameSite> sameSite) {
        return new HttpCookie(name, value, expires, maxAge, domain, path, secure, httpOnly, extension, sameSite);
    }

    public String copy$default$1() {
        return this.name();
    }

    public String copy$default$2() {
        return this.value();
    }

    public Option<DateTime> copy$default$3() {
        return this.expires();
    }

    public Option<Object> copy$default$4() {
        return this.maxAge();
    }

    public Option<String> copy$default$5() {
        return this.domain();
    }

    public Option<String> copy$default$6() {
        return this.path();
    }

    public boolean copy$default$7() {
        return this.secure();
    }

    public boolean copy$default$8() {
        return this.httpOnly();
    }

    public Option<String> copy$default$9() {
        return this.extension();
    }

    public Option<SameSite> copy$default$10() {
        return this.sameSite();
    }

    @Override
    public int productArity() {
        return 9;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.name();
            }
            case 1: {
                return this.value();
            }
            case 2: {
                return this.expires();
            }
            case 3: {
                return this.maxAge();
            }
            case 4: {
                return this.domain();
            }
            case 5: {
                return this.path();
            }
            case 6: {
                return BoxesRunTime.boxToBoolean(this.secure());
            }
            case 7: {
                return BoxesRunTime.boxToBoolean(this.httpOnly());
            }
            case 8: {
                return this.extension();
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n2));
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof HttpCookie;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof HttpCookie)) return false;
        HttpCookie that = (HttpCookie)object;
        if (!this.canEqual(that)) return false;
        String string2 = this.name();
        String string3 = that.name();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        String string4 = this.value();
        String string5 = that.value();
        if (string4 == null) {
            if (string5 != null) {
                return false;
            }
        } else if (!string4.equals(string5)) return false;
        Option<DateTime> option = this.expires();
        Option<DateTime> option2 = that.expires();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.maxAge();
        Option<Object> option4 = that.maxAge();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.domain();
        Option<String> option6 = that.domain();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<String> option7 = this.path();
        Option<String> option8 = that.path();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (this.secure() != that.secure()) return false;
        if (this.httpOnly() != that.httpOnly()) return false;
        Option<String> option9 = this.extension();
        Option<String> option10 = that.extension();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<SameSite> option11 = this.sameSite();
        Option<SameSite> option12 = that.sameSite();
        if (option11 == null) {
            if (option12 == null) return true;
            return false;
        } else {
            if (!option11.equals(option12)) return false;
            return true;
        }
    }

    @Override
    public HttpCookiePair pair() {
        return HttpCookiePair$.MODULE$.apply(this.name(), this.value());
    }

    @Override
    public <R extends Rendering> Rendering render(R r) {
        r.$tilde$tilde(this.name()).$tilde$tilde('=').$tilde$tilde(this.value());
        if (this.expires().isDefined()) {
            this.expires().get().renderRfc1123DateTimeString(r.$tilde$tilde("; Expires="));
        }
        if (this.maxAge().isDefined()) {
            r.$tilde$tilde("; Max-Age=").$tilde$tilde(BoxesRunTime.unboxToLong(this.maxAge().get()));
        }
        if (this.domain().isDefined()) {
            r.$tilde$tilde("; Domain=").$tilde$tilde(this.domain().get());
        }
        if (this.path().isDefined()) {
            r.$tilde$tilde("; Path=").$tilde$tilde(this.path().get());
        }
        if (this.secure()) {
            r.$tilde$tilde("; Secure");
        }
        if (this.httpOnly()) {
            r.$tilde$tilde("; HttpOnly");
        }
        if (this.extension().isDefined()) {
            r.$tilde$tilde(';').$tilde$tilde(' ').$tilde$tilde(this.extension().get());
        }
        if (this.sameSite().isDefined()) {
            r.$tilde$tilde("; SameSite=").$tilde$tilde(this.sameSite().get(), Renderer$.MODULE$.renderableRenderer());
        }
        return r;
    }

    @Override
    public Optional<org.apache.pekko.http.javadsl.model.headers.SameSite> getSameSite() {
        Option option = OptionConverters$.MODULE$.RichOption(this.sameSite().map((Function1<SameSite, org.apache.pekko.http.javadsl.model.headers.SameSite> & Serializable)_$1 -> _$1.asJava()));
        return OptionConverters$RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public Optional<String> getExtension() {
        return (Optional)JavaMapping$Implicits$.MODULE$.AddAsJava(this.extension(), S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$.MODULE$.option(JavaMapping$StringIdentity$.MODULE$))).asJava();
    }

    @Override
    public Optional<String> getPath() {
        return (Optional)JavaMapping$Implicits$.MODULE$.AddAsJava(this.path(), S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$.MODULE$.option(JavaMapping$StringIdentity$.MODULE$))).asJava();
    }

    @Override
    public Optional<String> getDomain() {
        return (Optional)JavaMapping$Implicits$.MODULE$.AddAsJava(this.domain(), S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$.MODULE$.option(JavaMapping$StringIdentity$.MODULE$))).asJava();
    }

    @Override
    public OptionalLong getMaxAge() {
        Option option = OptionConverters$.MODULE$.RichOption(this.maxAge());
        return OptionConverters$RichOption$.MODULE$.toJavaPrimitive$extension(option, OptionShape$.MODULE$.longOptionShape());
    }

    @Override
    public Optional<org.apache.pekko.http.javadsl.model.DateTime> getExpires() {
        Option option = OptionConverters$.MODULE$.RichOption(this.expires().map((Function1<DateTime, org.apache.pekko.http.javadsl.model.DateTime> & Serializable)_$2 -> (org.apache.pekko.http.javadsl.model.DateTime)JavaMapping$Implicits$.MODULE$.AddAsJava(_$2, S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$DateTime$.MODULE$)).asJava()));
        return OptionConverters$RichOption$.MODULE$.toJava$extension(option);
    }

    public HttpCookie withName(String name) {
        return this.copy(name, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public HttpCookie withValue(String value) {
        return this.copy(this.copy$default$1(), value, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public HttpCookie withExpires(DateTime dateTime) {
        Some<DateTime> some = Some$.MODULE$.apply(dateTime);
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<Object> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        Option<String> option3 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option4 = this.copy$default$9();
        Option<SameSite> option5 = this.copy$default$10();
        return this.copy(string2, string3, some, option, option2, option3, bl, bl2, option4, option5);
    }

    @Override
    public HttpCookie withExpires(org.apache.pekko.http.javadsl.model.DateTime dateTime) {
        Some<Object> some = Some$.MODULE$.apply(JavaMapping$Implicits$.MODULE$.AddAsScala(dateTime, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$DateTime$.MODULE$)).asScala());
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<Object> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        Option<String> option3 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option4 = this.copy$default$9();
        Option<SameSite> option5 = this.copy$default$10();
        return this.copy(string2, string3, some, option, option2, option3, bl, bl2, option4, option5);
    }

    @Override
    public HttpCookie withDomain(String domain) {
        Some<String> some = Some$.MODULE$.apply(domain);
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option = this.copy$default$3();
        Option<Object> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option4 = this.copy$default$9();
        Option<SameSite> option5 = this.copy$default$10();
        return this.copy(string2, string3, option, option2, some, option3, bl, bl2, option4, option5);
    }

    @Override
    public HttpCookie withPath(String path) {
        Some<String> some = Some$.MODULE$.apply(path);
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option = this.copy$default$3();
        Option<Object> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option4 = this.copy$default$9();
        Option<SameSite> option5 = this.copy$default$10();
        return this.copy(string2, string3, option, option2, option3, some, bl, bl2, option4, option5);
    }

    @Override
    public HttpCookie withMaxAge(long maxAge) {
        Some<Object> some = Some$.MODULE$.apply(BoxesRunTime.boxToLong(maxAge));
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option = this.copy$default$3();
        Option<String> option2 = this.copy$default$5();
        Option<String> option3 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option4 = this.copy$default$9();
        Option<SameSite> option5 = this.copy$default$10();
        return this.copy(string2, string3, option, some, option2, option3, bl, bl2, option4, option5);
    }

    @Override
    public HttpCookie withSecure(boolean secure) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), secure, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public HttpCookie withHttpOnly(boolean httpOnly) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), httpOnly, this.copy$default$9(), this.copy$default$10());
    }

    public HttpCookie withSameSite(SameSite sameSite) {
        Some<SameSite> some = Some$.MODULE$.apply(sameSite);
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option = this.copy$default$3();
        Option<Object> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        Option<String> option4 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option5 = this.copy$default$9();
        return this.copy(string2, string3, option, option2, option3, option4, bl, bl2, option5, some);
    }

    public HttpCookie withSameSite(Option<SameSite> sameSite) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), sameSite);
    }

    @Override
    public HttpCookie withSameSite(org.apache.pekko.http.javadsl.model.headers.SameSite sameSite) {
        Option<SameSite> option = Option$.MODULE$.apply(sameSite.asScala());
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option2 = this.copy$default$3();
        Option<Object> option3 = this.copy$default$4();
        Option<String> option4 = this.copy$default$5();
        Option<String> option5 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option6 = this.copy$default$9();
        return this.copy(string2, string3, option2, option3, option4, option5, bl, bl2, option6, option);
    }

    @Override
    public HttpCookie withSameSite(Optional<org.apache.pekko.http.javadsl.model.headers.SameSite> sameSite) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(sameSite);
        Option<SameSite> option = OptionConverters$RichOptional$.MODULE$.toScala$extension(optional).map((Function1<org.apache.pekko.http.javadsl.model.headers.SameSite, SameSite> & Serializable)_$3 -> _$3.asScala());
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option2 = this.copy$default$3();
        Option<Object> option3 = this.copy$default$4();
        Option<String> option4 = this.copy$default$5();
        Option<String> option5 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<String> option6 = this.copy$default$9();
        return this.copy(string2, string3, option2, option3, option4, option5, bl, bl2, option6, option);
    }

    @Override
    public HttpCookie withExtension(String extension) {
        Some<String> some = Some$.MODULE$.apply(extension);
        String string2 = this.copy$default$1();
        String string3 = this.copy$default$2();
        Option<DateTime> option = this.copy$default$3();
        Option<Object> option2 = this.copy$default$4();
        Option<String> option3 = this.copy$default$5();
        Option<String> option4 = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<SameSite> option5 = this.copy$default$10();
        return this.copy(string2, string3, option, option2, option3, option4, bl, bl2, some, option5);
    }

    private static final Object $init$$$anonfun$2(Option domain$10) {
        return new StringBuilder(36).append("'").append(HttpCookie$.MODULE$.domainChars().firstMismatch((String)domain$10.get()).get()).append("' not allowed in cookie domain ('").append(domain$10.get()).append("')").toString();
    }

    private static final Object $init$$$anonfun$4(Option path$10) {
        return new StringBuilder(34).append("'").append(HttpCookie$.MODULE$.pathOrExtChars().firstMismatch((String)path$10.get()).get()).append("' not allowed in cookie path ('").append(path$10.get()).append("')").toString();
    }

    private static final Object $init$$$anonfun$6(Option extension$10) {
        return new StringBuilder(39).append("'").append(HttpCookie$.MODULE$.pathOrExtChars().firstMismatch((String)extension$10.get()).get()).append("' not allowed in cookie extension ('").append(extension$10.get()).append("')").toString();
    }
}

