/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model.headers;

import java.io.Serializable;
import java.util.OptionalLong;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.ToStringRenderable;
import org.apache.pekko.http.impl.util.ValueRenderable;
import org.apache.pekko.http.scaladsl.model.headers.ByteRange$;
import org.apache.pekko.http.scaladsl.model.headers.ByteRange$FromOffset$;
import org.apache.pekko.http.scaladsl.model.headers.ByteRange$Slice$;
import org.apache.pekko.http.scaladsl.model.headers.ByteRange$Suffix$;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ByteRange
extends org.apache.pekko.http.javadsl.model.headers.ByteRange
implements ToStringRenderable,
ValueRenderable {
    public static Slice apply(long l, long l2) {
        return ByteRange$.MODULE$.apply(l, l2);
    }

    public static FromOffset fromOffset(long l) {
        return ByteRange$.MODULE$.fromOffset(l);
    }

    public static int ordinal(ByteRange byteRange) {
        return ByteRange$.MODULE$.ordinal(byteRange);
    }

    public static Suffix suffix(long l) {
        return ByteRange$.MODULE$.suffix(l);
    }

    @Override
    public OptionalLong getSliceFirst() {
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong getSliceLast() {
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong getOffset() {
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong getSuffixLength() {
        return OptionalLong.empty();
    }

    @Override
    public boolean isSlice() {
        return false;
    }

    @Override
    public boolean isFromOffset() {
        return false;
    }

    @Override
    public boolean isSuffix() {
        return false;
    }

    public static final class FromOffset
    extends ByteRange
    implements Product,
    Serializable {
        private final long offset;

        public static FromOffset apply(long l) {
            return ByteRange$FromOffset$.MODULE$.apply(l);
        }

        public static FromOffset fromProduct(Product product) {
            return ByteRange$FromOffset$.MODULE$.fromProduct(product);
        }

        public static FromOffset unapply(FromOffset fromOffset) {
            return ByteRange$FromOffset$.MODULE$.unapply(fromOffset);
        }

        public FromOffset(long offset) {
            this.offset = offset;
            Predef$.MODULE$.require(0L <= offset, this::$init$$$anonfun$2);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.offset()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FromOffset)) return false;
            FromOffset fromOffset = (FromOffset)object;
            if (this.offset() != fromOffset.offset()) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof FromOffset;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "FromOffset";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToLong(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offset";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long offset() {
            return this.offset;
        }

        @Override
        public <R extends Rendering> Rendering render(R r) {
            return r.$tilde$tilde(this.offset()).$tilde$tilde('-');
        }

        @Override
        public boolean isFromOffset() {
            return true;
        }

        @Override
        public OptionalLong getOffset() {
            return OptionalLong.of(this.offset());
        }

        public FromOffset copy(long offset) {
            return new FromOffset(offset);
        }

        public long copy$default$1() {
            return this.offset();
        }

        public long _1() {
            return this.offset();
        }

        private final Object $init$$$anonfun$2() {
            return "offset must be >= 0";
        }
    }

    public static final class Slice
    extends ByteRange
    implements Product,
    Serializable {
        private final long first;
        private final long last;

        public static Slice apply(long l, long l2) {
            return ByteRange$Slice$.MODULE$.apply(l, l2);
        }

        public static Slice fromProduct(Product product) {
            return ByteRange$Slice$.MODULE$.fromProduct(product);
        }

        public static Slice unapply(Slice slice) {
            return ByteRange$Slice$.MODULE$.unapply(slice);
        }

        public Slice(long first, long last) {
            this.first = first;
            this.last = last;
            Predef$.MODULE$.require(0L <= first && first <= last, this::$init$$$anonfun$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.first()));
            n = Statics.mix(n, Statics.longHash(this.last()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Slice)) return false;
            Slice slice = (Slice)object;
            if (this.first() != slice.first()) return false;
            if (this.last() != slice.last()) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Slice;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Slice";
        }

        @Override
        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToLong(l);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "first";
            }
            if (1 == n2) {
                return "last";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long first() {
            return this.first;
        }

        public long last() {
            return this.last;
        }

        @Override
        public <R extends Rendering> Rendering render(R r) {
            return r.$tilde$tilde(this.first()).$tilde$tilde('-').$tilde$tilde(this.last());
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public OptionalLong getSliceFirst() {
            return OptionalLong.of(this.first());
        }

        @Override
        public OptionalLong getSliceLast() {
            return OptionalLong.of(this.last());
        }

        public Slice copy(long first, long last) {
            return new Slice(first, last);
        }

        public long copy$default$1() {
            return this.first();
        }

        public long copy$default$2() {
            return this.last();
        }

        public long _1() {
            return this.first();
        }

        public long _2() {
            return this.last();
        }

        private final Object $init$$$anonfun$1() {
            return "first must be >= 0 and <= last";
        }
    }

    public static final class Suffix
    extends ByteRange
    implements Product,
    Serializable {
        private final long length;

        public static Suffix apply(long l) {
            return ByteRange$Suffix$.MODULE$.apply(l);
        }

        public static Suffix fromProduct(Product product) {
            return ByteRange$Suffix$.MODULE$.fromProduct(product);
        }

        public static Suffix unapply(Suffix suffix) {
            return ByteRange$Suffix$.MODULE$.unapply(suffix);
        }

        public Suffix(long length) {
            this.length = length;
            Predef$.MODULE$.require(0L <= length, this::$init$$$anonfun$3);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.length()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Suffix)) return false;
            Suffix suffix = (Suffix)object;
            if (this.length() != suffix.length()) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Suffix;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Suffix";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToLong(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "length";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long length() {
            return this.length;
        }

        @Override
        public <R extends Rendering> Rendering render(R r) {
            return r.$tilde$tilde('-').$tilde$tilde(this.length());
        }

        @Override
        public boolean isSuffix() {
            return true;
        }

        @Override
        public OptionalLong getSuffixLength() {
            return OptionalLong.of(this.length());
        }

        public Suffix copy(long length) {
            return new Suffix(length);
        }

        public long copy$default$1() {
            return this.length();
        }

        public long _1() {
            return this.length();
        }

        private final Object $init$$$anonfun$3() {
            return "length must be >= 0";
        }
    }
}

