/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.http.ccompat.QuerySeqOptimized;
import org.apache.pekko.http.impl.model.parser.UriParser;
import org.apache.pekko.http.impl.model.parser.UriParser$;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.JavaMapping$InetAddressIdentity$;
import org.apache.pekko.http.impl.util.S2JMapping$;
import org.apache.pekko.http.impl.util.StringRendering;
import org.apache.pekko.http.javadsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.Uri$Host$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv4Host$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv6Host$;
import org.apache.pekko.http.scaladsl.model.Uri$NamedHost$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$Relaxed$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Segment$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Slash$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Cons$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Empty$;
import org.apache.pekko.http.scaladsl.model.UriRendering$AuthorityRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$HostRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$PathRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$QueryRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$UriRenderer$;
import org.parboiled2.ParserInput;
import org.parboiled2.ParserInput$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.LinearSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DoNotInherit
public abstract class Uri
implements Product,
Serializable {
    private final String scheme;
    private final Authority authority;
    private final Path path;
    private final Option rawQueryString;
    private final Option fragment;

    public static Uri $div() {
        return Uri$.MODULE$.$div();
    }

    public static Uri apply(ParserInput parserInput) {
        return Uri$.MODULE$.apply(parserInput);
    }

    public static Uri apply(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.apply(parserInput, charset, parsingMode);
    }

    public static Uri apply(ParserInput parserInput, ParsingMode parsingMode) {
        return Uri$.MODULE$.apply(parserInput, parsingMode);
    }

    public static Uri apply(String string2) {
        return Uri$.MODULE$.apply(string2);
    }

    public static Uri apply(String string2, Authority authority, Path path, Option<String> option, Option<String> option2) {
        return Uri$.MODULE$.apply(string2, authority, path, option, option2);
    }

    public static Path collapseDotSegments(Path path) {
        return Uri$.MODULE$.collapseDotSegments(path);
    }

    public static Uri create(String string2, Authority authority, Path path, Option<String> option, Option<String> option2) {
        return Uri$.MODULE$.create(string2, authority, path, option, option2);
    }

    public static Uri create(String string2, String string3, Host host, int n, Path path, Option<String> option, Option<String> option2) {
        return Uri$.MODULE$.create(string2, string3, host, n, path, option, option2);
    }

    public static Uri createUnsafe(String string2, Authority authority, Path path, Option<String> option, Option<String> option2) {
        return Uri$.MODULE$.createUnsafe(string2, authority, path, option, option2);
    }

    public static String decode(String string2, Charset charset) {
        return Uri$.MODULE$.decode(string2, charset);
    }

    public static String decode(String string2, Charset charset, int n, StringBuilder stringBuilder) {
        return Uri$.MODULE$.decode(string2, charset, n, stringBuilder);
    }

    public static Uri effectiveHttpRequestUri(String string2, Host host, int n, Path path, Option<String> option, Option<String> option2, boolean bl, Host host2, int n2, Authority authority) {
        return Uri$.MODULE$.effectiveHttpRequestUri(string2, host, n, path, option, option2, bl, host2, n2, authority);
    }

    public static Uri effectiveRequestUri(String string2, Host host, int n, Path path, Option<String> option, Option<String> option2, String string3, Host host2, int n2, Authority authority) {
        return Uri$.MODULE$.effectiveRequestUri(string2, host, n, path, option, option2, string3, host2, n2, authority);
    }

    public static Nothing$ fail(String string2, String string3) {
        return Uri$.MODULE$.fail(string2, string3);
    }

    public static Uri from(String string2, String string3, String string4, int n, String string5, Option<String> option, Option<String> option2, ParsingMode parsingMode) {
        return Uri$.MODULE$.from(string2, string3, string4, n, string5, option, option2, parsingMode);
    }

    public static String httpScheme(boolean bl) {
        return Uri$.MODULE$.httpScheme(bl);
    }

    public static String normalize(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.normalize(parserInput, charset, parsingMode);
    }

    public static int normalizePort(int n, String string2) {
        return Uri$.MODULE$.normalizePort(n, string2);
    }

    public static String normalizeScheme(String string2) {
        return Uri$.MODULE$.normalizeScheme(string2);
    }

    public static Uri parseAbsolute(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.parseAbsolute(parserInput, charset, parsingMode);
    }

    public static Uri parseAndResolve(ParserInput parserInput, Uri uri, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.parseAndResolve(parserInput, uri, charset, parsingMode);
    }

    public static Authority parseHttp2AuthorityPseudoHeader(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.parseHttp2AuthorityPseudoHeader(parserInput, charset, parsingMode);
    }

    public static Tuple2<Path, Option<String>> parseHttp2PathPseudoHeader(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.parseHttp2PathPseudoHeader(parserInput, charset, parsingMode);
    }

    public static Uri parseHttpRequestTarget(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
        return Uri$.MODULE$.parseHttpRequestTarget(parserInput, charset, parsingMode);
    }

    public static Uri resolveUnsafe(String string2, String string3, Host host, int n, Path path, Option<String> option, Option<String> option2, Uri uri) {
        return Uri$.MODULE$.resolveUnsafe(string2, string3, host, n, path, option, option2, uri);
    }

    public static Uri unapply(Uri uri) {
        return Uri$.MODULE$.unapply(uri);
    }

    public static Path verifyPath(Path path, String string2, Host host) {
        return Uri$.MODULE$.verifyPath(path, string2, host);
    }

    public static String websocketScheme(boolean bl) {
        return Uri$.MODULE$.websocketScheme(bl);
    }

    public static String apply$default$1() {
        return Uri$.MODULE$.apply$default$1();
    }

    public static String from$default$1() {
        return Uri$.MODULE$.from$default$1();
    }

    public static boolean httpScheme$default$1() {
        return Uri$.MODULE$.httpScheme$default$1();
    }

    public static boolean websocketScheme$default$1() {
        return Uri$.MODULE$.websocketScheme$default$1();
    }

    public static Authority apply$default$2() {
        return Uri$.MODULE$.apply$default$2();
    }

    public static String fail$default$2() {
        return Uri$.MODULE$.fail$default$2();
    }

    public static String from$default$2() {
        return Uri$.MODULE$.from$default$2();
    }

    public static Charset normalize$default$2() {
        return Uri$.MODULE$.normalize$default$2();
    }

    public static Charset parseAbsolute$default$2() {
        return Uri$.MODULE$.parseAbsolute$default$2();
    }

    public static Charset parseHttp2AuthorityPseudoHeader$default$2() {
        return Uri$.MODULE$.parseHttp2AuthorityPseudoHeader$default$2();
    }

    public static Charset parseHttp2PathPseudoHeader$default$2() {
        return Uri$.MODULE$.parseHttp2PathPseudoHeader$default$2();
    }

    public static Charset parseHttpRequestTarget$default$2() {
        return Uri$.MODULE$.parseHttpRequestTarget$default$2();
    }

    public static Path apply$default$3() {
        return Uri$.MODULE$.apply$default$3();
    }

    public static String from$default$3() {
        return Uri$.MODULE$.from$default$3();
    }

    public static ParsingMode normalize$default$3() {
        return Uri$.MODULE$.normalize$default$3();
    }

    public static ParsingMode parseAbsolute$default$3() {
        return Uri$.MODULE$.parseAbsolute$default$3();
    }

    public static Charset parseAndResolve$default$3() {
        return Uri$.MODULE$.parseAndResolve$default$3();
    }

    public static ParsingMode parseHttp2AuthorityPseudoHeader$default$3() {
        return Uri$.MODULE$.parseHttp2AuthorityPseudoHeader$default$3();
    }

    public static ParsingMode parseHttp2PathPseudoHeader$default$3() {
        return Uri$.MODULE$.parseHttp2PathPseudoHeader$default$3();
    }

    public static ParsingMode parseHttpRequestTarget$default$3() {
        return Uri$.MODULE$.parseHttpRequestTarget$default$3();
    }

    public static Option<String> apply$default$4() {
        return Uri$.MODULE$.apply$default$4();
    }

    public static StringBuilder decode$default$4(String string2, Charset charset, int n) {
        return Uri$.MODULE$.decode$default$4(string2, charset, n);
    }

    public static int from$default$4() {
        return Uri$.MODULE$.from$default$4();
    }

    public static ParsingMode parseAndResolve$default$4() {
        return Uri$.MODULE$.parseAndResolve$default$4();
    }

    public static Option<String> apply$default$5() {
        return Uri$.MODULE$.apply$default$5();
    }

    public static String from$default$5() {
        return Uri$.MODULE$.from$default$5();
    }

    public static Option<String> from$default$6() {
        return Uri$.MODULE$.from$default$6();
    }

    public static Option<String> from$default$7() {
        return Uri$.MODULE$.from$default$7();
    }

    public static ParsingMode from$default$8() {
        return Uri$.MODULE$.from$default$8();
    }

    public static Authority effectiveHttpRequestUri$default$10() {
        return Uri$.MODULE$.effectiveHttpRequestUri$default$10();
    }

    public static Authority effectiveRequestUri$default$10() {
        return Uri$.MODULE$.effectiveRequestUri$default$10();
    }

    public Uri(String scheme, Authority authority, Path path, Option<String> rawQueryString, Option<String> fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.rawQueryString = rawQueryString;
        this.fragment = fragment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Uri)) return false;
        Uri uri = (Uri)object;
        String string2 = this.scheme();
        String string3 = uri.scheme();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Authority authority = this.authority();
        Authority authority2 = uri.authority();
        if (authority == null) {
            if (authority2 != null) {
                return false;
            }
        } else if (!((Object)authority).equals(authority2)) return false;
        Path path = this.path();
        Path path2 = uri.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        Option<String> option = this.rawQueryString();
        Option<String> option2 = uri.rawQueryString();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.fragment();
        Option<String> option4 = uri.fragment();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!uri.canEqual(this)) return false;
        return true;
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Uri;
    }

    @Override
    public int productArity() {
        return 5;
    }

    @Override
    public String productPrefix() {
        return "Uri";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "scheme";
            }
            case 1: {
                return "authority";
            }
            case 2: {
                return "path";
            }
            case 3: {
                return "rawQueryString";
            }
            case 4: {
                return "fragment";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public String scheme() {
        return this.scheme;
    }

    public Authority authority() {
        return this.authority;
    }

    public Path path() {
        return this.path;
    }

    public Option<String> rawQueryString() {
        return this.rawQueryString;
    }

    public Option<String> fragment() {
        return this.fragment;
    }

    public boolean isAbsolute() {
        return !this.isRelative();
    }

    public boolean isRelative() {
        return this.scheme().isEmpty();
    }

    public abstract boolean isEmpty();

    public Query query(Charset charset, ParsingMode mode) {
        Option<String> option = this.rawQueryString();
        if (option instanceof Some) {
            String q = (String)((Some)option).value();
            return new UriParser(ParserInput$.MODULE$.apply(q), charset, mode).parseQuery();
        }
        if (None$.MODULE$.equals(option)) {
            return Uri$Query$Empty$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Charset query$default$1() {
        return org.apache.pekko.http.impl.util.package$.MODULE$.UTF8();
    }

    public ParsingMode query$default$2() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Option<String> queryString(Charset charset) {
        return this.rawQueryString().map((Function1<String, String> & Serializable)s2 -> Uri$.MODULE$.decode((String)s2, charset));
    }

    public Charset queryString$default$1() {
        return org.apache.pekko.http.impl.util.package$.MODULE$.UTF8();
    }

    public int effectivePort() {
        if (this.authority().port() != 0) {
            return this.authority().port();
        }
        return BoxesRunTime.unboxToInt(Uri$.org$apache$pekko$http$scaladsl$model$Uri$$$defaultPorts.apply(this.scheme()));
    }

    public Uri copy(String scheme, Authority authority, Path path, Option<String> rawQueryString, Option<String> fragment) {
        return Uri$.MODULE$.apply(scheme, authority, path, rawQueryString, fragment);
    }

    public String copy$default$1() {
        return this.scheme();
    }

    public Authority copy$default$2() {
        return this.authority();
    }

    public Path copy$default$3() {
        return this.path();
    }

    public Option<String> copy$default$4() {
        return this.rawQueryString();
    }

    public Option<String> copy$default$5() {
        return this.fragment();
    }

    public Uri withScheme(String scheme) {
        return this.copy(scheme, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Uri withAuthority(Authority authority) {
        return this.copy(this.copy$default$1(), authority, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Uri withAuthority(Host host, int port, String userinfo) {
        Authority authority = Uri$Authority$.MODULE$.apply(host, port, userinfo);
        String string2 = this.copy$default$1();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(string2, authority, path, option, option2);
    }

    public String withAuthority$default$3() {
        return "";
    }

    public Uri withAuthority(String host, int port) {
        Authority authority = Uri$Authority$.MODULE$.apply(Uri$Host$.MODULE$.apply(host, Uri$Host$.MODULE$.apply$default$2(), Uri$Host$.MODULE$.apply$default$3()), port, Uri$Authority$.MODULE$.$lessinit$greater$default$3());
        String string2 = this.copy$default$1();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(string2, authority, path, option, option2);
    }

    public Uri withHost(Host host) {
        Authority authority = this.authority().copy(host, this.authority().copy$default$2(), this.authority().copy$default$3());
        String string2 = this.copy$default$1();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(string2, authority, path, option, option2);
    }

    public Uri withHost(String host) {
        Authority authority = this.authority().copy(Uri$Host$.MODULE$.apply(host, Uri$Host$.MODULE$.apply$default$2(), Uri$Host$.MODULE$.apply$default$3()), this.authority().copy$default$2(), this.authority().copy$default$3());
        String string2 = this.copy$default$1();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(string2, authority, path, option, option2);
    }

    public Uri withPort(int port) {
        Authority authority = this.authority().copy(this.authority().copy$default$1(), port, this.authority().copy$default$3());
        String string2 = this.copy$default$1();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(string2, authority, path, option, option2);
    }

    public Uri withPath(Path path) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), path, this.copy$default$4(), this.copy$default$5());
    }

    public Uri withUserInfo(String userinfo) {
        Authority authority = this.authority().copy(this.authority().copy$default$1(), this.authority().copy$default$2(), userinfo);
        String string2 = this.copy$default$1();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(string2, authority, path, option, option2);
    }

    public Uri withQuery(Query query) {
        None$ none$ = query.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(query.toString());
        String string2 = this.copy$default$1();
        Authority authority = this.copy$default$2();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$5();
        return this.copy(string2, authority, path, none$, option);
    }

    public Uri withRawQueryString(String rawQuery) {
        return this.withRawQueryString(rawQuery, Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri withRawQueryString(String rawQueryString, ParsingMode mode) {
        ParserInput.StringBasedParserInput stringBasedParserInput = ParserInput$.MODULE$.apply(rawQueryString);
        Charset charset = UriParser$.MODULE$.$lessinit$greater$default$2();
        Some<String> some = Some$.MODULE$.apply(new UriParser(stringBasedParserInput, charset, mode).parseRawQueryString());
        String string2 = this.copy$default$1();
        Authority authority = this.copy$default$2();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$5();
        return this.copy(string2, authority, path, some, option);
    }

    public Uri withFragment(String fragment) {
        Option<String> option = EnhancedString$.MODULE$.toOption$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(fragment));
        String string2 = this.copy$default$1();
        Authority authority = this.copy$default$2();
        Path path = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        return this.copy(string2, authority, path, option2, option);
    }

    public Uri resolvedAgainst(Uri base) {
        return Uri$.MODULE$.resolveUnsafe(this.scheme(), this.authority().userinfo(), this.authority().host(), this.authority().port(), this.path(), this.rawQueryString(), this.fragment(), base);
    }

    public Uri toEffectiveHttpRequestUri(Host hostHeaderHost, int hostHeaderPort, boolean securedConnection, Authority defaultAuthority) {
        return this.toEffectiveRequestUri(hostHeaderHost, hostHeaderPort, Uri$.MODULE$.httpScheme(securedConnection), defaultAuthority);
    }

    public boolean toEffectiveHttpRequestUri$default$3() {
        return false;
    }

    public Authority toEffectiveHttpRequestUri$default$4() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri toEffectiveRequestUri(Host hostHeaderHost, int hostHeaderPort, String defaultScheme, Authority defaultAuthority) {
        return Uri$.MODULE$.effectiveRequestUri(this.scheme(), this.authority().host(), this.authority().port(), this.path(), this.rawQueryString(), this.fragment(), defaultScheme, hostHeaderHost, hostHeaderPort, defaultAuthority);
    }

    public Authority toEffectiveRequestUri$default$4() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri toRelative() {
        Path path = this.path().isEmpty() ? Uri$Path$.MODULE$.$div() : this.path();
        String string2 = Uri$.MODULE$.apply$default$1();
        Authority authority = Uri$.MODULE$.apply$default$2();
        return Uri$.MODULE$.apply(string2, authority, path, this.rawQueryString(), this.fragment());
    }

    public Uri toHttpRequestTargetOriginForm() {
        return Uri$.MODULE$.create("", Uri$Authority$.MODULE$.Empty(), this.path().isEmpty() ? Uri$Path$.MODULE$.$div() : this.path(), this.rawQueryString(), None$.MODULE$);
    }

    public Uri withoutFragment() {
        None$ none$ = None$.MODULE$;
        String string2 = this.copy$default$1();
        Authority authority = this.copy$default$2();
        Path path = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        return this.copy(string2, authority, path, option, none$);
    }

    public String toString() {
        return ((StringRendering)UriRendering$UriRenderer$.MODULE$.render(new StringRendering(), this)).get();
    }

    public String _1() {
        return this.scheme();
    }

    public Authority _2() {
        return this.authority();
    }

    public Path _3() {
        return this.path();
    }

    public Option<String> _4() {
        return this.rawQueryString();
    }

    public Option<String> _5() {
        return this.fragment();
    }

    public static final class Authority
    extends org.apache.pekko.http.javadsl.model.Authority
    implements Product,
    Serializable {
        private final Host host;
        private final int port;
        private final String userinfo;

        public static Authority Empty() {
            return Uri$Authority$.MODULE$.Empty();
        }

        public static Authority apply(Host host, int n, String string2) {
            return Uri$Authority$.MODULE$.apply(host, n, string2);
        }

        public static Authority fromProduct(Product product) {
            return Uri$Authority$.MODULE$.fromProduct(product);
        }

        public static Authority parse(ParserInput parserInput, Charset charset, ParsingMode parsingMode) {
            return Uri$Authority$.MODULE$.parse(parserInput, charset, parsingMode);
        }

        public static Authority unapply(Authority authority) {
            return Uri$Authority$.MODULE$.unapply(authority);
        }

        public static int $lessinit$greater$default$2() {
            return Uri$Authority$.MODULE$.$lessinit$greater$default$2();
        }

        public static Charset parse$default$2() {
            return Uri$Authority$.MODULE$.parse$default$2();
        }

        public static String $lessinit$greater$default$3() {
            return Uri$Authority$.MODULE$.$lessinit$greater$default$3();
        }

        public static ParsingMode parse$default$3() {
            return Uri$Authority$.MODULE$.parse$default$3();
        }

        public Authority(Host host, int port, String userinfo) {
            this.host = host;
            this.port = port;
            this.userinfo = userinfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.host()));
            n = Statics.mix(n, this.port());
            n = Statics.mix(n, Statics.anyHash(this.userinfo()));
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Authority)) return false;
            Authority authority = (Authority)object;
            if (this.port() != authority.port()) return false;
            Host host = this.host();
            Host host2 = authority.host();
            if (host == null) {
                if (host2 != null) {
                    return false;
                }
            } else if (!host.equals(host2)) return false;
            String string2 = this.userinfo();
            String string3 = authority.userinfo();
            if (string2 == null) {
                if (string3 == null) return true;
                return false;
            } else {
                if (!string2.equals(string3)) return false;
                return true;
            }
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Authority;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Authority";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger(this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "host";
                }
                case 1: {
                    return "port";
                }
                case 2: {
                    return "userinfo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public Host host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public String userinfo() {
            return this.userinfo;
        }

        public boolean isEmpty() {
            return this.equals(Uri$Authority$.MODULE$.Empty());
        }

        public boolean nonEmpty() {
            return !this.isEmpty();
        }

        public Authority normalizedForHttp(boolean encrypted) {
            return this.normalizedFor(Uri$.MODULE$.httpScheme(encrypted));
        }

        public boolean normalizedForHttp$default$1() {
            return false;
        }

        public Authority normalizedFor(String scheme) {
            int normalizedPort = Uri$.MODULE$.normalizePort(this.port(), scheme);
            if (normalizedPort == this.port()) {
                return this;
            }
            return this.copy(this.copy$default$1(), normalizedPort, this.copy$default$3());
        }

        public String toString() {
            return ((StringRendering)UriRendering$AuthorityRenderer$.MODULE$.render(new StringRendering(), this)).get();
        }

        public Authority copy(Host host, int port, String userinfo) {
            return new Authority(host, port, userinfo);
        }

        public Host copy$default$1() {
            return this.host();
        }

        public int copy$default$2() {
            return this.port();
        }

        public String copy$default$3() {
            return this.userinfo();
        }

        public Host _1() {
            return this.host();
        }

        public int _2() {
            return this.port();
        }

        public String _3() {
            return this.userinfo();
        }
    }

    public static abstract class Host
    extends org.apache.pekko.http.javadsl.model.Host {
        public static IPv4Host apply(Inet4Address inet4Address) {
            return Uri$Host$.MODULE$.apply(inet4Address);
        }

        public static IPv6Host apply(Inet6Address inet6Address) {
            return Uri$Host$.MODULE$.apply(inet6Address);
        }

        public static Host apply(InetAddress inetAddress) {
            return Uri$Host$.MODULE$.apply(inetAddress);
        }

        public static Host apply(String string2, Charset charset, ParsingMode parsingMode) {
            return Uri$Host$.MODULE$.apply(string2, charset, parsingMode);
        }

        public static int ordinal(Host host) {
            return Uri$Host$.MODULE$.ordinal(host);
        }

        public static Charset apply$default$2() {
            return Uri$Host$.MODULE$.apply$default$2();
        }

        public static ParsingMode apply$default$3() {
            return Uri$Host$.MODULE$.apply$default$3();
        }

        @Override
        public abstract String address();

        @Override
        public abstract boolean isEmpty();

        public abstract Option<NonEmptyHost> toOption();

        public abstract scala.collection.immutable.Seq<InetAddress> inetAddresses();

        public abstract boolean equalsIgnoreCase(Host var1);

        public String toString() {
            return ((StringRendering)UriRendering$HostRenderer$.MODULE$.render(new StringRendering(), this)).get();
        }

        @Override
        public boolean isNamedHost() {
            return false;
        }

        @Override
        public boolean isIPv6() {
            return false;
        }

        @Override
        public boolean isIPv4() {
            return false;
        }

        @Override
        public java.lang.Iterable<InetAddress> getInetAddresses() {
            return (java.lang.Iterable)JavaMapping$Implicits$.MODULE$.AddAsJava(this.inetAddresses(), S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$.MODULE$.iterableMapping(JavaMapping$InetAddressIdentity$.MODULE$))).asJava();
        }
    }

    public static final class IPv4Host
    extends NonEmptyHost
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq bytes;
        private final String address;

        public static IPv4Host apply(byte by, byte by2, byte by3, byte by4) {
            return Uri$IPv4Host$.MODULE$.apply(by, by2, by3, by4);
        }

        public static IPv4Host apply(byte[] byArray) {
            return Uri$IPv4Host$.MODULE$.apply(byArray);
        }

        public static IPv4Host apply(byte[] byArray, String string2) {
            return Uri$IPv4Host$.MODULE$.apply(byArray, string2);
        }

        public static IPv4Host apply(scala.collection.immutable.Seq<Object> seq, String string2) {
            return Uri$IPv4Host$.MODULE$.apply(seq, string2);
        }

        public static IPv4Host apply(String string2) {
            return Uri$IPv4Host$.MODULE$.apply(string2);
        }

        public static IPv4Host fromProduct(Product product) {
            return Uri$IPv4Host$.MODULE$.fromProduct(product);
        }

        public static IPv4Host unapply(IPv4Host iPv4Host) {
            return Uri$IPv4Host$.MODULE$.unapply(iPv4Host);
        }

        public IPv4Host(scala.collection.immutable.Seq<Object> bytes, String address) {
            this.bytes = bytes;
            this.address = address;
            Predef$.MODULE$.require(bytes.length() == 4, this::$init$$$anonfun$1);
            Predef$.MODULE$.require(!address.isEmpty(), this::$init$$$anonfun$2);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IPv4Host)) return false;
            IPv4Host iPv4Host = (IPv4Host)object;
            scala.collection.immutable.Seq<Object> seq = this.bytes();
            scala.collection.immutable.Seq<Object> seq2 = iPv4Host.bytes();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            String string2 = this.address();
            String string3 = iPv4Host.address();
            if (string2 == null) {
                if (string3 == null) return true;
                return false;
            } else {
                if (!string2.equals(string3)) return false;
                return true;
            }
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof IPv4Host;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "IPv4Host";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bytes";
            }
            if (1 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public scala.collection.immutable.Seq<Object> bytes() {
            return this.bytes;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public boolean equalsIgnoreCase(Host other) {
            Host host = other;
            if (host instanceof IPv4Host) {
                IPv4Host iPv4Host = Uri$IPv4Host$.MODULE$.unapply((IPv4Host)host);
                scala.collection.immutable.Seq<Object> seq = iPv4Host._1();
                String string2 = iPv4Host._2();
                scala.collection.immutable.Seq<Object> seq2 = this.bytes();
                scala.collection.immutable.Seq<Object> seq3 = seq;
                if (!(seq2 != null ? !seq2.equals(seq3) : seq3 != null)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isIPv4() {
            return true;
        }

        @Override
        public scala.collection.immutable.Seq<InetAddress> inetAddresses() {
            return (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new InetAddress[]{InetAddress.getByAddress((byte[])this.bytes().toArray(ClassTag$.MODULE$.apply(Byte.TYPE)))}));
        }

        public IPv4Host copy(scala.collection.immutable.Seq<Object> bytes, String address) {
            return new IPv4Host(bytes, address);
        }

        public scala.collection.immutable.Seq<Object> copy$default$1() {
            return this.bytes();
        }

        public String copy$default$2() {
            return this.address();
        }

        public scala.collection.immutable.Seq<Object> _1() {
            return this.bytes();
        }

        public String _2() {
            return this.address();
        }

        private final Object $init$$$anonfun$1() {
            return "bytes array must have length 4";
        }

        private final Object $init$$$anonfun$2() {
            return "address must not be empty";
        }
    }

    public static final class IPv6Host
    extends NonEmptyHost
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq bytes;
        private final String address;

        public static IPv6Host apply(byte[] byArray) {
            return Uri$IPv6Host$.MODULE$.apply(byArray);
        }

        public static IPv6Host apply(byte[] byArray, String string2) {
            return Uri$IPv6Host$.MODULE$.apply(byArray, string2);
        }

        public static IPv6Host apply(scala.collection.immutable.Seq<Object> seq) {
            return Uri$IPv6Host$.MODULE$.apply(seq);
        }

        public static IPv6Host apply(String string2, String string3) {
            return Uri$IPv6Host$.MODULE$.apply(string2, string3);
        }

        public static IPv6Host fromProduct(Product product) {
            return Uri$IPv6Host$.MODULE$.fromProduct(product);
        }

        public static IPv6Host unapply(IPv6Host iPv6Host) {
            return Uri$IPv6Host$.MODULE$.unapply(iPv6Host);
        }

        public IPv6Host(scala.collection.immutable.Seq<Object> bytes, String address) {
            this.bytes = bytes;
            this.address = address;
            Predef$.MODULE$.require(bytes.length() == 16, this::$init$$$anonfun$3);
            Predef$.MODULE$.require(!address.isEmpty(), this::$init$$$anonfun$4);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IPv6Host)) return false;
            IPv6Host iPv6Host = (IPv6Host)object;
            scala.collection.immutable.Seq<Object> seq = this.bytes();
            scala.collection.immutable.Seq<Object> seq2 = iPv6Host.bytes();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            String string2 = this.address();
            String string3 = iPv6Host.address();
            if (string2 == null) {
                if (string3 == null) return true;
                return false;
            } else {
                if (!string2.equals(string3)) return false;
                return true;
            }
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof IPv6Host;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "IPv6Host";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bytes";
            }
            if (1 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public scala.collection.immutable.Seq<Object> bytes() {
            return this.bytes;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public boolean equalsIgnoreCase(Host other) {
            Host host = other;
            if (host instanceof IPv6Host) {
                IPv6Host iPv6Host = Uri$IPv6Host$.MODULE$.unapply((IPv6Host)host);
                scala.collection.immutable.Seq<Object> seq = iPv6Host._1();
                String string2 = iPv6Host._2();
                scala.collection.immutable.Seq<Object> seq2 = this.bytes();
                scala.collection.immutable.Seq<Object> seq3 = seq;
                if (!(seq2 != null ? !seq2.equals(seq3) : seq3 != null)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isIPv6() {
            return true;
        }

        @Override
        public scala.collection.immutable.Seq<InetAddress> inetAddresses() {
            return (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new InetAddress[]{InetAddress.getByAddress((byte[])this.bytes().toArray(ClassTag$.MODULE$.apply(Byte.TYPE)))}));
        }

        private IPv6Host copy(scala.collection.immutable.Seq<Object> bytes, String address) {
            return new IPv6Host(bytes, address);
        }

        private scala.collection.immutable.Seq<Object> copy$default$1() {
            return this.bytes();
        }

        private String copy$default$2() {
            return this.address();
        }

        public scala.collection.immutable.Seq<Object> _1() {
            return this.bytes();
        }

        public String _2() {
            return this.address();
        }

        private final Object $init$$$anonfun$3() {
            return "bytes array must have length 16";
        }

        private final Object $init$$$anonfun$4() {
            return "address must not be empty";
        }
    }

    public static final class NamedHost
    extends NonEmptyHost
    implements Product,
    Serializable {
        private final String address;

        public static NamedHost apply(String string2) {
            return Uri$NamedHost$.MODULE$.apply(string2);
        }

        public static NamedHost fromProduct(Product product) {
            return Uri$NamedHost$.MODULE$.fromProduct(product);
        }

        public static NamedHost unapply(NamedHost namedHost) {
            return Uri$NamedHost$.MODULE$.unapply(namedHost);
        }

        public NamedHost(String address) {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NamedHost)) return false;
            NamedHost namedHost = (NamedHost)object;
            String string2 = this.address();
            String string3 = namedHost.address();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof NamedHost;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "NamedHost";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public boolean equalsIgnoreCase(Host other) {
            Host host = other;
            if (host instanceof NamedHost) {
                String string2;
                NamedHost namedHost = Uri$NamedHost$.MODULE$.unapply((NamedHost)host);
                String otherAddress = string2 = namedHost._1();
                return this.address().equalsIgnoreCase(otherAddress);
            }
            return false;
        }

        @Override
        public boolean isNamedHost() {
            return true;
        }

        @Override
        public scala.collection.immutable.Seq<InetAddress> inetAddresses() {
            return Predef$.MODULE$.wrapRefArray(InetAddress.getAllByName(this.address())).toList();
        }

        public NamedHost copy(String address) {
            return new NamedHost(address);
        }

        public String copy$default$1() {
            return this.address();
        }

        public String _1() {
            return this.address();
        }
    }

    public static abstract class NonEmptyHost
    extends Host {
        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Option<NonEmptyHost> toOption() {
            return Some$.MODULE$.apply(this);
        }
    }

    public static interface ParsingMode
    extends Uri.ParsingMode {
        public static ParsingMode apply(String string2) {
            return Uri$ParsingMode$.MODULE$.apply(string2);
        }

        public static int ordinal(ParsingMode parsingMode) {
            return Uri$ParsingMode$.MODULE$.ordinal(parsingMode);
        }
    }

    public static abstract class Path {
        public static Slash SingleSlash() {
            return Uri$Path$.MODULE$.SingleSlash();
        }

        public static Path apply(String string2, Charset charset) {
            return Uri$Path$.MODULE$.apply(string2, charset);
        }

        public static int ordinal(Path path) {
            return Uri$Path$.MODULE$.ordinal(path);
        }

        public static Option<String> unapply(Path path) {
            return Uri$Path$.MODULE$.unapply(path);
        }

        public static Option<String> unapply(Uri uri) {
            return Uri$Path$.MODULE$.unapply(uri);
        }

        public static Charset apply$default$2() {
            return Uri$Path$.MODULE$.apply$default$2();
        }

        public abstract boolean isEmpty();

        public abstract boolean startsWithSlash();

        public abstract boolean startsWithSegment();

        public boolean endsWithSlash() {
            return this.rec$1(this);
        }

        public final boolean endsWith(String suffix, boolean ignoreTrailingSlash) {
            return this.rec$2(suffix, ignoreTrailingSlash, this, this.rec$default$2$1());
        }

        public boolean endsWith$default$2() {
            return false;
        }

        public abstract Object head();

        public abstract Path tail();

        public abstract int length();

        public abstract int charCount();

        public Path $colon$colon(char c) {
            Predef$.MODULE$.require(c == '/');
            return Uri$Path$Slash$.MODULE$.apply(this);
        }

        public abstract Path $colon$colon(String var1);

        public Path $plus(String pathString) {
            return this.$plus$plus(Uri$Path$.MODULE$.apply(pathString, Uri$Path$.MODULE$.apply$default$2()));
        }

        public abstract Path $plus$plus(Path var1);

        public Path reverse() {
            return this.reverseAndPrependTo(Uri$Path$Empty$.MODULE$);
        }

        public abstract Path reverseAndPrependTo(Path var1);

        public Path $div(String segment) {
            return this.$plus$plus(Uri$Path$Slash$.MODULE$.apply(Uri$Path$Empty$.MODULE$.$colon$colon(segment)));
        }

        public Path $qmark$div(String segment) {
            if (this.endsWithSlash()) {
                return this.$plus(segment);
            }
            return this.$div(segment);
        }

        public abstract boolean startsWith(Path var1);

        public abstract Path dropChars(int var1);

        public String toString() {
            return ((StringRendering)UriRendering$PathRenderer$.MODULE$.render(new StringRendering(), this)).get();
        }

        private final boolean rec$1(Path path) {
            Path path2;
            while (true) {
                SlashOrEmpty slashOrEmpty;
                if (Uri$Path$Empty$.MODULE$.equals(path2 = path)) {
                    return false;
                }
                if (path2 instanceof Slash) {
                    Path tail;
                    Slash slash = Uri$Path$Slash$.MODULE$.unapply((Slash)path2);
                    Path path3 = slash._1();
                    if (Uri$Path$Empty$.MODULE$.equals(path3)) {
                        return true;
                    }
                    path = tail = path3;
                    continue;
                }
                if (!(path2 instanceof Segment)) break;
                Segment segment = Uri$Path$Segment$.MODULE$.unapply((Segment)path2);
                String string2 = segment._1();
                SlashOrEmpty tail = slashOrEmpty = segment._2();
                path = tail;
            }
            throw new MatchError(path2);
        }

        private final boolean rec$2(String suffix$1, boolean ignoreTrailingSlash$1, Path path, String lastSegment) {
            Path path2;
            while (true) {
                SlashOrEmpty tail;
                if (Uri$Path$Empty$.MODULE$.equals(path2 = path)) {
                    return lastSegment.endsWith(suffix$1);
                }
                if (path2 instanceof Slash) {
                    Path tail2;
                    Slash slash = Uri$Path$Slash$.MODULE$.unapply((Slash)path2);
                    Path path3 = slash._1();
                    if (Uri$Path$Empty$.MODULE$.equals(path3)) {
                        return ignoreTrailingSlash$1 && lastSegment.endsWith(suffix$1);
                    }
                    Path path4 = tail2 = path3;
                    String string2 = "";
                    path = path4;
                    lastSegment = string2;
                    continue;
                }
                if (!(path2 instanceof Segment)) break;
                Segment segment = Uri$Path$Segment$.MODULE$.unapply((Segment)path2);
                String string3 = segment._1();
                SlashOrEmpty slashOrEmpty = segment._2();
                String head = string3;
                SlashOrEmpty slashOrEmpty2 = tail = slashOrEmpty;
                String string4 = head;
                path = slashOrEmpty2;
                lastSegment = string4;
            }
            throw new MatchError(path2);
        }

        private final String rec$default$2$1() {
            return "";
        }

        public static final class Segment
        extends Path
        implements Product,
        Serializable {
            private final String head;
            private final SlashOrEmpty tail;

            public static Segment apply(String string2, SlashOrEmpty slashOrEmpty) {
                return Uri$Path$Segment$.MODULE$.apply(string2, slashOrEmpty);
            }

            public static Segment fromProduct(Product product) {
                return Uri$Path$Segment$.MODULE$.fromProduct(product);
            }

            public static Segment unapply(Segment segment) {
                return Uri$Path$Segment$.MODULE$.unapply(segment);
            }

            public Segment(String head, SlashOrEmpty tail) {
                this.head = head;
                this.tail = tail;
                if (head.isEmpty()) {
                    throw new IllegalArgumentException("Path segment must not be empty");
                }
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode(this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Segment)) return false;
                Segment segment = (Segment)object;
                String string2 = this.head();
                String string3 = segment.head();
                if (string2 == null) {
                    if (string3 != null) {
                        return false;
                    }
                } else if (!string2.equals(string3)) return false;
                SlashOrEmpty slashOrEmpty = this.tail();
                SlashOrEmpty slashOrEmpty2 = segment.tail();
                if (slashOrEmpty == null) {
                    if (slashOrEmpty2 == null) return true;
                    return false;
                } else {
                    if (!slashOrEmpty.equals(slashOrEmpty2)) return false;
                    return true;
                }
            }

            @Override
            public boolean canEqual(Object that) {
                return that instanceof Segment;
            }

            @Override
            public int productArity() {
                return 2;
            }

            @Override
            public String productPrefix() {
                return "Segment";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "head";
                }
                if (1 == n2) {
                    return "tail";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String head() {
                return this.head;
            }

            @Override
            public SlashOrEmpty tail() {
                return this.tail;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean startsWithSlash() {
                return false;
            }

            @Override
            public boolean startsWithSegment() {
                return true;
            }

            @Override
            public int length() {
                return this.tail().length() + 1;
            }

            @Override
            public int charCount() {
                return this.head().length() + this.tail().charCount();
            }

            @Override
            public Path $colon$colon(String segment) {
                if (segment.isEmpty()) {
                    return this;
                }
                return Uri$Path$Segment$.MODULE$.apply(new StringBuilder(0).append(segment).append(this.head()).toString(), this.tail());
            }

            @Override
            public Path $plus$plus(Path suffix) {
                return this.tail().$plus$plus(suffix).$colon$colon(this.head());
            }

            @Override
            public Path reverseAndPrependTo(Path prefix) {
                return this.tail().reverseAndPrependTo(prefix.$colon$colon(this.head()));
            }

            @Override
            public boolean startsWith(Path that) {
                Path path = that;
                if (path instanceof Segment) {
                    Segment segment = Uri$Path$Segment$.MODULE$.unapply((Segment)path);
                    String string2 = segment._1();
                    SlashOrEmpty slashOrEmpty = segment._2();
                    String string3 = this.head();
                    String string4 = string2;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        SlashOrEmpty t = slashOrEmpty;
                        return this.tail().startsWith(t);
                    }
                    String h = string2;
                    if (Uri$Path$Empty$.MODULE$.equals(slashOrEmpty)) {
                        return this.head().startsWith(h);
                    }
                }
                Path x = path;
                return x.isEmpty();
            }

            @Override
            public Path dropChars(int count) {
                if (count < 1) {
                    return this;
                }
                if (count >= this.head().length()) {
                    return this.tail().dropChars(count - this.head().length());
                }
                String string2 = this.head().substring(count);
                return this.tail().$colon$colon(string2);
            }

            public Segment copy(String head, SlashOrEmpty tail) {
                return new Segment(head, tail);
            }

            public String copy$default$1() {
                return this.head();
            }

            public SlashOrEmpty copy$default$2() {
                return this.tail();
            }

            public String _1() {
                return this.head();
            }

            public SlashOrEmpty _2() {
                return this.tail();
            }
        }

        public static final class Slash
        extends SlashOrEmpty
        implements Product,
        Serializable {
            private final Path tail;

            public static Slash apply(Path path) {
                return Uri$Path$Slash$.MODULE$.apply(path);
            }

            public static Slash fromProduct(Product product) {
                return Uri$Path$Slash$.MODULE$.fromProduct(product);
            }

            public static Slash unapply(Slash slash) {
                return Uri$Path$Slash$.MODULE$.unapply(slash);
            }

            public Slash(Path tail) {
                this.tail = tail;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode(this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Slash)) return false;
                Slash slash = (Slash)object;
                Path path = this.tail();
                Path path2 = slash.tail();
                if (path != null) {
                    if (!path.equals(path2)) return false;
                    return true;
                }
                if (path2 == null) return true;
                return false;
            }

            @Override
            public boolean canEqual(Object that) {
                return that instanceof Slash;
            }

            @Override
            public int productArity() {
                return 1;
            }

            @Override
            public String productPrefix() {
                return "Slash";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "tail";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public Path tail() {
                return this.tail;
            }

            public char head() {
                return '/';
            }

            @Override
            public boolean startsWithSlash() {
                return true;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int length() {
                return this.tail().length() + 1;
            }

            @Override
            public int charCount() {
                return this.tail().charCount() + 1;
            }

            @Override
            public Path $colon$colon(String segment) {
                return segment.isEmpty() ? this : Uri$Path$Segment$.MODULE$.apply(segment, this);
            }

            @Override
            public Path $plus$plus(Path suffix) {
                return Uri$Path$Slash$.MODULE$.apply(this.tail().$plus$plus(suffix));
            }

            @Override
            public Path reverseAndPrependTo(Path prefix) {
                return this.tail().reverseAndPrependTo(Uri$Path$Slash$.MODULE$.apply(prefix));
            }

            @Override
            public boolean startsWith(Path that) {
                return that.isEmpty() || that.startsWithSlash() && this.tail().startsWith(that.tail());
            }

            @Override
            public Path dropChars(int count) {
                if (count < 1) {
                    return this;
                }
                return this.tail().dropChars(count - 1);
            }

            public Slash copy(Path tail) {
                return new Slash(tail);
            }

            public Path copy$default$1() {
                return this.tail();
            }

            public Path _1() {
                return this.tail();
            }
        }

        public static abstract class SlashOrEmpty
        extends Path {
            @Override
            public boolean startsWithSegment() {
                return false;
            }
        }
    }

    public static abstract class Query
    implements IterableOnce,
    IterableOnceOps,
    IterableOps,
    IterableFactoryDefaults,
    Iterable,
    scala.collection.immutable.Iterable,
    Function1,
    PartialFunction,
    SeqOps,
    Seq,
    scala.collection.immutable.Seq,
    LinearSeqOps,
    scala.collection.LinearSeq,
    LinearSeq,
    StrictOptimizedIterableOps,
    StrictOptimizedSeqOps,
    StrictOptimizedLinearSeqOps,
    QuerySeqOptimized {
        public static String EmptyValue() {
            return Uri$Query$.MODULE$.EmptyValue();
        }

        public static Builder<Tuple2<String, String>, Query> newBuilder() {
            return Uri$Query$.MODULE$.newBuilder();
        }

        public static int ordinal(Query query) {
            return Uri$Query$.MODULE$.ordinal(query);
        }

        public static Charset apply$default$2() {
            return Uri$Query$.MODULE$.apply$default$2();
        }

        public static ParsingMode apply$default$3() {
            return Uri$Query$.MODULE$.apply$default$3();
        }

        public Query() {
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            IterableOps.$init$(this);
            IterableFactoryDefaults.$init$(this);
            Iterable.$init$(this);
            scala.collection.immutable.Iterable.$init$(this);
            PartialFunction.$init$(this);
            SeqOps.$init$(this);
            Seq.$init$(this);
            scala.collection.immutable.Seq.$init$(this);
            LinearSeqOps.$init$(this);
            scala.collection.LinearSeq.$init$(this);
            LinearSeq.$init$(this);
            StrictOptimizedIterableOps.$init$(this);
            StrictOptimizedSeqOps.$init$(this);
            StrictOptimizedLinearSeqOps.$init$(this);
        }

        public <B> LinearSeq<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
            return (LinearSeq)IterableOps.concat$(this, suffix);
        }

        @Override
        public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
            return IterableOps.sizeCompare$((IterableOps)this, otherSize);
        }

        @Override
        public int scala$collection$SeqOps$$super$sizeCompare(Iterable<?> that) {
            return IterableOps.sizeCompare$((IterableOps)this, that);
        }

        @Override
        public <B> boolean scala$collection$LinearSeqOps$$super$sameElements(IterableOnce<B> that) {
            return SeqOps.sameElements$(this, that);
        }

        public abstract String key();

        public abstract String value();

        @Override
        public Cons $plus$colon(Tuple2<String, String> kvp) {
            return Uri$Query$Cons$.MODULE$.apply(kvp._1(), kvp._2(), this);
        }

        public Option<String> get(String key2) {
            return this.g$1(key2, this);
        }

        public String getOrElse(String key2, Function0<String> function0) {
            return this.g$2(function0, key2, this);
        }

        public List<String> getAll(String key2) {
            return this.fetch$1(key2, this, this.fetch$default$2$1());
        }

        public Map<String, String> toMap() {
            return this.append$1((Map)Predef$.MODULE$.Map().empty(), this);
        }

        public Map<String, List<String>> toMultiMap() {
            return this.append$2((Map)Predef$.MODULE$.Map().empty(), this);
        }

        @Override
        public String toString() {
            return ((StringRendering)UriRendering$QueryRenderer$.MODULE$.render(new StringRendering(), this)).get();
        }

        private final Option g$1(String key$1, Query q) {
            while (!q.isEmpty()) {
                String string2 = q.key();
                String string3 = key$1;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return Some$.MODULE$.apply(q.value());
                }
                q = (Query)q.tail();
            }
            return None$.MODULE$;
        }

        private final String g$2(Function0 default$1, String key$2, Query q) {
            while (!q.isEmpty()) {
                String string2 = q.key();
                String string3 = key$2;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return q.value();
                }
                q = (Query)q.tail();
            }
            return (String)default$1.apply();
        }

        private final List fetch$1(String key$3, Query q, List result) {
            while (!q.isEmpty()) {
                List<String> list;
                Query query = (Query)q.tail();
                String string2 = q.key();
                String string3 = key$3;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    String string4 = q.value();
                    list = result.$colon$colon(string4);
                } else {
                    list = result;
                }
                List<String> list2 = list;
                q = query;
                result = list2;
            }
            return result;
        }

        private final List fetch$default$2$1() {
            return package$.MODULE$.Nil();
        }

        private final Map append$1(Map map, Query q) {
            while (!q.isEmpty()) {
                Map map2 = (Map)map.updated(q.key(), q.value());
                Query query = (Query)q.tail();
                map = map2;
                q = query;
            }
            return map;
        }

        private final List append$2$$anonfun$1() {
            return package$.MODULE$.Nil();
        }

        private final Map append$2(Map map, Query q) {
            while (!q.isEmpty()) {
                Map map2 = (Map)map.updated(q.key(), ((SeqOps)map.getOrElse(q.key(), this::append$2$$anonfun$1)).$colon$plus(q.value()));
                Query query = (Query)q.tail();
                map = map2;
                q = query;
            }
            return map;
        }

        public static final class Cons
        extends Query
        implements Product,
        Serializable {
            private final String key;
            private final String value;
            private final Query tail;

            public static Cons fromProduct(Product product) {
                return Uri$Query$Cons$.MODULE$.fromProduct(product);
            }

            public Cons(String key2, String value, Query tail) {
                this.key = key2;
                this.value = value;
                this.tail = tail;
            }

            @Override
            public int productArity() {
                return 3;
            }

            @Override
            public String productPrefix() {
                return "Cons";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "key";
                    }
                    case 1: {
                        return "value";
                    }
                    case 2: {
                        return "tail";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String key() {
                return this.key;
            }

            @Override
            public String value() {
                return this.value;
            }

            @Override
            public Query tail() {
                return this.tail;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Tuple2<String, String> head() {
                return Tuple2$.MODULE$.apply(this.key(), this.value());
            }

            public Cons copy(String key2, String value, Query tail) {
                return new Cons(key2, value, tail);
            }

            public String copy$default$1() {
                return this.key();
            }

            public String copy$default$2() {
                return this.value();
            }

            public Query copy$default$3() {
                return this.tail();
            }

            public String _1() {
                return this.key();
            }

            public String _2() {
                return this.value();
            }

            public Query _3() {
                return this.tail();
            }
        }
    }
}

