/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.UriParser;
import org.apache.pekko.http.impl.model.parser.UriParser$;
import org.apache.pekko.http.impl.util.StringRendering;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.IllegalUriException$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.Uri$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Host$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv4Host$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv6Host$;
import org.apache.pekko.http.scaladsl.model.Uri$NamedHost$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$Relaxed$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Segment$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Slash$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.UriRendering$;
import org.parboiled2.CharPredicate;
import org.parboiled2.CharUtils$;
import org.parboiled2.ParserInput;
import org.parboiled2.ParserInput$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Uri$
implements Serializable {
    public static final Uri$Empty$ Empty;
    private static final Uri $div;
    public static final Uri$Authority$ Authority;
    public static final Uri$Host$ Host;
    public static final Uri$IPv4Host$ IPv4Host;
    public static final Uri$IPv6Host$ IPv6Host;
    public static final Uri$NamedHost$ NamedHost;
    public static final Uri$Path$ Path;
    public static final Uri$Query$ Query;
    public static final Map<String, Object> org$apache$pekko$http$scaladsl$model$Uri$$$defaultPorts;
    public static final Uri$ParsingMode$ ParsingMode;
    public static final Uri$ MODULE$;

    private Uri$() {
    }

    static {
        MODULE$ = new Uri$();
        $div = MODULE$.apply("/");
        Tuple2[] tuple2Array = new Tuple2[17];
        String string2 = Predef$.MODULE$.ArrowAssoc("ftp");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToInteger(21));
        String string3 = Predef$.MODULE$.ArrowAssoc("ssh");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, BoxesRunTime.boxToInteger(22));
        String string4 = Predef$.MODULE$.ArrowAssoc("telnet");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, BoxesRunTime.boxToInteger(23));
        String string5 = Predef$.MODULE$.ArrowAssoc("smtp");
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, BoxesRunTime.boxToInteger(25));
        String string6 = Predef$.MODULE$.ArrowAssoc("domain");
        tuple2Array[4] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string6, BoxesRunTime.boxToInteger(53));
        String string7 = Predef$.MODULE$.ArrowAssoc("tftp");
        tuple2Array[5] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string7, BoxesRunTime.boxToInteger(69));
        String string8 = Predef$.MODULE$.ArrowAssoc("http");
        tuple2Array[6] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string8, BoxesRunTime.boxToInteger(80));
        String string9 = Predef$.MODULE$.ArrowAssoc("ws");
        tuple2Array[7] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string9, BoxesRunTime.boxToInteger(80));
        String string10 = Predef$.MODULE$.ArrowAssoc("pop3");
        tuple2Array[8] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string10, BoxesRunTime.boxToInteger(110));
        String string11 = Predef$.MODULE$.ArrowAssoc("nntp");
        tuple2Array[9] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string11, BoxesRunTime.boxToInteger(119));
        String string12 = Predef$.MODULE$.ArrowAssoc("imap");
        tuple2Array[10] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string12, BoxesRunTime.boxToInteger(143));
        String string13 = Predef$.MODULE$.ArrowAssoc("snmp");
        tuple2Array[11] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string13, BoxesRunTime.boxToInteger(161));
        String string14 = Predef$.MODULE$.ArrowAssoc("ldap");
        tuple2Array[12] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string14, BoxesRunTime.boxToInteger(389));
        String string15 = Predef$.MODULE$.ArrowAssoc("https");
        tuple2Array[13] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string15, BoxesRunTime.boxToInteger(443));
        String string16 = Predef$.MODULE$.ArrowAssoc("wss");
        tuple2Array[14] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string16, BoxesRunTime.boxToInteger(443));
        String string17 = Predef$.MODULE$.ArrowAssoc("imaps");
        tuple2Array[15] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string17, BoxesRunTime.boxToInteger(993));
        String string18 = Predef$.MODULE$.ArrowAssoc("nfs");
        tuple2Array[16] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string18, BoxesRunTime.boxToInteger(2049));
        org$apache$pekko$http$scaladsl$model$Uri$$$defaultPorts = ((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).withDefaultValue(BoxesRunTime.boxToInteger(-1));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Uri$.class);
    }

    public Uri unapply(Uri x$1) {
        return x$1;
    }

    public Uri $div() {
        return $div;
    }

    public Uri apply(String input) {
        return this.apply(ParserInput$.MODULE$.apply(input), package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input) {
        return this.apply(input, package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input, Uri.ParsingMode mode) {
        return this.apply(input, package$.MODULE$.UTF8(), mode);
    }

    public Uri apply(ParserInput input, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(input, charset, mode).parseUriReference();
    }

    public Uri apply(String scheme, Uri.Authority authority, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        Uri.Path p = this.verifyPath(path, scheme, authority.host());
        return this.create(this.normalizeScheme(scheme), authority, scheme.isEmpty() ? p : this.collapseDotSegments(p), queryString, fragment);
    }

    public String apply$default$1() {
        return "";
    }

    public Uri.Authority apply$default$2() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri.Path apply$default$3() {
        return Uri$Path$Empty$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Uri from(String scheme, String userinfo, String host, int port, String path, Option<String> queryString, Option<String> fragment, Uri.ParsingMode mode) {
        return this.apply(scheme, Uri$Authority$.MODULE$.apply(Uri$Host$.MODULE$.apply(host, package$.MODULE$.UTF8(), mode), this.normalizePort(port, scheme), userinfo), Uri$Path$.MODULE$.apply(path, Uri$Path$.MODULE$.apply$default$2()), queryString, fragment);
    }

    public String from$default$1() {
        return "";
    }

    public String from$default$2() {
        return "";
    }

    public String from$default$3() {
        return "";
    }

    public int from$default$4() {
        return 0;
    }

    public String from$default$5() {
        return "";
    }

    public Option<String> from$default$6() {
        return None$.MODULE$;
    }

    public Option<String> from$default$7() {
        return None$.MODULE$;
    }

    public Uri.ParsingMode from$default$8() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAbsolute(ParserInput input, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(input, charset, mode).parseAbsoluteUri();
    }

    public Charset parseAbsolute$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAbsolute$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAndResolve(ParserInput string2, Uri base, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(string2, charset, mode).parseAndResolveUriReference(base);
    }

    public Charset parseAndResolve$default$3() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAndResolve$default$4() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseHttpRequestTarget(ParserInput requestTarget, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(requestTarget, charset, mode).parseHttpRequestTarget();
    }

    public Charset parseHttpRequestTarget$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttpRequestTarget$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Tuple2<Uri.Path, Option<String>> parseHttp2PathPseudoHeader(ParserInput headerValue, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(headerValue, charset, mode).parseHttp2PathPseudoHeader();
    }

    public Charset parseHttp2PathPseudoHeader$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttp2PathPseudoHeader$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri.Authority parseHttp2AuthorityPseudoHeader(ParserInput headerValue, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(headerValue, charset, mode).parseHttp2AuthorityPseudoHeader();
    }

    public Charset parseHttp2AuthorityPseudoHeader$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttp2AuthorityPseudoHeader$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public String normalize(ParserInput uri, Charset charset, Uri.ParsingMode mode) {
        Uri parsed = this.apply(uri, charset, mode);
        Uri.Authority authority = parsed.authority().normalizedFor(parsed.scheme());
        String string2 = parsed.copy$default$1();
        Uri.Path path = parsed.copy$default$3();
        Option<String> option = parsed.copy$default$4();
        Option<String> option2 = parsed.copy$default$5();
        Uri normalized = parsed.copy(string2, authority, path, option, option2);
        return ((StringRendering)UriRendering$.MODULE$.renderUri(new StringRendering(), normalized, charset)).get();
    }

    public Charset normalize$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode normalize$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri effectiveHttpRequestUri(String scheme, Uri.Host host, int port, Uri.Path path, Option<String> query, Option<String> fragment, boolean securedConnection, Uri.Host hostHeaderHost, int hostHeaderPort, Uri.Authority defaultAuthority) {
        return this.effectiveRequestUri(scheme, host, port, path, query, fragment, this.httpScheme(securedConnection), hostHeaderHost, hostHeaderPort, defaultAuthority);
    }

    public Uri.Authority effectiveHttpRequestUri$default$10() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri effectiveRequestUri(String scheme, Uri.Host host, int port, Uri.Path path, Option<String> query, Option<String> fragment, String defaultScheme, Uri.Host hostHeaderHost, int hostHeaderPort, Uri.Authority defaultAuthority) {
        String _scheme = scheme;
        Uri.Host _host = host;
        int _port = port;
        if (_scheme.isEmpty()) {
            _scheme = defaultScheme;
            if (_host.isEmpty()) {
                if (hostHeaderHost.isEmpty()) {
                    _host = defaultAuthority.host();
                    _port = defaultAuthority.port();
                } else {
                    _host = hostHeaderHost;
                    _port = hostHeaderPort;
                }
            }
        }
        return this.create(_scheme, "", _host, _port, this.collapseDotSegments(path), query, fragment);
    }

    public Uri.Authority effectiveRequestUri$default$10() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public String httpScheme(boolean securedConnection) {
        if (securedConnection) {
            return "https";
        }
        return "http";
    }

    public boolean httpScheme$default$1() {
        return false;
    }

    public String websocketScheme(boolean securedConnection) {
        if (securedConnection) {
            return "wss";
        }
        return "ws";
    }

    public boolean websocketScheme$default$1() {
        return false;
    }

    public Uri resolveUnsafe(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Option<String> query, Option<String> fragment, Uri base) {
        Predef$.MODULE$.require(base.isAbsolute(), this::resolveUnsafe$$anonfun$1);
        if (scheme.isEmpty()) {
            if (host.isEmpty()) {
                if (path.isEmpty()) {
                    return this.createUnsafe(base.scheme(), base.authority(), base.path(), query.orElse(() -> this.resolveUnsafe$$anonfun$2(base)), fragment);
                }
                Uri.Path p = path.startsWithSlash() ? path : this.mergePaths$1(base, path);
                return this.createUnsafe(base.scheme(), base.authority(), this.collapseDotSegments(p), query, fragment);
            }
            return this.createUnsafe(base.scheme(), Uri$Authority$.MODULE$.apply(host, port, userinfo), this.collapseDotSegments(path), query, fragment);
        }
        return this.createUnsafe(scheme, Uri$Authority$.MODULE$.apply(host, port, userinfo), this.collapseDotSegments(path), query, fragment);
    }

    public String decode(String string2, Charset charset) {
        int ix = string2.indexOf(37);
        if (ix >= 0) {
            return this.decode(string2, charset, ix, this.decode$default$4(string2, charset, ix));
        }
        return string2;
    }

    public String decode(String string2, Charset charset, int ix, StringBuilder sb) {
        while (ix < string2.length()) {
            char c = string2.charAt(ix);
            if ('%' == c) {
                Serializable serializable;
                int lastPercentSignIndexPlus3;
                for (lastPercentSignIndexPlus3 = ix + 3; lastPercentSignIndexPlus3 < string2.length() && string2.charAt(lastPercentSignIndexPlus3) == '%'; lastPercentSignIndexPlus3 += 3) {
                }
                if (string2.length() < lastPercentSignIndexPlus3) {
                    throw this.fail(new StringBuilder(32).append("Illegal percent-encoding at pos ").append(lastPercentSignIndexPlus3 - 3).toString(), this.fail$default$2());
                }
                int bytesCount = (lastPercentSignIndexPlus3 - ix) / 3;
                byte[] bytes = new byte[bytesCount];
                if (this.decodeBytes$1(bytesCount, ix, bytes, string2, this.decodeBytes$default$1$1(), this.decodeBytes$default$2$1()) >> 7 == 0 && UriRendering$.MODULE$.isAsciiCompatible(charset)) {
                    this.appendBytes$1(bytesCount, sb, bytes, this.appendBytes$default$1$1());
                    serializable = BoxedUnit.UNIT;
                } else {
                    serializable = sb.append(new String(bytes, charset));
                }
                ix = lastPercentSignIndexPlus3;
                continue;
            }
            char x = c;
            int n = ix + 1;
            StringBuilder stringBuilder = sb.append(x);
            ix = n;
            sb = stringBuilder;
        }
        return sb.toString();
    }

    public StringBuilder decode$default$4(String string2, Charset charset, int ix) {
        return new StringBuilder(string2.length()).append(string2, 0, ix);
    }

    public String normalizeScheme(String scheme) {
        int n = this.verify$1(scheme, this.verify$default$1$1(), this.verify$default$2$1(), this.verify$default$3$1());
        if (-2 == n) {
            return scheme.toLowerCase();
        }
        if (-1 == n) {
            return scheme;
        }
        int ix = n;
        throw this.fail(new StringBuilder(53).append("Invalid URI scheme, unexpected character at pos ").append(ix).append(" ('").append(scheme.charAt(ix)).append("')").toString(), this.fail$default$2());
    }

    public int normalizePort(int port, String scheme) {
        if (port >> 16 == 0) {
            if (port != 0 && BoxesRunTime.unboxToInt(org$apache$pekko$http$scaladsl$model$Uri$$$defaultPorts.apply(scheme)) == port) {
                return 0;
            }
            return port;
        }
        throw this.fail(new StringBuilder(13).append("Invalid port ").append(port).toString(), this.fail$default$2());
    }

    public Uri.Path verifyPath(Uri.Path path, String scheme, Uri.Host host) {
        if (host.isEmpty()) {
            if (path.startsWithSlash() && path.tail().startsWithSlash()) {
                throw this.fail("The path of an URI without authority must not begin with \"//\"", this.fail$default$2());
            }
        } else if (path.startsWithSegment()) {
            throw this.fail("The path of an URI containing an authority must either be empty or start with a '/' (slash) character", this.fail$default$2());
        }
        return path;
    }

    public Uri.Path collapseDotSegments(Uri.Path path) {
        if (this.hasDotOrDotDotSegment$1(path)) {
            if (path.startsWithSlash()) {
                return this.process$1(path, this.process$default$2$1());
            }
            return this.process$1(Uri$Path$Slash$.MODULE$.apply(path), this.process$default$2$1()).tail();
        }
        return path;
    }

    public Nothing$ fail(String summary, String detail) {
        throw IllegalUriException$.MODULE$.apply(summary, detail);
    }

    public String fail$default$2() {
        return "";
    }

    public Uri create(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        return this.create(scheme, Uri$Authority$.MODULE$.apply(host, port, userinfo), path, queryString, fragment);
    }

    public Uri create(String scheme, Uri.Authority authority, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        return this.createUnsafe(scheme, authority, path, queryString.map((Function1<String, String> & Serializable)_$3 -> new UriParser(ParserInput$.MODULE$.apply((String)_$3), UriParser$.MODULE$.$lessinit$greater$default$2(), UriParser$.MODULE$.$lessinit$greater$default$3()).parseRawQueryString()), fragment);
    }

    public Uri createUnsafe(String scheme, Uri.Authority authority, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        if (path.isEmpty() && scheme.isEmpty() && authority.isEmpty() && queryString.isEmpty() && fragment.isEmpty()) {
            return Uri$Empty$.MODULE$;
        }
        return new Uri(scheme, authority, path, queryString, fragment, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(scheme$14, authority$13, path$13, queryString$1, fragment$12);
            }

            public boolean isEmpty() {
                return false;
            }
        };
    }

    private final Object resolveUnsafe$$anonfun$1() {
        return "Resolution base Uri must be absolute";
    }

    private final Option resolveUnsafe$$anonfun$2(Uri base$1) {
        return base$1.rawQueryString();
    }

    private final Uri.Path replaceLastSegment$1(Uri.Path p, Uri.Path replacement) {
        Uri.Path path;
        block6: {
            block5: {
                path = p;
                if (Uri$Path$Empty$.MODULE$.equals(path)) break block5;
                if (!(path instanceof Uri.Path.Segment)) break block6;
                Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path);
                String string2 = segment._1();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
                if (!Uri$Path$Empty$.MODULE$.equals(slashOrEmpty)) break block6;
            }
            return replacement;
        }
        if (path instanceof Uri.Path.Segment) {
            Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path);
            String string3 = segment._1();
            Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
            String string4 = string3;
            Uri.Path.SlashOrEmpty tail = slashOrEmpty;
            return this.replaceLastSegment$1(tail, replacement).$colon$colon(string4);
        }
        if (path instanceof Uri.Path.Slash) {
            Uri.Path path2;
            Uri.Path.Slash slash = Uri$Path$Slash$.MODULE$.unapply((Uri.Path.Slash)path);
            Uri.Path tail = path2 = slash._1();
            return Uri$Path$Slash$.MODULE$.apply(this.replaceLastSegment$1(tail, replacement));
        }
        throw new MatchError(path);
    }

    private final Uri.Path mergePaths$1(Uri base, Uri.Path path) {
        if (!base.authority().isEmpty() && base.path().isEmpty()) {
            return Uri$Path$Slash$.MODULE$.apply(path);
        }
        return this.replaceLastSegment$1(base.path(), path);
    }

    private final int intValueOfHexChar$1(String string$4, int j) {
        char c = string$4.charAt(j);
        if (CharacterClasses$.MODULE$.HEXDIG().apply(c)) {
            return CharUtils$.MODULE$.hexValue(c);
        }
        throw this.fail(new StringBuilder(32).append("Illegal percent-encoding at pos ").append(j).toString(), this.fail$default$2());
    }

    private final int intValueOfHexWord$1(String string$3, int i) {
        return this.intValueOfHexChar$1(string$3, i) * 16 + this.intValueOfHexChar$1(string$3, i + 1);
    }

    private final int decodeBytes$1(int bytesCount$1, int ix$tailLocal2$1, byte[] bytes$1, String string$5, int i, int oredBytes) {
        while (i < bytesCount$1) {
            int n = this.intValueOfHexWord$1(string$5, ix$tailLocal2$1 + 3 * i + 1);
            bytes$1[i] = (byte)n;
            int n2 = i + 1;
            int n3 = oredBytes | n;
            i = n2;
            oredBytes = n3;
        }
        return oredBytes;
    }

    private final int decodeBytes$default$1$1() {
        return 0;
    }

    private final int decodeBytes$default$2$1() {
        return 0;
    }

    private final void appendBytes$1(int bytesCount$2, StringBuilder sb$tailLocal1$1, byte[] bytes$2, int i) {
        while (i < bytesCount$2) {
            sb$tailLocal1$1.append((char)bytes$2[i]);
            ++i;
        }
    }

    private final int appendBytes$default$1$1() {
        return 0;
    }

    private final int verify$1(String scheme$13, int ix, CharPredicate allowed, boolean allLower) {
        while (ix < scheme$13.length()) {
            char c = scheme$13.charAt(ix);
            if (allowed.apply(c)) {
                int n = ix + 1;
                CharPredicate charPredicate = CharacterClasses$.MODULE$.scheme$minuschar();
                boolean bl = allLower && !CharacterClasses$.MODULE$.UPPER_ALPHA().apply(c);
                ix = n;
                allowed = charPredicate;
                allLower = bl;
                continue;
            }
            return ix;
        }
        if (allLower) {
            return -1;
        }
        return -2;
    }

    private final int verify$default$1$1() {
        return 0;
    }

    private final CharPredicate verify$default$2$1() {
        return CharacterClasses$.MODULE$.ALPHA();
    }

    private final boolean verify$default$3$1() {
        return true;
    }

    private final boolean hasDotOrDotDotSegment$1(Uri.Path p) {
        Uri.Path path;
        while (!Uri$Path$Empty$.MODULE$.equals(path = p)) {
            if (path instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path);
                String string2 = segment._1();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
                if (".".equals(string2) || "..".equals(string2)) {
                    return true;
                }
            }
            p = p.tail();
        }
        return false;
    }

    private final Uri.Path process$1(Uri.Path input, Uri.Path output) {
        Uri.Path path;
        while (true) {
            Uri.Path.SlashOrEmpty tail;
            Uri.Path.Slash slash;
            Uri.Path path2;
            if (Uri$Path$Empty$.MODULE$.equals(path = input)) {
                return output.reverse();
            }
            if (path instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path);
                String string2 = segment._1();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
                if (".".equals(string2) || "..".equals(string2)) {
                    if (slashOrEmpty instanceof Uri.Path.Slash) {
                        Uri.Path path3;
                        Uri.Path tail2;
                        Uri.Path.Slash slash2 = Uri$Path$Slash$.MODULE$.unapply((Uri.Path.Slash)slashOrEmpty);
                        input = tail2 = (path3 = slash2._1());
                        continue;
                    }
                }
            }
            if (path instanceof Uri.Path.Slash && (path2 = (slash = Uri$Path$Slash$.MODULE$.unapply((Uri.Path.Slash)path))._1()) instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path2);
                String string3 = segment._1();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
                if (".".equals(string3)) {
                    Uri.Path.SlashOrEmpty tail3 = slashOrEmpty;
                    input = tail3.isEmpty() ? Uri$Path$.MODULE$.$div() : tail3;
                    continue;
                }
                if ("..".equals(string3)) {
                    Uri.Path path4;
                    Uri.Path.SlashOrEmpty tail4 = slashOrEmpty;
                    Uri.Path path5 = path4 = tail4.isEmpty() ? Uri$Path$.MODULE$.$div() : tail4;
                    Uri.Path path6 = output.startsWithSegment() ? (output.tail().startsWithSlash() ? output.tail().tail() : tail4) : output;
                    input = path4;
                    output = path6;
                    continue;
                }
            }
            if (path instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path);
                String string4 = segment._1();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
                if (".".equals(string4) || "..".equals(string4)) {
                    Uri.Path.SlashOrEmpty tail5 = slashOrEmpty;
                    input = tail5;
                    continue;
                }
            }
            if (path instanceof Uri.Path.Slash) {
                Uri.Path path7;
                Uri.Path tail6;
                Uri.Path.Slash slash3 = Uri$Path$Slash$.MODULE$.unapply((Uri.Path.Slash)path);
                Uri.Path path8 = tail6 = (path7 = slash3._1());
                Uri.Path.Slash slash4 = Uri$Path$Slash$.MODULE$.apply(output);
                input = path8;
                output = slash4;
                continue;
            }
            if (!(path instanceof Uri.Path.Segment)) break;
            Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path);
            String string5 = segment._1();
            Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
            String string6 = string5;
            Uri.Path.SlashOrEmpty slashOrEmpty2 = tail = slashOrEmpty;
            Uri.Path path9 = output.$colon$colon(string6);
            input = slashOrEmpty2;
            output = path9;
        }
        throw new MatchError(path);
    }

    private final Uri.Path process$default$2$1() {
        return Uri$Path$Empty$.MODULE$;
    }
}

