/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.impl.util.ObjectRegistry;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$ClientError$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$CustomStatusCode$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$Informational$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$Redirection$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$ServerError$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$Success$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;

public final class StatusCodes$
implements ObjectRegistry<Object, StatusCode> {
    private static Map org$apache$pekko$http$impl$util$ObjectRegistry$$_registry;
    public static final StatusCodes$Informational$ Informational;
    public static final StatusCodes$Success$ Success;
    public static final StatusCodes$Redirection$ Redirection;
    public static final StatusCodes$ClientError$ ClientError;
    public static final StatusCodes$ServerError$ ServerError;
    public static final StatusCodes$CustomStatusCode$ CustomStatusCode;
    private static final StatusCodes.Informational Continue;
    private static final StatusCodes.Informational SwitchingProtocols;
    private static final StatusCodes.Informational Processing;
    @ApiMayChange
    private static final StatusCodes.Informational EarlyHints;
    private static final StatusCodes.Success OK;
    private static final StatusCodes.Success Created;
    private static final StatusCodes.Success Accepted;
    private static final StatusCodes.Success NonAuthoritativeInformation;
    private static final StatusCodes.Success NoContent;
    private static final StatusCodes.Success ResetContent;
    private static final StatusCodes.Success PartialContent;
    private static final StatusCodes.Success MultiStatus;
    private static final StatusCodes.Success AlreadyReported;
    private static final StatusCodes.Success IMUsed;
    private static final StatusCodes.Redirection MultipleChoices;
    private static final StatusCodes.Redirection MovedPermanently;
    private static final StatusCodes.Redirection Found;
    private static final StatusCodes.Redirection SeeOther;
    private static final StatusCodes.Redirection NotModified;
    private static final StatusCodes.Redirection UseProxy;
    private static final StatusCodes.Redirection TemporaryRedirect;
    private static final StatusCodes.Redirection PermanentRedirect;
    private static final StatusCodes.ClientError BadRequest;
    private static final StatusCodes.ClientError Unauthorized;
    private static final StatusCodes.ClientError PaymentRequired;
    private static final StatusCodes.ClientError Forbidden;
    private static final StatusCodes.ClientError NotFound;
    private static final StatusCodes.ClientError MethodNotAllowed;
    private static final StatusCodes.ClientError NotAcceptable;
    private static final StatusCodes.ClientError ProxyAuthenticationRequired;
    private static final StatusCodes.ClientError RequestTimeout;
    private static final StatusCodes.ClientError Conflict;
    private static final StatusCodes.ClientError Gone;
    private static final StatusCodes.ClientError LengthRequired;
    private static final StatusCodes.ClientError PreconditionFailed;
    private static final StatusCodes.ClientError ContentTooLarge;
    private static final StatusCodes.ClientError PayloadTooLarge;
    private static final StatusCodes.ClientError RequestEntityTooLarge;
    private static final StatusCodes.ClientError UriTooLong;
    private static final StatusCodes.ClientError RequestUriTooLong;
    private static final StatusCodes.ClientError UnsupportedMediaType;
    private static final StatusCodes.ClientError RangeNotSatisfiable;
    private static final StatusCodes.ClientError RequestedRangeNotSatisfiable;
    private static final StatusCodes.ClientError ExpectationFailed;
    private static final StatusCodes.ClientError ImATeapot;
    private static final StatusCodes.ClientError EnhanceYourCalm;
    private static final StatusCodes.ClientError MisdirectedRequest;
    private static final StatusCodes.ClientError UnprocessableContent;
    private static final StatusCodes.ClientError UnprocessableEntity;
    private static final StatusCodes.ClientError Locked;
    private static final StatusCodes.ClientError FailedDependency;
    private static final StatusCodes.ClientError TooEarly;
    private static final StatusCodes.ClientError UnorderedCollection;
    private static final StatusCodes.ClientError UpgradeRequired;
    private static final StatusCodes.ClientError PreconditionRequired;
    private static final StatusCodes.ClientError TooManyRequests;
    private static final StatusCodes.ClientError RequestHeaderFieldsTooLarge;
    private static final StatusCodes.ClientError RetryWith;
    private static final StatusCodes.ClientError BlockedByParentalControls;
    private static final StatusCodes.ClientError UnavailableForLegalReasons;
    private static final StatusCodes.ServerError InternalServerError;
    private static final StatusCodes.ServerError NotImplemented;
    private static final StatusCodes.ServerError BadGateway;
    private static final StatusCodes.ServerError ServiceUnavailable;
    private static final StatusCodes.ServerError GatewayTimeout;
    private static final StatusCodes.ServerError HttpVersionNotSupported;
    private static final StatusCodes.ServerError HTTPVersionNotSupported;
    private static final StatusCodes.ServerError VariantAlsoNegotiates;
    private static final StatusCodes.ServerError InsufficientStorage;
    private static final StatusCodes.ServerError LoopDetected;
    private static final StatusCodes.ServerError BandwidthLimitExceeded;
    private static final StatusCodes.ServerError NotExtended;
    private static final StatusCodes.ServerError NetworkAuthenticationRequired;
    private static final StatusCodes.ServerError NetworkReadTimeout;
    private static final StatusCodes.ServerError NetworkConnectTimeout;
    public static final StatusCodes$ MODULE$;

    private StatusCodes$() {
    }

    static {
        MODULE$ = new StatusCodes$();
        ObjectRegistry.$init$(MODULE$);
        Continue = MODULE$.reg(StatusCodes$Informational$.MODULE$.apply(100, "Continue", "The server has received the request headers, and the client should proceed to send the request body."));
        SwitchingProtocols = MODULE$.reg(StatusCodes$Informational$.MODULE$.apply(101, "Switching Protocols", "The server is switching protocols, because the client requested the switch."));
        Processing = MODULE$.reg(StatusCodes$Informational$.MODULE$.apply(102, "Processing", "The server is processing the request, but no response is available yet."));
        EarlyHints = MODULE$.reg(StatusCodes$Informational$.MODULE$.apply(103, "Early Hints", "The server is likely to send a final response with the header fields included in the response."));
        OK = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(200, "OK", "OK", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(200)));
        Created = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(201, "Created", "The request has been fulfilled and resulted in a new resource being created.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(201)));
        Accepted = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(202, "Accepted", "The request has been accepted for processing, but the processing has not been completed.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(202)));
        NonAuthoritativeInformation = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(203, "Non-Authoritative Information", "The server successfully processed the request, but is returning information that may be from another source.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(203)));
        NoContent = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(204, "No Content", "The server successfully processed the request and is not returning any content.", false));
        ResetContent = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(205, "Reset Content", "The server successfully processed the request, but is not returning any content.", false));
        PartialContent = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(206, "Partial Content", "The server is delivering only part of the resource due to a range header sent by the client.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(206)));
        MultiStatus = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(207, "Multi-Status", "The message body that follows is an XML message and can contain a number of separate response codes, depending on how many sub-requests were made.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(207)));
        AlreadyReported = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(208, "Already Reported", "The members of a DAV binding have already been enumerated in a previous reply to this request, and are not being included again.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(208)));
        IMUsed = MODULE$.reg(StatusCodes$Success$.MODULE$.apply(226, "IM Used", "The server has fulfilled a GET request for the resource, and the response is a representation of the result of one or more instance-manipulations applied to the current instance.", StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(226)));
        MultipleChoices = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(300, "Multiple Choices", "There are multiple options for the resource that the client may follow.", "There are multiple options for the resource that the client may follow. The preferred one is <a href=\"%s\">this URI</a>.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(300)));
        MovedPermanently = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(301, "Moved Permanently", "This and all future requests should be directed to the given URI.", "This and all future requests should be directed to <a href=\"%s\">this URI</a>.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(301)));
        Found = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(302, "Found", "The resource was found, but at a different URI.", "The requested resource temporarily resides under <a href=\"%s\">this URI</a>.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(302)));
        SeeOther = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(303, "See Other", "The response to the request can be found under another URI using a GET method.", "The response to the request can be found under <a href=\"%s\">this URI</a> using a GET method.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(303)));
        NotModified = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(304, "Not Modified", "The resource has not been modified since last requested.", "", false));
        UseProxy = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(305, "Use Proxy", "This single request is to be repeated via the proxy given by the Location field.", "This single request is to be repeated via the proxy under <a href=\"%s\">this URI</a>.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(305)));
        TemporaryRedirect = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(307, "Temporary Redirect", "The request should be repeated with another URI, but future requests can still use the original URI.", "The request should be repeated with <a href=\"%s\">this URI</a>, but future requests can still use the original URI.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(307)));
        PermanentRedirect = MODULE$.reg(StatusCodes$Redirection$.MODULE$.apply(308, "Permanent Redirect", "The request, and all future requests should be repeated using another URI.", "The request, and all future requests should be repeated using <a href=\"%s\">this URI</a>.", StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(308)));
        BadRequest = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(400, "Bad Request", "The request contains bad syntax or cannot be fulfilled."));
        Unauthorized = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(401, "Unauthorized", "Authentication is possible but has failed or not yet been provided."));
        PaymentRequired = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(402, "Payment Required", "Reserved for future use."));
        Forbidden = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(403, "Forbidden", "The request was a legal request, but the server is refusing to respond to it."));
        NotFound = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(404, "Not Found", "The requested resource could not be found but may be available again in the future."));
        MethodNotAllowed = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(405, "Method Not Allowed", "A request was made of a resource using a request method not supported by that resource;"));
        NotAcceptable = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(406, "Not Acceptable", "The requested resource is only capable of generating content not acceptable according to the Accept headers sent in the request."));
        ProxyAuthenticationRequired = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(407, "Proxy Authentication Required", "Proxy authentication is required to access the requested resource."));
        RequestTimeout = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(408, "Request Timeout", "The server timed out waiting for the request."));
        Conflict = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(409, "Conflict", "The request could not be processed because of conflict in the request, such as an edit conflict."));
        Gone = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(410, "Gone", "The resource requested is no longer available and will not be available again."));
        LengthRequired = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(411, "Length Required", "The request did not specify the length of its content, which is required by the requested resource."));
        PreconditionFailed = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(412, "Precondition Failed", "The server does not meet one of the preconditions that the requester put on the request."));
        ContentTooLarge = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(413, "Content Too Large", "The request content is larger than the server is willing or able to process."));
        PayloadTooLarge = MODULE$.ContentTooLarge();
        RequestEntityTooLarge = MODULE$.ContentTooLarge();
        UriTooLong = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(414, "URI Too Long", "The URI provided was too long for the server to process."));
        RequestUriTooLong = MODULE$.UriTooLong();
        UnsupportedMediaType = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(415, "Unsupported Media Type", "The request entity has a media type which the server or resource does not support."));
        RangeNotSatisfiable = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(416, "Range Not Satisfiable", "The client has asked for a portion of the file, but the server cannot supply that portion."));
        RequestedRangeNotSatisfiable = MODULE$.RangeNotSatisfiable();
        ExpectationFailed = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(417, "Expectation Failed", "The server cannot meet the requirements of the Expect request-header field."));
        ImATeapot = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(418, "I'm a teapot", "The resulting entity body MAY be short and stout."));
        EnhanceYourCalm = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(420, "Enhance Your Calm", "You are being rate-limited."));
        MisdirectedRequest = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(421, "Misdirected Request", "The request was directed at a server that is not able to produce a response."));
        UnprocessableContent = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(422, "Unprocessable Content", "The request was well-formed but was unable to be followed due to semantic errors."));
        UnprocessableEntity = MODULE$.UnprocessableContent();
        Locked = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(423, "Locked", "The resource that is being accessed is locked."));
        FailedDependency = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(424, "Failed Dependency", "The request failed due to failure of a previous request."));
        TooEarly = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(425, "Too Early", "The server is unwilling to risk processing a request that might be replayed."));
        UnorderedCollection = MODULE$.TooEarly();
        UpgradeRequired = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(426, "Upgrade Required", "The client should switch to a different protocol."));
        PreconditionRequired = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(428, "Precondition Required", "The server requires the request to be conditional."));
        TooManyRequests = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(429, "Too Many Requests", "The user has sent too many requests in a given amount of time."));
        RequestHeaderFieldsTooLarge = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(431, "Request Header Fields Too Large", "The server is unwilling to process the request because either an individual header field, or all the header fields collectively, are too large."));
        RetryWith = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(449, "Retry With", "The request should be retried after doing the appropriate action."));
        BlockedByParentalControls = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(450, "Blocked by Windows Parental Controls", "Windows Parental Controls are turned on and are blocking access to the given webpage."));
        UnavailableForLegalReasons = MODULE$.reg(StatusCodes$ClientError$.MODULE$.apply(451, "Unavailable For Legal Reasons", "Resource access is denied for legal reasons."));
        InternalServerError = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(500, "Internal Server Error", "There was an internal server error."));
        NotImplemented = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(501, "Not Implemented", "The server either does not recognize the request method, or it lacks the ability to fulfill the request."));
        BadGateway = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(502, "Bad Gateway", "The server was acting as a gateway or proxy and received an invalid response from the upstream server."));
        ServiceUnavailable = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(503, "Service Unavailable", "The server is currently unavailable (because it is overloaded or down for maintenance)."));
        GatewayTimeout = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(504, "Gateway Timeout", "The server was acting as a gateway or proxy and did not receive a timely response from the upstream server."));
        HttpVersionNotSupported = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(505, "HTTP Version Not Supported", "The server does not support the HTTP protocol version used in the request."));
        HTTPVersionNotSupported = MODULE$.HttpVersionNotSupported();
        VariantAlsoNegotiates = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(506, "Variant Also Negotiates", "Transparent content negotiation for the request, results in a circular reference."));
        InsufficientStorage = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(507, "Insufficient Storage", "Insufficient storage to complete the request."));
        LoopDetected = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(508, "Loop Detected", "The server detected an infinite loop while processing the request."));
        BandwidthLimitExceeded = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(509, "Bandwidth Limit Exceeded", "Bandwidth limit has been exceeded."));
        NotExtended = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(510, "Not Extended", "Further extensions to the request are required for the server to fulfill it."));
        NetworkAuthenticationRequired = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(511, "Network Authentication Required", "The client needs to authenticate to gain network access."));
        NetworkReadTimeout = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(598, "Network read timeout error", ""));
        NetworkConnectTimeout = MODULE$.reg(StatusCodes$ServerError$.MODULE$.apply(599, "Network connect timeout error", ""));
    }

    @Override
    public Map org$apache$pekko$http$impl$util$ObjectRegistry$$_registry() {
        return org$apache$pekko$http$impl$util$ObjectRegistry$$_registry;
    }

    @Override
    public void org$apache$pekko$http$impl$util$ObjectRegistry$$_registry_$eq(Map x$1) {
        org$apache$pekko$http$impl$util$ObjectRegistry$$_registry = x$1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StatusCodes$.class);
    }

    private <T extends StatusCode> T reg(T code) {
        Predef$.MODULE$.require(this.getForKey(BoxesRunTime.boxToInteger(code.intValue())).isEmpty(), () -> this.reg$$anonfun$1(code));
        return (T)((StatusCode)this.register(BoxesRunTime.boxToInteger(code.intValue()), code));
    }

    public StatusCode custom(int intValue, String reason, String defaultMessage, boolean isSuccess, boolean allowsEntity) {
        return StatusCodes$CustomStatusCode$.MODULE$.apply(intValue, reason, defaultMessage, isSuccess, allowsEntity);
    }

    public StatusCode custom(int intValue, String reason, String defaultMessage) {
        StatusCodes.HttpFailure httpFailure;
        if (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 199).contains(intValue)) {
            return StatusCodes$Informational$.MODULE$.apply(intValue, reason, defaultMessage);
        }
        if (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(200), 299).contains(intValue)) {
            return StatusCodes$Success$.MODULE$.apply(intValue, reason, defaultMessage, StatusCodes$Success$.MODULE$.$lessinit$greater$default$4(intValue));
        }
        if (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(300), 399).contains(intValue)) {
            return StatusCodes$Redirection$.MODULE$.apply(intValue, reason, defaultMessage, defaultMessage, StatusCodes$Redirection$.MODULE$.$lessinit$greater$default$5(intValue));
        }
        if (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(400), 499).contains(intValue)) {
            httpFailure = StatusCodes$ClientError$.MODULE$.apply(intValue, reason, defaultMessage);
        } else if (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(500), 599).contains(intValue)) {
            httpFailure = StatusCodes$ServerError$.MODULE$.apply(intValue, reason, defaultMessage);
        } else {
            throw new IllegalArgumentException("Can't register status code in non-standard region, please use the 5-parameter version of custom(...) to provide the additional required information to register this status code.");
        }
        return httpFailure;
    }

    public String custom$default$3() {
        return "";
    }

    public StatusCodes.Informational Continue() {
        return Continue;
    }

    public StatusCodes.Informational SwitchingProtocols() {
        return SwitchingProtocols;
    }

    public StatusCodes.Informational Processing() {
        return Processing;
    }

    public StatusCodes.Informational EarlyHints() {
        return EarlyHints;
    }

    public StatusCodes.Success OK() {
        return OK;
    }

    public StatusCodes.Success Created() {
        return Created;
    }

    public StatusCodes.Success Accepted() {
        return Accepted;
    }

    public StatusCodes.Success NonAuthoritativeInformation() {
        return NonAuthoritativeInformation;
    }

    public StatusCodes.Success NoContent() {
        return NoContent;
    }

    public StatusCodes.Success ResetContent() {
        return ResetContent;
    }

    public StatusCodes.Success PartialContent() {
        return PartialContent;
    }

    public StatusCodes.Success MultiStatus() {
        return MultiStatus;
    }

    public StatusCodes.Success AlreadyReported() {
        return AlreadyReported;
    }

    public StatusCodes.Success IMUsed() {
        return IMUsed;
    }

    public StatusCodes.Redirection MultipleChoices() {
        return MultipleChoices;
    }

    public StatusCodes.Redirection MovedPermanently() {
        return MovedPermanently;
    }

    public StatusCodes.Redirection Found() {
        return Found;
    }

    public StatusCodes.Redirection SeeOther() {
        return SeeOther;
    }

    public StatusCodes.Redirection NotModified() {
        return NotModified;
    }

    public StatusCodes.Redirection UseProxy() {
        return UseProxy;
    }

    public StatusCodes.Redirection TemporaryRedirect() {
        return TemporaryRedirect;
    }

    public StatusCodes.Redirection PermanentRedirect() {
        return PermanentRedirect;
    }

    public StatusCodes.ClientError BadRequest() {
        return BadRequest;
    }

    public StatusCodes.ClientError Unauthorized() {
        return Unauthorized;
    }

    public StatusCodes.ClientError PaymentRequired() {
        return PaymentRequired;
    }

    public StatusCodes.ClientError Forbidden() {
        return Forbidden;
    }

    public StatusCodes.ClientError NotFound() {
        return NotFound;
    }

    public StatusCodes.ClientError MethodNotAllowed() {
        return MethodNotAllowed;
    }

    public StatusCodes.ClientError NotAcceptable() {
        return NotAcceptable;
    }

    public StatusCodes.ClientError ProxyAuthenticationRequired() {
        return ProxyAuthenticationRequired;
    }

    public StatusCodes.ClientError RequestTimeout() {
        return RequestTimeout;
    }

    public StatusCodes.ClientError Conflict() {
        return Conflict;
    }

    public StatusCodes.ClientError Gone() {
        return Gone;
    }

    public StatusCodes.ClientError LengthRequired() {
        return LengthRequired;
    }

    public StatusCodes.ClientError PreconditionFailed() {
        return PreconditionFailed;
    }

    public StatusCodes.ClientError ContentTooLarge() {
        return ContentTooLarge;
    }

    public StatusCodes.ClientError PayloadTooLarge() {
        return PayloadTooLarge;
    }

    public StatusCodes.ClientError RequestEntityTooLarge() {
        return RequestEntityTooLarge;
    }

    public StatusCodes.ClientError UriTooLong() {
        return UriTooLong;
    }

    public StatusCodes.ClientError RequestUriTooLong() {
        return RequestUriTooLong;
    }

    public StatusCodes.ClientError UnsupportedMediaType() {
        return UnsupportedMediaType;
    }

    public StatusCodes.ClientError RangeNotSatisfiable() {
        return RangeNotSatisfiable;
    }

    public StatusCodes.ClientError RequestedRangeNotSatisfiable() {
        return RequestedRangeNotSatisfiable;
    }

    public StatusCodes.ClientError ExpectationFailed() {
        return ExpectationFailed;
    }

    public StatusCodes.ClientError ImATeapot() {
        return ImATeapot;
    }

    public StatusCodes.ClientError EnhanceYourCalm() {
        return EnhanceYourCalm;
    }

    public StatusCodes.ClientError MisdirectedRequest() {
        return MisdirectedRequest;
    }

    public StatusCodes.ClientError UnprocessableContent() {
        return UnprocessableContent;
    }

    public StatusCodes.ClientError UnprocessableEntity() {
        return UnprocessableEntity;
    }

    public StatusCodes.ClientError Locked() {
        return Locked;
    }

    public StatusCodes.ClientError FailedDependency() {
        return FailedDependency;
    }

    public StatusCodes.ClientError TooEarly() {
        return TooEarly;
    }

    public StatusCodes.ClientError UnorderedCollection() {
        return UnorderedCollection;
    }

    public StatusCodes.ClientError UpgradeRequired() {
        return UpgradeRequired;
    }

    public StatusCodes.ClientError PreconditionRequired() {
        return PreconditionRequired;
    }

    public StatusCodes.ClientError TooManyRequests() {
        return TooManyRequests;
    }

    public StatusCodes.ClientError RequestHeaderFieldsTooLarge() {
        return RequestHeaderFieldsTooLarge;
    }

    public StatusCodes.ClientError RetryWith() {
        return RetryWith;
    }

    public StatusCodes.ClientError BlockedByParentalControls() {
        return BlockedByParentalControls;
    }

    public StatusCodes.ClientError UnavailableForLegalReasons() {
        return UnavailableForLegalReasons;
    }

    public StatusCodes.ServerError InternalServerError() {
        return InternalServerError;
    }

    public StatusCodes.ServerError NotImplemented() {
        return NotImplemented;
    }

    public StatusCodes.ServerError BadGateway() {
        return BadGateway;
    }

    public StatusCodes.ServerError ServiceUnavailable() {
        return ServiceUnavailable;
    }

    public StatusCodes.ServerError GatewayTimeout() {
        return GatewayTimeout;
    }

    public StatusCodes.ServerError HttpVersionNotSupported() {
        return HttpVersionNotSupported;
    }

    public StatusCodes.ServerError HTTPVersionNotSupported() {
        return HTTPVersionNotSupported;
    }

    public StatusCodes.ServerError VariantAlsoNegotiates() {
        return VariantAlsoNegotiates;
    }

    public StatusCodes.ServerError InsufficientStorage() {
        return InsufficientStorage;
    }

    public StatusCodes.ServerError LoopDetected() {
        return LoopDetected;
    }

    public StatusCodes.ServerError BandwidthLimitExceeded() {
        return BandwidthLimitExceeded;
    }

    public StatusCodes.ServerError NotExtended() {
        return NotExtended;
    }

    public StatusCodes.ServerError NetworkAuthenticationRequired() {
        return NetworkAuthenticationRequired;
    }

    public StatusCodes.ServerError NetworkReadTimeout() {
        return NetworkReadTimeout;
    }

    public StatusCodes.ServerError NetworkConnectTimeout() {
        return NetworkConnectTimeout;
    }

    private final Object reg$$anonfun$1(StatusCode code$1) {
        return new StringBuilder(42).append("Status code for ").append(code$1.intValue()).append(" already registered as '").append(this.getForKey(BoxesRunTime.boxToInteger(code$1.intValue())).get()).append("'.").toString();
    }
}

