/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$HttpCharset$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.LazyValueBytesRenderable;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.javadsl.model.MediaRanges;
import org.apache.pekko.http.javadsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentType$WithMissingCharset$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaType$;
import org.apache.pekko.http.scaladsl.model.MediaType$Compressible$;
import org.apache.pekko.http.scaladsl.model.WithQValue;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.util.Either;

@DoNotInherit
public abstract class MediaType
implements org.apache.pekko.http.javadsl.model.MediaType,
LazyValueBytesRenderable,
WithQValue<MediaRange> {
    private byte[] org$apache$pekko$http$impl$util$LazyValueBytesRenderable$$_valueBytes;
    private final String mainType;
    private final String subType;

    public static Binary applicationBinary(String string2, Compressibility compressibility, Seq<String> seq) {
        return MediaType$.MODULE$.applicationBinary(string2, compressibility, seq);
    }

    public static WithFixedCharset applicationWithFixedCharset(String string2, HttpCharset httpCharset, Seq<String> seq) {
        return MediaType$.MODULE$.applicationWithFixedCharset(string2, httpCharset, seq);
    }

    public static WithOpenCharset applicationWithOpenCharset(String string2, Seq<String> seq) {
        return MediaType$.MODULE$.applicationWithOpenCharset(string2, seq);
    }

    public static Binary audio(String string2, Compressibility compressibility, Seq<String> seq) {
        return MediaType$.MODULE$.audio(string2, compressibility, seq);
    }

    public static MediaType custom(String string2, boolean bl, Compressibility compressibility, List<String> list) {
        return MediaType$.MODULE$.custom(string2, bl, compressibility, list);
    }

    public static Binary customBinary(String string2, String string3, Compressibility compressibility, List<String> list, Map<String, String> map, boolean bl) {
        return MediaType$.MODULE$.customBinary(string2, string3, compressibility, list, map, bl);
    }

    public static Multipart customMultipart(String string2, Map<String, String> map) {
        return MediaType$.MODULE$.customMultipart(string2, map);
    }

    public static WithFixedCharset customWithFixedCharset(String string2, String string3, HttpCharset httpCharset, List<String> list, Map<String, String> map, boolean bl) {
        return MediaType$.MODULE$.customWithFixedCharset(string2, string3, httpCharset, list, map, bl);
    }

    public static WithOpenCharset customWithOpenCharset(String string2, String string3, List<String> list, Map<String, String> map, boolean bl) {
        return MediaType$.MODULE$.customWithOpenCharset(string2, string3, list, map, bl);
    }

    public static Binary font(String string2, Compressibility compressibility, Seq<String> seq) {
        return MediaType$.MODULE$.font(string2, compressibility, seq);
    }

    public static Binary image(String string2, Compressibility compressibility, Seq<String> seq) {
        return MediaType$.MODULE$.image(string2, compressibility, seq);
    }

    public static Binary message(String string2, Compressibility compressibility, Seq<String> seq) {
        return MediaType$.MODULE$.message(string2, compressibility, seq);
    }

    public static Either<List<ErrorInfo>, MediaType> parse(String string2) {
        return MediaType$.MODULE$.parse(string2);
    }

    public static WithOpenCharset text(String string2, Seq<String> seq) {
        return MediaType$.MODULE$.text(string2, seq);
    }

    public static WithFixedCharset textWithFixedCharset(String string2, HttpCharset httpCharset, Seq<String> seq) {
        return MediaType$.MODULE$.textWithFixedCharset(string2, httpCharset, seq);
    }

    public static Option<String> unapply(MediaType mediaType) {
        return MediaType$.MODULE$.unapply(mediaType);
    }

    public static Binary video(String string2, Compressibility compressibility, Seq<String> seq) {
        return MediaType$.MODULE$.video(string2, compressibility, seq);
    }

    public static Compressibility custom$default$3() {
        return MediaType$.MODULE$.custom$default$3();
    }

    public static List<String> customWithOpenCharset$default$3() {
        return MediaType$.MODULE$.customWithOpenCharset$default$3();
    }

    public static List<String> custom$default$4() {
        return MediaType$.MODULE$.custom$default$4();
    }

    public static List<String> customBinary$default$4() {
        return MediaType$.MODULE$.customBinary$default$4();
    }

    public static List<String> customWithFixedCharset$default$4() {
        return MediaType$.MODULE$.customWithFixedCharset$default$4();
    }

    public static Map<String, String> customWithOpenCharset$default$4() {
        return MediaType$.MODULE$.customWithOpenCharset$default$4();
    }

    public static Map<String, String> customBinary$default$5() {
        return MediaType$.MODULE$.customBinary$default$5();
    }

    public static Map<String, String> customWithFixedCharset$default$5() {
        return MediaType$.MODULE$.customWithFixedCharset$default$5();
    }

    public static boolean customWithOpenCharset$default$5() {
        return MediaType$.MODULE$.customWithOpenCharset$default$5();
    }

    public static boolean customBinary$default$6() {
        return MediaType$.MODULE$.customBinary$default$6();
    }

    public static boolean customWithFixedCharset$default$6() {
        return MediaType$.MODULE$.customWithFixedCharset$default$6();
    }

    public MediaType(String _mainType, String _subType) {
        LazyValueBytesRenderable.$init$(this);
        this.mainType = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(_mainType));
        this.subType = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(_subType));
    }

    @Override
    public byte[] org$apache$pekko$http$impl$util$LazyValueBytesRenderable$$_valueBytes() {
        return this.org$apache$pekko$http$impl$util$LazyValueBytesRenderable$$_valueBytes;
    }

    @Override
    public void org$apache$pekko$http$impl$util$LazyValueBytesRenderable$$_valueBytes_$eq(byte[] x$1) {
        this.org$apache$pekko$http$impl$util$LazyValueBytesRenderable$$_valueBytes = x$1;
    }

    @Override
    public String mainType() {
        return this.mainType;
    }

    @Override
    public String subType() {
        return this.subType;
    }

    public abstract List<String> fileExtensions();

    public abstract Map<String, String> params();

    public abstract Compressibility comp();

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isAudio() {
        return false;
    }

    @Override
    public boolean isImage() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return false;
    }

    @Override
    public boolean isMultipart() {
        return false;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public boolean isVideo() {
        return false;
    }

    public abstract MediaType withParams(Map<String, String> var1);

    public abstract MediaType withComp(Compressibility var1);

    @Override
    public MediaRange withQValue(float qValue) {
        return MediaRange$.MODULE$.apply(this, qValue);
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof MediaType) {
            MediaType x = (MediaType)object;
            return this.value().equalsIgnoreCase(x.value());
        }
        return false;
    }

    public int hashCode() {
        return this.value().toLowerCase().hashCode();
    }

    @Override
    public org.apache.pekko.http.javadsl.model.MediaRange toRange() {
        return MediaRanges.create(this);
    }

    @Override
    public org.apache.pekko.http.javadsl.model.MediaRange toRange(float qValue) {
        return MediaRanges.create(this, qValue);
    }

    @Override
    public boolean isCompressible() {
        return this.comp().compressible();
    }

    @DoNotInherit
    public static abstract class Binary
    extends MediaType
    implements MediaType.Binary {
        private final String value;
        private final Compressibility comp;
        private final List fileExtensions;

        public Binary(String value, String _mainType, String _subType, Compressibility comp, List<String> fileExtensions) {
            this.value = value;
            this.comp = comp;
            this.fileExtensions = fileExtensions;
            super(_mainType, _subType);
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Compressibility comp() {
            return this.comp;
        }

        @Override
        public List<String> fileExtensions() {
            return this.fileExtensions;
        }

        @Override
        public boolean binary() {
            return true;
        }

        @Override
        public Map<String, String> params() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public Binary withParams(Map<String, String> params) {
            return MediaType$.MODULE$.customBinary(this.mainType(), this.subType(), this.comp(), this.fileExtensions(), params, MediaType$.MODULE$.customBinary$default$6());
        }

        @Override
        public Binary withComp(Compressibility comp) {
            return MediaType$.MODULE$.customBinary(this.mainType(), this.subType(), comp, this.fileExtensions(), this.params(), MediaType$.MODULE$.customBinary$default$6());
        }

        @Override
        public ContentType.Binary toContentType() {
            return ContentType$.MODULE$.apply(this);
        }
    }

    public static class Compressibility
    implements MediaType.Compressibility {
        private final boolean compressible;

        public Compressibility(boolean compressible) {
            this.compressible = compressible;
        }

        @Override
        public boolean compressible() {
            return this.compressible;
        }
    }

    public static final class Multipart
    extends Binary
    implements MediaType.Multipart {
        private final String subType;
        private final Map<String, String> _params;

        public Multipart(String subType, Map<String, String> _params) {
            this.subType = subType;
            this._params = _params;
            super(MediaType$.MODULE$.org$apache$pekko$http$scaladsl$model$MediaType$$$renderValue("multipart", subType, _params), "multipart", subType, MediaType$Compressible$.MODULE$, scala.package$.MODULE$.Nil());
        }

        @Override
        public Map<String, String> params() {
            return this._params;
        }

        @Override
        public boolean isMultipart() {
            return true;
        }

        @Override
        public Multipart withParams(Map<String, String> params) {
            return new Multipart(this.subType, params);
        }

        public Multipart withBoundary(String boundary2) {
            return this.withParams(boundary2.isEmpty() ? (Map)this.params().$minus("boundary") : (Map)this.params().updated("boundary", boundary2));
        }
    }

    @DoNotInherit
    public static abstract class NonBinary
    extends MediaType
    implements MediaType.NonBinary {
        public NonBinary(String _mainType, String _subType) {
            super(_mainType, _subType);
        }

        @Override
        public boolean binary() {
            return false;
        }

        @Override
        public Compressibility comp() {
            return MediaType$Compressible$.MODULE$;
        }

        @Override
        public Binary withComp(Compressibility comp) {
            return MediaType$.MODULE$.customBinary(this.mainType(), this.subType(), comp, this.fileExtensions(), this.params(), MediaType$.MODULE$.customBinary$default$6());
        }
    }

    @DoNotInherit
    public static abstract class NonMultipartWithOpenCharset
    extends WithOpenCharset {
        private final String value;
        private final List fileExtensions;

        public NonMultipartWithOpenCharset(String value, String _mainType, String _subType, List<String> fileExtensions) {
            this.value = value;
            this.fileExtensions = fileExtensions;
            super(_mainType, _subType);
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public List<String> fileExtensions() {
            return this.fileExtensions;
        }

        @Override
        public Map<String, String> params() {
            return Predef$.MODULE$.Map().empty();
        }
    }

    @DoNotInherit
    public static abstract class WithFixedCharset
    extends NonBinary
    implements MediaType.WithFixedCharset {
        private final String value;
        private final HttpCharset charset;
        private final List fileExtensions;

        public WithFixedCharset(String value, String _mainType, String _subType, HttpCharset charset, List<String> fileExtensions) {
            this.value = value;
            this.charset = charset;
            this.fileExtensions = fileExtensions;
            super(_mainType, _subType);
        }

        @Override
        public String value() {
            return this.value;
        }

        public HttpCharset charset() {
            return this.charset;
        }

        @Override
        public List<String> fileExtensions() {
            return this.fileExtensions;
        }

        @Override
        public Map<String, String> params() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public WithFixedCharset withParams(Map<String, String> params) {
            return MediaType$.MODULE$.customWithFixedCharset(this.mainType(), this.subType(), this.charset(), this.fileExtensions(), params, MediaType$.MODULE$.customWithFixedCharset$default$6());
        }

        @Override
        public ContentType.WithFixedCharset toContentType() {
            return ContentType$.MODULE$.apply(this);
        }
    }

    @DoNotInherit
    public static abstract class WithOpenCharset
    extends NonBinary
    implements MediaType.WithOpenCharset {
        public WithOpenCharset(String _mainType, String _subType) {
            super(_mainType, _subType);
        }

        public ContentType.WithMissingCharset withMissingCharset() {
            return ContentType$WithMissingCharset$.MODULE$.apply(this);
        }

        public ContentType.WithCharset withCharset(HttpCharset charset) {
            return ContentType$.MODULE$.apply(this, charset);
        }

        @Override
        public WithOpenCharset withParams(Map<String, String> params) {
            return MediaType$.MODULE$.customWithOpenCharset(this.mainType(), this.subType(), this.fileExtensions(), params, MediaType$.MODULE$.customWithOpenCharset$default$5());
        }

        @Override
        public ContentType.WithCharset toContentType(org.apache.pekko.http.javadsl.model.HttpCharset charset) {
            return this.withCharset((HttpCharset)JavaMapping$Implicits$.MODULE$.AddAsScala(charset, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$HttpCharset$.MODULE$)).asScala());
        }

        @Override
        public ContentType.WithMissingCharset toContentTypeWithMissingCharset() {
            return this.withMissingCharset();
        }
    }
}

