/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.JavaMapping$MediaType$;
import org.apache.pekko.http.impl.util.Renderable;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.ToStringRenderable;
import org.apache.pekko.http.impl.util.ValueRenderable;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange$;
import org.apache.pekko.http.scaladsl.model.HttpCharsetRange;
import org.apache.pekko.http.scaladsl.model.MediaRange$;
import org.apache.pekko.http.scaladsl.model.MediaRange$Custom$;
import org.apache.pekko.http.scaladsl.model.MediaRange$One$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.WithQValue;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class MediaRange
extends org.apache.pekko.http.javadsl.model.MediaRange
implements Renderable,
WithQValue<MediaRange> {
    public static MediaRange apply(MediaType mediaType) {
        return MediaRange$.MODULE$.apply(mediaType);
    }

    public static MediaRange apply(MediaType mediaType, float f) {
        return MediaRange$.MODULE$.apply(mediaType, f);
    }

    public static MediaRange custom(String string2, Map<String, String> map, float f) {
        return MediaRange$.MODULE$.custom(string2, map, f);
    }

    public static Tuple2<Map<String, String>, Object> splitOffQValue(Map<String, String> map, float f) {
        return MediaRange$.MODULE$.splitOffQValue(map, f);
    }

    public static float apply$default$2() {
        return MediaRange$.MODULE$.apply$default$2();
    }

    public static Map<String, String> custom$default$2() {
        return MediaRange$.MODULE$.custom$default$2();
    }

    public static float splitOffQValue$default$2() {
        return MediaRange$.MODULE$.splitOffQValue$default$2();
    }

    public static float custom$default$3() {
        return MediaRange$.MODULE$.custom$default$3();
    }

    public abstract String value();

    @Override
    public abstract String mainType();

    public abstract Map<String, String> params();

    @Override
    public abstract float qValue();

    public abstract boolean matches(MediaType var1);

    public boolean isApplication() {
        return false;
    }

    public boolean isAudio() {
        return false;
    }

    public boolean isImage() {
        return false;
    }

    public boolean isMessage() {
        return false;
    }

    public boolean isMultipart() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public boolean isVideo() {
        return false;
    }

    public boolean isWildcard() {
        String string2 = this.mainType();
        String string3 = "*";
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public abstract MediaRange withParams(Map<String, String> var1);

    public ContentTypeRange withCharsetRange(HttpCharsetRange charsetRange) {
        return ContentTypeRange$.MODULE$.apply(this, charsetRange);
    }

    @Override
    public java.util.Map<String, String> getParams() {
        return JavaConverters$.MODULE$.mapAsJavaMapConverter(this.params()).asJava();
    }

    @Override
    public boolean matches(org.apache.pekko.http.javadsl.model.MediaType mediaType) {
        return this.matches((MediaType)JavaMapping$Implicits$.MODULE$.AddAsScala(mediaType, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$MediaType$.MODULE$)).asScala());
    }

    public static final class Custom
    extends MediaRange
    implements ToStringRenderable,
    ValueRenderable,
    Product,
    Serializable {
        private final String mainType;
        private final Map params;
        private final float qValue;

        public static Custom apply(String string2, Map<String, String> map, float f) {
            return MediaRange$Custom$.MODULE$.apply(string2, map, f);
        }

        public static Custom fromProduct(Product product) {
            return MediaRange$Custom$.MODULE$.fromProduct(product);
        }

        public static Custom unapply(Custom custom) {
            return MediaRange$Custom$.MODULE$.unapply(custom);
        }

        public Custom(String mainType, Map<String, String> params, float qValue) {
            this.mainType = mainType;
            this.params = params;
            this.qValue = qValue;
            Predef$.MODULE$.require(0.0f <= qValue && qValue <= 1.0f, this::$init$$$anonfun$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.mainType()));
            n = Statics.mix(n, Statics.anyHash(this.params()));
            n = Statics.mix(n, Statics.floatHash(this.qValue()));
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Custom)) return false;
            Custom custom = (Custom)object;
            if (this.qValue() != custom.qValue()) return false;
            String string2 = this.mainType();
            String string3 = custom.mainType();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Map<String, String> map = this.params();
            Map<String, String> map2 = custom.params();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Custom;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Custom";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToFloat(this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "mainType";
                }
                case 1: {
                    return "params";
                }
                case 2: {
                    return "qValue";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String mainType() {
            return this.mainType;
        }

        @Override
        public Map<String, String> params() {
            return this.params;
        }

        @Override
        public float qValue() {
            return this.qValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(MediaType mediaType) {
            String string2 = this.mainType();
            String string3 = "*";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String string4 = mediaType.mainType();
                String string5 = this.mainType();
                if (string4 == null) {
                    if (string5 != null) {
                        return false;
                    }
                } else if (!string4.equals(string5)) return false;
            }
            if (!this.params().forall((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key2 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return mediaType.params().get(key2).contains(value);
                }
                throw new MatchError(tuple2);
            })) return false;
            return true;
        }

        @Override
        public MediaRange withParams(Map<String, String> params) {
            return MediaRange$.MODULE$.custom(this.mainType(), params, this.qValue());
        }

        @Override
        public MediaRange withQValue(float qValue) {
            if (qValue != this.qValue()) {
                return MediaRange$.MODULE$.custom(this.mainType(), this.params(), qValue);
            }
            return this;
        }

        @Override
        public <R extends Rendering> Rendering render(R r) {
            r.$tilde$tilde(this.mainType()).$tilde$tilde('/').$tilde$tilde('*');
            if (this.qValue() < 1.0f) {
                r.$tilde$tilde(";q=").$tilde$tilde(this.qValue());
            }
            if (this.params().nonEmpty()) {
                this.params().foreach((Function1<Tuple2, Rendering> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.$tilde$tilde(';').$tilde$tilde(' ').$tilde$tilde(k).$tilde$tilde('=').$tilde$tilde$hash(v);
                    }
                    throw new MatchError(tuple2);
                });
            }
            return r;
        }

        @Override
        public boolean isApplication() {
            String string2 = this.mainType();
            String string3 = "application";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        @Override
        public boolean isAudio() {
            String string2 = this.mainType();
            String string3 = "audio";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        @Override
        public boolean isImage() {
            String string2 = this.mainType();
            String string3 = "image";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        @Override
        public boolean isMessage() {
            String string2 = this.mainType();
            String string3 = "message";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        @Override
        public boolean isMultipart() {
            String string2 = this.mainType();
            String string3 = "multipart";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        @Override
        public boolean isText() {
            String string2 = this.mainType();
            String string3 = "text";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        @Override
        public boolean isVideo() {
            String string2 = this.mainType();
            String string3 = "video";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        public Custom copy(String mainType, Map<String, String> params, float qValue) {
            return new Custom(mainType, params, qValue);
        }

        public String copy$default$1() {
            return this.mainType();
        }

        public Map<String, String> copy$default$2() {
            return this.params();
        }

        public float copy$default$3() {
            return this.qValue();
        }

        public String _1() {
            return this.mainType();
        }

        public Map<String, String> _2() {
            return this.params();
        }

        public float _3() {
            return this.qValue();
        }

        private final Object $init$$$anonfun$1() {
            return "qValue must be >= 0 and <= 1.0";
        }
    }

    public static final class One
    extends MediaRange
    implements ToStringRenderable,
    ValueRenderable,
    Product,
    Serializable {
        private final MediaType mediaType;
        private final float qValue;

        public static One apply(MediaType mediaType, float f) {
            return MediaRange$One$.MODULE$.apply(mediaType, f);
        }

        public static One fromProduct(Product product) {
            return MediaRange$One$.MODULE$.fromProduct(product);
        }

        public static One unapply(One one) {
            return MediaRange$One$.MODULE$.unapply(one);
        }

        public One(MediaType mediaType, float qValue) {
            this.mediaType = mediaType;
            this.qValue = qValue;
            Predef$.MODULE$.require(0.0f <= qValue && qValue <= 1.0f, this::$init$$$anonfun$2);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.mediaType()));
            n = Statics.mix(n, Statics.floatHash(this.qValue()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof One)) return false;
            One one = (One)object;
            if (this.qValue() != one.qValue()) return false;
            MediaType mediaType = this.mediaType();
            MediaType mediaType2 = one.mediaType();
            if (mediaType != null) {
                if (!((Object)mediaType).equals(mediaType2)) return false;
                return true;
            }
            if (mediaType2 == null) return true;
            return false;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof One;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "One";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToFloat(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "mediaType";
            }
            if (1 == n2) {
                return "qValue";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public MediaType mediaType() {
            return this.mediaType;
        }

        @Override
        public float qValue() {
            return this.qValue;
        }

        @Override
        public String mainType() {
            return this.mediaType().mainType();
        }

        @Override
        public Map<String, String> params() {
            return this.mediaType().params();
        }

        @Override
        public boolean isApplication() {
            return this.mediaType().isApplication();
        }

        @Override
        public boolean isAudio() {
            return this.mediaType().isAudio();
        }

        @Override
        public boolean isImage() {
            return this.mediaType().isImage();
        }

        @Override
        public boolean isMessage() {
            return this.mediaType().isMessage();
        }

        @Override
        public boolean isMultipart() {
            return this.mediaType().isMultipart();
        }

        @Override
        public boolean isText() {
            return this.mediaType().isText();
        }

        @Override
        public boolean isVideo() {
            return this.mediaType().isVideo();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(MediaType mediaType) {
            String string2 = this.mediaType().mainType();
            String string3 = mediaType.mainType();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.mediaType().subType();
            String string5 = mediaType.subType();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            if (!this.mediaType().params().forall((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String string2 = (String)tuple2._1();
                    if ("charset".equals(string2)) {
                        return true;
                    }
                    String key2 = string2;
                    String value = (String)tuple2._2();
                    return mediaType.params().get(key2).contains(value);
                }
                throw new MatchError(tuple2);
            })) return false;
            return true;
        }

        @Override
        public MediaRange withParams(Map<String, String> params) {
            return this.copy(this.mediaType().withParams(params), this.copy$default$2());
        }

        @Override
        public MediaRange withQValue(float qValue) {
            return this.copy(this.copy$default$1(), qValue);
        }

        @Override
        public <R extends Rendering> Rendering render(R r) {
            if (this.qValue() < 1.0f) {
                return r.$tilde$tilde((MediaType)this.mediaType(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(";q=").$tilde$tilde(this.qValue());
            }
            return r.$tilde$tilde((MediaType)this.mediaType(), Renderer$.MODULE$.renderableRenderer());
        }

        public One copy(MediaType mediaType, float qValue) {
            return new One(mediaType, qValue);
        }

        public MediaType copy$default$1() {
            return this.mediaType();
        }

        public float copy$default$2() {
            return this.qValue();
        }

        public MediaType _1() {
            return this.mediaType();
        }

        public float _2() {
            return this.qValue();
        }

        private final Object $init$$$anonfun$2() {
            return "qValue must be >= 0 and <= 1.0";
        }
    }
}

