/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.OptHttpResponse$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCode$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.HashCode$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public final class HttpResponse
extends org.apache.pekko.http.javadsl.model.HttpResponse
implements HttpMessage {
    private final StatusCode status;
    private final Seq headers;
    private final Map attributes;
    private final ResponseEntity entity;
    private final HttpProtocol protocol;

    public static HttpResponse apply(StatusCode statusCode, Seq<HttpHeader> seq, ResponseEntity responseEntity, HttpProtocol httpProtocol) {
        return HttpResponse$.MODULE$.apply(statusCode, seq, responseEntity, httpProtocol);
    }

    public static HttpResponse unapply(HttpResponse httpResponse) {
        return HttpResponse$.MODULE$.unapply(httpResponse);
    }

    public static StatusCode apply$default$1() {
        return HttpResponse$.MODULE$.apply$default$1();
    }

    public static Seq<HttpHeader> apply$default$2() {
        return HttpResponse$.MODULE$.apply$default$2();
    }

    public static ResponseEntity apply$default$3() {
        return HttpResponse$.MODULE$.apply$default$3();
    }

    public static HttpProtocol apply$default$4() {
        return HttpResponse$.MODULE$.apply$default$4();
    }

    public HttpResponse(StatusCode status, Seq<HttpHeader> headers, Map<AttributeKey<?>, ?> attributes, ResponseEntity entity, HttpProtocol protocol) {
        this.status = status;
        this.headers = headers;
        this.attributes = attributes;
        this.entity = entity;
        this.protocol = protocol;
        Predef$.MODULE$.require(entity.isKnownEmpty() || status.allowsEntity(), HttpResponse::$init$$$anonfun$3);
        HttpProtocol httpProtocol = protocol;
        HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
        Predef$.MODULE$.require((httpProtocol != null ? !((Object)httpProtocol).equals(httpProtocol2) : httpProtocol2 != null) || !entity.isChunked(), HttpResponse::$init$$$anonfun$4);
    }

    @Override
    public StatusCode status() {
        return this.status;
    }

    @Override
    public Seq<HttpHeader> headers() {
        return this.headers;
    }

    @Override
    public Map<AttributeKey<?>, ?> attributes() {
        return this.attributes;
    }

    @Override
    public ResponseEntity entity() {
        return this.entity;
    }

    @Override
    public HttpProtocol protocol() {
        return this.protocol;
    }

    @Override
    public HttpResponse self() {
        return this;
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public HttpResponse(StatusCode status, Seq<HttpHeader> headers, ResponseEntity entity, HttpProtocol protocol) {
        this(status, headers, (Map<AttributeKey<?>, ?>)Predef$.MODULE$.Map().empty(), entity, protocol);
    }

    @Override
    public HttpResponse withHeaders(Seq<HttpHeader> headers) {
        if (headers == this.headers()) {
            return this;
        }
        return this.copyImpl(this.copyImpl$default$1(), headers, this.copyImpl$default$3(), this.copyImpl$default$4(), this.copyImpl$default$5());
    }

    @Override
    public HttpResponse withAttributes(Map<AttributeKey<?>, ?> attributes) {
        if (attributes == this.attributes()) {
            return this;
        }
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), attributes, this.copyImpl$default$4(), this.copyImpl$default$5());
    }

    @Override
    public org.apache.pekko.http.javadsl.model.HttpResponse withProtocol(org.apache.pekko.http.javadsl.model.HttpProtocol protocol) {
        return this.withProtocol((HttpProtocol)protocol);
    }

    public HttpResponse withProtocol(HttpProtocol protocol) {
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), this.copyImpl$default$3(), this.copyImpl$default$4(), protocol);
    }

    @Override
    public HttpResponse withStatus(int statusCode) {
        return this.copyImpl(StatusCode$.MODULE$.int2StatusCode(statusCode), this.copyImpl$default$2(), this.copyImpl$default$3(), this.copyImpl$default$4(), this.copyImpl$default$5());
    }

    @Override
    public HttpResponse withStatus(org.apache.pekko.http.javadsl.model.StatusCode statusCode) {
        return this.copyImpl((StatusCode)statusCode, this.copyImpl$default$2(), this.copyImpl$default$3(), this.copyImpl$default$4(), this.copyImpl$default$5());
    }

    @Override
    public HttpResponse withHeadersAndEntity(Seq<HttpHeader> headers, RequestEntity entity) {
        return this.withHeadersAndEntity(headers, (ResponseEntity)entity);
    }

    public HttpResponse withHeadersAndEntity(Seq<HttpHeader> headers, ResponseEntity entity) {
        return this.copyImpl(this.copyImpl$default$1(), headers, this.copyImpl$default$3(), entity, this.copyImpl$default$5());
    }

    @Override
    public HttpResponse withEntity(org.apache.pekko.http.javadsl.model.ResponseEntity entity) {
        ResponseEntity responseEntity = (ResponseEntity)entity;
        StatusCode statusCode = this.copyImpl$default$1();
        Seq<HttpHeader> seq = this.copyImpl$default$2();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$3();
        HttpProtocol httpProtocol = this.copyImpl$default$5();
        return this.copyImpl(statusCode, seq, map, responseEntity, httpProtocol);
    }

    @Override
    public HttpResponse withEntity(RequestEntity entity) {
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), this.copyImpl$default$3(), entity, this.copyImpl$default$5());
    }

    @Override
    public HttpResponse withEntity(org.apache.pekko.http.javadsl.model.RequestEntity entity) {
        return this.withEntity((org.apache.pekko.http.javadsl.model.ResponseEntity)entity);
    }

    public HttpResponse mapEntity(Function1<ResponseEntity, ResponseEntity> f) {
        return this.withEntity(f.apply(this.entity()));
    }

    @Override
    public <T> HttpResponse transformEntityDataBytes(Graph<FlowShape<ByteString, ByteString>, T> transformer) {
        ResponseEntity responseEntity = this.entity().transformDataBytes(Flow$.MODULE$.fromGraph(transformer));
        StatusCode statusCode = this.copyImpl$default$1();
        Seq<HttpHeader> seq = this.copyImpl$default$2();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$3();
        HttpProtocol httpProtocol = this.copyImpl$default$5();
        return this.copyImpl(statusCode, seq, map, responseEntity, httpProtocol);
    }

    public HttpResponse copy(StatusCode status, Seq<HttpHeader> headers, ResponseEntity entity, HttpProtocol protocol) {
        return this.copyImpl(status, headers, this.copyImpl$default$3(), entity, protocol);
    }

    public StatusCode copy$default$1() {
        return this.status();
    }

    public Seq<HttpHeader> copy$default$2() {
        return this.headers();
    }

    public ResponseEntity copy$default$3() {
        return this.entity();
    }

    public HttpProtocol copy$default$4() {
        return this.protocol();
    }

    private HttpResponse copyImpl(StatusCode status, Seq<HttpHeader> headers, Map<AttributeKey<?>, ?> attributes, ResponseEntity entity, HttpProtocol protocol) {
        return new HttpResponse(status, headers, attributes, entity, protocol);
    }

    private StatusCode copyImpl$default$1() {
        return this.status();
    }

    private Seq<HttpHeader> copyImpl$default$2() {
        return this.headers();
    }

    private Map<AttributeKey<?>, ?> copyImpl$default$3() {
        return this.attributes();
    }

    private ResponseEntity copyImpl$default$4() {
        return this.entity();
    }

    private HttpProtocol copyImpl$default$5() {
        return this.protocol();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof HttpResponse)) return false;
        HttpResponse httpResponse = (HttpResponse)object;
        HttpResponse httpResponse2 = HttpResponse$.MODULE$.unapply(httpResponse);
        if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse2)) return false;
        HttpResponse httpResponse3 = httpResponse2;
        StatusCode statusCode = httpResponse3._1();
        Seq<HttpHeader> seq = httpResponse3._2();
        ResponseEntity responseEntity = httpResponse3._3();
        HttpProtocol httpProtocol = httpResponse3._4();
        StatusCode _status = statusCode;
        Seq<HttpHeader> _headers = seq;
        ResponseEntity _entity = responseEntity;
        HttpProtocol _protocol = httpProtocol;
        HttpResponse response = httpResponse;
        StatusCode statusCode2 = this.status();
        StatusCode statusCode3 = _status;
        if (statusCode2 == null) {
            if (statusCode3 != null) {
                return false;
            }
        } else if (!statusCode2.equals(statusCode3)) return false;
        Seq<HttpHeader> seq2 = this.headers();
        Seq<HttpHeader> seq3 = _headers;
        if (seq2 == null) {
            if (seq3 != null) {
                return false;
            }
        } else if (!seq2.equals(seq3)) return false;
        Map<AttributeKey<?>, ?> map = this.attributes();
        Map<AttributeKey<?>, ?> map2 = response.attributes();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        ResponseEntity responseEntity2 = this.entity();
        ResponseEntity responseEntity3 = _entity;
        if (responseEntity2 == null) {
            if (responseEntity3 != null) {
                return false;
            }
        } else if (!responseEntity2.equals(responseEntity3)) return false;
        HttpProtocol httpProtocol2 = this.protocol();
        HttpProtocol httpProtocol3 = _protocol;
        if (httpProtocol2 == null) {
            if (httpProtocol3 == null) return true;
            return false;
        } else {
            if (!((Object)httpProtocol2).equals(httpProtocol3)) return false;
            return true;
        }
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.status());
        result = HashCode$.MODULE$.hash(result, this.headers());
        result = HashCode$.MODULE$.hash(result, this.attributes());
        result = HashCode$.MODULE$.hash(result, this.entity());
        result = HashCode$.MODULE$.hash(result, this.protocol());
        return result;
    }

    public String toString() {
        return new StringBuilder(17).append("HttpResponse(").append(this._1()).append(",").append(this._2()).append(",").append(this._3()).append(",").append(this._4()).append(")").toString();
    }

    public StatusCode _1() {
        return this.status();
    }

    public Seq<HttpHeader> _2() {
        return this.headers();
    }

    public ResponseEntity _3() {
        return this.entity();
    }

    public HttpProtocol _4() {
        return this.protocol();
    }

    private static final Object $init$$$anonfun$3() {
        return "Responses with this status code must have an empty entity";
    }

    private static final Object $init$$$anonfun$4() {
        return "HTTP/1.0 responses must not have a chunked entity";
    }
}

