/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.JavaMapping$Uri$;
import org.apache.pekko.http.impl.util.S2JMapping$;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.OptHttpRequest$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Cookie;
import org.apache.pekko.http.scaladsl.model.headers.Cookie$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.http.scaladsl.model.headers.HttpCookiePair;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.HashCode$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public final class HttpRequest
extends org.apache.pekko.http.javadsl.model.HttpRequest
implements HttpMessage {
    private final HttpMethod method;
    private final Uri uri;
    private final Seq headers;
    private final Map attributes;
    private final RequestEntity entity;
    private final HttpProtocol protocol;

    public static HttpRequest apply(HttpMethod httpMethod, Uri uri, Seq<HttpHeader> seq, RequestEntity requestEntity, HttpProtocol httpProtocol) {
        return HttpRequest$.MODULE$.apply(httpMethod, uri, seq, requestEntity, httpProtocol);
    }

    public static HttpRequest unapply(HttpRequest httpRequest) {
        return HttpRequest$.MODULE$.unapply(httpRequest);
    }

    public static void verifyUri(Uri uri) {
        HttpRequest$.MODULE$.verifyUri(uri);
    }

    public static HttpMethod apply$default$1() {
        return HttpRequest$.MODULE$.apply$default$1();
    }

    public static Uri apply$default$2() {
        return HttpRequest$.MODULE$.apply$default$2();
    }

    public static Seq<HttpHeader> apply$default$3() {
        return HttpRequest$.MODULE$.apply$default$3();
    }

    public static RequestEntity apply$default$4() {
        return HttpRequest$.MODULE$.apply$default$4();
    }

    public static HttpProtocol apply$default$5() {
        return HttpRequest$.MODULE$.apply$default$5();
    }

    public HttpRequest(HttpMethod method, Uri uri, Seq<HttpHeader> headers, Map<AttributeKey<?>, ?> attributes, RequestEntity entity, HttpProtocol protocol) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.attributes = attributes;
        this.entity = entity;
        this.protocol = protocol;
        HttpRequest$.MODULE$.verifyUri(uri);
        Predef$.MODULE$.require(entity.isKnownEmpty() || method.isEntityAccepted(), () -> HttpRequest.$init$$$anonfun$1(method));
        HttpProtocol httpProtocol = protocol;
        HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
        Predef$.MODULE$.require((httpProtocol != null ? !((Object)httpProtocol).equals(httpProtocol2) : httpProtocol2 != null) || !entity.isChunked(), HttpRequest::$init$$$anonfun$2);
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    public Uri uri() {
        return this.uri;
    }

    @Override
    public Seq<HttpHeader> headers() {
        return this.headers;
    }

    @Override
    public Map<AttributeKey<?>, ?> attributes() {
        return this.attributes;
    }

    @Override
    public RequestEntity entity() {
        return this.entity;
    }

    @Override
    public HttpProtocol protocol() {
        return this.protocol;
    }

    @Override
    public HttpRequest self() {
        return this;
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public boolean isResponse() {
        return false;
    }

    public HttpRequest(HttpMethod method, Uri uri, Seq<HttpHeader> headers, RequestEntity entity, HttpProtocol protocol) {
        this(method, uri, headers, (Map<AttributeKey<?>, ?>)Predef$.MODULE$.Map().empty(), entity, protocol);
    }

    public Uri effectiveUri(boolean securedConnection, Host defaultHostHeader) {
        return HttpRequest$.MODULE$.effectiveUri(this.uri(), this.headers(), securedConnection, defaultHostHeader);
    }

    public Host effectiveUri$default$2() {
        return Host$.MODULE$.empty();
    }

    public HttpRequest withEffectiveUri(boolean securedConnection, Host defaultHostHeader) {
        Uri uri = this.effectiveUri(securedConnection, defaultHostHeader);
        HttpMethod httpMethod = this.copyImpl$default$1();
        Seq<HttpHeader> seq = this.copyImpl$default$3();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$4();
        RequestEntity requestEntity = this.copyImpl$default$5();
        HttpProtocol httpProtocol = this.copyImpl$default$6();
        return this.copyImpl(httpMethod, uri, seq, map, requestEntity, httpProtocol);
    }

    public Host withEffectiveUri$default$2() {
        return Host$.MODULE$.empty();
    }

    public Seq<HttpCookiePair> cookies() {
        return (Seq)this.headers().withFilter((Function1<HttpHeader, boolean> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Cookie) {
                Seq<HttpCookiePair> seq;
                Cookie cookie = Cookie$.MODULE$.unapply((Cookie)httpHeader);
                Seq<HttpCookiePair> cookies = seq = cookie._1();
                return true;
            }
            return false;
        }).flatMap((Function1<HttpHeader, IterableOnce> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Cookie) {
                Seq<HttpCookiePair> seq;
                Cookie cookie2 = Cookie$.MODULE$.unapply((Cookie)httpHeader);
                Seq<HttpCookiePair> cookies = seq = cookie2._1();
                return (Seq)cookies.map((Function1<HttpCookiePair, HttpCookiePair> & Serializable)cookie -> cookie);
            }
            throw new MatchError(httpHeader);
        });
    }

    public boolean canBeRetried() {
        return this.method().isIdempotent();
    }

    @Override
    public HttpRequest withHeaders(Seq<HttpHeader> headers) {
        if (headers == this.headers()) {
            return this;
        }
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), headers, this.copyImpl$default$4(), this.copyImpl$default$5(), this.copyImpl$default$6());
    }

    @Override
    public HttpRequest withAttributes(Map<AttributeKey<?>, ?> attributes) {
        if (attributes == this.attributes()) {
            return this;
        }
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), this.copyImpl$default$3(), attributes, this.copyImpl$default$5(), this.copyImpl$default$6());
    }

    @Override
    public HttpRequest withHeadersAndEntity(Seq<HttpHeader> headers, RequestEntity entity) {
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), headers, this.copyImpl$default$4(), entity, this.copyImpl$default$6());
    }

    @Override
    public HttpRequest withEntity(org.apache.pekko.http.javadsl.model.RequestEntity entity) {
        RequestEntity requestEntity = (RequestEntity)entity;
        HttpMethod httpMethod = this.copyImpl$default$1();
        Uri uri = this.copyImpl$default$2();
        Seq<HttpHeader> seq = this.copyImpl$default$3();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$4();
        HttpProtocol httpProtocol = this.copyImpl$default$6();
        return this.copyImpl(httpMethod, uri, seq, map, requestEntity, httpProtocol);
    }

    @Override
    public HttpRequest withEntity(RequestEntity entity) {
        return this.copyImpl(this.copyImpl$default$1(), this.copyImpl$default$2(), this.copyImpl$default$3(), this.copyImpl$default$4(), entity, this.copyImpl$default$6());
    }

    public HttpRequest mapEntity(Function1<RequestEntity, RequestEntity> f) {
        return this.withEntity(f.apply(this.entity()));
    }

    @Override
    public HttpRequest withMethod(org.apache.pekko.http.javadsl.model.HttpMethod method) {
        return this.copyImpl((HttpMethod)method, this.copyImpl$default$2(), this.copyImpl$default$3(), this.copyImpl$default$4(), this.copyImpl$default$5(), this.copyImpl$default$6());
    }

    @Override
    public HttpRequest withProtocol(org.apache.pekko.http.javadsl.model.HttpProtocol protocol) {
        HttpProtocol httpProtocol = (HttpProtocol)protocol;
        HttpMethod httpMethod = this.copyImpl$default$1();
        Uri uri = this.copyImpl$default$2();
        Seq<HttpHeader> seq = this.copyImpl$default$3();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$4();
        RequestEntity requestEntity = this.copyImpl$default$5();
        return this.copyImpl(httpMethod, uri, seq, map, requestEntity, httpProtocol);
    }

    @Override
    public HttpRequest withUri(String path) {
        return this.withUri(Uri$.MODULE$.apply(path));
    }

    public HttpRequest withUri(Uri uri) {
        return this.copyImpl(this.copyImpl$default$1(), uri, this.copyImpl$default$3(), this.copyImpl$default$4(), this.copyImpl$default$5(), this.copyImpl$default$6());
    }

    @Override
    public <M> HttpRequest transformEntityDataBytes(Graph<FlowShape<ByteString, ByteString>, M> transformer) {
        RequestEntity requestEntity = this.entity().transformDataBytes(Flow$.MODULE$.fromGraph(transformer));
        HttpMethod httpMethod = this.copyImpl$default$1();
        Uri uri = this.copyImpl$default$2();
        Seq<HttpHeader> seq = this.copyImpl$default$3();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$4();
        HttpProtocol httpProtocol = this.copyImpl$default$6();
        return this.copyImpl(httpMethod, uri, seq, map, requestEntity, httpProtocol);
    }

    @Override
    public org.apache.pekko.http.javadsl.model.Uri getUri() {
        return (org.apache.pekko.http.javadsl.model.Uri)JavaMapping$Implicits$.MODULE$.AddAsJava(this.uri(), S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$Uri$.MODULE$)).asJava();
    }

    @Override
    public HttpRequest withUri(org.apache.pekko.http.javadsl.model.Uri uri) {
        Uri uri2 = uri.asScala();
        HttpMethod httpMethod = this.copyImpl$default$1();
        Seq<HttpHeader> seq = this.copyImpl$default$3();
        Map<AttributeKey<?>, ?> map = this.copyImpl$default$4();
        RequestEntity requestEntity = this.copyImpl$default$5();
        HttpProtocol httpProtocol = this.copyImpl$default$6();
        return this.copyImpl(httpMethod, uri2, seq, map, requestEntity, httpProtocol);
    }

    public HttpRequest copy(HttpMethod method, Uri uri, Seq<HttpHeader> headers, RequestEntity entity, HttpProtocol protocol) {
        return this.copyImpl(method, uri, headers, this.copyImpl$default$4(), entity, protocol);
    }

    public HttpMethod copy$default$1() {
        return this.method();
    }

    public Uri copy$default$2() {
        return this.uri();
    }

    public Seq<HttpHeader> copy$default$3() {
        return this.headers();
    }

    public RequestEntity copy$default$4() {
        return this.entity();
    }

    public HttpProtocol copy$default$5() {
        return this.protocol();
    }

    private HttpRequest copyImpl(HttpMethod method, Uri uri, Seq<HttpHeader> headers, Map<AttributeKey<?>, ?> attributes, RequestEntity entity, HttpProtocol protocol) {
        return new HttpRequest(method, uri, headers, attributes, entity, protocol);
    }

    private HttpMethod copyImpl$default$1() {
        return this.method();
    }

    private Uri copyImpl$default$2() {
        return this.uri();
    }

    private Seq<HttpHeader> copyImpl$default$3() {
        return this.headers();
    }

    private Map<AttributeKey<?>, ?> copyImpl$default$4() {
        return this.attributes();
    }

    private RequestEntity copyImpl$default$5() {
        return this.entity();
    }

    private HttpProtocol copyImpl$default$6() {
        return this.protocol();
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.method());
        result = HashCode$.MODULE$.hash(result, this.uri());
        result = HashCode$.MODULE$.hash(result, this.headers());
        result = HashCode$.MODULE$.hash(result, this.attributes());
        result = HashCode$.MODULE$.hash(result, this.entity());
        result = HashCode$.MODULE$.hash(result, this.protocol());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof HttpRequest)) return false;
        HttpRequest httpRequest = (HttpRequest)object;
        HttpRequest httpRequest2 = HttpRequest$.MODULE$.unapply(httpRequest);
        if (OptHttpRequest$.MODULE$.isEmpty$extension(httpRequest2)) return false;
        HttpRequest httpRequest3 = httpRequest2;
        HttpMethod httpMethod = httpRequest3._1();
        Uri uri = httpRequest3._2();
        Seq<HttpHeader> seq = httpRequest3._3();
        RequestEntity requestEntity = httpRequest3._4();
        HttpProtocol httpProtocol = httpRequest3._5();
        HttpMethod _method = httpMethod;
        Uri _uri = uri;
        Seq<HttpHeader> _headers = seq;
        RequestEntity _entity = requestEntity;
        HttpProtocol _protocol = httpProtocol;
        HttpRequest request = httpRequest;
        HttpMethod httpMethod2 = this.method();
        HttpMethod httpMethod3 = _method;
        if (httpMethod2 == null) {
            if (httpMethod3 != null) {
                return false;
            }
        } else if (!((Object)httpMethod2).equals(httpMethod3)) return false;
        Uri uri2 = this.uri();
        Uri uri3 = _uri;
        if (uri2 == null) {
            if (uri3 != null) {
                return false;
            }
        } else if (!((Object)uri2).equals(uri3)) return false;
        Seq<HttpHeader> seq2 = this.headers();
        Seq<HttpHeader> seq3 = _headers;
        if (seq2 == null) {
            if (seq3 != null) {
                return false;
            }
        } else if (!seq2.equals(seq3)) return false;
        Map<AttributeKey<?>, ?> map = this.attributes();
        Map<AttributeKey<?>, ?> map2 = request.attributes();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        RequestEntity requestEntity2 = this.entity();
        RequestEntity requestEntity3 = _entity;
        if (requestEntity2 == null) {
            if (requestEntity3 != null) {
                return false;
            }
        } else if (!requestEntity2.equals(requestEntity3)) return false;
        HttpProtocol httpProtocol2 = this.protocol();
        HttpProtocol httpProtocol3 = _protocol;
        if (httpProtocol2 == null) {
            if (httpProtocol3 == null) return true;
            return false;
        } else {
            if (!((Object)httpProtocol2).equals(httpProtocol3)) return false;
            return true;
        }
    }

    public String toString() {
        return new StringBuilder(17).append("HttpRequest(").append(this._1()).append(",").append(this._2()).append(",").append(this._3()).append(",").append(this._4()).append(",").append(this._5()).append(")").toString();
    }

    public HttpMethod _1() {
        return this.method();
    }

    public Uri _2() {
        return this.uri();
    }

    public Seq<HttpHeader> _3() {
        return this.headers();
    }

    public RequestEntity _4() {
        return this.entity();
    }

    public HttpProtocol _5() {
        return this.protocol();
    }

    private static final Object $init$$$anonfun$1(HttpMethod method$6) {
        return new StringBuilder(49).append("Requests with method '").append(method$6.value()).append("' must have an empty entity").toString();
    }

    private static final Object $init$$$anonfun$2() {
        return "HTTP/1.0 requests must not have a chunked entity";
    }
}

