/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class ErrorInfo
implements Product,
Serializable {
    private final String summary;
    private final String detail;
    private final String errorHeaderName;

    @InternalApi
    public static ErrorInfo apply(String string2, String string3) {
        return ErrorInfo$.MODULE$.apply(string2, string3);
    }

    public static ErrorInfo fromCompoundString(String string2) {
        return ErrorInfo$.MODULE$.fromCompoundString(string2);
    }

    public static Option<Tuple2<String, String>> unapply(ErrorInfo errorInfo) {
        return ErrorInfo$.MODULE$.unapply(errorInfo);
    }

    public static String $lessinit$greater$default$1() {
        return ErrorInfo$.MODULE$.$lessinit$greater$default$1();
    }

    public static String apply$default$1() {
        return ErrorInfo$.MODULE$.apply$default$1();
    }

    public static String $lessinit$greater$default$2() {
        return ErrorInfo$.MODULE$.$lessinit$greater$default$2();
    }

    public static String apply$default$2() {
        return ErrorInfo$.MODULE$.apply$default$2();
    }

    public static String $lessinit$greater$default$3() {
        return ErrorInfo$.MODULE$.$lessinit$greater$default$3();
    }

    public ErrorInfo(String summary, String detail, String errorHeaderName) {
        this.summary = summary;
        this.detail = detail;
        this.errorHeaderName = errorHeaderName;
    }

    public String summary() {
        return this.summary;
    }

    public String detail() {
        return this.detail;
    }

    public String errorHeaderName() {
        return this.errorHeaderName;
    }

    public ErrorInfo withSummary(String newSummary) {
        return this.copy(newSummary, this.copy$default$2());
    }

    public ErrorInfo withSummaryPrepended(String prefix) {
        return this.withSummary(this.summary().isEmpty() ? prefix : new StringBuilder(2).append(prefix).append(": ").append(this.summary()).toString());
    }

    public ErrorInfo withErrorHeaderName(String headerName) {
        return new ErrorInfo(this.summary(), this.detail(), headerName.toLowerCase());
    }

    public ErrorInfo withFallbackSummary(String fallbackSummary) {
        if (this.summary().isEmpty()) {
            return this.withSummary(fallbackSummary);
        }
        return this;
    }

    public String formatPretty() {
        if (this.summary().isEmpty()) {
            return this.detail();
        }
        if (this.detail().isEmpty()) {
            return this.summary();
        }
        return new StringBuilder(2).append(this.summary()).append(": ").append(this.detail()).toString();
    }

    public String format(boolean withDetail) {
        if (withDetail) {
            return this.formatPretty();
        }
        return this.summary();
    }

    @InternalApi
    public ErrorInfo copy(String summary, String detail) {
        return new ErrorInfo(summary, detail, this.errorHeaderName());
    }

    public String copy$default$1() {
        return this.summary();
    }

    public String copy$default$2() {
        return this.detail();
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ErrorInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof ErrorInfo)) return false;
        ErrorInfo that2 = (ErrorInfo)object;
        if (!that2.canEqual(this)) return false;
        String string2 = that2.summary();
        String string3 = this.summary();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        String string4 = that2.detail();
        String string5 = this.detail();
        if (string4 == null) {
            if (string5 != null) {
                return false;
            }
        } else if (!string4.equals(string5)) return false;
        String string6 = that2.errorHeaderName();
        String string7 = this.errorHeaderName();
        if (string6 == null) {
            if (string7 == null) return true;
            return false;
        } else {
            if (!string6.equals(string7)) return false;
            return true;
        }
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.summary();
            }
            case 1: {
                return this.detail();
            }
            case 2: {
                return this.errorHeaderName();
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n2));
    }

    @Override
    public int productArity() {
        return 3;
    }

    @InternalApi
    public ErrorInfo(String summary, String detail) {
        this(summary, detail, "");
    }

    public String toString() {
        return new StringBuilder(32).append("ErrorInfo(").append(this.summary()).append(", (details omitted), ").append(this.errorHeaderName()).append(")").toString();
    }
}

