/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$ContentType$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.ToStringRenderable;
import org.apache.pekko.http.impl.util.ValueRenderable;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$$u003B$u0020charset$eq$;
import org.apache.pekko.http.scaladsl.model.ContentType$Binary$;
import org.apache.pekko.http.scaladsl.model.ContentType$WithMissingCharset$;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange$;
import org.apache.pekko.http.scaladsl.model.HttpCharsetRange;
import org.apache.pekko.http.scaladsl.model.HttpCharsetRange$$times$;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.MediaType;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ContentTypeRange
extends org.apache.pekko.http.javadsl.model.ContentTypeRange
implements ToStringRenderable,
ValueRenderable,
Product,
Serializable {
    private final MediaRange mediaRange;
    private final HttpCharsetRange charsetRange;

    public static ContentTypeRange $times() {
        return ContentTypeRange$.MODULE$.$times();
    }

    public static ContentTypeRange apply(ContentType contentType) {
        return ContentTypeRange$.MODULE$.apply(contentType);
    }

    public static ContentTypeRange apply(MediaRange mediaRange) {
        return ContentTypeRange$.MODULE$.apply(mediaRange);
    }

    public static ContentTypeRange apply(MediaRange mediaRange, HttpCharsetRange httpCharsetRange) {
        return ContentTypeRange$.MODULE$.apply(mediaRange, httpCharsetRange);
    }

    public static ContentTypeRange apply(MediaType mediaType) {
        return ContentTypeRange$.MODULE$.apply(mediaType);
    }

    public static ContentTypeRange fromProduct(Product product) {
        return ContentTypeRange$.MODULE$.fromProduct(product);
    }

    public static ContentTypeRange unapply(ContentTypeRange contentTypeRange) {
        return ContentTypeRange$.MODULE$.unapply(contentTypeRange);
    }

    public ContentTypeRange(MediaRange mediaRange, HttpCharsetRange charsetRange) {
        this.mediaRange = mediaRange;
        this.charsetRange = charsetRange;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ContentTypeRange)) return false;
        ContentTypeRange contentTypeRange = (ContentTypeRange)object;
        MediaRange mediaRange = this.mediaRange();
        MediaRange mediaRange2 = contentTypeRange.mediaRange();
        if (mediaRange == null) {
            if (mediaRange2 != null) {
                return false;
            }
        } else if (!mediaRange.equals(mediaRange2)) return false;
        HttpCharsetRange httpCharsetRange = this.charsetRange();
        HttpCharsetRange httpCharsetRange2 = contentTypeRange.charsetRange();
        if (httpCharsetRange == null) {
            if (httpCharsetRange2 == null) return true;
            return false;
        } else {
            if (!httpCharsetRange.equals(httpCharsetRange2)) return false;
            return true;
        }
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ContentTypeRange;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "ContentTypeRange";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "mediaRange";
        }
        if (1 == n2) {
            return "charsetRange";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public MediaRange mediaRange() {
        return this.mediaRange;
    }

    @Override
    public HttpCharsetRange charsetRange() {
        return this.charsetRange;
    }

    @Override
    public boolean matches(org.apache.pekko.http.javadsl.model.ContentType contentType) {
        ContentType contentType2 = (ContentType)JavaMapping$Implicits$.MODULE$.convertToScala(contentType, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ContentType$.MODULE$));
        if (contentType2 instanceof ContentType.Binary) {
            MediaType.Binary binary;
            ContentType.Binary binary2 = ContentType$Binary$.MODULE$.unapply((ContentType.Binary)contentType2);
            MediaType.Binary mt = binary = binary2._1();
            return this.mediaRange().matches(mt);
        }
        if (contentType2 instanceof ContentType.WithMissingCharset) {
            MediaType.WithOpenCharset withOpenCharset;
            ContentType.WithMissingCharset withMissingCharset = ContentType$WithMissingCharset$.MODULE$.unapply((ContentType.WithMissingCharset)contentType2);
            MediaType.WithOpenCharset mt = withOpenCharset = withMissingCharset._1();
            return this.mediaRange().matches(mt);
        }
        if (contentType2 instanceof ContentType.NonBinary) {
            ContentType.NonBinary x = (ContentType.NonBinary)contentType2;
            return this.mediaRange().matches((MediaType)x.mediaType()) && this.charsetRange().matches(x.charset());
        }
        throw new MatchError(contentType2);
    }

    @Override
    public <R extends Rendering> Rendering render(R r) {
        HttpCharsetRange httpCharsetRange = this.charsetRange();
        if (((Object)HttpCharsetRange$$times$.MODULE$).equals(httpCharsetRange)) {
            return r.$tilde$tilde((MediaRange)this.mediaRange(), Renderer$.MODULE$.renderableRenderer());
        }
        HttpCharsetRange x = httpCharsetRange;
        return r.$tilde$tilde((MediaRange)this.mediaRange(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ContentType$$u003B$u0020charset$eq$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(x, Renderer$.MODULE$.renderableRenderer());
    }

    public ContentTypeRange copy(MediaRange mediaRange, HttpCharsetRange charsetRange) {
        return new ContentTypeRange(mediaRange, charsetRange);
    }

    public MediaRange copy$default$1() {
        return this.mediaRange();
    }

    public HttpCharsetRange copy$default$2() {
        return this.charsetRange();
    }

    public MediaRange _1() {
        return this.mediaRange();
    }

    public HttpCharsetRange _2() {
        return this.charsetRange();
    }
}

