/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$$u003B$u0020charset$eq$;
import org.apache.pekko.http.scaladsl.model.ContentType$Binary$;
import org.apache.pekko.http.scaladsl.model.ContentType$WithCharset$;
import org.apache.pekko.http.scaladsl.model.ContentType$WithFixedCharset$;
import org.apache.pekko.http.scaladsl.model.ContentType$WithMissingCharset$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class ContentType$
implements Mirror.Sum,
Serializable {
    public static final ContentType$Binary$ Binary;
    public static final ContentType$WithFixedCharset$ WithFixedCharset;
    public static final ContentType$WithCharset$ WithCharset;
    public static final ContentType$WithMissingCharset$ WithMissingCharset;
    public static final ContentType$$u003B$u0020charset$eq$ $u003B$u0020charset$eq;
    public static final ContentType$ MODULE$;

    private ContentType$() {
    }

    static {
        MODULE$ = new ContentType$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ContentType$.class);
    }

    public ContentType.Binary apply(MediaType.Binary mediaType) {
        return ContentType$Binary$.MODULE$.apply(mediaType);
    }

    public ContentType.WithFixedCharset apply(MediaType.WithFixedCharset mediaType) {
        return ContentType$WithFixedCharset$.MODULE$.apply(mediaType);
    }

    public ContentType.WithCharset apply(MediaType.WithOpenCharset mediaType, HttpCharset charset) {
        return ContentType$WithCharset$.MODULE$.apply(mediaType, charset);
    }

    public ContentType apply(MediaType mediaType, Function0<HttpCharset> charset) {
        ContentType contentType;
        MediaType mediaType2 = mediaType;
        if (mediaType2 instanceof MediaType.Binary) {
            MediaType.Binary x = (MediaType.Binary)mediaType2;
            contentType = this.apply(x);
        } else if (mediaType2 instanceof MediaType.WithFixedCharset) {
            MediaType.WithFixedCharset x = (MediaType.WithFixedCharset)mediaType2;
            contentType = this.apply(x);
        } else if (mediaType2 instanceof MediaType.WithOpenCharset) {
            MediaType.WithOpenCharset x = (MediaType.WithOpenCharset)mediaType2;
            contentType = this.apply(x, charset.apply());
        } else {
            throw new MatchError(mediaType2);
        }
        return contentType;
    }

    public Option<Tuple2<MediaType, Option<HttpCharset>>> unapply(ContentType contentType) {
        MediaType mediaType = Predef$.MODULE$.ArrowAssoc(contentType.mediaType());
        return Some$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(mediaType, contentType.charsetOption()));
    }

    public Either<List<ErrorInfo>, ContentType> parse(String value) {
        return Content$minusType$.MODULE$.parseFromValueString(value).right().map((Function1<Content$minusType, ContentType> & Serializable)_$2 -> _$2.contentType());
    }

    public int ordinal(ContentType x$0) {
        ContentType contentType = x$0;
        if (contentType instanceof ContentType.Binary) {
            return 0;
        }
        if (contentType instanceof ContentType.NonBinary) {
            return 1;
        }
        if (contentType instanceof ContentType.WithMissingCharset) {
            return 2;
        }
        throw new MatchError(contentType);
    }
}

