/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.marshallers.sprayjson;

import java.nio.charset.StandardCharsets;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ByteString;
import spray.json.ParserInput;

@InternalApi
public final class SprayJsonByteStringParserInput
extends ParserInput.IndexedBytesParserInput {
    private final ByteString bytes;

    public SprayJsonByteStringParserInput(ByteString bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte byteAt(int offset) {
        return this.bytes.apply(offset);
    }

    @Override
    public int length() {
        return this.bytes.size();
    }

    @Override
    public String sliceString(int start, int end) {
        return this.bytes.slice(start, end - start).decodeString(StandardCharsets.UTF_8);
    }

    @Override
    public char[] sliceCharArray(int start, int end) {
        return StandardCharsets.UTF_8.decode(this.bytes.slice(start, end).asByteBuffer()).array();
    }
}

