/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.coding;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.coding.Coder;
import org.apache.pekko.http.scaladsl.coding.Compressor;
import org.apache.pekko.http.scaladsl.coding.Decoder;
import org.apache.pekko.http.scaladsl.coding.DeflateCompressor;
import org.apache.pekko.http.scaladsl.coding.DeflateCompressor$;
import org.apache.pekko.http.scaladsl.coding.DeflateDecompressor;
import org.apache.pekko.http.scaladsl.coding.Encoder;
import org.apache.pekko.http.scaladsl.coding.StreamDecoder;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;

@InternalApi
public class Deflate
implements Encoder,
Decoder,
Coder,
StreamDecoder {
    private final int compressionLevel;
    private final Function1 messageFilter;
    private final HttpEncoding encoding;

    public Deflate(int compressionLevel, Function1<HttpMessage, Object> messageFilter) {
        this.compressionLevel = compressionLevel;
        this.messageFilter = messageFilter;
        this.encoding = HttpEncodings$.MODULE$.deflate();
    }

    @Override
    public Function1<HttpMessage, Object> messageFilter() {
        return this.messageFilter;
    }

    public Deflate(Function1<HttpMessage, Object> messageFilter) {
        this(DeflateCompressor$.MODULE$.DefaultCompressionLevel(), messageFilter);
    }

    @Override
    public HttpEncoding encoding() {
        return this.encoding;
    }

    @Override
    public Compressor newCompressor() {
        return new DeflateCompressor(this.compressionLevel);
    }

    @Override
    public Function0<GraphStage<FlowShape<ByteString, ByteString>>> newDecompressorStage(int maxBytesPerChunk) {
        return (Function0<GraphStage> & Serializable)() -> new DeflateDecompressor(maxBytesPerChunk);
    }

    public Deflate withLevel(int level) {
        return new Deflate(level, this.messageFilter());
    }
}

