/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.client;

import java.io.Serializable;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.client.TransformerPipelineSupport;
import org.apache.pekko.http.scaladsl.marshalling.Marshal$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpHeader$;
import org.apache.pekko.http.scaladsl.model.HttpHeader$ParsingResult$Ok$;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;

public interface RequestBuilding
extends TransformerPipelineSupport {
    public static void $init$(RequestBuilding $this) {
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Get_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.GET()));
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Post_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.POST()));
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Put_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.PUT()));
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Patch_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.PATCH()));
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Delete_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.DELETE()));
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Options_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.OPTIONS()));
        $this.org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Head_$eq(new RequestBuilder($this, HttpMethods$.MODULE$.HEAD()));
    }

    public RequestBuilder Get();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Get_$eq(RequestBuilder var1);

    public RequestBuilder Post();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Post_$eq(RequestBuilder var1);

    public RequestBuilder Put();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Put_$eq(RequestBuilder var1);

    public RequestBuilder Patch();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Patch_$eq(RequestBuilder var1);

    public RequestBuilder Delete();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Delete_$eq(RequestBuilder var1);

    public RequestBuilder Options();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Options_$eq(RequestBuilder var1);

    public RequestBuilder Head();

    public void org$apache$pekko$http$scaladsl$client$RequestBuilding$_setter_$Head_$eq(RequestBuilder var1);

    public static Function1 addHeader$(RequestBuilding $this, HttpHeader header) {
        return $this.addHeader(header);
    }

    default public Function1<HttpRequest, HttpRequest> addHeader(HttpHeader header) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$1 -> (HttpRequest)_$1.mapHeaders((Function1<Seq, Seq> & Serializable)(T1 _$2) -> (Seq)_$2.$plus$colon(header));
    }

    public static Function1 addHeader$(RequestBuilding $this, String headerName, String headerValue) {
        return $this.addHeader(headerName, headerValue);
    }

    default public Function1<HttpRequest, HttpRequest> addHeader(String headerName, String headerValue) {
        HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(headerName, headerValue, HttpHeader$.MODULE$.parse$default$3());
        if (parsingResult instanceof HttpHeader.ParsingResult.Ok) {
            HttpHeader.ParsingResult.Ok ok = HttpHeader$ParsingResult$Ok$.MODULE$.unapply((HttpHeader.ParsingResult.Ok)parsingResult);
            HttpHeader httpHeader = ok._1();
            List<ErrorInfo> list = ok._2();
            HttpHeader h = httpHeader;
            Nil$ nil$ = package$.MODULE$.Nil();
            List<ErrorInfo> list2 = list;
            if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
                return this.addHeader(h);
            }
        }
        HttpHeader.ParsingResult result = parsingResult;
        throw new IllegalArgumentException(((ErrorInfo)result.errors().head()).formatPretty());
    }

    public static Function1 addHeaders$(RequestBuilding $this, HttpHeader first, Seq more) {
        return $this.addHeaders(first, more);
    }

    default public Function1<HttpRequest, HttpRequest> addHeaders(HttpHeader first, Seq<HttpHeader> more) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$3 -> (HttpRequest)_$3.mapHeaders((Function1<Seq, Seq> & Serializable)(T1 _$4) -> (Seq)_$4.$plus$plus((IterableOnce)more.$plus$colon(first)));
    }

    public static Function1 mapHeaders$(RequestBuilding $this, Function1 f) {
        return $this.mapHeaders(f);
    }

    default public Function1<HttpRequest, HttpRequest> mapHeaders(Function1<Seq<HttpHeader>, Seq<HttpHeader>> f) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$5 -> (HttpRequest)_$5.mapHeaders((Function1)f);
    }

    public static Function1 removeHeader$(RequestBuilding $this, String headerName) {
        return $this.removeHeader(headerName);
    }

    default public Function1<HttpRequest, HttpRequest> removeHeader(String headerName) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$6 -> (HttpRequest)_$6.mapHeaders((Function1<Seq, Seq> & Serializable)(T1 _$7) -> (Seq)_$7.filterNot((Function1<HttpHeader, boolean> & Serializable)_$8 -> _$8.name().equalsIgnoreCase(headerName)));
    }

    public static Function1 removeHeader$(RequestBuilding $this, ClassTag evidence$1) {
        return $this.removeHeader(evidence$1);
    }

    default public <T extends HttpHeader> Function1<HttpRequest, HttpRequest> removeHeader(ClassTag<T> evidence$1) {
        return this.removeHeader(Predef$.MODULE$.implicitly(evidence$1).runtimeClass());
    }

    public static Function1 removeHeader$(RequestBuilding $this, Class clazz) {
        return $this.removeHeader(clazz);
    }

    default public Function1<HttpRequest, HttpRequest> removeHeader(Class<?> clazz) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$9 -> (HttpRequest)_$9.mapHeaders((Function1<Seq, Seq> & Serializable)(T1 _$10) -> (Seq)_$10.filterNot((Function1<HttpHeader, boolean> & Serializable)x$0 -> clazz.isInstance(x$0)));
    }

    public static Function1 removeHeaders$(RequestBuilding $this, Seq names) {
        return $this.removeHeaders(names);
    }

    default public Function1<HttpRequest, HttpRequest> removeHeaders(Seq<String> names) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$11 -> (HttpRequest)_$11.mapHeaders((Function1<Seq, Seq> & Serializable)(T1 _$12) -> (Seq)_$12.filterNot((Function1<HttpHeader, boolean> & Serializable)header -> names.exists((Function1<String, boolean> & Serializable)_$13 -> _$13.equalsIgnoreCase(header.name()))));
    }

    public static Function1 addAttribute$(RequestBuilding $this, AttributeKey key2, Object value) {
        return $this.addAttribute(key2, value);
    }

    default public <T> Function1<HttpRequest, HttpRequest> addAttribute(AttributeKey<T> key2, T value) {
        return (Function1<HttpRequest, HttpRequest> & Serializable)_$14 -> (HttpRequest)_$14.addAttribute((org.apache.pekko.http.javadsl.model.AttributeKey)key2, value);
    }

    public static Function1 addCredentials$(RequestBuilding $this, HttpCredentials credentials) {
        return $this.addCredentials(credentials);
    }

    default public Function1<HttpRequest, HttpRequest> addCredentials(HttpCredentials credentials) {
        return this.addHeader(Authorization$.MODULE$.apply(credentials));
    }

    public static Function1 logRequest$(RequestBuilding $this, LoggingAdapter log, int level) {
        return $this.logRequest(log, level);
    }

    default public Function1<HttpRequest, HttpRequest> logRequest(LoggingAdapter log, int level) {
        return this.logValue(log, level);
    }

    public static int logRequest$default$2$(RequestBuilding $this) {
        return $this.logRequest$default$2();
    }

    default public int logRequest$default$2() {
        return Logging$.MODULE$.DebugLevel();
    }

    public static Function1 logRequest$(RequestBuilding $this, Function1 logFun) {
        return $this.logRequest(logFun);
    }

    default public Function1<HttpRequest, HttpRequest> logRequest(Function1<HttpRequest, BoxedUnit> logFun) {
        return this.logValue(logFun);
    }

    public static Function1 header2AddHeader$(RequestBuilding $this, HttpHeader header) {
        return $this.header2AddHeader(header);
    }

    default public Function1<HttpRequest, HttpRequest> header2AddHeader(HttpHeader header) {
        return this.addHeader(header);
    }

    public class RequestBuilder {
        private final HttpMethod method;
        private final /* synthetic */ RequestBuilding $outer;

        public RequestBuilder(RequestBuilding $outer, HttpMethod method) {
            this.method = method;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public HttpMethod method() {
            return this.method;
        }

        public HttpRequest apply() {
            return this.apply("/");
        }

        public HttpRequest apply(String uri) {
            return this.apply(uri, (RequestEntity)HttpEntity$.MODULE$.Empty());
        }

        public <T> HttpRequest apply(String uri, T content, Marshaller<T, RequestEntity> m, ExecutionContext ec) {
            return this.apply(uri, (Option<T>)Some$.MODULE$.apply(content), m, ec);
        }

        public <T> HttpRequest apply(String uri, Option<T> content, Marshaller<T, RequestEntity> m, ExecutionContext ec) {
            Uri uri2 = Uri$.MODULE$.apply(uri);
            return this.apply(uri2, content, m, this.apply$default$4(uri2, content), ec);
        }

        public HttpRequest apply(String uri, RequestEntity entity) {
            return this.apply(Uri$.MODULE$.apply(uri), entity);
        }

        public HttpRequest apply(Uri uri) {
            return this.apply(uri, (RequestEntity)HttpEntity$.MODULE$.Empty());
        }

        public <T> HttpRequest apply(Uri uri, T content, Marshaller<T, RequestEntity> m, ExecutionContext ec) {
            Some<T> some = Some$.MODULE$.apply(content);
            return this.apply(uri, some, m, this.apply$default$4(uri, some), ec);
        }

        public <T> HttpRequest apply(Uri uri, Option<T> content, Marshaller<T, RequestEntity> m, Timeout timeout, ExecutionContext ec) {
            Option<T> option = content;
            if (None$.MODULE$.equals(option)) {
                return this.apply(uri, (RequestEntity)HttpEntity$.MODULE$.Empty());
            }
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                RequestEntity entity = Await$.MODULE$.result(Marshal$.MODULE$.apply(value).to(m, ec), timeout.duration());
                return this.apply(uri, entity);
            }
            throw new MatchError(option);
        }

        public <T> Timeout apply$default$4(Uri uri, Option<T> content) {
            return Timeout$.MODULE$.apply(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
        }

        public HttpRequest apply(Uri uri, RequestEntity entity) {
            return HttpRequest$.MODULE$.apply(this.method(), uri, package$.MODULE$.Nil(), entity, HttpRequest$.MODULE$.apply$default$5());
        }

        public final /* synthetic */ RequestBuilding org$apache$pekko$http$scaladsl$client$RequestBuilding$RequestBuilder$$$outer() {
            return this.$outer;
        }
    }
}

