/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.PekkoVersion$;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.Version$;
import org.apache.pekko.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import org.apache.pekko.http.impl.engine.client.OutgoingConnectionBlueprint$;
import org.apache.pekko.http.impl.engine.client.PoolId;
import org.apache.pekko.http.impl.engine.client.PoolId$;
import org.apache.pekko.http.impl.engine.client.PoolId$SharedPool$;
import org.apache.pekko.http.impl.engine.client.PoolMaster;
import org.apache.pekko.http.impl.engine.client.PoolMaster$;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2Ext;
import org.apache.pekko.http.impl.engine.http2.OutgoingConnectionBuilderImpl$;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering$;
import org.apache.pekko.http.impl.engine.server.GracefulTerminatorStage$;
import org.apache.pekko.http.impl.engine.server.HttpAttributes$;
import org.apache.pekko.http.impl.engine.server.HttpServerBluePrint$;
import org.apache.pekko.http.impl.engine.server.MasterServerTerminator;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.impl.engine.ws.WebSocketClientBlueprint$;
import org.apache.pekko.http.impl.settings.ConnectionPoolSetup;
import org.apache.pekko.http.impl.settings.ConnectionPoolSetup$;
import org.apache.pekko.http.impl.settings.HostConnectionPoolSetup;
import org.apache.pekko.http.impl.settings.HostConnectionPoolSetup$;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.ConnectionContext;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.DefaultSSLContextCreation;
import org.apache.pekko.http.scaladsl.DeprecatedSslContextParameters;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.Http$IncomingConnection$;
import org.apache.pekko.http.scaladsl.Http$ServerBinding$;
import org.apache.pekko.http.scaladsl.HttpConnectionContext$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder;
import org.apache.pekko.http.scaladsl.ServerBuilder;
import org.apache.pekko.http.scaladsl.ServerBuilder$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.IllegalUriException;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.http.scaladsl.model.ws.Message;
import org.apache.pekko.http.scaladsl.model.ws.WebSocketRequest;
import org.apache.pekko.http.scaladsl.model.ws.WebSocketUpgradeResponse;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings$;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings$;
import org.apache.pekko.http.scaladsl.settings.Http2ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Client$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.Server$;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.stream.TLSClosing;
import org.apache.pekko.stream.TLSClosing$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.TLSRole;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RunnableGraph;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.TLS$;
import org.apache.pekko.stream.scaladsl.TLSPlacebo$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ManifestInfo;
import org.apache.pekko.util.ManifestInfo$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

@DoNotInherit
public class HttpExt
implements Extension,
DefaultSSLContextCreation {
    private final Config config;
    private final ExtendedActorSystem system;
    private final ConnectionPoolSettings defaultConnectionPoolSettings;
    private HttpsConnectionContext _defaultClientHttpsConnectionContext;
    private ConnectionContext _defaultServerConnectionContext;
    private final DateHeaderRendering dateHeaderRendering;
    private final PoolMaster poolMaster;
    private final Materializer systemMaterializer;

    @InternalStableApi
    public HttpExt(Config config, ExtendedActorSystem system) {
        this.config = config;
        this.system = system;
        Version$.MODULE$.check(system.settings().config());
        PekkoVersion$.MODULE$.require("pekko-http", Version$.MODULE$.supportedPekkoVersion());
        ((ManifestInfo)ManifestInfo$.MODULE$.apply(system)).checkSameVersion("Pekko HTTP", this.allModules(), true);
        this.defaultConnectionPoolSettings = (ConnectionPoolSettings)ConnectionPoolSettings$.MODULE$.apply(system);
        int DefaultPortForProtocol = -1;
        this.dateHeaderRendering = DateHeaderRendering$.MODULE$.apply(DateHeaderRendering$.MODULE$.apply$default$1(), system);
        this.poolMaster = PoolMaster$.MODULE$.apply(system);
        this.systemMaterializer = ((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer();
    }

    private Config config() {
        return this.config;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    private List<String> allModules() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"pekko-parsing", "pekko-http-core", "pekko-http", "pekko-http-caching", "pekko-http-testkit", "pekko-http-testkit-munit", "pekko-http-marshallers-scala", "pekko-http-marshallers-java", "pekko-http-spray-json", "pekko-http-xml", "pekko-http-jackson"}));
    }

    public DateHeaderRendering dateHeaderRendering() {
        return this.dateHeaderRendering;
    }

    private BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, ServerTerminator> fuseServerBidiFlow(ServerSettings settings, ConnectionContext connectionContext, LoggingAdapter log) {
        BidiFlow bidiFlow;
        BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> httpLayer = this.serverLayer(settings, None$.MODULE$, log, ((org.apache.pekko.http.javadsl.ConnectionContext)((Object)connectionContext)).isSecure());
        BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> tlsStage = this.sslTlsServerStage(connectionContext);
        Duration duration = ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout();
        if (duration instanceof FiniteDuration) {
            FiniteDuration t = (FiniteDuration)duration;
            bidiFlow = httpLayer.atop(tlsStage).atop(HttpConnectionIdleTimeoutBidi$.MODULE$.apply(t, (Option<InetSocketAddress>)None$.MODULE$));
        } else {
            bidiFlow = httpLayer.atop(tlsStage);
        }
        BidiFlow serverBidiFlow = bidiFlow;
        return GracefulTerminatorStage$.MODULE$.apply(this.system(), settings).atop(serverBidiFlow);
    }

    private BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> delayCancellationStage(ServerSettings settings) {
        return BidiFlow$.MODULE$.fromFlows(Flow$.MODULE$.apply(), StreamUtils$.MODULE$.delayCancellation(ServerSettings$.MODULE$.timeoutsShortcut(settings).lingerTimeout()));
    }

    private Flow<ByteString, ByteString, Tuple2<Future<Done>, ServerTerminator>> fuseServerFlow(BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, ServerTerminator> baseFlow, Flow<HttpRequest, HttpResponse, Object> handler) {
        return Flow$.MODULE$.fromGraph(((Flow)((Flow)((Flow)Flow$.MODULE$.apply().watchTermination(Keep$.MODULE$.right())).via(handler)).watchTermination((Function2<Future, Future, Future> & Serializable)(termWatchBefore, termWatchAfter) -> termWatchBefore.flatMap((Function1<Done, Future> & Serializable)_$3 -> termWatchAfter, ExecutionContexts$.MODULE$.parasitic()))).joinMat(baseFlow, Keep$.MODULE$.both()));
    }

    private Source<Tcp.IncomingConnection, Future<Tcp.ServerBinding>> tcpBind(String string2, int port, ServerSettings settings) {
        return ((Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system())).bind(string2, port, settings.backlog(), settings.socketOptions(), false, Duration$.MODULE$.Inf());
    }

    private int choosePort(int port, ConnectionContext connectionContext, ServerSettings settings) {
        if (port >= 0) {
            return port;
        }
        if (((org.apache.pekko.http.javadsl.ConnectionContext)((Object)connectionContext)).isSecure()) {
            return settings.defaultHttpsPort();
        }
        return settings.defaultHttpPort();
    }

    public ServerBuilder newServerAt(String string2, int port) {
        return ServerBuilder$.MODULE$.apply(string2, port, this.system());
    }

    public Source<Http.IncomingConnection, Future<Http.ServerBinding>> bind(String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log) {
        if (settings.previewServerSettings().enableHttp2()) {
            log.warning(new StringBuilder(96).append("Binding with a connection source not supported with HTTP/2. Falling back to HTTP/1.1 for port [").append(port).append("]").toString());
        }
        BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, ServerTerminator> fullLayer = this.fuseServerBidiFlow(settings, connectionContext, log);
        MasterServerTerminator masterTerminator = new MasterServerTerminator(log);
        return ((Source)this.tcpBind(string2, this.choosePort(port, connectionContext, settings), settings).map((Function1<Tcp.IncomingConnection, Http.IncomingConnection> & Serializable)incoming -> {
            Graph preparedLayer = fullLayer.addAttributes(Http$.MODULE$.prepareAttributes(settings, (Tcp.IncomingConnection)incoming));
            Flow<HttpResponse, HttpRequest, ServerTerminator> serverFlow = ((BidiFlow)preparedLayer).join(incoming.flow());
            return Http$IncomingConnection$.MODULE$.apply(incoming.localAddress(), incoming.remoteAddress(), serverFlow);
        })).mapMaterializedValue((Function1<Future, Future> & Serializable)_$4 -> _$4.map((Function1<Tcp.ServerBinding, Http.ServerBinding> & Serializable)tcpBinding -> Http$ServerBinding$.MODULE$.apply(tcpBinding.localAddress(), (Function0<Future<BoxedUnit>>)(Function0<Future> & Serializable)() -> tcpBinding.unbind(), (Function1<FiniteDuration, Future<Http.HttpTerminated>>)(Function1<FiniteDuration, Future> & Serializable)timeout -> masterTerminator.terminate((FiniteDuration)timeout, this.systemMaterializer.executionContext())), this.systemMaterializer.executionContext()));
    }

    public int bind$default$2() {
        return -1;
    }

    public ConnectionContext bind$default$3() {
        return this.defaultServerHttpContext();
    }

    public ServerSettings bind$default$4() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter bind$default$5() {
        return this.system().log();
    }

    public Source<Http.IncomingConnection, Future<Http.ServerBinding>> bindImpl(String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log) {
        return this.bind(string2, port, connectionContext, settings, log);
    }

    public Future<Http.ServerBinding> bindAndHandle(Flow<HttpRequest, HttpResponse, Object> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log, Materializer fm) {
        if (settings.previewServerSettings().enableHttp2()) {
            log.warning(new StringBuilder(97).append("Binding with a connection source not supported with HTTP/2. Falling back to HTTP/1.1 for port [").append(port).append("].").toString());
        }
        Flow<ByteString, ByteString, Tuple2<Future<Done>, ServerTerminator>> fullLayer = this.fuseServerFlow(this.fuseServerBidiFlow(settings, connectionContext, log), handler);
        MasterServerTerminator masterTerminator = new MasterServerTerminator(log);
        return (Future)((RunnableGraph)((Source)((Source)this.tcpBind(string2, this.choosePort(port, connectionContext, settings), settings).mapAsyncUnordered(settings.maxConnections(), (Function1<Tcp.IncomingConnection, Future> & Serializable)incoming -> {
            Future<Done> future;
            try {
                future = ((Future)((RunnableGraph)((Flow)((Flow)fullLayer.watchTermination((Function2<Tuple2, Future, Tuple2> & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2;
                    Tuple2<Tuple2, Future> tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 != null && (tuple2 = tuple22._1()) != null) {
                        Future done = (Future)tuple2._1();
                        ServerTerminator connectionTerminator = (ServerTerminator)tuple2._2();
                        Future whenTerminates = tuple22._2();
                        whenTerminates.onComplete(_$5 -> masterTerminator.removeConnection(connectionTerminator), fm.executionContext());
                        return Tuple2$.MODULE$.apply(done, connectionTerminator);
                    }
                    throw new MatchError(tuple22);
                })).addAttributes(Http$.MODULE$.prepareAttributes(settings, (Tcp.IncomingConnection)incoming))).join(incoming.flow()).mapMaterializedValue((Function1<Tuple2, Future> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Future future = (Future)tuple2._1();
                        ServerTerminator connectionTerminator = (ServerTerminator)tuple2._2();
                        masterTerminator.registerConnection(connectionTerminator, fm.executionContext());
                        return future;
                    }
                    throw new MatchError(tuple2);
                }).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()))).run(fm)).recover(new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Option<Throwable> option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = option.get();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Option<Throwable> option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = option.get();
                            return Done$.MODULE$;
                        }
                        return function1.apply(x);
                    }
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    log.error(e, "Could not materialize handling flow for {}", incoming);
                    throw e;
                }
                throw throwable;
            }
            return future;
        })).mapMaterializedValue((Function1<Future, Future> & Serializable)m -> m.map((Function1<Tcp.ServerBinding, Http.ServerBinding> & Serializable)tcpBinding -> Http$ServerBinding$.MODULE$.apply(tcpBinding.localAddress(), (Function0<Future<BoxedUnit>>)(Function0<Future> & Serializable)() -> tcpBinding.unbind(), (Function1<FiniteDuration, Future<Http.HttpTerminated>>)(Function1<FiniteDuration, Future> & Serializable)timeout -> masterTerminator.terminate((FiniteDuration)timeout, fm.executionContext())), fm.executionContext()))).to(Sink$.MODULE$.ignore())).run(fm);
    }

    public int bindAndHandle$default$3() {
        return -1;
    }

    public ConnectionContext bindAndHandle$default$4() {
        return this.defaultServerHttpContext();
    }

    public ServerSettings bindAndHandle$default$5() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter bindAndHandle$default$6() {
        return this.system().log();
    }

    public Materializer bindAndHandle$default$7(Flow<HttpRequest, HttpResponse, Object> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log) {
        return this.systemMaterializer;
    }

    public Future<Http.ServerBinding> bindAndHandleImpl(Flow<HttpRequest, HttpResponse, Object> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log, Materializer fm) {
        return this.bindAndHandle(handler, string2, port, connectionContext, settings, log, fm);
    }

    public Future<Http.ServerBinding> bindAndHandleSync(Function1<HttpRequest, HttpResponse> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log, Materializer fm) {
        return this.bindAndHandleAsync((Function1<HttpRequest, Future<HttpResponse>>)(Function1<HttpRequest, Future> & Serializable)req -> FastFuture$.MODULE$.successful().apply(handler.apply((HttpRequest)req)), string2, port, connectionContext, settings, 0, log, fm);
    }

    public int bindAndHandleSync$default$3() {
        return -1;
    }

    public ConnectionContext bindAndHandleSync$default$4() {
        return this.defaultServerHttpContext();
    }

    public ServerSettings bindAndHandleSync$default$5() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter bindAndHandleSync$default$6() {
        return this.system().log();
    }

    public Materializer bindAndHandleSync$default$7(Function1<HttpRequest, HttpResponse> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log) {
        return this.systemMaterializer;
    }

    public Future<Http.ServerBinding> bindAndHandleAsync(Function1<HttpRequest, Future<HttpResponse>> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, int parallelism, LoggingAdapter log, Materializer fm) {
        int n;
        if (settings.previewServerSettings().enableHttp2()) {
            ServerSettings serverSettings;
            log.debug("Binding server using HTTP/2");
            if (parallelism > 0) {
                serverSettings = settings.mapHttp2Settings((Function1<Http2ServerSettings, Http2ServerSettings> & Serializable)_$6 -> _$6.withMaxConcurrentStreams(parallelism));
            } else {
                if (parallelism < 0) {
                    throw new IllegalArgumentException("Only positive values allowed for `parallelism`.");
                }
                serverSettings = settings;
            }
            ServerSettings definitiveSettings = serverSettings;
            return ((Http2Ext)Http2$.MODULE$.apply((ClassicActorSystemProvider)this.system())).bindAndHandleAsync(handler, string2, port, connectionContext, definitiveSettings, log, fm);
        }
        if (parallelism > 0) {
            n = parallelism;
        } else {
            if (parallelism < 0) {
                throw new IllegalArgumentException("Only positive values allowed for `parallelism`.");
            }
            n = settings.pipeliningLimit();
        }
        int definitiveParallelism = n;
        return this.bindAndHandleImpl((Flow)Flow$.MODULE$.apply().mapAsync(definitiveParallelism, handler), string2, port, connectionContext, settings, log, fm);
    }

    public int bindAndHandleAsync$default$3() {
        return -1;
    }

    public ConnectionContext bindAndHandleAsync$default$4() {
        return this.defaultServerHttpContext();
    }

    public ServerSettings bindAndHandleAsync$default$5() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public int bindAndHandleAsync$default$6() {
        return 0;
    }

    public LoggingAdapter bindAndHandleAsync$default$7() {
        return this.system().log();
    }

    public Materializer bindAndHandleAsync$default$8(Function1<HttpRequest, Future<HttpResponse>> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, int parallelism, LoggingAdapter log) {
        return this.systemMaterializer;
    }

    public Future<Http.ServerBinding> bindAndHandleAsyncImpl(Function1<HttpRequest, Future<HttpResponse>> handler, String string2, int port, ConnectionContext connectionContext, ServerSettings settings, int parallelism, LoggingAdapter log, Materializer fm) {
        return this.bindAndHandleAsync(handler, string2, port, connectionContext, settings, parallelism, log, fm);
    }

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> serverLayer(ServerSettings settings, Option<InetSocketAddress> remoteAddress, LoggingAdapter log, boolean isSecureConnection) {
        Graph server = ((BidiFlow)HttpServerBluePrint$.MODULE$.apply(settings, log, isSecureConnection, this.dateHeaderRendering()).addAttributes(HttpAttributes$.MODULE$.remoteAddress(remoteAddress))).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()));
        return ((BidiFlow)server).atop(this.delayCancellationStage(settings));
    }

    public ServerSettings serverLayer$default$1() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public Option<InetSocketAddress> serverLayer$default$2() {
        return None$.MODULE$;
    }

    public LoggingAdapter serverLayer$default$3() {
        return this.system().log();
    }

    public boolean serverLayer$default$4() {
        return false;
    }

    public PoolMaster poolMaster() {
        return this.poolMaster;
    }

    public OutgoingConnectionBuilder connectionTo(String host) {
        return OutgoingConnectionBuilderImpl$.MODULE$.apply(host, this.system());
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnection(String host, int port, Option<InetSocketAddress> localAddress, ClientConnectionSettings settings, LoggingAdapter log) {
        return this._outgoingConnection(host, port, settings.withLocalAddressOverride(localAddress), ConnectionContext$.MODULE$.noEncryption(), log);
    }

    public int outgoingConnection$default$2() {
        return 80;
    }

    public Option<InetSocketAddress> outgoingConnection$default$3() {
        return None$.MODULE$;
    }

    public ClientConnectionSettings outgoingConnection$default$4() {
        return (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter outgoingConnection$default$5() {
        return this.system().log();
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnectionHttps(String host, int port, HttpsConnectionContext connectionContext, Option<InetSocketAddress> localAddress, ClientConnectionSettings settings, LoggingAdapter log) {
        return this._outgoingConnection(host, port, settings.withLocalAddressOverride(localAddress), connectionContext, log);
    }

    public int outgoingConnectionHttps$default$2() {
        return 443;
    }

    public HttpsConnectionContext outgoingConnectionHttps$default$3() {
        return this.defaultClientHttpsContext();
    }

    public Option<InetSocketAddress> outgoingConnectionHttps$default$4() {
        return None$.MODULE$;
    }

    public ClientConnectionSettings outgoingConnectionHttps$default$5() {
        return (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter outgoingConnectionHttps$default$6() {
        return this.system().log();
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnectionUsingContext(String host, int port, ConnectionContext connectionContext, ClientConnectionSettings settings, LoggingAdapter log) {
        return this._outgoingConnection(host, port, settings, connectionContext, log);
    }

    public ClientConnectionSettings outgoingConnectionUsingContext$default$4() {
        return (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter outgoingConnectionUsingContext$default$5() {
        return this.system().log();
    }

    private Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> _outgoingConnection(String host, int port, ClientConnectionSettings settings, ConnectionContext connectionContext, LoggingAdapter log) {
        int n = port;
        Host hostHeader = 0 == n ? Host$.MODULE$.apply(host) : (80 == n && !((org.apache.pekko.http.javadsl.ConnectionContext)((Object)connectionContext)).isSecure() ? Host$.MODULE$.apply(host) : (443 == n && ((org.apache.pekko.http.javadsl.ConnectionContext)((Object)connectionContext)).isSecure() ? Host$.MODULE$.apply(host) : Host$.MODULE$.apply(host, port)));
        BidiFlow<HttpRequest, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpResponse, NotUsed> layer = this.clientLayer(hostHeader, settings, log);
        return layer.joinMat(this._outgoingTlsConnectionLayer(host, port, settings, connectionContext, log), Keep$.MODULE$.right()).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()));
    }

    private Flow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, Future<Http.OutgoingConnection>> _outgoingTlsConnectionLayer(String host, int port, ClientConnectionSettings settings, ConnectionContext connectionContext, LoggingAdapter log) {
        BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> tlsStage = this.sslTlsClientStage(connectionContext, host, port);
        return tlsStage.joinMat(settings.transport().connectTo(host, port, settings, this.system()), Keep$.MODULE$.right());
    }

    public BidiFlow<HttpRequest, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpResponse, NotUsed> clientLayer(Host hostHeader) {
        return this.clientLayer(hostHeader, (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system()), this.clientLayer$default$3());
    }

    public BidiFlow<HttpRequest, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpResponse, NotUsed> clientLayer(Host hostHeader, ClientConnectionSettings settings, LoggingAdapter log) {
        return OutgoingConnectionBlueprint$.MODULE$.apply(hostHeader, settings, log).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()));
    }

    public LoggingAdapter clientLayer$default$3() {
        return this.system().log();
    }

    public <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> newHostConnectionPool(String host, int port, ConnectionPoolSettings settings, LoggingAdapter log, Materializer fm) {
        ConnectionPoolSetup cps = ConnectionPoolSetup$.MODULE$.apply(settings.forHost(host), ConnectionContext$.MODULE$.noEncryption(), log);
        return this.newHostConnectionPool(HostConnectionPoolSetup$.MODULE$.apply(host, port, cps), fm);
    }

    public int newHostConnectionPool$default$2() {
        return 80;
    }

    public <T> ConnectionPoolSettings newHostConnectionPool$default$3() {
        return this.defaultConnectionPoolSettings;
    }

    public <T> LoggingAdapter newHostConnectionPool$default$4() {
        return this.system().log();
    }

    public <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> newHostConnectionPoolHttps(String host, int port, HttpsConnectionContext connectionContext, ConnectionPoolSettings settings, LoggingAdapter log, Materializer fm) {
        ConnectionPoolSetup cps = ConnectionPoolSetup$.MODULE$.apply(settings.forHost(host), connectionContext, log);
        return this.newHostConnectionPool(HostConnectionPoolSetup$.MODULE$.apply(host, port, cps), fm);
    }

    public int newHostConnectionPoolHttps$default$2() {
        return 443;
    }

    public <T> HttpsConnectionContext newHostConnectionPoolHttps$default$3() {
        return this.defaultClientHttpsContext();
    }

    public <T> ConnectionPoolSettings newHostConnectionPoolHttps$default$4() {
        return this.defaultConnectionPoolSettings;
    }

    public <T> LoggingAdapter newHostConnectionPoolHttps$default$5() {
        return this.system().log();
    }

    @InternalApi
    public <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> newHostConnectionPool(HostConnectionPoolSetup setup, Materializer fm) {
        PoolId poolId = new PoolId(setup, PoolId$.MODULE$.newUniquePool());
        this.poolMaster().startPool(poolId, fm);
        return this.poolClientFlow(poolId);
    }

    public <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> cachedHostConnectionPool(String host, int port, ConnectionPoolSettings settings, LoggingAdapter log) {
        ConnectionPoolSetup cps = ConnectionPoolSetup$.MODULE$.apply(settings.forHost(host), ConnectionContext$.MODULE$.noEncryption(), log);
        HostConnectionPoolSetup setup = HostConnectionPoolSetup$.MODULE$.apply(host, port, cps);
        return this.cachedHostConnectionPool(setup);
    }

    public int cachedHostConnectionPool$default$2() {
        return 80;
    }

    public <T> ConnectionPoolSettings cachedHostConnectionPool$default$3() {
        return this.defaultConnectionPoolSettings;
    }

    public <T> LoggingAdapter cachedHostConnectionPool$default$4() {
        return this.system().log();
    }

    public <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> cachedHostConnectionPoolHttps(String host, int port, HttpsConnectionContext connectionContext, ConnectionPoolSettings settings, LoggingAdapter log) {
        ConnectionPoolSetup cps = ConnectionPoolSetup$.MODULE$.apply(settings.forHost(host), connectionContext, log);
        HostConnectionPoolSetup setup = HostConnectionPoolSetup$.MODULE$.apply(host, port, cps);
        return this.cachedHostConnectionPool(setup);
    }

    public int cachedHostConnectionPoolHttps$default$2() {
        return 443;
    }

    public <T> HttpsConnectionContext cachedHostConnectionPoolHttps$default$3() {
        return this.defaultClientHttpsContext();
    }

    public <T> ConnectionPoolSettings cachedHostConnectionPoolHttps$default$4() {
        return this.defaultConnectionPoolSettings;
    }

    public <T> LoggingAdapter cachedHostConnectionPoolHttps$default$5() {
        return this.system().log();
    }

    private <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> cachedHostConnectionPool(HostConnectionPoolSetup setup) {
        PoolId poolId = this.sharedPoolId(setup);
        this.poolMaster().startPool(poolId, Materializer$.MODULE$.matFromSystem(this.system()));
        return this.poolClientFlow(poolId);
    }

    public <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, NotUsed> superPool(HttpsConnectionContext connectionContext, ConnectionPoolSettings settings, LoggingAdapter log) {
        return this.clientFlow(settings, (Function1<HttpRequest, Future<HttpResponse>>)(Function1<HttpRequest, Future> & Serializable)request -> this.singleRequest((HttpRequest)request, connectionContext, settings.forHost(request.uri().authority().host().toString()), log));
    }

    public <T> HttpsConnectionContext superPool$default$1() {
        return this.defaultClientHttpsContext();
    }

    public <T> ConnectionPoolSettings superPool$default$2() {
        return this.defaultConnectionPoolSettings;
    }

    public <T> LoggingAdapter superPool$default$3() {
        return this.system().log();
    }

    public Future<HttpResponse> singleRequest(HttpRequest request, HttpsConnectionContext connectionContext, ConnectionPoolSettings settings, LoggingAdapter log) {
        Future<Object> future;
        try {
            future = this.poolMaster().dispatchRequest(this.sharedPoolIdFor(request, settings.forHost(request.uri().authority().host().toString()), connectionContext, log), request, Materializer$.MODULE$.matFromSystem(this.system()));
        }
        catch (IllegalUriException e) {
            future = FastFuture$.MODULE$.failed().apply(e);
        }
        return future;
    }

    public HttpsConnectionContext singleRequest$default$2() {
        return this.defaultClientHttpsContext();
    }

    public ConnectionPoolSettings singleRequest$default$3() {
        return this.defaultConnectionPoolSettings;
    }

    public LoggingAdapter singleRequest$default$4() {
        return this.system().log();
    }

    public BidiFlow<Message, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, Message, Future<WebSocketUpgradeResponse>> webSocketClientLayer(WebSocketRequest request, ClientConnectionSettings settings, LoggingAdapter log) {
        return WebSocketClientBlueprint$.MODULE$.apply(request, settings, log).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()));
    }

    public ClientConnectionSettings webSocketClientLayer$default$2() {
        return (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter webSocketClientLayer$default$3() {
        return this.system().log();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Flow<Message, Message, Future<WebSocketUpgradeResponse>> webSocketClientFlow(WebSocketRequest request, ConnectionContext connectionContext, Option<InetSocketAddress> localAddress, ClientConnectionSettings settings, LoggingAdapter log) {
        ConnectionContext connectionContext2;
        Predef$.MODULE$.require(request.uri().isAbsolute(), () -> HttpExt.webSocketClientFlow$$anonfun$1(request));
        String string2 = request.uri().scheme();
        if ("ws".equals(string2)) {
            connectionContext2 = ConnectionContext$.MODULE$.noEncryption();
        } else if ("wss".equals(string2)) {
            if (!((org.apache.pekko.http.javadsl.ConnectionContext)((Object)connectionContext)).isSecure()) throw new IllegalArgumentException("Provided connectionContext is not secure, yet request to secure `wss` endpoint detected!");
            connectionContext2 = connectionContext;
        } else {
            String scheme = string2;
            throw new IllegalArgumentException(new StringBuilder(99).append("Illegal URI scheme '").append(scheme).append("' in '").append(request.uri()).append("' for WebSocket request. ").append("WebSocket requests must use either 'ws' or 'wss'").toString());
        }
        HttpConnectionContext$ ctx = connectionContext2;
        String host = request.uri().authority().host().address();
        int port = request.uri().effectivePort();
        return this.webSocketClientLayer(request, settings, log).join(this._outgoingTlsConnectionLayer(host, port, settings.withLocalAddressOverride(localAddress), ctx, log)).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()));
    }

    public ConnectionContext webSocketClientFlow$default$2() {
        return this.defaultClientHttpsContext();
    }

    public Option<InetSocketAddress> webSocketClientFlow$default$3() {
        return None$.MODULE$;
    }

    public ClientConnectionSettings webSocketClientFlow$default$4() {
        return (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter webSocketClientFlow$default$5() {
        return this.system().log();
    }

    public <T> Tuple2<Future<WebSocketUpgradeResponse>, T> singleWebSocketRequest(WebSocketRequest request, Flow<Message, Message, T> clientFlow, ConnectionContext connectionContext, Option<InetSocketAddress> localAddress, ClientConnectionSettings settings, LoggingAdapter log, Materializer mat) {
        return this.webSocketClientFlow(request, connectionContext, localAddress, settings, log).joinMat(clientFlow, Keep$.MODULE$.both()).run(mat);
    }

    public <T> ConnectionContext singleWebSocketRequest$default$3() {
        return this.defaultClientHttpsContext();
    }

    public <T> Option<InetSocketAddress> singleWebSocketRequest$default$4() {
        return None$.MODULE$;
    }

    public <T> ClientConnectionSettings singleWebSocketRequest$default$5() {
        return (ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(this.system());
    }

    public <T> LoggingAdapter singleWebSocketRequest$default$6() {
        return this.system().log();
    }

    public Future<BoxedUnit> shutdownAllConnectionPools() {
        return this.poolMaster().shutdownAll().map(_$7 -> {}, this.system().dispatcher());
    }

    public ConnectionContext defaultServerHttpContext() {
        ConnectionContext connectionContext;
        HttpExt httpExt = this;
        synchronized (httpExt) {
            if (this._defaultServerConnectionContext == null) {
                this._defaultServerConnectionContext = ConnectionContext$.MODULE$.noEncryption();
            }
            connectionContext = this._defaultServerConnectionContext;
        }
        return connectionContext;
    }

    public void setDefaultServerHttpContext(ConnectionContext context) {
        HttpExt httpExt = this;
        synchronized (httpExt) {
            this._defaultServerConnectionContext = context;
        }
    }

    public HttpsConnectionContext defaultClientHttpsContext() {
        HttpsConnectionContext httpsConnectionContext;
        HttpExt httpExt = this;
        synchronized (httpExt) {
            HttpsConnectionContext httpsConnectionContext2;
            HttpsConnectionContext httpsConnectionContext3 = this._defaultClientHttpsConnectionContext;
            if (httpsConnectionContext3 == null) {
                HttpsConnectionContext ctx;
                this._defaultClientHttpsConnectionContext = ctx = ConnectionContext$.MODULE$.httpsClient(SSLContext.getDefault());
                httpsConnectionContext2 = ctx;
            } else {
                HttpsConnectionContext ctx;
                httpsConnectionContext2 = ctx = httpsConnectionContext3;
            }
            httpsConnectionContext = httpsConnectionContext2;
        }
        return httpsConnectionContext;
    }

    public void setDefaultClientHttpsContext(HttpsConnectionContext context) {
        HttpExt httpExt = this;
        synchronized (httpExt) {
            this._defaultClientHttpsConnectionContext = context;
        }
    }

    private PoolId sharedPoolIdFor(HttpRequest request, ConnectionPoolSettings settings, ConnectionContext connectionContext, LoggingAdapter log) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.uri().scheme())) && request.uri().authority().nonEmpty()) {
            ConnectionContext httpsCtx = request.uri().scheme().equalsIgnoreCase("https") ? connectionContext : ConnectionContext$.MODULE$.noEncryption();
            ConnectionPoolSetup setup = ConnectionPoolSetup$.MODULE$.apply(settings, httpsCtx, log);
            String host = request.uri().authority().host().toString();
            HostConnectionPoolSetup hcps = HostConnectionPoolSetup$.MODULE$.apply(host, request.uri().effectivePort(), setup);
            return this.sharedPoolId(hcps);
        }
        String msg = new StringBuilder(96).append("Cannot determine request scheme and target endpoint as ").append(request.method()).append(" request to ").append(request.uri()).append(" doesn't have an absolute URI").toString();
        throw new IllegalUriException(ErrorInfo$.MODULE$.apply(msg, ErrorInfo$.MODULE$.apply$default$2()));
    }

    private PoolId sharedPoolId(HostConnectionPoolSetup hcps) {
        return new PoolId(hcps, PoolId$SharedPool$.MODULE$);
    }

    private <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Http.HostConnectionPool> poolClientFlow(PoolId poolId) {
        return this.clientFlow(poolId.hcps().setup().settings(), (Function1<HttpRequest, Future<HttpResponse>>)(Function1<HttpRequest, Future> & Serializable)request -> this.poolMaster().dispatchRequest(poolId, (HttpRequest)request, Materializer$.MODULE$.matFromSystem(this.system()))).mapMaterializedValue((Function1<NotUsed, Http.HostConnectionPoolImpl> & Serializable)_$8 -> new Http.HostConnectionPoolImpl(poolId, this.poolMaster()));
    }

    private <T> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, NotUsed> clientFlow(ConnectionPoolSettings settings, Function1<HttpRequest, Future<HttpResponse>> poolInterface) {
        int parallelism = settings.pipeliningLimit() * settings.maxConnections();
        return (Flow)Flow$.MODULE$.apply().mapAsyncUnordered(parallelism, (Function1<Tuple2, Future> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                HttpRequest request = (HttpRequest)tuple2._1();
                Object userContext = tuple2._2();
                return ((Future)poolInterface.apply(request)).transform((Function1<Try, Try> & Serializable)response -> {
                    Try try_ = Predef$.MODULE$.ArrowAssoc(response);
                    return Success$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(try_, userContext));
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            throw new MatchError(tuple2);
        });
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> sslTlsClientStage(ConnectionContext connectionContext, String host, int port) {
        return this.sslTlsStage(connectionContext, Client$.MODULE$, Some$.MODULE$.apply(Tuple2$.MODULE$.apply(host, BoxesRunTime.boxToInteger(port))));
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> sslTlsServerStage(ConnectionContext connectionContext) {
        return this.sslTlsStage(connectionContext, Server$.MODULE$, None$.MODULE$);
    }

    private BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> sslTlsStage(ConnectionContext connectionContext, TLSRole role, Option<Tuple2<String, Object>> hostInfo) {
        ConnectionContext connectionContext2 = connectionContext;
        if (connectionContext2 instanceof HttpsConnectionContext) {
            HttpsConnectionContext hctx = (HttpsConnectionContext)connectionContext2;
            Either<DeprecatedSslContextParameters, Function1<Option<Tuple2<String, Object>>, SSLEngine>> either = hctx.sslContextData();
            if (either instanceof Left) {
                DeprecatedSslContextParameters ssl = (DeprecatedSslContextParameters)((Left)either).value();
                TLSProtocol.NegotiateNewSession negotiateNewSession = ssl.firstSession();
                TLSClosing tLSClosing = TLSClosing$.MODULE$.eagerClose();
                return TLS$.MODULE$.apply(ssl.sslContext(), ssl.sslConfig(), negotiateNewSession, role, tLSClosing, hostInfo);
            }
            if (either instanceof Right) {
                Function1 engineCreator = (Function1)((Right)either).value();
                return TLS$.MODULE$.apply((Function0<SSLEngine> & Serializable)() -> (SSLEngine)engineCreator.apply(hostInfo), TLSClosing$.MODULE$.eagerClose());
            }
            throw new MatchError(either);
        }
        ConnectionContext other = connectionContext2;
        return TLSPlacebo$.MODULE$.apply();
    }

    @InternalApi
    public Future<Object> poolSize() {
        return this.poolMaster().poolSize();
    }

    private static final Object webSocketClientFlow$$anonfun$1(WebSocketRequest request$1) {
        return new StringBuilder(49).append("WebSocket request URI must be absolute but was '").append(request$1.uri()).append("'").toString();
    }
}

