/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import com.typesafe.sslconfig.pekko.PekkoSSLConfig;
import com.typesafe.sslconfig.pekko.PekkoSSLConfig$;
import com.typesafe.sslconfig.pekko.util.PekkoLoggerFactory;
import com.typesafe.sslconfig.ssl.ClientAuth;
import com.typesafe.sslconfig.ssl.ClientAuth$Default$;
import com.typesafe.sslconfig.ssl.ClientAuth$Need$;
import com.typesafe.sslconfig.ssl.ClientAuth$None$;
import com.typesafe.sslconfig.ssl.ClientAuth$Want$;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.stream.TLSClientAuth$Need$;
import org.apache.pekko.stream.TLSClientAuth$None$;
import org.apache.pekko.stream.TLSClientAuth$Want$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;

public interface DefaultSSLContextCreation {
    public ActorSystem system();

    public static PekkoSSLConfig sslConfig$(DefaultSSLContextCreation $this) {
        return $this.sslConfig();
    }

    default public PekkoSSLConfig sslConfig() {
        return (PekkoSSLConfig)PekkoSSLConfig$.MODULE$.apply((ClassicActorSystemProvider)this.system());
    }

    private LoggingAdapter log() {
        return this.system().log();
    }

    public static void validateAndWarnAboutLooseSettings$(DefaultSSLContextCreation $this) {
        $this.validateAndWarnAboutLooseSettings();
    }

    default public void validateAndWarnAboutLooseSettings() {
    }

    public static HttpsConnectionContext createDefaultClientHttpsContext$(DefaultSSLContextCreation $this) {
        return $this.createDefaultClientHttpsContext();
    }

    default public HttpsConnectionContext createDefaultClientHttpsContext() {
        return this.createClientHttpsContext((PekkoSSLConfig)PekkoSSLConfig$.MODULE$.apply((ClassicActorSystemProvider)this.system()));
    }

    public static HttpsConnectionContext createServerHttpsContext$(DefaultSSLContextCreation $this, PekkoSSLConfig sslConfig) {
        return $this.createServerHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createServerHttpsContext(PekkoSSLConfig sslConfig) {
        this.log().warning("Automatic server-side configuration is not supported yet, will attempt to use client-side settings. Instead it is recommended to construct the Servers HttpsConnectionContext manually (via SSLContext).");
        return this.createClientHttpsContext(sslConfig);
    }

    public static HttpsConnectionContext createClientHttpsContext$(DefaultSSLContextCreation $this, PekkoSSLConfig sslConfig) {
        return $this.createClientHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createClientHttpsContext(PekkoSSLConfig sslConfig) {
        Option option;
        SSLContext sSLContext;
        SSLConfigSettings config = sslConfig.config();
        LoggingAdapter log = Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromClass());
        PekkoLoggerFactory mkLogger = new PekkoLoggerFactory(this.system());
        if (sslConfig.config().default()) {
            log.debug("buildSSLContext: ssl-config.default is true, using default SSLContext");
            sslConfig.validateDefaultTrustManager(config);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = sslConfig.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = sslConfig.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder(mkLogger, config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = sslConfig.configureProtocols(defaultProtocols, config);
        defaultParams.setProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = sslConfig.configureCipherSuites(defaultCiphers, config);
        defaultParams.setCipherSuites(cipherSuites);
        ClientAuth clientAuth = config.sslParametersConfig().clientAuth();
        if (ClientAuth$Default$.MODULE$.equals(clientAuth)) {
            option = None$.MODULE$;
        } else if (ClientAuth$Want$.MODULE$.equals(clientAuth)) {
            option = Some$.MODULE$.apply(TLSClientAuth$Want$.MODULE$);
        } else if (ClientAuth$Need$.MODULE$.equals(clientAuth)) {
            option = Some$.MODULE$.apply(TLSClientAuth$Need$.MODULE$);
        } else if (ClientAuth$None$.MODULE$.equals(clientAuth)) {
            option = Some$.MODULE$.apply(TLSClientAuth$None$.MODULE$);
        } else {
            throw new MatchError(clientAuth);
        }
        None$ clientAuth2 = option;
        if (!sslConfig.config().loose().disableHostnameVerification()) {
            defaultParams.setEndpointIdentificationAlgorithm("https");
        }
        return new HttpsConnectionContext(sslContext, Some$.MODULE$.apply(sslConfig), Some$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(cipherSuites).toList()), Some$.MODULE$.apply(Predef$.MODULE$.wrapRefArray(defaultProtocols).toList()), clientAuth2, Some$.MODULE$.apply(defaultParams));
    }
}

