/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import com.typesafe.sslconfig.pekko.PekkoSSLConfig;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.scaladsl.DeprecatedSslContextParameters$;
import org.apache.pekko.http.scaladsl.HttpConnectionContext$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.stream.TLSClientAuth;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ConnectionContext$
implements Serializable {
    public static final ConnectionContext$ MODULE$ = new ConnectionContext$();

    private ConnectionContext$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConnectionContext$.class);
    }

    public HttpsConnectionContext httpsServer(SSLContext sslContext) {
        return this.httpsServer((Function0<SSLEngine> & Serializable)() -> {
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            return engine;
        });
    }

    @ApiMayChange
    public HttpsConnectionContext httpsServer(Function0<SSLEngine> createSSLEngine) {
        return new HttpsConnectionContext(package$.MODULE$.Right().apply((Function1<Option, SSLEngine> & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return (SSLEngine)createSSLEngine.apply();
            }
            if (option instanceof Some) {
                throw new IllegalArgumentException("host and port supplied for connection based on server connection context");
            }
            throw new MatchError(option);
        }));
    }

    public HttpsConnectionContext httpsClient(SSLContext context) {
        return this.httpsClient((Function2<String, Object, SSLEngine>)(Function2<Object, Object, SSLEngine> & Serializable)(host, port) -> this.httpsClient$$anonfun$1(context, (String)host, BoxesRunTime.unboxToInt(port)));
    }

    @ApiMayChange
    public HttpsConnectionContext httpsClient(Function2<String, Object, SSLEngine> createSSLEngine) {
        return new HttpsConnectionContext(package$.MODULE$.Right().apply((Function1<Option, SSLEngine> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException("host and port missing for connection based on client connection context");
            }
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                String host = (String)tuple2._1();
                int port = BoxesRunTime.unboxToInt(tuple2._2());
                return (SSLEngine)createSSLEngine.apply(host, BoxesRunTime.boxToInteger(port));
            }
            throw new MatchError(option);
        }));
    }

    public HttpsConnectionContext https(SSLContext sslContext, Option<PekkoSSLConfig> sslConfig, Option<Seq<String>> enabledCipherSuites, Option<Seq<String>> enabledProtocols, Option<TLSClientAuth> clientAuth, Option<SSLParameters> sslParameters) {
        return new HttpsConnectionContext(package$.MODULE$.Left().apply(DeprecatedSslContextParameters$.MODULE$.apply(sslContext, sslConfig, enabledCipherSuites, enabledProtocols, clientAuth, sslParameters)));
    }

    public Option<PekkoSSLConfig> https$default$2() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> https$default$3() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> https$default$4() {
        return None$.MODULE$;
    }

    public Option<TLSClientAuth> https$default$5() {
        return None$.MODULE$;
    }

    public Option<SSLParameters> https$default$6() {
        return None$.MODULE$;
    }

    public HttpConnectionContext$ noEncryption() {
        return HttpConnectionContext$.MODULE$;
    }

    private final /* synthetic */ SSLEngine httpsClient$$anonfun$1(SSLContext context$1, String host, int port) {
        SSLEngine engine = context$1.createSSLEngine(host, port);
        engine.setUseClientMode(true);
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("https");
        engine.setSSLParameters(params);
        return engine;
    }
}

