/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.impl.engine.client.HttpsProxyGraphStage$;
import org.apache.pekko.http.scaladsl.ClientTransport$;
import org.apache.pekko.http.scaladsl.ClientTransport$ClientTransportWithCustomResolver$;
import org.apache.pekko.http.scaladsl.ClientTransport$HttpsProxyTransport$;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ApiMayChange
public interface ClientTransport {
    public static ClientTransport TCP() {
        return ClientTransport$.MODULE$.TCP();
    }

    public static ClientTransport httpsProxy(ActorSystem actorSystem) {
        return ClientTransport$.MODULE$.httpsProxy(actorSystem);
    }

    public static ClientTransport httpsProxy(HttpCredentials httpCredentials, ActorSystem actorSystem) {
        return ClientTransport$.MODULE$.httpsProxy(httpCredentials, actorSystem);
    }

    public static ClientTransport httpsProxy(InetSocketAddress inetSocketAddress) {
        return ClientTransport$.MODULE$.httpsProxy(inetSocketAddress);
    }

    public static ClientTransport httpsProxy(InetSocketAddress inetSocketAddress, HttpCredentials httpCredentials) {
        return ClientTransport$.MODULE$.httpsProxy(inetSocketAddress, httpCredentials);
    }

    public static ClientTransport withCustomResolver(Function2<String, Object, Future<InetSocketAddress>> function2) {
        return ClientTransport$.MODULE$.withCustomResolver(function2);
    }

    public Flow<ByteString, ByteString, Future<Http.OutgoingConnection>> connectTo(String var1, int var2, ClientConnectionSettings var3, ActorSystem var4);

    public static class ClientTransportWithCustomResolver
    implements ClientTransport,
    Product,
    Serializable {
        private final Function2 lookup;

        public static ClientTransportWithCustomResolver apply(Function2<String, Object, Future<InetSocketAddress>> function2) {
            return ClientTransport$ClientTransportWithCustomResolver$.MODULE$.apply(function2);
        }

        public static ClientTransportWithCustomResolver fromProduct(Product product) {
            return ClientTransport$ClientTransportWithCustomResolver$.MODULE$.fromProduct(product);
        }

        public static ClientTransportWithCustomResolver unapply(ClientTransportWithCustomResolver clientTransportWithCustomResolver) {
            return ClientTransport$ClientTransportWithCustomResolver$.MODULE$.unapply(clientTransportWithCustomResolver);
        }

        public ClientTransportWithCustomResolver(Function2<String, Object, Future<InetSocketAddress>> lookup) {
            this.lookup = lookup;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClientTransportWithCustomResolver)) return false;
            ClientTransportWithCustomResolver clientTransportWithCustomResolver = (ClientTransportWithCustomResolver)object;
            Function2<String, Object, Future<InetSocketAddress>> function2 = this.lookup();
            Function2<String, Object, Future<InetSocketAddress>> function22 = clientTransportWithCustomResolver.lookup();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            if (!clientTransportWithCustomResolver.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ClientTransportWithCustomResolver;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "ClientTransportWithCustomResolver";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lookup";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Function2<String, Object, Future<InetSocketAddress>> lookup() {
            return this.lookup;
        }

        @Override
        public Flow<ByteString, ByteString, Future<Http.OutgoingConnection>> connectTo(String host, int port, ClientConnectionSettings settings, ActorSystem system) {
            ExecutionContextExecutor ec = system.dispatcher();
            return this.initFutureFlow((Function0<Future> & Serializable)() -> this.lookup().apply(host, BoxesRunTime.boxToInteger(port)).map((Function1<InetSocketAddress, Flow> & Serializable)address -> ClientTransport$.MODULE$.org$apache$pekko$http$scaladsl$ClientTransport$$$connectToAddress((InetSocketAddress)address, settings, system), ec), ec).mapMaterializedValue((Function1<Future, Future> & Serializable)_$4 -> _$4.flatten($less$colon$less$.MODULE$.refl()));
        }

        private <M> Flow<ByteString, ByteString, Future<M>> initFutureFlow(Function0<Future<Flow<ByteString, ByteString, M>>> flowFactory, ExecutionContext ec) {
            return ((Flow)Flow$.MODULE$.apply().prepend(Source$.MODULE$.single(ByteString$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapByteArray(new byte[0]))))).viaMat((Graph)((Object)((Flow)Flow$.MODULE$.lazyInitAsync(flowFactory).mapMaterializedValue((Function1<Future, Future> & Serializable)_$5 -> _$5.map((Function1<Option, Object> & Serializable)_$6 -> _$6.get(), ec))).buffer(1, OverflowStrategy$.MODULE$.backpressure())), Keep$.MODULE$.right());
        }

        public ClientTransportWithCustomResolver copy(Function2<String, Object, Future<InetSocketAddress>> lookup) {
            return new ClientTransportWithCustomResolver(lookup);
        }

        public Function2<String, Object, Future<InetSocketAddress>> copy$default$1() {
            return this.lookup();
        }

        public Function2<String, Object, Future<InetSocketAddress>> _1() {
            return this.lookup();
        }
    }

    public static class HttpsProxyTransport
    implements ClientTransport,
    Product,
    Serializable {
        private final InetSocketAddress proxyAddress;
        private final ClientTransport underlyingTransport;
        private final Option proxyCredentials;

        public static HttpsProxyTransport apply(InetSocketAddress inetSocketAddress, ClientTransport clientTransport, Option<HttpCredentials> option) {
            return ClientTransport$HttpsProxyTransport$.MODULE$.apply(inetSocketAddress, clientTransport, option);
        }

        public static HttpsProxyTransport fromProduct(Product product) {
            return ClientTransport$HttpsProxyTransport$.MODULE$.fromProduct(product);
        }

        public static HttpsProxyTransport unapply(HttpsProxyTransport httpsProxyTransport) {
            return ClientTransport$HttpsProxyTransport$.MODULE$.unapply(httpsProxyTransport);
        }

        public static ClientTransport $lessinit$greater$default$2() {
            return ClientTransport$HttpsProxyTransport$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<HttpCredentials> $lessinit$greater$default$3() {
            return ClientTransport$HttpsProxyTransport$.MODULE$.$lessinit$greater$default$3();
        }

        public HttpsProxyTransport(InetSocketAddress proxyAddress, ClientTransport underlyingTransport, Option<HttpCredentials> proxyCredentials) {
            this.proxyAddress = proxyAddress;
            this.underlyingTransport = underlyingTransport;
            this.proxyCredentials = proxyCredentials;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HttpsProxyTransport)) return false;
            HttpsProxyTransport httpsProxyTransport = (HttpsProxyTransport)object;
            InetSocketAddress inetSocketAddress = this.proxyAddress();
            InetSocketAddress inetSocketAddress2 = httpsProxyTransport.proxyAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            ClientTransport clientTransport = this.underlyingTransport();
            ClientTransport clientTransport2 = httpsProxyTransport.underlyingTransport();
            if (clientTransport == null) {
                if (clientTransport2 != null) {
                    return false;
                }
            } else if (!clientTransport.equals(clientTransport2)) return false;
            Option<HttpCredentials> option = this.proxyCredentials();
            Option<HttpCredentials> option2 = httpsProxyTransport.proxyCredentials();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!httpsProxyTransport.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof HttpsProxyTransport;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "HttpsProxyTransport";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "proxyAddress";
                }
                case 1: {
                    return "underlyingTransport";
                }
                case 2: {
                    return "proxyCredentials";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public InetSocketAddress proxyAddress() {
            return this.proxyAddress;
        }

        public ClientTransport underlyingTransport() {
            return this.underlyingTransport;
        }

        public Option<HttpCredentials> proxyCredentials() {
            return this.proxyCredentials;
        }

        public HttpsProxyTransport(InetSocketAddress proxyAddress, ClientTransport underlyingTransport) {
            this(proxyAddress, underlyingTransport, None$.MODULE$);
        }

        @Override
        public Flow<ByteString, ByteString, Future<Http.OutgoingConnection>> connectTo(String host, int port, ClientConnectionSettings settings, ActorSystem system) {
            return HttpsProxyGraphStage$.MODULE$.apply(host, port, settings, this.proxyCredentials()).joinMat(this.underlyingTransport().connectTo(this.proxyAddress().getHostString(), this.proxyAddress().getPort(), settings, system), Keep$.MODULE$.right()).mapMaterializedValue((Function1<Future, Future> & Serializable)_$2 -> _$2.map((Function1<Http.OutgoingConnection, Http.OutgoingConnection> & Serializable)_$3 -> {
                InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(host, port);
                InetSocketAddress inetSocketAddress2 = _$3.copy$default$1();
                return _$3.copy(inetSocketAddress2, inetSocketAddress);
            }, system.dispatcher()));
        }

        public HttpsProxyTransport copy(InetSocketAddress proxyAddress, ClientTransport underlyingTransport, Option<HttpCredentials> proxyCredentials) {
            return new HttpsProxyTransport(proxyAddress, underlyingTransport, proxyCredentials);
        }

        public InetSocketAddress copy$default$1() {
            return this.proxyAddress();
        }

        public ClientTransport copy$default$2() {
            return this.underlyingTransport();
        }

        public Option<HttpCredentials> copy$default$3() {
            return this.proxyCredentials();
        }

        public InetSocketAddress _1() {
            return this.proxyAddress();
        }

        public ClientTransport _2() {
            return this.underlyingTransport();
        }

        public Option<HttpCredentials> _3() {
            return this.proxyCredentials();
        }
    }
}

