/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.settings;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.List;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.http.impl.settings.ConnectionPoolSettingsImpl;
import org.apache.pekko.http.impl.settings.ConnectionPoolSettingsImpl$;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$ClientConnectionSettings$;
import org.apache.pekko.http.impl.util.JavaMapping$ClientTransport$;
import org.apache.pekko.http.impl.util.JavaMapping$ConnectionPoolSettings$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.javadsl.ClientTransport;
import org.apache.pekko.http.javadsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.javadsl.settings.ConnectionPoolSettings$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$ScalaDurationOps$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.util.matching.Regex;

@DoNotInherit
public abstract class ConnectionPoolSettings {
    public static ConnectionPoolSettings create(ActorSystem actorSystem) {
        return ConnectionPoolSettings$.MODULE$.create(actorSystem);
    }

    public static /* synthetic */ Object create(ActorSystem actorSystem) {
        return ConnectionPoolSettings$.MODULE$.create(actorSystem);
    }

    public static ConnectionPoolSettings create(Config config) {
        return ConnectionPoolSettings$.MODULE$.create(config);
    }

    public static ConnectionPoolSettings create(String string2) {
        return ConnectionPoolSettings$.MODULE$.create(string2);
    }

    public int getMaxConnections() {
        return ((ConnectionPoolSettingsImpl)this).maxConnections();
    }

    public int getMinConnections() {
        return ((ConnectionPoolSettingsImpl)this).minConnections();
    }

    public int getMaxRetries() {
        return ((ConnectionPoolSettingsImpl)this).maxRetries();
    }

    public int getMaxOpenRequests() {
        return ((ConnectionPoolSettingsImpl)this).maxOpenRequests();
    }

    public int getPipeliningLimit() {
        return ((ConnectionPoolSettingsImpl)this).pipeliningLimit();
    }

    public java.time.Duration getMaxConnectionLifetime() {
        return JavaDurationConverters$ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps(((ConnectionPoolSettingsImpl)this).maxConnectionLifetime()));
    }

    public FiniteDuration getBaseConnectionBackoff() {
        return ((ConnectionPoolSettingsImpl)this).baseConnectionBackoff();
    }

    public FiniteDuration getMaxConnectionBackoff() {
        return ((ConnectionPoolSettingsImpl)this).maxConnectionBackoff();
    }

    public Duration getIdleTimeout() {
        return ((ConnectionPoolSettingsImpl)this).idleTimeout();
    }

    public Duration getKeepAliveTimeout() {
        return ((ConnectionPoolSettingsImpl)this).keepAliveTimeout();
    }

    public ClientConnectionSettings getConnectionSettings() {
        return ((ConnectionPoolSettingsImpl)this).connectionSettings();
    }

    @ApiMayChange
    public Duration getResponseEntitySubscriptionTimeout() {
        return ((ConnectionPoolSettingsImpl)this).responseEntitySubscriptionTimeout();
    }

    @ApiMayChange
    public ConnectionPoolSettings withHostOverrides(List<Tuple2<String, ConnectionPoolSettings>> hostOverrides) {
        Object object = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(hostOverrides).asScala()).toList().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String h = (String)tuple2._1();
                ConnectionPoolSettings s2 = (ConnectionPoolSettings)tuple2._2();
                Regex regex = Predef$.MODULE$.ArrowAssoc(ConnectionPoolSettingsImpl$.MODULE$.hostRegex(h));
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(regex, JavaMapping$Implicits$.MODULE$.AddAsScala(s2, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ConnectionPoolSettings$.MODULE$)).asScala());
            }
            throw new MatchError(tuple2);
        });
        int n = ((ConnectionPoolSettingsImpl)this).copy$default$1();
        int n2 = ((ConnectionPoolSettingsImpl)this).copy$default$2();
        int n3 = ((ConnectionPoolSettingsImpl)this).copy$default$3();
        int n4 = ((ConnectionPoolSettingsImpl)this).copy$default$4();
        int n5 = ((ConnectionPoolSettingsImpl)this).copy$default$5();
        Duration duration = ((ConnectionPoolSettingsImpl)this).copy$default$6();
        FiniteDuration finiteDuration = ((ConnectionPoolSettingsImpl)this).copy$default$7();
        FiniteDuration finiteDuration2 = ((ConnectionPoolSettingsImpl)this).copy$default$8();
        Duration duration2 = ((ConnectionPoolSettingsImpl)this).copy$default$9();
        Duration duration3 = ((ConnectionPoolSettingsImpl)this).copy$default$10();
        org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings clientConnectionSettings = ((ConnectionPoolSettingsImpl)this).copy$default$11();
        Duration duration4 = ((ConnectionPoolSettingsImpl)this).copy$default$12();
        return ((ConnectionPoolSettingsImpl)this).copy(n, n2, n3, n4, n5, duration, finiteDuration, finiteDuration2, duration2, duration3, clientConnectionSettings, duration4, (Seq<Tuple2<Regex, org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings>>)object);
    }

    @ApiMayChange
    public ConnectionPoolSettings appendHostOverride(String hostPattern, ConnectionPoolSettings settings) {
        Regex regex = Predef$.MODULE$.ArrowAssoc(ConnectionPoolSettingsImpl$.MODULE$.hostRegex(hostPattern));
        Seq seq = (Seq)((ConnectionPoolSettingsImpl)this).hostOverrides().$colon$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(regex, JavaMapping$Implicits$.MODULE$.AddAsScala(settings, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ConnectionPoolSettings$.MODULE$)).asScala()));
        int n = ((ConnectionPoolSettingsImpl)this).copy$default$1();
        int n2 = ((ConnectionPoolSettingsImpl)this).copy$default$2();
        int n3 = ((ConnectionPoolSettingsImpl)this).copy$default$3();
        int n4 = ((ConnectionPoolSettingsImpl)this).copy$default$4();
        int n5 = ((ConnectionPoolSettingsImpl)this).copy$default$5();
        Duration duration = ((ConnectionPoolSettingsImpl)this).copy$default$6();
        FiniteDuration finiteDuration = ((ConnectionPoolSettingsImpl)this).copy$default$7();
        FiniteDuration finiteDuration2 = ((ConnectionPoolSettingsImpl)this).copy$default$8();
        Duration duration2 = ((ConnectionPoolSettingsImpl)this).copy$default$9();
        Duration duration3 = ((ConnectionPoolSettingsImpl)this).copy$default$10();
        org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings clientConnectionSettings = ((ConnectionPoolSettingsImpl)this).copy$default$11();
        Duration duration4 = ((ConnectionPoolSettingsImpl)this).copy$default$12();
        return ((ConnectionPoolSettingsImpl)this).copy(n, n2, n3, n4, n5, duration, finiteDuration, finiteDuration2, duration2, duration3, clientConnectionSettings, duration4, seq);
    }

    public abstract ConnectionPoolSettings withMaxConnections(int var1);

    public abstract ConnectionPoolSettings withMinConnections(int var1);

    public abstract ConnectionPoolSettings withMaxRetries(int var1);

    public abstract ConnectionPoolSettings withMaxOpenRequests(int var1);

    public abstract ConnectionPoolSettings withPipeliningLimit(int var1);

    public abstract ConnectionPoolSettings withBaseConnectionBackoff(FiniteDuration var1);

    public abstract ConnectionPoolSettings withMaxConnectionBackoff(FiniteDuration var1);

    public abstract ConnectionPoolSettings withIdleTimeout(Duration var1);

    public abstract ConnectionPoolSettings withKeepAliveTimeout(Duration var1);

    public abstract ConnectionPoolSettings withMaxConnectionLifetime(Duration var1);

    public ConnectionPoolSettings withConnectionSettings(ClientConnectionSettings newValue) {
        Function1<org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings, org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings> & Serializable intersect = (Function1<org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings, org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings> & Serializable)_$1 -> _$1.withConnectionSettings((org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings)JavaMapping$Implicits$.MODULE$.AddAsScala(newValue, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ClientConnectionSettings$.MODULE$)).asScala());
        org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings clientConnectionSettings = (org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings)JavaMapping$Implicits$.MODULE$.AddAsScala(newValue, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ClientConnectionSettings$.MODULE$)).asScala();
        int n = ((ConnectionPoolSettingsImpl)this).copyDeep$default$2();
        int n2 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$3();
        int n3 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$4();
        int n4 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$5();
        int n5 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$6();
        Duration duration = ((ConnectionPoolSettingsImpl)this).copyDeep$default$7();
        FiniteDuration finiteDuration = ((ConnectionPoolSettingsImpl)this).copyDeep$default$8();
        FiniteDuration finiteDuration2 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$9();
        Duration duration2 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$10();
        Duration duration3 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$11();
        Duration duration4 = ((ConnectionPoolSettingsImpl)this).copyDeep$default$13();
        return ((ConnectionPoolSettingsImpl)this).copyDeep(intersect, n, n2, n3, n4, n5, duration, finiteDuration, finiteDuration2, duration2, duration3, clientConnectionSettings, duration4);
    }

    @ApiMayChange
    public abstract ConnectionPoolSettings withResponseEntitySubscriptionTimeout(Duration var1);

    public ConnectionPoolSettings withTransport(ClientTransport newValue) {
        return ((ConnectionPoolSettingsImpl)this).withUpdatedConnectionSettings((Function1<org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings, org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings> & Serializable)_$2 -> _$2.withTransport((org.apache.pekko.http.scaladsl.ClientTransport)JavaMapping$Implicits$.MODULE$.AddAsScala(newValue, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ClientTransport$.MODULE$)).asScala()));
    }
}

