/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.model;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.pekko.http.impl.model.JavaQuery;
import org.apache.pekko.http.impl.model.UriJavaAccessor;
import org.apache.pekko.http.javadsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.japi.Pair;
import org.parboiled2.CharPredicate;
import org.parboiled2.ParserInput$;

public abstract class Query {
    public static final Query EMPTY = new JavaQuery(UriJavaAccessor.emptyQuery());

    public abstract Optional<String> get(String var1);

    public abstract String getOrElse(String var1, String var2);

    public abstract List<String> getAll(String var1);

    public abstract List<Pair<String, String>> toList();

    public abstract Map<String, String> toMap();

    public abstract Map<String, List<String>> toMultiMap();

    public abstract Query withParam(String var1, String var2);

    public abstract String render(HttpCharset var1);

    public abstract String render(HttpCharset var1, CharPredicate var2);

    public static Query create(String string2) {
        return new JavaQuery(Uri$Query$.MODULE$.apply(string2));
    }

    public static Query create(String string2, Uri.ParsingMode parsingMode) {
        return new JavaQuery(UriJavaAccessor.queryApply(string2, parsingMode));
    }

    public static Query create(String string2, Charset charset, Uri.ParsingMode parsingMode) {
        return new JavaQuery(Uri$Query$.MODULE$.apply(ParserInput$.MODULE$.apply(string2), charset, parsingMode));
    }

    @SafeVarargs
    public static Query create(Pair<String, String> ... pairArray) {
        return new JavaQuery(UriJavaAccessor.queryApply(pairArray));
    }

    public static Query create(Iterable<Pair<String, String>> iterable) {
        Pair[] pairArray = (Pair[])StreamSupport.stream(iterable.spliterator(), false).toArray(Pair[]::new);
        return Query.create(pairArray);
    }

    public static Query create(Map<String, String> map) {
        return new JavaQuery(UriJavaAccessor.queryApply(map));
    }
}

