/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$ConnectionContext$;
import org.apache.pekko.http.impl.util.JavaMapping$HttpResponse$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.JavaMapping$ServerSettings$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.javadsl.HandlerProvider;
import org.apache.pekko.http.javadsl.HttpsConnectionContext;
import org.apache.pekko.http.javadsl.IncomingConnection;
import org.apache.pekko.http.javadsl.ServerBinding;
import org.apache.pekko.http.javadsl.ServerBuilder$;
import org.apache.pekko.http.javadsl.ServerBuilder$Impl$;
import org.apache.pekko.http.javadsl.model.HttpRequest;
import org.apache.pekko.http.javadsl.model.HttpResponse;
import org.apache.pekko.http.javadsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$CompletionStageOps$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import scala.Function1;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface ServerBuilder {
    public static ServerBuilder apply(String string2, int n, ClassicActorSystemProvider classicActorSystemProvider) {
        return ServerBuilder$.MODULE$.apply(string2, n, classicActorSystemProvider);
    }

    public ServerBuilder onInterface(String var1);

    public ServerBuilder onPort(int var1);

    public ServerBuilder logTo(LoggingAdapter var1);

    public ServerBuilder withSettings(ServerSettings var1);

    public ServerBuilder adaptSettings(Function<ServerSettings, ServerSettings> var1);

    public ServerBuilder enableHttps(HttpsConnectionContext var1);

    public ServerBuilder withMaterializer(Materializer var1);

    public CompletionStage<ServerBinding> bind(Function<HttpRequest, CompletionStage<HttpResponse>> var1);

    public CompletionStage<ServerBinding> bind(HandlerProvider var1);

    public CompletionStage<ServerBinding> bindSync(Function<HttpRequest, HttpResponse> var1);

    public CompletionStage<ServerBinding> bindFlow(Flow<HttpRequest, HttpResponse, ?> var1);

    public Source<IncomingConnection, CompletionStage<ServerBinding>> connectionSource();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Impl
    implements ServerBuilder,
    Product,
    Serializable {
        private final String interface;
        private final int port;
        private final ConnectionContext context;
        private final LoggingAdapter log;
        private final ServerSettings settings;
        private final ClassicActorSystemProvider system;
        private final Materializer materializer;

        public static Impl apply(String string2, int n, ConnectionContext connectionContext, LoggingAdapter loggingAdapter, ServerSettings serverSettings, ClassicActorSystemProvider classicActorSystemProvider, Materializer materializer) {
            return ServerBuilder$Impl$.MODULE$.apply(string2, n, connectionContext, loggingAdapter, serverSettings, classicActorSystemProvider, materializer);
        }

        public static Impl fromProduct(Product product) {
            return ServerBuilder$Impl$.MODULE$.fromProduct(product);
        }

        public static Impl unapply(Impl impl) {
            return ServerBuilder$Impl$.MODULE$.unapply(impl);
        }

        public Impl(String string2, int port, ConnectionContext context, LoggingAdapter log, ServerSettings settings, ClassicActorSystemProvider system, Materializer materializer) {
            this.interface = string2;
            this.port = port;
            this.context = context;
            this.log = log;
            this.settings = settings;
            this.system = system;
            this.materializer = materializer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.interface()));
            n = Statics.mix(n, this.port());
            n = Statics.mix(n, Statics.anyHash(this.context()));
            n = Statics.mix(n, Statics.anyHash(this.log()));
            n = Statics.mix(n, Statics.anyHash(this.settings()));
            n = Statics.mix(n, Statics.anyHash(this.system()));
            n = Statics.mix(n, Statics.anyHash(this.materializer()));
            return Statics.finalizeHash(n, 7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Impl)) return false;
            Impl impl = (Impl)object;
            if (this.port() != impl.port()) return false;
            String string2 = this.interface();
            String string3 = impl.interface();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            ConnectionContext connectionContext = this.context();
            ConnectionContext connectionContext2 = impl.context();
            if (connectionContext == null) {
                if (connectionContext2 != null) {
                    return false;
                }
            } else if (!connectionContext.equals(connectionContext2)) return false;
            LoggingAdapter loggingAdapter = this.log();
            LoggingAdapter loggingAdapter2 = impl.log();
            if (loggingAdapter == null) {
                if (loggingAdapter2 != null) {
                    return false;
                }
            } else if (!loggingAdapter.equals(loggingAdapter2)) return false;
            ServerSettings serverSettings = this.settings();
            ServerSettings serverSettings2 = impl.settings();
            if (serverSettings == null) {
                if (serverSettings2 != null) {
                    return false;
                }
            } else if (!serverSettings.equals(serverSettings2)) return false;
            ClassicActorSystemProvider classicActorSystemProvider = this.system();
            ClassicActorSystemProvider classicActorSystemProvider2 = impl.system();
            if (classicActorSystemProvider == null) {
                if (classicActorSystemProvider2 != null) {
                    return false;
                }
            } else if (!classicActorSystemProvider.equals(classicActorSystemProvider2)) return false;
            Materializer materializer = this.materializer();
            Materializer materializer2 = impl.materializer();
            if (materializer == null) {
                if (materializer2 != null) {
                    return false;
                }
            } else if (!materializer.equals(materializer2)) return false;
            if (!impl.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Impl;
        }

        @Override
        public int productArity() {
            return 7;
        }

        @Override
        public String productPrefix() {
            return "Impl";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger(this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "interface";
                }
                case 1: {
                    return "port";
                }
                case 2: {
                    return "context";
                }
                case 3: {
                    return "log";
                }
                case 4: {
                    return "settings";
                }
                case 5: {
                    return "system";
                }
                case 6: {
                    return "materializer";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String interface() {
            return this.interface;
        }

        public int port() {
            return this.port;
        }

        public ConnectionContext context() {
            return this.context;
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public ServerSettings settings() {
            return this.settings;
        }

        public ClassicActorSystemProvider system() {
            return this.system;
        }

        public Materializer materializer() {
            return this.materializer;
        }

        private ExecutionContext executionContext() {
            return this.system().classicSystem().dispatcher();
        }

        private HttpExt http() {
            return Http$.MODULE$.apply(this.system().classicSystem());
        }

        @Override
        public ServerBuilder onInterface(String newInterface) {
            return this.copy(newInterface, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder onPort(int newPort) {
            return this.copy(this.copy$default$1(), newPort, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder logTo(LoggingAdapter newLog) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newLog, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder withSettings(ServerSettings newSettings) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), newSettings, this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder adaptSettings(Function<ServerSettings, ServerSettings> f) {
            ServerSettings serverSettings = f.apply(this.settings());
            String string2 = this.copy$default$1();
            int n = this.copy$default$2();
            ConnectionContext connectionContext = this.copy$default$3();
            LoggingAdapter loggingAdapter = this.copy$default$4();
            ClassicActorSystemProvider classicActorSystemProvider = this.copy$default$6();
            Materializer materializer = this.copy$default$7();
            return this.copy(string2, n, connectionContext, loggingAdapter, serverSettings, classicActorSystemProvider, materializer);
        }

        @Override
        public ServerBuilder enableHttps(HttpsConnectionContext newContext) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newContext, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder withMaterializer(Materializer newMaterializer) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), newMaterializer);
        }

        @Override
        public CompletionStage<ServerBinding> bind(Function<HttpRequest, CompletionStage<HttpResponse>> handler) {
            Future future = FutureConverters$.MODULE$.FutureOps(this.http().bindAndHandleAsyncImpl((Function1<org.apache.pekko.http.scaladsl.model.HttpRequest, Future<org.apache.pekko.http.scaladsl.model.HttpResponse>>)(Function1<org.apache.pekko.http.scaladsl.model.HttpRequest, Future> & Serializable)_$1 -> {
                CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)handler.apply((HttpRequest)_$1));
                return FutureConverters$CompletionStageOps$.MODULE$.asScala$extension(completionStage).map((Function1<HttpResponse, org.apache.pekko.http.scaladsl.model.HttpResponse> & Serializable)_$2 -> (org.apache.pekko.http.scaladsl.model.HttpResponse)JavaMapping$Implicits$.MODULE$.AddAsScala(_$2, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$HttpResponse$.MODULE$)).asScala(), this.executionContext());
            }, this.interface(), this.port(), (org.apache.pekko.http.scaladsl.ConnectionContext)JavaMapping$Implicits$.MODULE$.AddAsScala(this.context(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ConnectionContext$.MODULE$)).asScala(), (org.apache.pekko.http.scaladsl.settings.ServerSettings)JavaMapping$Implicits$.MODULE$.AddAsScala(this.settings(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ServerSettings$.MODULE$)).asScala(), 0, this.log(), this.materializer()).map((Function1<Http.ServerBinding, ServerBinding> & Serializable)_$3 -> new ServerBinding((Http.ServerBinding)_$3), this.executionContext()));
            return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
        }

        @Override
        public CompletionStage<ServerBinding> bind(HandlerProvider handlerProvider) {
            return this.bind(handlerProvider.handler(this.system()));
        }

        @Override
        public CompletionStage<ServerBinding> bindSync(Function<HttpRequest, HttpResponse> handler) {
            Future future = FutureConverters$.MODULE$.FutureOps(this.http().bindAndHandleAsyncImpl((Function1<org.apache.pekko.http.scaladsl.model.HttpRequest, Future<org.apache.pekko.http.scaladsl.model.HttpResponse>>)(Function1<org.apache.pekko.http.scaladsl.model.HttpRequest, Future> & Serializable)req -> FastFuture$.MODULE$.successful().apply(JavaMapping$Implicits$.MODULE$.AddAsScala(handler.apply((HttpRequest)req), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$HttpResponse$.MODULE$)).asScala()), this.interface(), this.port(), (org.apache.pekko.http.scaladsl.ConnectionContext)JavaMapping$Implicits$.MODULE$.AddAsScala(this.context(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ConnectionContext$.MODULE$)).asScala(), (org.apache.pekko.http.scaladsl.settings.ServerSettings)JavaMapping$Implicits$.MODULE$.AddAsScala(this.settings(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ServerSettings$.MODULE$)).asScala(), 0, this.log(), this.materializer()).map((Function1<Http.ServerBinding, ServerBinding> & Serializable)_$4 -> new ServerBinding((Http.ServerBinding)_$4), this.executionContext()));
            return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
        }

        @Override
        public CompletionStage<ServerBinding> bindFlow(Flow<HttpRequest, HttpResponse, ?> handlerFlow) {
            Future future = FutureConverters$.MODULE$.FutureOps(this.http().bindAndHandleImpl(handlerFlow.asScala(), this.interface(), this.port(), (org.apache.pekko.http.scaladsl.ConnectionContext)JavaMapping$Implicits$.MODULE$.AddAsScala(this.context(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ConnectionContext$.MODULE$)).asScala(), (org.apache.pekko.http.scaladsl.settings.ServerSettings)JavaMapping$Implicits$.MODULE$.AddAsScala(this.settings(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ServerSettings$.MODULE$)).asScala(), this.log(), this.materializer()).map((Function1<Http.ServerBinding, ServerBinding> & Serializable)_$5 -> new ServerBinding((Http.ServerBinding)_$5), this.executionContext()));
            return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
        }

        @Override
        public Source<IncomingConnection, CompletionStage<ServerBinding>> connectionSource() {
            return ((org.apache.pekko.stream.scaladsl.Source)((org.apache.pekko.stream.scaladsl.Source)this.http().bindImpl(this.interface(), this.port(), (org.apache.pekko.http.scaladsl.ConnectionContext)JavaMapping$Implicits$.MODULE$.AddAsScala(this.context(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ConnectionContext$.MODULE$)).asScala(), (org.apache.pekko.http.scaladsl.settings.ServerSettings)JavaMapping$Implicits$.MODULE$.AddAsScala(this.settings(), J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ServerSettings$.MODULE$)).asScala(), this.log()).map((Function1<Http.IncomingConnection, IncomingConnection> & Serializable)_$6 -> new IncomingConnection((Http.IncomingConnection)_$6))).mapMaterializedValue((Function1<Future, CompletionStage> & Serializable)_$7 -> {
                Future future = FutureConverters$.MODULE$.FutureOps(_$7.map((Function1<Http.ServerBinding, ServerBinding> & Serializable)_$8 -> new ServerBinding((Http.ServerBinding)_$8), ExecutionContexts$.MODULE$.parasitic()));
                return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
            })).asJava();
        }

        public Impl copy(String string2, int port, ConnectionContext context, LoggingAdapter log, ServerSettings settings, ClassicActorSystemProvider system, Materializer materializer) {
            return new Impl(string2, port, context, log, settings, system, materializer);
        }

        public String copy$default$1() {
            return this.interface();
        }

        public int copy$default$2() {
            return this.port();
        }

        public ConnectionContext copy$default$3() {
            return this.context();
        }

        public LoggingAdapter copy$default$4() {
            return this.log();
        }

        public ServerSettings copy$default$5() {
            return this.settings();
        }

        public ClassicActorSystemProvider copy$default$6() {
            return this.system();
        }

        public Materializer copy$default$7() {
            return this.materializer();
        }

        public String _1() {
            return this.interface();
        }

        public int _2() {
            return this.port();
        }

        public ConnectionContext _3() {
            return this.context();
        }

        public LoggingAdapter _4() {
            return this.log();
        }

        public ServerSettings _5() {
            return this.settings();
        }

        public ClassicActorSystemProvider _6() {
            return this.system();
        }

        public Materializer _7() {
            return this.materializer();
        }
    }
}

