/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.http.impl.util.ExposeAttributes$;
import org.apache.pekko.http.impl.util.StreamUtils;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.impl.util.StreamUtils$$anon$8$;
import org.apache.pekko.http.impl.util.StreamUtils$$anon$8$$anon$9$DeliveringData$;
import org.apache.pekko.http.impl.util.StreamUtils$$anon$8$$anon$9$WaitingForData$;
import org.apache.pekko.http.impl.util.StreamUtils$CaptureMaterializationAndTerminationOp$;
import org.apache.pekko.http.impl.util.StreamUtils$CaptureTerminationOp$;
import org.apache.pekko.http.impl.util.StreamUtils$OneTimeValve$;
import org.apache.pekko.http.impl.util.StreamUtils$StreamControl$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.KillSwitch;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class StreamUtils$
implements Serializable {
    public static final StreamUtils$OneTimeValve$ OneTimeValve;
    private static final Source<Nothing$, NotUsed> EmptySource;
    private static final Materializer OnlyRunInGraphInterpreterContext;
    public static final StreamUtils$StreamControl$ StreamControl;
    public static final Future<BoxedUnit> org$apache$pekko$http$impl$util$StreamUtils$$$successfulDone;
    public static final StreamUtils$CaptureMaterializationAndTerminationOp$ CaptureMaterializationAndTerminationOp;
    public static final StreamUtils$CaptureTerminationOp$ CaptureTerminationOp;
    public static final StreamUtils$ MODULE$;

    private StreamUtils$() {
    }

    static {
        MODULE$ = new StreamUtils$();
        EmptySource = Source$.MODULE$.empty();
        OnlyRunInGraphInterpreterContext = null;
        org$apache$pekko$http$impl$util$StreamUtils$$$successfulDone = Future$.MODULE$.successful(BoxedUnit.UNIT);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StreamUtils$.class);
    }

    public GraphStage<FlowShape<ByteString, ByteString>> byteStringTransformer(Function1<ByteString, ByteString> f, Function0<ByteString> finish) {
        return new GraphStages.SimpleLinearGraphStage<ByteString>(f, finish, this){
            public final Function1 org$apache$pekko$http$impl$util$StreamUtils$$anon$1$$f$1;
            public final Function0 org$apache$pekko$http$impl$util$StreamUtils$$anon$1$$finish$1;
            {
                this.org$apache$pekko$http$impl$util$StreamUtils$$anon$1$$f$1 = f$3;
                this.org$apache$pekko$http$impl$util$StreamUtils$$anon$1$$finish$1 = finish$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public void onPush() {
                        ByteString data = (ByteString)this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$1$$f$1.apply(this.grab(this.$outer.in()));
                        if (data.nonEmpty()) {
                            this.push(this.$outer.out(), data);
                            return;
                        }
                        this.pull(this.$outer.in());
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFinish() {
                        ByteString data = (ByteString)this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$1$$finish$1.apply();
                        if (data.nonEmpty()) {
                            this.emit(this.$outer.out(), data);
                        }
                        this.completeStage();
                    }
                };
            }
        };
    }

    public <T, Mat> Tuple2<Source<T, Mat>, Future<BoxedUnit>> captureTermination(Source<T, Mat> source) {
        Tuple4<Source<T, Mat>, Future<BoxedUnit>, Future<BoxedUnit>, KillSwitch> tuple4 = this.captureMaterializationTerminationAndKillSwitch(source);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Source<T, Mat> newSource = tuple4._1();
        Future<BoxedUnit> termination = tuple4._2();
        Tuple2<Source<T, Mat>, Future<BoxedUnit>> tuple2 = Tuple2$.MODULE$.apply(newSource, termination);
        Source<T, Mat> newSource2 = tuple2._1();
        Future<BoxedUnit> termination2 = tuple2._2();
        return Tuple2$.MODULE$.apply(newSource2, termination2);
    }

    public <T, Mat> Tuple4<Source<T, Mat>, Future<BoxedUnit>, Future<BoxedUnit>, KillSwitch> captureMaterializationTerminationAndKillSwitch(Source<T, Mat> source) {
        Promise terminationPromise = Promise$.MODULE$.apply();
        Promise materializationPromise = Promise$.MODULE$.apply();
        Promise killResult = Promise$.MODULE$.apply();
        KillSwitch killSwitch = new KillSwitch(killResult){
            private final Promise killResult$1;
            {
                this.killResult$1 = killResult$3;
            }

            public void shutdown() {
                this.killResult$1.trySuccess(BoxedUnit.UNIT);
            }

            public void abort(Throwable ex) {
                this.killResult$1.tryFailure(ex);
            }
        };
        GraphStages.SimpleLinearGraphStage transformer = new GraphStages.SimpleLinearGraphStage<T>(materializationPromise, killResult, terminationPromise){
            public final Promise org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$materializationPromise$1;
            public final Promise org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$killResult$2;
            public final Promise org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$terminationPromise$1;
            {
                this.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$materializationPromise$1 = materializationPromise$2;
                this.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$killResult$2 = killResult$4;
                this.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$terminationPromise$1 = terminationPromise$2;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private final AsyncCallback killCallback;
                    private final /* synthetic */ anon.4 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.setHandlers($outer.in(), $outer.out(), this);
                        this.killCallback = this.getAsyncCallback(result -> this.handleKill((Try)result));
                    }

                    public void preStart() {
                        this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$materializationPromise$1.trySuccess(BoxedUnit.UNIT);
                        Option<Try<T>> option = this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$killResult$2.future().value();
                        if (option instanceof Some) {
                            Try res = (Try)((Some)option).value();
                            this.handleKill(res);
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$killResult$2.future().onComplete(t -> this.killCallback.invoke(t), ExecutionContexts$.MODULE$.parasitic());
                            return;
                        }
                        throw new MatchError(option);
                    }

                    public void onPush() {
                        this.push(this.$outer.out(), this.grab(this.$outer.in()));
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFailure(Throwable ex) {
                        this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$terminationPromise$1.tryFailure(ex);
                        this.failStage(ex);
                    }

                    public void postStop() {
                        this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$4$$terminationPromise$1.trySuccess(BoxedUnit.UNIT);
                    }

                    public void handleKill(Try result) {
                        Try try_ = result;
                        if (try_ instanceof Success) {
                            this.completeStage();
                            return;
                        }
                        if (try_ instanceof Failure) {
                            Throwable ex = ((Failure)try_).exception();
                            this.failStage(ex);
                            return;
                        }
                        throw new MatchError(try_);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$1(scala.util.Try ), preStart$$anonfun$1(scala.util.Try )}, serializedLambda);
                    }
                };
            }
        };
        return Tuple4$.MODULE$.apply(source.via((Graph)transformer), terminationPromise.future(), materializationPromise.future(), killSwitch);
    }

    public Flow<ByteString, ByteString, NotUsed> sliceBytesTransformer(long start, long length) {
        GraphStages.SimpleLinearGraphStage<ByteString> transformer = new GraphStages.SimpleLinearGraphStage<ByteString>(start, length){
            private final long start$1;
            private final long length$1;
            {
                this.start$1 = start$3;
                this.length$1 = length$3;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this.start$1, this.length$1, this){
                    private long toSkip;
                    private long remaining;
                    private final /* synthetic */ anon.6 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.toSkip = start$2;
                        this.remaining = length$2;
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    public long toSkip() {
                        return this.toSkip;
                    }

                    public void toSkip_$eq(long x$1) {
                        this.toSkip = x$1;
                    }

                    public long remaining() {
                        return this.remaining;
                    }

                    public void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        ByteString element = (ByteString)this.grab(this.$outer.in());
                        if (this.toSkip() >= (long)element.length()) {
                            this.pull(this.$outer.in());
                        } else {
                            ByteString data = element.drop((int)this.toSkip()).take((int)package$.MODULE$.min(this.remaining(), Integer.MAX_VALUE));
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.push(this.$outer.out(), data);
                            if (this.remaining() <= 0L) {
                                this.completeStage();
                            }
                        }
                        if (this.toSkip() > 0L) {
                            this.toSkip_$eq(this.toSkip() - (long)element.length());
                            return;
                        }
                    }
                };
            }
        };
        return ((Flow)Flow$.MODULE$.apply().via(transformer)).named("sliceBytes");
    }

    public GraphStage<FlowShape<ByteString, ByteString>> limitByteChunksStage(int maxBytesPerChunk) {
        return new GraphStages.SimpleLinearGraphStage<ByteString>(maxBytesPerChunk, this){
            public final int org$apache$pekko$http$impl$util$StreamUtils$$anon$8$$maxBytesPerChunk$1;
            {
                this.org$apache$pekko$http$impl$util$StreamUtils$$anon$8$$maxBytesPerChunk$1 = maxBytesPerChunk$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Attributes initialAttributes() {
                return Attributes$.MODULE$.name("limitByteChunksStage");
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new GraphStageLogic(this){
                    public static final long OFFSET$1;
                    public static final long OFFSET$0;
                    private ByteString remaining;
                    private volatile Object WaitingForData$lzy1;
                    private volatile Object DeliveringData$lzy1;
                    private final /* synthetic */ anon.8 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.remaining = ByteString$.MODULE$.empty();
                        this.setHandlers($outer.in(), $outer.out(), this.WaitingForData());
                    }

                    static {
                        OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(anon$8$$anon$9.class.getDeclaredField("DeliveringData$lzy1"));
                        OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon$8$$anon$9.class.getDeclaredField("WaitingForData$lzy1"));
                    }

                    public ByteString remaining() {
                        return this.remaining;
                    }

                    public void remaining_$eq(ByteString x$1) {
                        this.remaining = x$1;
                    }

                    public void splitAndPush(ByteString data) {
                        ByteString toPush = data.take(this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$8$$maxBytesPerChunk$1);
                        ByteString toKeep = data.drop(this.$outer.org$apache$pekko$http$impl$util$StreamUtils$$anon$8$$maxBytesPerChunk$1);
                        this.push(this.$outer.out(), toPush);
                        this.remaining_$eq(toKeep);
                    }

                    public final StreamUtils$$anon$8$$anon$9$WaitingForData$ WaitingForData() {
                        Object object = this.WaitingForData$lzy1;
                        if (object instanceof StreamUtils$$anon$8$$anon$9$WaitingForData$) {
                            return (StreamUtils$$anon$8$$anon$9$WaitingForData$)object;
                        }
                        if (object == LazyVals$NullValue$.MODULE$) {
                            return null;
                        }
                        return (StreamUtils$$anon$8$$anon$9$WaitingForData$)this.WaitingForData$lzyINIT1();
                    }

                    private Object WaitingForData$lzyINIT1() {
                        Object object;
                        block8: {
                            while (true) {
                                if ((object = this.WaitingForData$lzy1) == null) {
                                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                                    Serializable serializable = null;
                                    StreamUtils$$anon$8$$anon$9$WaitingForData$ streamUtils$$anon$8$$anon$9$WaitingForData$ = null;
                                    try {
                                        streamUtils$$anon$8$$anon$9$WaitingForData$ = new StreamUtils$$anon$8$$anon$9$WaitingForData$(this);
                                        serializable = streamUtils$$anon$8$$anon$9$WaitingForData$ == null ? LazyVals$NullValue$.MODULE$ : streamUtils$$anon$8$$anon$9$WaitingForData$;
                                    }
                                    finally {
                                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.WaitingForData$lzy1;
                                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                                            waiting.countDown();
                                        }
                                    }
                                    return streamUtils$$anon$8$$anon$9$WaitingForData$;
                                }
                                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                if (object == LazyVals$Evaluating$.MODULE$) {
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                                    continue;
                                }
                                if (!(object instanceof LazyVals.Waiting)) break;
                                ((LazyVals.Waiting)object).await();
                            }
                            return null;
                        }
                        return object;
                    }

                    public final StreamUtils$$anon$8$$anon$9$DeliveringData$ DeliveringData() {
                        Object object = this.DeliveringData$lzy1;
                        if (object instanceof StreamUtils$$anon$8$$anon$9$DeliveringData$) {
                            return (StreamUtils$$anon$8$$anon$9$DeliveringData$)object;
                        }
                        if (object == LazyVals$NullValue$.MODULE$) {
                            return null;
                        }
                        return (StreamUtils$$anon$8$$anon$9$DeliveringData$)this.DeliveringData$lzyINIT1();
                    }

                    private Object DeliveringData$lzyINIT1() {
                        Object object;
                        block8: {
                            while (true) {
                                if ((object = this.DeliveringData$lzy1) == null) {
                                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                                    Serializable serializable = null;
                                    StreamUtils$$anon$8$$anon$9$DeliveringData$ streamUtils$$anon$8$$anon$9$DeliveringData$ = null;
                                    try {
                                        streamUtils$$anon$8$$anon$9$DeliveringData$ = new StreamUtils$$anon$8$$anon$9$DeliveringData$(this);
                                        serializable = streamUtils$$anon$8$$anon$9$DeliveringData$ == null ? LazyVals$NullValue$.MODULE$ : streamUtils$$anon$8$$anon$9$DeliveringData$;
                                    }
                                    finally {
                                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DeliveringData$lzy1;
                                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                                            waiting.countDown();
                                        }
                                    }
                                    return streamUtils$$anon$8$$anon$9$DeliveringData$;
                                }
                                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                if (object == LazyVals$Evaluating$.MODULE$) {
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                                    continue;
                                }
                                if (!(object instanceof LazyVals.Waiting)) break;
                                ((LazyVals.Waiting)object).await();
                            }
                            return null;
                        }
                        return object;
                    }

                    public String toString() {
                        return "limitByteChunksStage";
                    }

                    public Object protected$grab(Inlet in) {
                        return this.grab(in);
                    }

                    public void protected$push(Outlet out, Object elem) {
                        this.push(out, elem);
                    }

                    public void protected$setHandlers(Inlet in, Outlet out, InHandler handler) {
                        this.setHandlers(in, out, handler);
                    }

                    public void protected$pull(Inlet in) {
                        this.pull(in);
                    }

                    public final /* synthetic */ anon.8 org$apache$pekko$http$impl$util$StreamUtils$_$$anon$_$$anon$$$outer() {
                        return this.$outer;
                    }
                };
            }
        };
    }

    public <T> Flow<T, T, NotUsed> delayCancellation(Duration cancelAfter) {
        return Flow$.MODULE$.fromGraph(new StreamUtils.DelayCancellationStage(cancelAfter));
    }

    public <T, U> Flow<T, U, NotUsed> statefulAttrsMap(Function1<Attributes, Function1<T, U>> functionConstructor) {
        return Flow$.MODULE$.apply().via(ExposeAttributes$.MODULE$.apply(functionConstructor));
    }

    public Materializer OnlyRunInGraphInterpreterContext() {
        return OnlyRunInGraphInterpreterContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelSource(Source<?, ?> source, Materializer materializer) {
        Materializer materializer2;
        Source<?, ?> source2 = source;
        Source<Nothing$, NotUsed> source3 = EmptySource;
        Source<?, ?> source4 = source2;
        if (!(source3 != null ? !source3.equals(source4) : source4 != null)) {
            return;
        }
        Source<?, ?> x = source2;
        GraphInterpreter graphInterpreter = GraphInterpreter$.MODULE$.currentInterpreterOrNull();
        if (graphInterpreter == null) {
            if (materializer == null) throw new IllegalStateException("Need to pass materializer to cancelSource if not run from GraphInterpreter context.");
            materializer2 = materializer;
        } else {
            GraphInterpreter x2 = graphInterpreter;
            materializer2 = x2.subFusingMaterializer();
        }
        Materializer mat = materializer2;
        x.runWith(Sink$.MODULE$.ignore(), mat);
    }

    public <T extends HttpEntity, M> Tuple2<T, M> transformEntityStream(T entity, StreamUtils.EntityStreamOp<M> streamOp) {
        T t = entity;
        if (t instanceof HttpEntity.Strict) {
            HttpEntity.Strict x = (HttpEntity.Strict)t;
            HttpEntity httpEntity = Predef$.MODULE$.ArrowAssoc(x);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(httpEntity, streamOp.strictM());
        }
        if (t instanceof HttpEntity.Default) {
            HttpEntity.Default x = (HttpEntity.Default)t;
            Tuple2<Source<ByteString, Object>, M> tuple2 = streamOp.apply(x.data());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Source<ByteString, Object> newData = tuple2._1();
            M whenCompleted = tuple2._2();
            Tuple2<Source<ByteString, Object>, M> tuple22 = Tuple2$.MODULE$.apply(newData, whenCompleted);
            Source<ByteString, Object> newData2 = tuple22._1();
            M whenCompleted2 = tuple22._2();
            HttpEntity httpEntity = Predef$.MODULE$.ArrowAssoc(x.copy(x.copy$default$1(), x.copy$default$2(), newData2));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(httpEntity, whenCompleted2);
        }
        if (t instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked x = (HttpEntity.Chunked)t;
            Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, M> tuple2 = streamOp.apply(x.chunks());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Source<HttpEntity.ChunkStreamPart, Object> newChunks = tuple2._1();
            M whenCompleted = tuple2._2();
            Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, M> tuple23 = Tuple2$.MODULE$.apply(newChunks, whenCompleted);
            Source<HttpEntity.ChunkStreamPart, Object> newChunks2 = tuple23._1();
            M whenCompleted3 = tuple23._2();
            HttpEntity httpEntity = Predef$.MODULE$.ArrowAssoc(x.copy(x.copy$default$1(), newChunks2));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(httpEntity, whenCompleted3);
        }
        if (t instanceof HttpEntity.CloseDelimited) {
            HttpEntity.CloseDelimited x = (HttpEntity.CloseDelimited)t;
            Tuple2<Source<ByteString, Object>, M> tuple2 = streamOp.apply(x.data());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Source<ByteString, Object> newData = tuple2._1();
            M whenCompleted = tuple2._2();
            Tuple2<Source<ByteString, Object>, M> tuple24 = Tuple2$.MODULE$.apply(newData, whenCompleted);
            Source<ByteString, Object> newData3 = tuple24._1();
            M whenCompleted4 = tuple24._2();
            HttpEntity httpEntity = Predef$.MODULE$.ArrowAssoc(x.copy(x.copy$default$1(), newData3));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(httpEntity, whenCompleted4);
        }
        if (t instanceof HttpEntity.IndefiniteLength) {
            HttpEntity.IndefiniteLength x = (HttpEntity.IndefiniteLength)t;
            Tuple2<Source<ByteString, Object>, M> tuple2 = streamOp.apply(x.data());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Source<ByteString, Object> newData = tuple2._1();
            M whenCompleted = tuple2._2();
            Tuple2<Source<ByteString, Object>, M> tuple25 = Tuple2$.MODULE$.apply(newData, whenCompleted);
            Source<ByteString, Object> newData4 = tuple25._1();
            M whenCompleted5 = tuple25._2();
            HttpEntity httpEntity = Predef$.MODULE$.ArrowAssoc(x.copy(x.copy$default$1(), newData4));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(httpEntity, whenCompleted5);
        }
        throw new MatchError(t);
    }

    public Future<IOResult> handleIOResult(IOResult ioResult) {
        if (ioResult.wasSuccessful()) {
            return FastFuture$.MODULE$.successful().apply(ioResult);
        }
        return FastFuture$.MODULE$.failed().apply(ioResult.getError());
    }

    public <T> Flow<T, T, NotUsed> encodeErrorAndComplete(Function1<Throwable, T> f) {
        return (Flow)Flow$.MODULE$.apply().recoverWithRetries(1, (PartialFunction)((Object)new Serializable(f, this){
            private final Function1 f$2;
            {
                this.f$2 = f$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable t = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Source<Object, NotUsed> source;
                    Throwable t = throwable;
                    try {
                        source = Source$.MODULE$.single(this.f$2.apply(t));
                    }
                    catch (Throwable throwable2) {
                        Option<Throwable> option;
                        Throwable throwable3 = throwable2;
                        if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                            Throwable throwable4;
                            Throwable ex = throwable4 = option.get();
                            source = Source$.MODULE$.failed(ex);
                        }
                        throw throwable2;
                    }
                    return source;
                }
                return function1.apply(x);
            }
        }));
    }
}

