/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.TLSProtocol$SendBytes$;
import org.apache.pekko.stream.TLSProtocol$SessionBytes$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class LogByteStringTools$
implements Serializable {
    private static final int MaxBytesPrinted;
    private static final Attributes LogFailuresOnDebugAttributes;
    public static final LogByteStringTools$ MODULE$;

    private LogByteStringTools$() {
    }

    static {
        MODULE$ = new LogByteStringTools$();
        MaxBytesPrinted = 80;
        int n = Logging$.MODULE$.DebugLevel();
        int n2 = Attributes$.MODULE$.logLevels$default$1();
        int n3 = Attributes$.MODULE$.logLevels$default$2();
        LogFailuresOnDebugAttributes = Attributes$.MODULE$.logLevels(n2, n3, n);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogByteStringTools$.class);
    }

    public int MaxBytesPrinted() {
        return MaxBytesPrinted;
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> logByteStringBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logByteString(new StringBuilder(5).append(name).append(" DOWN").toString(), maxBytes), this.logByteString(new StringBuilder(5).append(name).append(" UP  ").toString(), maxBytes));
    }

    public int logByteStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A, B> BidiFlow<A, A, B, B, NotUsed> logToStringBidi(String name, int maxBytes, ClassTag<A> evidence$1, ClassTag<B> evidence$2) {
        return BidiFlow$.MODULE$.fromFlows(this.logToString(new StringBuilder(1).append(name).append(" ").append(this.limitedName$1(evidence$1)).toString(), maxBytes), this.logToString(new StringBuilder(1).append(name).append(" ").append(this.limitedName$1(evidence$2)).toString(), maxBytes));
    }

    public int logToStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<ByteString, ByteString, NotUsed> logByteString(String name, int maxBytes) {
        Flow flow = Flow$.MODULE$.apply();
        Function1<ByteString, Object> & Serializable intersect = (Function1<ByteString, Object> & Serializable)_$1 -> this.printByteString((ByteString)_$1, maxBytes, this.printByteString$default$3(), this.printByteString$default$4());
        return ((Flow)flow.log(name, intersect, flow.log$default$3(name, intersect))).addAttributes(LogFailuresOnDebugAttributes);
    }

    public int logByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> Flow<A, A, NotUsed> logToString(String name, int maxBytes) {
        Flow flow = Flow$.MODULE$.apply();
        Function1<Object, Object> & Serializable intersect = (Function1<Object, Object> & Serializable)_$2 -> StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(_$2.toString()), maxBytes);
        return ((Flow)flow.log(name, intersect, flow.log$default$3(name, intersect))).addAttributes(LogFailuresOnDebugAttributes);
    }

    public int logToString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTLSBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logTlsOutbound(new StringBuilder(8).append(name).append(" ToNet  ").toString(), maxBytes), this.logTlsInbound(new StringBuilder(8).append(name).append(" FromNet").toString(), maxBytes));
    }

    public int logTLSBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, NotUsed> logTlsOutbound(String name, int maxBytes) {
        Flow flow = Flow$.MODULE$.apply();
        Function1<TLSProtocol.SslTlsOutbound, Object> & Serializable intersect = (Function1<TLSProtocol.SslTlsOutbound, Object> & Serializable)x$1 -> {
            TLSProtocol.SslTlsOutbound sslTlsOutbound = x$1;
            if (sslTlsOutbound instanceof TLSProtocol.SendBytes) {
                ByteString byteString;
                TLSProtocol.SendBytes sendBytes = TLSProtocol$SendBytes$.MODULE$.unapply((TLSProtocol.SendBytes)sslTlsOutbound);
                ByteString bytes = byteString = sendBytes._1();
                return new StringBuilder(10).append("SendBytes ").append(this.printByteString(bytes, maxBytes, this.printByteString$default$3(), this.printByteString$default$4())).toString();
            }
            if (sslTlsOutbound instanceof TLSProtocol.NegotiateNewSession) {
                TLSProtocol.NegotiateNewSession n = (TLSProtocol.NegotiateNewSession)sslTlsOutbound;
                return n.toString();
            }
            throw new MatchError(sslTlsOutbound);
        };
        return ((Flow)flow.log(name, intersect, flow.log$default$3(name, intersect))).addAttributes(LogFailuresOnDebugAttributes);
    }

    public int logTlsOutbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTlsInbound(String name, int maxBytes) {
        Flow flow = Flow$.MODULE$.apply();
        Function1<TLSProtocol.SslTlsInbound, Object> & Serializable intersect = (Function1<TLSProtocol.SslTlsInbound, Object> & Serializable)x$1 -> {
            TLSProtocol.SslTlsInbound sslTlsInbound = x$1;
            if (sslTlsInbound instanceof TLSProtocol.SessionTruncated) {
                TLSProtocol.SessionTruncated s2 = (TLSProtocol.SessionTruncated)sslTlsInbound;
                return s2;
            }
            if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = TLSProtocol$SessionBytes$.MODULE$.unapply((TLSProtocol.SessionBytes)sslTlsInbound);
                SSLSession sSLSession = sessionBytes._1();
                ByteString byteString = sessionBytes._2();
                SSLSession session = sSLSession;
                ByteString bytes = byteString;
                return new StringBuilder(13).append("SessionBytes ").append(this.printByteString(bytes, maxBytes, this.printByteString$default$3(), this.printByteString$default$4())).toString();
            }
            throw new MatchError(sslTlsInbound);
        };
        return ((Flow)flow.log(name, intersect, flow.log$default$3(name, intersect))).addAttributes(LogFailuresOnDebugAttributes);
    }

    public int logTlsInbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public String printByteString(ByteString bytes, int maxBytes, boolean addPrefix, String indent) {
        return this.formatBytes$1(indent, maxBytes, addPrefix, bytes).mkString("");
    }

    public int printByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public boolean printByteString$default$3() {
        return true;
    }

    public String printByteString$default$4() {
        return " ";
    }

    public char asASCII(byte b) {
        if (b >= 32 && b < 127) {
            return (char)b;
        }
        return '.';
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, Object> logTLSBidiBySetting(String tag, Option<Object> maxBytesSetting) {
        return (BidiFlow)maxBytesSetting.map((Function1<Object, BidiFlow> & Serializable)_$3 -> this.logTLSBidiBySetting$$anonfun$1(tag, BoxesRunTime.unboxToInt(_$3))).getOrElse(this::logTLSBidiBySetting$$anonfun$2);
    }

    private final String limitedName$1(ClassTag tag) {
        return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(Logging$.MODULE$.simpleName(tag.runtimeClass())), 20)));
    }

    private final String asHex$1(byte b) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToByte(b)}));
    }

    private final /* synthetic */ String $anonfun$5(byte b) {
        return this.asHex$1(b);
    }

    private final /* synthetic */ char $anonfun$6(byte b) {
        return this.asASCII(b);
    }

    private final String formatLine$1(String indent$2, ByteString bs) {
        String hex = ((IterableOnceOps)bs.map((Function1<Object, String> & Serializable)b -> this.$anonfun$5(BoxesRunTime.unboxToByte(b)))).mkString(" ");
        String ascii = ((IterableOnceOps)bs.map((Function1<Object, char> & Serializable)b -> this.$anonfun$6(BoxesRunTime.unboxToByte(b)))).mkString();
        return StringOps$.MODULE$.format$extension("%s%-48s | %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{indent$2, hex, ascii}));
    }

    private final String formatBytes$2(String indent$3, ByteString bs2) {
        return bs2.grouped(16).map((Function1<ByteString, String> & Serializable)bs -> this.formatLine$1(indent$3, (ByteString)bs)).mkString("\n");
    }

    private final Iterator formatBytes$1(String indent$1, int maxBytes$5, boolean addPrefix$1, ByteString bs) {
        String prefix = new StringBuilder(18).append(indent$1).append("ByteString(").append(bs.size()).append(" bytes)").toString();
        if (bs.size() <= maxBytes$5 * 2) {
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{addPrefix$1 ? new StringBuilder(1).append(prefix).append("\n").toString() : "", this.formatBytes$2(indent$1, bs)}));
        }
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{addPrefix$1 ? new StringBuilder(16).append(prefix).append(" first + last ").append(maxBytes$5).append(":\n").toString() : "", this.formatBytes$2(indent$1, bs.take(maxBytes$5)), new StringBuilder(46).append("\n").append(indent$1).append("                    ... [").append(bs.size() - maxBytes$5 * 2).append(" bytes omitted] ...\n").toString(), this.formatBytes$2(indent$1, bs.takeRight(maxBytes$5))}));
    }

    private final /* synthetic */ BidiFlow logTLSBidiBySetting$$anonfun$1(String tag$1, int _$3) {
        return this.logTLSBidi(tag$1, _$3);
    }

    private final BidiFlow logTLSBidiBySetting$$anonfun$2() {
        return BidiFlow$.MODULE$.identity();
    }
}

