/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.nio.charset.StandardCharsets;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ByteString;
import org.parboiled2.ParserInput;

@InternalApi
public final class ByteStringParserInput
extends ParserInput.DefaultParserInput {
    private final ByteString bytes;
    private final int length;

    public ByteStringParserInput(ByteString bytes) {
        this.bytes = bytes;
        this.length = bytes.size();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int ix) {
        return (char)(this.bytes.apply(ix) & 0xFF);
    }

    @Override
    public String sliceString(int start, int end) {
        return this.bytes.slice(start, end).decodeString(StandardCharsets.ISO_8859_1);
    }

    @Override
    public char[] sliceCharArray(int start, int end) {
        return StandardCharsets.ISO_8859_1.decode(this.bytes.slice(start, end).asByteBuffer()).array();
    }
}

