/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.ByteArrayRendering$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteString$ByteString1$;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxedUnit;

@InternalApi
public class ByteArrayRendering
implements Rendering {
    private final Function1<String, BoxedUnit> logDiscardedHeader;
    private byte[] array;
    private int size;

    public static Function1<String, BoxedUnit> $lessinit$greater$default$2() {
        return ByteArrayRendering$.MODULE$.$lessinit$greater$default$2();
    }

    public ByteArrayRendering(int sizeHint, Function1<String, BoxedUnit> logDiscardedHeader) {
        this.logDiscardedHeader = logDiscardedHeader;
        this.array = new byte[sizeHint];
        this.size = 0;
    }

    public ByteArrayRendering(int sizeHint) {
        this(sizeHint, ByteArrayRendering.ByteArrayRendering$superArg$1(sizeHint));
    }

    public byte[] get() {
        if (this.size == this.array.length) {
            return this.array;
        }
        return Arrays.copyOfRange(this.array, 0, this.size);
    }

    @Override
    public ByteArrayRendering $tilde$tilde(char c) {
        int oldSize = this.growBy(1);
        this.array[oldSize] = (byte)c;
        return this;
    }

    @Override
    public ByteArrayRendering $tilde$tilde(byte[] bytes) {
        if (bytes.length > 0) {
            int oldSize = this.growBy(bytes.length);
            System.arraycopy(bytes, 0, this.array, oldSize, bytes.length);
        }
        return this;
    }

    @Override
    public ByteArrayRendering $tilde$tilde(ByteString bytes) {
        if (bytes.length() > 0) {
            int oldSize = this.growBy(bytes.length());
            bytes.copyToArray(this.array, oldSize, bytes.length());
        }
        return this;
    }

    private int growBy(int delta) {
        int oldSize = this.size;
        long neededSize = (long)oldSize + (long)delta;
        if ((long)this.array.length < neededSize) {
            Predef$.MODULE$.require(neededSize < Integer.MAX_VALUE, ByteArrayRendering::growBy$$anonfun$1);
            int newLen = (int)package$.MODULE$.min(package$.MODULE$.max((long)this.array.length << 1, neededSize), (long)Integer.MAX_VALUE);
            byte[] newArray = new byte[newLen];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.size = (int)neededSize;
        return oldSize;
    }

    public int remainingCapacity() {
        return this.array.length - this.size;
    }

    public ByteString asByteString() {
        return ByteString$ByteString1$.MODULE$.apply(this.array, 0, this.size);
    }

    @Override
    public int mark() {
        return this.size;
    }

    @Override
    public boolean check(int mark) {
        int origMark = mark;
        return this.rec$7(origMark, mark);
    }

    private static Function1<String, BoxedUnit> ByteArrayRendering$superArg$1(int sizeHint) {
        return _$3 -> {};
    }

    private static final Object growBy$$anonfun$1() {
        return "Cannot create byte array greater than 2GB in size";
    }

    private final boolean rec$7(int origMark$2, int mark) {
        while (mark < this.size) {
            if (this.array[mark] == 13 || this.array[mark] == 10) {
                this.logDiscardedHeader.apply(new StringBuilder(39).append("Invalid outgoing header was discarded. ").append(LogByteStringTools$.MODULE$.printByteString(ByteString$.MODULE$.fromArray(this.array, origMark$2, this.size - origMark$2), LogByteStringTools$.MODULE$.printByteString$default$2(), LogByteStringTools$.MODULE$.printByteString$default$3(), LogByteStringTools$.MODULE$.printByteString$default$4())).toString());
                this.size = origMark$2;
                return false;
            }
            ++mark;
        }
        return true;
    }
}

