/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.settings;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.settings.ConnectionPoolSettingsImpl$;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
public final class ConnectionPoolSettingsImpl
extends ConnectionPoolSettings
implements Product,
Serializable {
    private final int maxConnections;
    private final int minConnections;
    private final int maxRetries;
    private final int maxOpenRequests;
    private final int pipeliningLimit;
    private final Duration maxConnectionLifetime;
    private final FiniteDuration baseConnectionBackoff;
    private final FiniteDuration maxConnectionBackoff;
    private final Duration idleTimeout;
    private final Duration keepAliveTimeout;
    private final ClientConnectionSettings connectionSettings;
    private final Duration responseEntitySubscriptionTimeout;
    private final Seq hostOverrides;

    public static Object apply(ActorSystem actorSystem) {
        return ConnectionPoolSettingsImpl$.MODULE$.apply(actorSystem);
    }

    public static Object apply(Config config) {
        return ConnectionPoolSettingsImpl$.MODULE$.apply(config);
    }

    public static ConnectionPoolSettingsImpl apply(int n, int n2, int n3, int n4, int n5, Duration duration, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, Duration duration2, Duration duration3, ClientConnectionSettings clientConnectionSettings, Duration duration4, Seq<Tuple2<Regex, ConnectionPoolSettings>> seq) {
        return ConnectionPoolSettingsImpl$.MODULE$.apply(n, n2, n3, n4, n5, duration, finiteDuration, finiteDuration2, duration2, duration3, clientConnectionSettings, duration4, seq);
    }

    public static Object apply(String string2) {
        return ConnectionPoolSettingsImpl$.MODULE$.apply(string2);
    }

    public static Object default(ActorRefFactory actorRefFactory) {
        return ConnectionPoolSettingsImpl$.MODULE$.default(actorRefFactory);
    }

    public static ConnectionPoolSettingsImpl fromProduct(Product product) {
        return ConnectionPoolSettingsImpl$.MODULE$.fromProduct(product);
    }

    public static ConnectionPoolSettingsImpl fromSubConfig(Config config, Config config2) {
        return ConnectionPoolSettingsImpl$.MODULE$.fromSubConfig(config, config2);
    }

    public static Regex hostRegex(String string2) {
        return ConnectionPoolSettingsImpl$.MODULE$.hostRegex(string2);
    }

    public static ConnectionPoolSettingsImpl unapply(ConnectionPoolSettingsImpl connectionPoolSettingsImpl) {
        return ConnectionPoolSettingsImpl$.MODULE$.unapply(connectionPoolSettingsImpl);
    }

    public ConnectionPoolSettingsImpl(int maxConnections, int minConnections, int maxRetries, int maxOpenRequests, int pipeliningLimit, Duration maxConnectionLifetime, FiniteDuration baseConnectionBackoff, FiniteDuration maxConnectionBackoff, Duration idleTimeout, Duration keepAliveTimeout, ClientConnectionSettings connectionSettings, Duration responseEntitySubscriptionTimeout, Seq<Tuple2<Regex, ConnectionPoolSettings>> hostOverrides) {
        this.maxConnections = maxConnections;
        this.minConnections = minConnections;
        this.maxRetries = maxRetries;
        this.maxOpenRequests = maxOpenRequests;
        this.pipeliningLimit = pipeliningLimit;
        this.maxConnectionLifetime = maxConnectionLifetime;
        this.baseConnectionBackoff = baseConnectionBackoff;
        this.maxConnectionBackoff = maxConnectionBackoff;
        this.idleTimeout = idleTimeout;
        this.keepAliveTimeout = keepAliveTimeout;
        this.connectionSettings = connectionSettings;
        this.responseEntitySubscriptionTimeout = responseEntitySubscriptionTimeout;
        this.hostOverrides = hostOverrides;
        Predef$.MODULE$.require(maxConnections > 0, ConnectionPoolSettingsImpl::$init$$$anonfun$1);
        Predef$.MODULE$.require(minConnections >= 0, ConnectionPoolSettingsImpl::$init$$$anonfun$2);
        Predef$.MODULE$.require(minConnections <= maxConnections, ConnectionPoolSettingsImpl::$init$$$anonfun$3);
        Predef$.MODULE$.require(maxRetries >= 0, ConnectionPoolSettingsImpl::$init$$$anonfun$4);
        Predef$.MODULE$.require(maxOpenRequests > 0, ConnectionPoolSettingsImpl::$init$$$anonfun$5);
        Predef$.MODULE$.require(pipeliningLimit > 0, ConnectionPoolSettingsImpl::$init$$$anonfun$6);
        Predef$.MODULE$.require(maxConnectionLifetime.$greater(Duration$.MODULE$.Zero()), ConnectionPoolSettingsImpl::$init$$$anonfun$7);
        Predef$.MODULE$.require(idleTimeout.$greater$eq(Duration$.MODULE$.Zero()), ConnectionPoolSettingsImpl::$init$$$anonfun$8);
        Predef$.MODULE$.require(minConnections == 0 || baseConnectionBackoff.toMillis() > 0L && maxConnectionBackoff.toMillis() > 10L, ConnectionPoolSettingsImpl::$init$$$anonfun$9);
        Predef$.MODULE$.require(hostOverrides.isEmpty() || hostOverrides.forall((Function1<Tuple2, boolean> & Serializable)_$1 -> ((ConnectionPoolSettings)_$1._2()).hostOverrides().isEmpty()), ConnectionPoolSettingsImpl::$init$$$anonfun$11);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.maxConnections());
        n = Statics.mix(n, this.minConnections());
        n = Statics.mix(n, this.maxRetries());
        n = Statics.mix(n, this.maxOpenRequests());
        n = Statics.mix(n, this.pipeliningLimit());
        n = Statics.mix(n, Statics.anyHash(this.maxConnectionLifetime()));
        n = Statics.mix(n, Statics.anyHash(this.baseConnectionBackoff()));
        n = Statics.mix(n, Statics.anyHash(this.maxConnectionBackoff()));
        n = Statics.mix(n, Statics.anyHash(this.idleTimeout()));
        n = Statics.mix(n, Statics.anyHash(this.keepAliveTimeout()));
        n = Statics.mix(n, Statics.anyHash(this.connectionSettings()));
        n = Statics.mix(n, Statics.anyHash(this.responseEntitySubscriptionTimeout()));
        n = Statics.mix(n, Statics.anyHash(this.hostOverrides()));
        return Statics.finalizeHash(n, 13);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConnectionPoolSettingsImpl)) return false;
        ConnectionPoolSettingsImpl connectionPoolSettingsImpl = (ConnectionPoolSettingsImpl)object;
        if (this.maxConnections() != connectionPoolSettingsImpl.maxConnections()) return false;
        if (this.minConnections() != connectionPoolSettingsImpl.minConnections()) return false;
        if (this.maxRetries() != connectionPoolSettingsImpl.maxRetries()) return false;
        if (this.maxOpenRequests() != connectionPoolSettingsImpl.maxOpenRequests()) return false;
        if (this.pipeliningLimit() != connectionPoolSettingsImpl.pipeliningLimit()) return false;
        Duration duration = this.maxConnectionLifetime();
        Duration duration2 = connectionPoolSettingsImpl.maxConnectionLifetime();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        FiniteDuration finiteDuration = this.baseConnectionBackoff();
        FiniteDuration finiteDuration2 = connectionPoolSettingsImpl.baseConnectionBackoff();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.maxConnectionBackoff();
        FiniteDuration finiteDuration4 = connectionPoolSettingsImpl.maxConnectionBackoff();
        if (finiteDuration3 == null) {
            if (finiteDuration4 != null) {
                return false;
            }
        } else if (!((Object)finiteDuration3).equals(finiteDuration4)) return false;
        Duration duration3 = this.idleTimeout();
        Duration duration4 = connectionPoolSettingsImpl.idleTimeout();
        if (duration3 == null) {
            if (duration4 != null) {
                return false;
            }
        } else if (!duration3.equals(duration4)) return false;
        Duration duration5 = this.keepAliveTimeout();
        Duration duration6 = connectionPoolSettingsImpl.keepAliveTimeout();
        if (duration5 == null) {
            if (duration6 != null) {
                return false;
            }
        } else if (!duration5.equals(duration6)) return false;
        ClientConnectionSettings clientConnectionSettings = this.connectionSettings();
        ClientConnectionSettings clientConnectionSettings2 = connectionPoolSettingsImpl.connectionSettings();
        if (clientConnectionSettings == null) {
            if (clientConnectionSettings2 != null) {
                return false;
            }
        } else if (!clientConnectionSettings.equals(clientConnectionSettings2)) return false;
        Duration duration7 = this.responseEntitySubscriptionTimeout();
        Duration duration8 = connectionPoolSettingsImpl.responseEntitySubscriptionTimeout();
        if (duration7 == null) {
            if (duration8 != null) {
                return false;
            }
        } else if (!duration7.equals(duration8)) return false;
        Seq<Tuple2<Regex, ConnectionPoolSettings>> seq = this.hostOverrides();
        Seq<Tuple2<Regex, ConnectionPoolSettings>> seq2 = connectionPoolSettingsImpl.hostOverrides();
        if (seq == null) {
            if (seq2 == null) return true;
            return false;
        } else {
            if (!seq.equals(seq2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ConnectionPoolSettingsImpl;
    }

    @Override
    public int productArity() {
        return 13;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger(this._2());
            }
            case 2: {
                return BoxesRunTime.boxToInteger(this._3());
            }
            case 3: {
                return BoxesRunTime.boxToInteger(this._4());
            }
            case 4: {
                return BoxesRunTime.boxToInteger(this._5());
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
            case 10: {
                return this._11();
            }
            case 11: {
                return this._12();
            }
            case 12: {
                return this._13();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "maxConnections";
            }
            case 1: {
                return "minConnections";
            }
            case 2: {
                return "maxRetries";
            }
            case 3: {
                return "maxOpenRequests";
            }
            case 4: {
                return "pipeliningLimit";
            }
            case 5: {
                return "maxConnectionLifetime";
            }
            case 6: {
                return "baseConnectionBackoff";
            }
            case 7: {
                return "maxConnectionBackoff";
            }
            case 8: {
                return "idleTimeout";
            }
            case 9: {
                return "keepAliveTimeout";
            }
            case 10: {
                return "connectionSettings";
            }
            case 11: {
                return "responseEntitySubscriptionTimeout";
            }
            case 12: {
                return "hostOverrides";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public int maxConnections() {
        return this.maxConnections;
    }

    @Override
    public int minConnections() {
        return this.minConnections;
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    public int maxOpenRequests() {
        return this.maxOpenRequests;
    }

    @Override
    public int pipeliningLimit() {
        return this.pipeliningLimit;
    }

    @Override
    public Duration maxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public FiniteDuration baseConnectionBackoff() {
        return this.baseConnectionBackoff;
    }

    @Override
    public FiniteDuration maxConnectionBackoff() {
        return this.maxConnectionBackoff;
    }

    @Override
    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Duration keepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    @Override
    public ClientConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    @Override
    public Duration responseEntitySubscriptionTimeout() {
        return this.responseEntitySubscriptionTimeout;
    }

    @Override
    public Seq<Tuple2<Regex, ConnectionPoolSettings>> hostOverrides() {
        return this.hostOverrides;
    }

    @Override
    public String productPrefix() {
        return "ConnectionPoolSettings";
    }

    @Override
    public ConnectionPoolSettingsImpl withUpdatedConnectionSettings(Function1<ClientConnectionSettings, ClientConnectionSettings> f) {
        ClientConnectionSettings clientConnectionSettings = f.apply(this.connectionSettings());
        Seq seq = (Seq)this.hostOverrides().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Regex k = (Regex)tuple2._1();
                ConnectionPoolSettings v = (ConnectionPoolSettings)tuple2._2();
                Regex regex = Predef$.MODULE$.ArrowAssoc(k);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(regex, v.withUpdatedConnectionSettings(f));
            }
            throw new MatchError(tuple2);
        });
        int n = this.copy$default$1();
        int n2 = this.copy$default$2();
        int n3 = this.copy$default$3();
        int n4 = this.copy$default$4();
        int n5 = this.copy$default$5();
        Duration duration = this.copy$default$6();
        FiniteDuration finiteDuration = this.copy$default$7();
        FiniteDuration finiteDuration2 = this.copy$default$8();
        Duration duration2 = this.copy$default$9();
        Duration duration3 = this.copy$default$10();
        Duration duration4 = this.copy$default$12();
        return this.copy(n, n2, n3, n4, n5, duration, finiteDuration, finiteDuration2, duration2, duration3, clientConnectionSettings, duration4, seq);
    }

    public ConnectionPoolSettings copyDeep(Function1<ConnectionPoolSettings, ConnectionPoolSettings> mapHostOverrides, int maxConnections, int minConnections, int maxRetries, int maxOpenRequests, int pipeliningLimit, Duration maxConnectionLifetime, FiniteDuration baseConnectionBackoff, FiniteDuration maxConnectionBackoff, Duration idleTimeout, Duration keepAliveTimeout, ClientConnectionSettings connectionSettings, Duration responseEntitySubscriptionTimeout) {
        return this.copy(maxConnections, minConnections, maxRetries, maxOpenRequests, pipeliningLimit, maxConnectionLifetime, baseConnectionBackoff, maxConnectionBackoff, idleTimeout, keepAliveTimeout, connectionSettings, responseEntitySubscriptionTimeout, (Seq)this.hostOverrides().map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Regex k = (Regex)tuple2._1();
                ConnectionPoolSettings v = (ConnectionPoolSettings)tuple2._2();
                Regex regex = Predef$.MODULE$.ArrowAssoc(k);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(regex, mapHostOverrides.apply(v));
            }
            throw new MatchError(tuple2);
        }));
    }

    public int copyDeep$default$2() {
        return this.maxConnections();
    }

    public int copyDeep$default$3() {
        return this.minConnections();
    }

    public int copyDeep$default$4() {
        return this.maxRetries();
    }

    public int copyDeep$default$5() {
        return this.maxOpenRequests();
    }

    public int copyDeep$default$6() {
        return this.pipeliningLimit();
    }

    public Duration copyDeep$default$7() {
        return this.maxConnectionLifetime();
    }

    public FiniteDuration copyDeep$default$8() {
        return this.baseConnectionBackoff();
    }

    public FiniteDuration copyDeep$default$9() {
        return this.maxConnectionBackoff();
    }

    public Duration copyDeep$default$10() {
        return this.idleTimeout();
    }

    public Duration copyDeep$default$11() {
        return this.keepAliveTimeout();
    }

    public ClientConnectionSettings copyDeep$default$12() {
        return this.connectionSettings();
    }

    public Duration copyDeep$default$13() {
        return this.responseEntitySubscriptionTimeout();
    }

    public ConnectionPoolSettingsImpl copy(int maxConnections, int minConnections, int maxRetries, int maxOpenRequests, int pipeliningLimit, Duration maxConnectionLifetime, FiniteDuration baseConnectionBackoff, FiniteDuration maxConnectionBackoff, Duration idleTimeout, Duration keepAliveTimeout, ClientConnectionSettings connectionSettings, Duration responseEntitySubscriptionTimeout, Seq<Tuple2<Regex, ConnectionPoolSettings>> hostOverrides) {
        return new ConnectionPoolSettingsImpl(maxConnections, minConnections, maxRetries, maxOpenRequests, pipeliningLimit, maxConnectionLifetime, baseConnectionBackoff, maxConnectionBackoff, idleTimeout, keepAliveTimeout, connectionSettings, responseEntitySubscriptionTimeout, hostOverrides);
    }

    public int copy$default$1() {
        return this.maxConnections();
    }

    public int copy$default$2() {
        return this.minConnections();
    }

    public int copy$default$3() {
        return this.maxRetries();
    }

    public int copy$default$4() {
        return this.maxOpenRequests();
    }

    public int copy$default$5() {
        return this.pipeliningLimit();
    }

    public Duration copy$default$6() {
        return this.maxConnectionLifetime();
    }

    public FiniteDuration copy$default$7() {
        return this.baseConnectionBackoff();
    }

    public FiniteDuration copy$default$8() {
        return this.maxConnectionBackoff();
    }

    public Duration copy$default$9() {
        return this.idleTimeout();
    }

    public Duration copy$default$10() {
        return this.keepAliveTimeout();
    }

    public ClientConnectionSettings copy$default$11() {
        return this.connectionSettings();
    }

    public Duration copy$default$12() {
        return this.responseEntitySubscriptionTimeout();
    }

    public Seq<Tuple2<Regex, ConnectionPoolSettings>> copy$default$13() {
        return this.hostOverrides();
    }

    public int _1() {
        return this.maxConnections();
    }

    public int _2() {
        return this.minConnections();
    }

    public int _3() {
        return this.maxRetries();
    }

    public int _4() {
        return this.maxOpenRequests();
    }

    public int _5() {
        return this.pipeliningLimit();
    }

    public Duration _6() {
        return this.maxConnectionLifetime();
    }

    public FiniteDuration _7() {
        return this.baseConnectionBackoff();
    }

    public FiniteDuration _8() {
        return this.maxConnectionBackoff();
    }

    public Duration _9() {
        return this.idleTimeout();
    }

    public Duration _10() {
        return this.keepAliveTimeout();
    }

    public ClientConnectionSettings _11() {
        return this.connectionSettings();
    }

    public Duration _12() {
        return this.responseEntitySubscriptionTimeout();
    }

    public Seq<Tuple2<Regex, ConnectionPoolSettings>> _13() {
        return this.hostOverrides();
    }

    private static final Object $init$$$anonfun$1() {
        return "max-connections must be > 0";
    }

    private static final Object $init$$$anonfun$2() {
        return "min-connections must be >= 0";
    }

    private static final Object $init$$$anonfun$3() {
        return "min-connections must be <= max-connections";
    }

    private static final Object $init$$$anonfun$4() {
        return "max-retries must be >= 0";
    }

    private static final Object $init$$$anonfun$5() {
        return "max-open-requests must be > 0";
    }

    private static final Object $init$$$anonfun$6() {
        return "pipelining-limit must be > 0";
    }

    private static final Object $init$$$anonfun$7() {
        return "max-connection-lifetime must be > 0";
    }

    private static final Object $init$$$anonfun$8() {
        return "idle-timeout must be >= 0";
    }

    private static final Object $init$$$anonfun$9() {
        return "If min-connections > 0, you need to set a base-connection-backoff must be > 0 and max-connection-backoff must be > 10 millis to avoid client pools excessively trying to open up new connections.";
    }

    private static final Object $init$$$anonfun$11() {
        return "host-overrides should not be nested";
    }
}

