/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.model.parser;

import java.nio.charset.Charset;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.IpAddressParsing;
import org.apache.pekko.http.impl.model.parser.UriParser$;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.StringRendering;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.Uri$Host$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv4Host$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv6Host$;
import org.apache.pekko.http.scaladsl.model.Uri$NamedHost$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$Relaxed$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$Strict$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Cons$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Empty$;
import org.apache.pekko.http.scaladsl.model.UriRendering$;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.http.scaladsl.model.headers.HttpOrigin;
import org.apache.pekko.http.scaladsl.model.headers.HttpOrigin$;
import org.parboiled2.CharPredicate;
import org.parboiled2.CharUtils$;
import org.parboiled2.ErrorFormatter;
import org.parboiled2.ErrorFormatter$;
import org.parboiled2.ParseError;
import org.parboiled2.Parser;
import org.parboiled2.Parser$;
import org.parboiled2.Parser$DeliveryScheme$;
import org.parboiled2.Parser$StartTracingException$;
import org.parboiled2.ParserInput;
import org.parboiled2.Rule;
import org.parboiled2.Rule$;
import org.parboiled2.RuleTrace;
import org.parboiled2.RuleTrace$Action$;
import org.parboiled2.RuleTrace$AndPredicate$;
import org.parboiled2.RuleTrace$Capture$;
import org.parboiled2.RuleTrace$CharMatch$;
import org.parboiled2.RuleTrace$CharPredicateMatch$;
import org.parboiled2.RuleTrace$FirstOf$;
import org.parboiled2.RuleTrace$Named$;
import org.parboiled2.RuleTrace$NonTerminal$;
import org.parboiled2.RuleTrace$NotPredicate$;
import org.parboiled2.RuleTrace$NotPredicate$Terminal$;
import org.parboiled2.RuleTrace$OneOrMore$;
import org.parboiled2.RuleTrace$Optional$;
import org.parboiled2.RuleTrace$RuleCall$;
import org.parboiled2.RuleTrace$Run$;
import org.parboiled2.RuleTrace$Sequence$;
import org.parboiled2.RuleTrace$ZeroOrMore$;
import org.parboiled2.StringBuilding;
import org.parboiled2.support.Unpack$;
import org.parboiled2.support.Unpack$HNilUnpack$;
import org.parboiled2.support.hlist.$colon$colon;
import org.parboiled2.support.hlist.HNil;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@InternalApi
public final class UriParser
extends Parser
implements IpAddressParsing,
StringBuilding {
    private StringBuilder sb;
    private ParserInput _input;
    private final Charset uriParsingCharset;
    private final Uri.ParsingMode uriParsingMode;
    private final int maxValueStackSize;
    private final CharPredicate path$minussegment$minuschar;
    private final CharPredicate query$minuschar;
    private final CharPredicate query$minuskey$minuschar;
    private final CharPredicate query$minusvalue$minuschar;
    private final CharPredicate fragment$minuschar;
    private String _scheme;
    private String _userinfo;
    private Uri.Host _host;
    private int _port;
    private Uri.Path _path;
    private Option<String> _rawQueryString;
    private Option<String> _fragment;
    private int _firstPercentIx;

    public static Charset $lessinit$greater$default$2() {
        return UriParser$.MODULE$.$lessinit$greater$default$2();
    }

    public static Uri.ParsingMode $lessinit$greater$default$3() {
        return UriParser$.MODULE$.$lessinit$greater$default$3();
    }

    public UriParser(ParserInput _input, Charset uriParsingCharset, Uri.ParsingMode uriParsingMode, int maxValueStackSize) {
        CharPredicate charPredicate;
        CharPredicate charPredicate2;
        this._input = _input;
        this.uriParsingCharset = uriParsingCharset;
        this.uriParsingMode = uriParsingMode;
        this.maxValueStackSize = maxValueStackSize;
        super(Parser$.MODULE$.$lessinit$greater$default$1(), maxValueStackSize);
        StringBuilding.$init$(this);
        Uri.ParsingMode parsingMode = uriParsingMode;
        this.path$minussegment$minuschar = Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode) ? CharacterClasses$.MODULE$.pchar$minusbase() : CharacterClasses$.MODULE$.relaxed$minuspath$minussegment$minuschar();
        Uri.ParsingMode parsingMode2 = uriParsingMode;
        this.query$minuschar = Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode2) ? CharacterClasses$.MODULE$.query$minusfragment$minuschar() : CharacterClasses$.MODULE$.relaxed$minusquery$minuschar();
        Uri.ParsingMode parsingMode3 = uriParsingMode;
        if (Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode3)) {
            charPredicate2 = CharacterClasses$.MODULE$.strict$minusquery$minuskey$minuschar();
        } else if (Uri$ParsingMode$Relaxed$.MODULE$.equals(parsingMode3)) {
            charPredicate2 = CharacterClasses$.MODULE$.relaxed$minusquery$minuskey$minuschar();
        } else {
            throw new MatchError(parsingMode3);
        }
        this.query$minuskey$minuschar = charPredicate2;
        Uri.ParsingMode parsingMode4 = uriParsingMode;
        if (Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode4)) {
            charPredicate = CharacterClasses$.MODULE$.strict$minusquery$minusvalue$minuschar();
        } else if (Uri$ParsingMode$Relaxed$.MODULE$.equals(parsingMode4)) {
            charPredicate = CharacterClasses$.MODULE$.relaxed$minusquery$minusvalue$minuschar();
        } else {
            throw new MatchError(parsingMode4);
        }
        this.query$minusvalue$minuschar = charPredicate;
        Uri.ParsingMode parsingMode5 = uriParsingMode;
        this.fragment$minuschar = Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode5) ? CharacterClasses$.MODULE$.query$minusfragment$minuschar() : CharacterClasses$.MODULE$.relaxed$minusfragment$minuschar();
        this._scheme = "";
        this._userinfo = "";
        this._host = Uri$Host$Empty$.MODULE$;
        this._port = 0;
        this._path = Uri$Path$Empty$.MODULE$;
        this._rawQueryString = None$.MODULE$;
        this._fragment = None$.MODULE$;
        this._firstPercentIx = -1;
        Statics.releaseFence();
    }

    @Override
    public StringBuilder sb() {
        return this.sb;
    }

    @Override
    public void org$parboiled2$StringBuilding$_setter_$sb_$eq(StringBuilder x$0) {
        this.sb = x$0;
    }

    public Charset uriParsingCharset() {
        return this.uriParsingCharset;
    }

    public Uri.ParsingMode uriParsingMode() {
        return this.uriParsingMode;
    }

    public int maxValueStackSize() {
        return this.maxValueStackSize;
    }

    @Override
    public ParserInput input() {
        return this._input;
    }

    public UriParser(ParserInput input, Charset uriParsingCharset, Uri.ParsingMode uriParsingMode) {
        this(input, uriParsingCharset, uriParsingMode, 1024);
    }

    public Uri parseAbsoluteUri() {
        Parser.DeliveryScheme scheme$proxy1 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseAbsoluteUri$$anonfun$1, scheme$proxy1);
        if (either instanceof Right) {
            return Uri$.MODULE$.createUnsafe(this._scheme, Uri$Authority$.MODULE$.apply(this._host, this._port, this._userinfo), Uri$.MODULE$.collapseDotSegments(this._path), this._rawQueryString, this._fragment);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "absolute URI");
        }
        throw new MatchError(either);
    }

    public Uri parseUriReference() {
        Parser.DeliveryScheme scheme$proxy2 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseUriReference$$anonfun$1, scheme$proxy2);
        if (either instanceof Right) {
            return this.createUriReference();
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "URI reference");
        }
        throw new MatchError(either);
    }

    public Uri parseAndResolveUriReference(Uri base) {
        Parser.DeliveryScheme scheme$proxy3 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseAndResolveUriReference$$anonfun$1, scheme$proxy3);
        if (either instanceof Right) {
            return Uri$.MODULE$.resolveUnsafe(this._scheme, this._userinfo, this._host, this._port, this._path, this._rawQueryString, this._fragment, base);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "URI reference");
        }
        throw new MatchError(either);
    }

    public HttpOrigin parseOrigin() {
        Parser.DeliveryScheme scheme$proxy4 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseOrigin$$anonfun$1, scheme$proxy4);
        if (either instanceof Right) {
            return HttpOrigin$.MODULE$.apply(this._scheme, Host$.MODULE$.apply(this._host.address(), this._port));
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "origin");
        }
        throw new MatchError(either);
    }

    public Uri.Host parseHost() {
        Parser.DeliveryScheme scheme$proxy5 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHost$$anonfun$1, scheme$proxy5);
        if (either instanceof Right) {
            return this._host;
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "URI host");
        }
        throw new MatchError(either);
    }

    public String parseRawQueryString() {
        Parser.DeliveryScheme scheme$proxy6 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseRawQueryString$$anonfun$1, scheme$proxy6);
        if (either instanceof Right) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object b = ((Right)either).value();
            if (!(boxedUnit != null ? !((Object)boxedUnit).equals(b) : b != null)) {
                return this.parseSafeRawQueryString(this.sb().toString());
            }
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "rawQueryString");
        }
        throw new MatchError(either);
    }

    public String parseSafeRawQueryString(String rawQueryString) {
        Uri.ParsingMode parsingMode = this.uriParsingMode();
        if (Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode)) {
            return rawQueryString;
        }
        if (Uri$ParsingMode$Relaxed$.MODULE$.equals(parsingMode)) {
            return ((StringRendering)UriRendering$.MODULE$.encode(new StringRendering(), rawQueryString, this.uriParsingCharset(), CharacterClasses$.MODULE$.query$minusfragment$minuschar().$plus$plus('%'), false)).get();
        }
        throw new MatchError(parsingMode);
    }

    public Uri.Query parseQuery() {
        Parser.DeliveryScheme scheme$proxy7 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$.MODULE$.single());
        Either either = (Either)this.__run(this::parseQuery$$anonfun$1, scheme$proxy7);
        if (either instanceof Right) {
            Uri.Query query = (Uri.Query)((Right)either).value();
            return query;
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "query");
        }
        throw new MatchError(either);
    }

    public Uri.Authority parseAuthority() {
        Parser.DeliveryScheme scheme$proxy8 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseAuthority$$anonfun$1, scheme$proxy8);
        if (either instanceof Right) {
            return Uri$Authority$.MODULE$.apply(this._host, this._port, this._userinfo);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "authority");
        }
        throw new MatchError(either);
    }

    public Nothing$ fail(ParseError error, String target) {
        ErrorFormatter formatter = new ErrorFormatter(ErrorFormatter$.MODULE$.$lessinit$greater$default$1(), ErrorFormatter$.MODULE$.$lessinit$greater$default$2(), false, ErrorFormatter$.MODULE$.$lessinit$greater$default$4(), ErrorFormatter$.MODULE$.$lessinit$greater$default$5(), ErrorFormatter$.MODULE$.$lessinit$greater$default$6(), ErrorFormatter$.MODULE$.$lessinit$greater$default$7());
        return Uri$.MODULE$.fail(new StringBuilder(10).append("Illegal ").append(target).append(": ").append(formatter.format(error, this.input())).toString(), formatter.formatErrorLine(error, this.input()));
    }

    public void reset(ParserInput newInput) {
        this._input = newInput;
        this._scheme = "";
        this._userinfo = "";
        this._host = Uri$Host$Empty$.MODULE$;
        this._port = 0;
        this._path = Uri$Path$Empty$.MODULE$;
        this._rawQueryString = None$.MODULE$;
        this._fragment = None$.MODULE$;
        this._firstPercentIx = -1;
    }

    private void setScheme(String scheme) {
        this._scheme = scheme;
    }

    private void setUserInfo(String userinfo) {
        this._userinfo = userinfo;
    }

    private void setHost(Uri.Host host) {
        this._host = host;
    }

    private void setPort(int port) {
        this._port = port;
    }

    private void setPath(Uri.Path path) {
        this._path = path;
    }

    private void setRawQueryString(String rawQueryString) {
        this._rawQueryString = Some$.MODULE$.apply(this.parseSafeRawQueryString(rawQueryString));
    }

    private void setFragment(String fragment) {
        this._fragment = Some$.MODULE$.apply(fragment);
    }

    public Rule<HNil, HNil> URI() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$9(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            boolean bl3 = ll4 = this.scheme() != null;
            boolean bl4 = ll4 ? ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl5 = ll3 ? this.hier$minuspart() != null : (ll2 = false);
            if (ll2) {
                boolean matched2;
                boolean ll5;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll5 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl7 = ll5 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                boolean matched3;
                boolean ll6;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl8 = ll6 = ParserMacroMethods_this.cursorChar() == '#' && ParserMacroMethods_this.__advance();
                boolean bl9 = ll6 ? this.fragment() != null : (matched3 = false);
                if (!matched3) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> origin() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$10(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            boolean bl2 = ll4 = this.scheme() != null;
            boolean bl3 = ll4 ? ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl4 = ll3 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl5 = ll2 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll = false);
            bl = ll ? this.hostAndPort() != null : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> hier$minuspart() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$11(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean l3;
            boolean ll;
            boolean ll2;
            boolean ll3;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance();
            boolean bl5 = ll3 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl6 = ll2 ? this.authority() != null : (ll = false);
            boolean bl7 = ll ? this.path$minusabempty() != null : (l3 = false);
            if (!l3) {
                ParserMacroMethods_this.__restoreState(mark);
                bl3 = this.path$minusabsolute() != null;
            } else {
                bl3 = l2 = true;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.path$minusrootless() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.path$minusempty() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> URI$minusreference() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$12(ParserMacroMethods_this);
        } else {
            boolean l;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl2 = l = this.URI() != null;
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.relative$minusref() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, $colon$colon<Uri, HNil>> URI$minusreference$minuspushed() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$13(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.URI$minusreference() != null;
            if (ll) {
                ParserMacroMethods_this.valueStack().push(this.createUriReference());
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> absolute$minusURI() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$14(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = this.scheme() != null;
            boolean bl3 = ll3 ? ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl4 = ll2 ? this.hier$minuspart() != null : (ll = false);
            if (ll) {
                boolean matched2;
                boolean ll4;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl5 = ll4 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl6 = ll4 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> relative$minusref() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$15(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.relative$minuspart() != null;
            if (ll2) {
                boolean matched2;
                boolean ll3;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl5 = ll3 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                boolean matched3;
                boolean ll4;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll4 = ParserMacroMethods_this.cursorChar() == '#' && ParserMacroMethods_this.__advance();
                boolean bl7 = ll4 ? this.fragment() != null : (matched3 = false);
                if (!matched3) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> relative$minuspart() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$16(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean l3;
            boolean ll;
            boolean ll2;
            boolean ll3;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance();
            boolean bl5 = ll3 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl6 = ll2 ? this.authority() != null : (ll = false);
            boolean bl7 = ll ? this.path$minusabempty() != null : (l3 = false);
            if (!l3) {
                ParserMacroMethods_this.__restoreState(mark);
                bl3 = this.path$minusabsolute() != null;
            } else {
                bl3 = l2 = true;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.path$minusnoscheme() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.path$minusempty() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> scheme() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$17(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl3 = ll4 = ParserMacroMethods_this.cursorChar() == 'h' && ParserMacroMethods_this.__advance();
            boolean bl4 = ll4 ? ParserMacroMethods_this.cursorChar() == 't' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl5 = ll3 ? ParserMacroMethods_this.cursorChar() == 't' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl6 = ll2 ? ParserMacroMethods_this.cursorChar() == 'p' && ParserMacroMethods_this.__advance() : (ll = false);
            if (ll) {
                boolean l2;
                boolean bl7;
                long mark2 = ParserMacroMethods_this.__saveState();
                long mark3 = ParserMacroMethods_this.__saveState();
                boolean matched2 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                ParserMacroMethods_this.__restoreState(mark3);
                boolean ll5 = matched2;
                if (ll5) {
                    this.setScheme("http");
                    bl7 = true;
                } else {
                    bl7 = l2 = false;
                }
                if (!l2) {
                    boolean ll6;
                    boolean bl8;
                    boolean ll7;
                    ParserMacroMethods_this.__restoreState(mark2);
                    boolean bl9 = ll7 = ParserMacroMethods_this.cursorChar() == 's' && ParserMacroMethods_this.__advance();
                    if (ll7) {
                        long mark4 = ParserMacroMethods_this.__saveState();
                        boolean matched3 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                        ParserMacroMethods_this.__restoreState(mark4);
                        bl8 = matched3;
                    } else {
                        bl8 = ll6 = false;
                    }
                    if (ll6) {
                        this.setScheme("https");
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = l = false;
            }
            if (!l) {
                boolean ll8;
                boolean bl10;
                boolean ll9;
                boolean bl11;
                boolean ll10;
                boolean ll11;
                boolean ll12;
                ParserMacroMethods_this.__restoreState(mark);
                boolean bl12 = ll12 = this.clearSB() != null;
                boolean bl13 = ll12 ? CharacterClasses$.MODULE$.ALPHA().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance() : (ll11 = false);
                boolean bl14 = ll11 ? this.appendLowered() != null : (ll10 = false);
                if (ll10) {
                    ParserMacroMethods_this.__restoreState(this.rec$2(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
                    bl11 = true;
                } else {
                    bl11 = ll9 = false;
                }
                if (ll9) {
                    long mark5 = ParserMacroMethods_this.__saveState();
                    boolean matched4 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                    ParserMacroMethods_this.__restoreState(mark5);
                    bl10 = matched4;
                } else {
                    bl10 = ll8 = false;
                }
                if (ll8) {
                    this.setScheme(this.sb().toString());
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, $colon$colon<String, HNil>> scheme$minuspushed() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$18(ParserMacroMethods_this);
        } else {
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$4(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            boolean bl2 = true;
            boolean ll = bl2;
            if (!ll) return null;
            this.setScheme(this.sb().toString());
            boolean bl3 = true;
            boolean ll2 = bl3;
            if (!ll2) return null;
            ParserMacroMethods_this.valueStack().push(this._scheme);
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return Rule$.MODULE$;
    }

    public Rule<HNil, HNil> authority() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$19(ParserMacroMethods_this);
        } else {
            boolean matched2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl2 = matched2 = this.userinfo() != null;
            if (!matched2) {
                ParserMacroMethods_this.__restoreState(mark);
            }
            boolean ll = true;
            bl = ll ? this.hostAndPort() != null : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> userinfo() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$20(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean bl2;
            boolean ll3;
            boolean bl3 = ll3 = this.clearSBForDecoding() != null;
            if (ll3) {
                ParserMacroMethods_this.__restoreState(this.rec$6(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
                bl2 = true;
            } else {
                bl2 = ll2 = false;
            }
            boolean bl4 = ll2 ? ParserMacroMethods_this.cursorChar() == '@' && ParserMacroMethods_this.__advance() : (ll = false);
            if (ll) {
                this.setUserInfo(this.getDecodedString(this.getDecodedString$default$1()));
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> hostAndPort() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$21(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.host() != null;
            if (ll) {
                boolean matched2;
                boolean ll2;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl3 = ll2 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                boolean bl4 = ll2 ? this.port() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, $colon$colon<Uri.Host, $colon$colon<Object, HNil>>> hostAndPort$minuspushed() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$22(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.hostAndPort() != null;
            if (ll2) {
                ParserMacroMethods_this.valueStack().push(this._host);
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                ParserMacroMethods_this.valueStack().push(BoxesRunTime.boxToInteger(this._port));
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> host() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$23(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl3 = l2 = this.IP$minusliteral() != null;
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.ipv4Host() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.reg$minusname() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> relaxedHost() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$24(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean l3;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = l3 = this.IP$minusliteral() != null;
            if (!l3) {
                ParserMacroMethods_this.__restoreState(mark);
                bl3 = this.ipv6Host() != null;
            } else {
                bl3 = l2 = true;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.ipv4Host() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.reg$minusname() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> port() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$25(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
            if (ll2) {
                this.setPort(this.lastChar() - 48);
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                boolean matched2;
                boolean bl4;
                boolean ll3;
                boolean bl5;
                boolean ll4;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll4 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                if (ll4) {
                    this.setPort(10 * this._port + this.lastChar() - 48);
                    bl5 = true;
                } else {
                    bl5 = ll3 = false;
                }
                if (ll3) {
                    boolean matched3;
                    boolean bl7;
                    boolean ll5;
                    boolean bl8;
                    boolean ll6;
                    long mark2 = ParserMacroMethods_this.__saveState();
                    boolean bl9 = ll6 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                    if (ll6) {
                        this.setPort(10 * this._port + this.lastChar() - 48);
                        bl8 = true;
                    } else {
                        bl8 = ll5 = false;
                    }
                    if (ll5) {
                        boolean matched4;
                        boolean bl10;
                        boolean ll7;
                        boolean bl11;
                        boolean ll8;
                        long mark3 = ParserMacroMethods_this.__saveState();
                        boolean bl12 = ll8 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                        if (ll8) {
                            this.setPort(10 * this._port + this.lastChar() - 48);
                            bl11 = true;
                        } else {
                            bl11 = ll7 = false;
                        }
                        if (ll7) {
                            boolean matched5;
                            boolean bl13;
                            boolean ll9;
                            long mark4 = ParserMacroMethods_this.__saveState();
                            boolean bl14 = ll9 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                            if (ll9) {
                                this.setPort(10 * this._port + this.lastChar() - 48);
                                bl13 = true;
                            } else {
                                bl13 = matched5 = false;
                            }
                            if (!matched5) {
                                ParserMacroMethods_this.__restoreState(mark4);
                            }
                            bl10 = true;
                        } else {
                            bl10 = matched4 = false;
                        }
                        if (!matched4) {
                            ParserMacroMethods_this.__restoreState(mark3);
                        }
                        bl7 = true;
                    } else {
                        bl7 = matched3 = false;
                    }
                    if (!matched3) {
                        ParserMacroMethods_this.__restoreState(mark2);
                    }
                    bl4 = true;
                } else {
                    bl4 = matched2 = false;
                }
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> IP$minusliteral() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$26(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean bl2 = ll2 = ParserMacroMethods_this.cursorChar() == '[' && ParserMacroMethods_this.__advance();
            boolean bl3 = ll2 ? this.ipv6Host() != null : (ll = false);
            bl = ll ? ParserMacroMethods_this.cursorChar() == ']' && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> ipv4Host() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$27(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3;
            boolean matched2;
            int start1 = ParserMacroMethods_this.cursor();
            boolean bl4 = matched2 = this.ip$minusv4$minusaddress() != null;
            if (matched2) {
                ParserMacroMethods_this.valueStack().push(ParserMacroMethods_this.input().sliceString(start1, ParserMacroMethods_this.cursor()));
                bl3 = true;
            } else {
                bl3 = ll2 = false;
            }
            if (ll2) {
                long mark = ParserMacroMethods_this.__saveState();
                boolean matched3 = CharacterClasses$.MODULE$.colonSlashEOI().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = matched3;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                String a = (String)ParserMacroMethods_this.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this.valueStack().pop();
                this._host = Uri$IPv4Host$.MODULE$.apply(b, a);
                bl = ParserMacroMethods_this.__push(BoxedUnit.UNIT);
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> ipv6Host() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$28(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean matched2;
            int start1 = ParserMacroMethods_this.cursor();
            boolean bl3 = matched2 = this.ip$minusv6$minusaddress() != null;
            if (matched2) {
                ParserMacroMethods_this.valueStack().push(ParserMacroMethods_this.input().sliceString(start1, ParserMacroMethods_this.cursor()));
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                String a = (String)ParserMacroMethods_this.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this.valueStack().pop();
                this.setHost(Uri$IPv6Host$.MODULE$.apply(b, a));
                bl = ParserMacroMethods_this.__push(BoxedUnit.UNIT);
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Rule<HNil, HNil> reg$minusname() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$29(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSBForDecoding() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$8(ParserMacroMethods_this, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                this.setHost(Uri$NamedHost$.MODULE$.apply(this.getDecodedStringAndLowerIfEncoded(org.parboiled2.package$.MODULE$.UTF8())));
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                this.setHost(Uri$Host$Empty$.MODULE$);
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusabempty() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$30(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean bl2 = ll2 = this.clearSB() != null;
            boolean bl3 = ll2 ? this.slashSegments() != null : (ll = false);
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusabsolute() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$31(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            boolean bl3 = ll4 = this.clearSB() != null;
            boolean bl4 = ll4 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl5 = ll3 ? this.appendSB('/') != null : (ll2 = false);
            if (ll2) {
                boolean matched2;
                boolean ll5;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll5 = this.segment$minusnz() != null;
                boolean bl7 = ll5 ? this.slashSegments() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusnoscheme() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$32(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = this.clearSB() != null;
            boolean bl3 = ll3 ? this.segment$minusnz$minusnc() != null : (ll2 = false);
            boolean bl4 = ll2 ? this.slashSegments() != null : (ll = false);
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusrootless() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$33(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = this.clearSB() != null;
            boolean bl3 = ll3 ? this.segment$minusnz() != null : (ll2 = false);
            boolean bl4 = ll2 ? this.slashSegments() != null : (ll = false);
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusempty() {
        boolean matched;
        UriParser ParserMacroMethods_this = this;
        boolean bl = ParserMacroMethods_this.__inErrorAnalysis() ? this.wrapped$34(ParserMacroMethods_this) : (matched = this.MATCH() != null);
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> slashSegments() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$35(ParserMacroMethods_this);
        } else {
            ParserMacroMethods_this.__restoreState(this.rec$10(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
            bl = matched = true;
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> segment() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$36(ParserMacroMethods_this);
        } else {
            ParserMacroMethods_this.__restoreState(this.rec$12(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
            bl = matched = true;
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, HNil> segment$minusnz() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$37(ParserMacroMethods_this);
        } else {
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$14(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return Rule$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, HNil> segment$minusnz$minusnc() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$38(ParserMacroMethods_this);
        } else {
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$16(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return Rule$.MODULE$;
    }

    public Rule<HNil, HNil> pchar() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$39(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean ll;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl2 = ll = this.path$minussegment$minuschar.apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Rule<HNil, HNil> rawQueryString() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$40(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSB() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$18(ParserMacroMethods_this, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                this.setRawQueryString(this.sb().toString());
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                this.setRawQueryString("");
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, $colon$colon<Uri.Query, HNil>> query() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$45(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl3 = ll = ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance();
            if (ll) {
                ParserMacroMethods_this.valueStack().push(Uri$Query$Empty$.MODULE$);
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.keyValuePairs$1() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Rule<HNil, HNil> fragment() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$46(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSBForDecoding() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$24(ParserMacroMethods_this, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                this.setFragment(this.getDecodedString(this.getDecodedString$default$1()));
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                this.setFragment("");
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> pct$minusencoded() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$47(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = ParserMacroMethods_this.cursorChar() == '%' && ParserMacroMethods_this.__advance();
            boolean bl3 = ll3 ? CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl4 = ll2 ? CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance() : (ll = false);
            if (ll) {
                if (this._firstPercentIx == -1) {
                    this._firstPercentIx = this.sb().length();
                }
                this.sb().append('%').append(this.charAt(-2)).append(this.lastChar());
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, HNil> absolute$minuspath() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$48(ParserMacroMethods_this);
        } else {
            if (this.clearSB() == null) return null;
            boolean bl2 = true;
            boolean ll = bl2;
            if (!ll) return null;
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$26(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            boolean bl3 = true;
            boolean ll2 = bl3;
            if (!ll2) return null;
            if (this.savePath() == null) return null;
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return Rule$.MODULE$;
    }

    public Rule<HNil, HNil> request$minustarget() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$49(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean ll;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll = this.absolute$minuspath() != null;
            if (ll) {
                boolean matched2;
                boolean ll2;
                long mark2 = ParserMacroMethods_this.__saveState();
                boolean bl5 = ll2 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl6 = ll2 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark2);
                }
                bl3 = true;
            } else {
                bl3 = l2 = false;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.absolute$minusURI() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.authority() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Uri parseHttpRequestTarget() {
        Parser.DeliveryScheme scheme$proxy9 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHttpRequestTarget$$anonfun$1, scheme$proxy9);
        if (either instanceof Right) {
            Uri.Path path = this._scheme.isEmpty() ? this._path : Uri$.MODULE$.collapseDotSegments(this._path);
            return Uri$.MODULE$.createUnsafe(this._scheme, Uri$Authority$.MODULE$.apply(this._host, this._port, this._userinfo), path, this._rawQueryString, this._fragment);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "request-target");
        }
        throw new MatchError(either);
    }

    public Rule<HNil, HNil> http2$minusauthority$minuspseudo$minusheader() {
        return this.hostAndPort();
    }

    public Uri.Authority parseHttp2AuthorityPseudoHeader() {
        Parser.DeliveryScheme scheme$proxy10 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHttp2AuthorityPseudoHeader$$anonfun$1, scheme$proxy10);
        if (either instanceof Right) {
            return Uri$Authority$.MODULE$.apply(this._host, this._port, Uri$Authority$.MODULE$.$lessinit$greater$default$3());
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "http2-authority-pseudo-header");
        }
        throw new MatchError(either);
    }

    public Rule<HNil, HNil> http2$minuspath$minuspseudo$minusheader() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$52(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.absolute$minuspath() != null;
            if (ll) {
                boolean matched2;
                boolean ll2;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl3 = ll2 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl4 = ll2 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    public Tuple2<Uri.Path, Option<String>> parseHttp2PathPseudoHeader() {
        Parser.DeliveryScheme scheme$proxy11 = Parser$DeliveryScheme$.MODULE$.Either(Unpack$HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHttp2PathPseudoHeader$$anonfun$1, scheme$proxy11);
        if (either instanceof Right) {
            Uri.Path path = Uri$.MODULE$.collapseDotSegments(this._path);
            return Tuple2$.MODULE$.apply(path, this._rawQueryString);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "http2-path-pseudo-header");
        }
        throw new MatchError(either);
    }

    private Rule<HNil, HNil> appendLowered() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$54(ParserMacroMethods_this);
        } else {
            this.sb().append(CharUtils$.MODULE$.toLowerCase(this.lastChar()));
            bl = matched = true;
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private Rule<HNil, HNil> savePath() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$55(ParserMacroMethods_this);
        } else {
            this.setPath(Uri$Path$.MODULE$.apply(this.sb().toString(), this.uriParsingCharset()));
            bl = matched = true;
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private Rule<HNil, HNil> clearSBForDecoding() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$56(ParserMacroMethods_this);
        } else {
            this.sb().setLength(0);
            this._firstPercentIx = -1;
            bl = matched = true;
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private String getDecodedString(Charset charset) {
        if (this._firstPercentIx >= 0) {
            String string2 = this.sb().toString();
            int n = this._firstPercentIx;
            return Uri$.MODULE$.decode(string2, charset, n, Uri$.MODULE$.decode$default$4(string2, charset, n));
        }
        return this.sb().toString();
    }

    private Charset getDecodedString$default$1() {
        return this.uriParsingCharset();
    }

    private String getDecodedStringAndLowerIfEncoded(Charset charset) {
        if (this._firstPercentIx >= 0) {
            String string2 = this.sb().toString();
            int n = this._firstPercentIx;
            return EnhancedString$.MODULE$.toRootLowerCase$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(Uri$.MODULE$.decode(string2, charset, n, Uri$.MODULE$.decode$default$4(string2, charset, n))));
        }
        return this.sb().toString();
    }

    private Uri createUriReference() {
        Uri.Path path = this._scheme.isEmpty() ? this._path : Uri$.MODULE$.collapseDotSegments(this._path);
        return Uri$.MODULE$.createUnsafe(this._scheme, Uri$Authority$.MODULE$.apply(this._host, Uri$.MODULE$.normalizePort(this._port, this._scheme), this._userinfo), path, this._rawQueryString, this._fragment);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$1(UriParser ParserMacroMethods_this$1) {
        int start = ParserMacroMethods_this$1.cursor();
        try {
            int start2 = ParserMacroMethods_this$1.cursor();
            try {
                if (this.absolute$minusURI() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$1.cursorChar() == this.EOI() && ParserMacroMethods_this$1.__advance()) {
                        if (ParserMacroMethods_this$1.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$1.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$1.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseAbsoluteUri"), start);
        }
    }

    private final Rule parseAbsoluteUri$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$1(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.absolute$minusURI() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$2(UriParser ParserMacroMethods_this$2) {
        int start = ParserMacroMethods_this$2.cursor();
        try {
            int start2 = ParserMacroMethods_this$2.cursor();
            try {
                if (this.URI$minusreference() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$2.cursorChar() == this.EOI() && ParserMacroMethods_this$2.__advance()) {
                        if (ParserMacroMethods_this$2.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$2.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$2.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseUriReference"), start);
        }
    }

    private final Rule parseUriReference$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$2(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.URI$minusreference() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$3(UriParser ParserMacroMethods_this$3) {
        int start = ParserMacroMethods_this$3.cursor();
        try {
            int start2 = ParserMacroMethods_this$3.cursor();
            try {
                if (this.URI$minusreference() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$3.cursorChar() == this.EOI() && ParserMacroMethods_this$3.__advance()) {
                        if (ParserMacroMethods_this$3.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$3.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$3.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseAndResolveUriReference"), start);
        }
    }

    private final Rule parseAndResolveUriReference$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$3(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.URI$minusreference() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$4(UriParser ParserMacroMethods_this$4) {
        int start = ParserMacroMethods_this$4.cursor();
        try {
            int start2 = ParserMacroMethods_this$4.cursor();
            try {
                if (this.origin() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$4.cursorChar() == this.EOI() && ParserMacroMethods_this$4.__advance()) {
                        if (ParserMacroMethods_this$4.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$4.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$4.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseOrigin"), start);
        }
    }

    private final Rule parseOrigin$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$4(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.origin() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$5(UriParser ParserMacroMethods_this$5) {
        int start = ParserMacroMethods_this$5.cursor();
        try {
            int start2 = ParserMacroMethods_this$5.cursor();
            try {
                if (this.relaxedHost() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$5.cursorChar() == this.EOI() && ParserMacroMethods_this$5.__advance()) {
                        if (ParserMacroMethods_this$5.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$5.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$5.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseHost"), start);
        }
    }

    private final Rule parseHost$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$5(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.relaxedHost() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$6(UriParser ParserMacroMethods_this$6) {
        int start = ParserMacroMethods_this$6.cursor();
        try {
            int start2 = ParserMacroMethods_this$6.cursor();
            try {
                if (this.rawQueryString() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$6.cursorChar() == this.EOI() && ParserMacroMethods_this$6.__advance()) {
                        if (ParserMacroMethods_this$6.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$6.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$6.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseRawQueryString"), start);
        }
    }

    private final Rule parseRawQueryString$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$6(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.rawQueryString() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$7(UriParser ParserMacroMethods_this$7) {
        int start = ParserMacroMethods_this$7.cursor();
        try {
            int start2 = ParserMacroMethods_this$7.cursor();
            try {
                if (this.query() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$7.cursorChar() == this.EOI() && ParserMacroMethods_this$7.__advance()) {
                        if (ParserMacroMethods_this$7.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$7.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$7.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseQuery"), start);
        }
    }

    private final Rule parseQuery$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$7(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.query() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$8(UriParser ParserMacroMethods_this$8) {
        int start = ParserMacroMethods_this$8.cursor();
        try {
            int start2 = ParserMacroMethods_this$8.cursor();
            try {
                if (this.authority() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$8.cursorChar() == this.EOI() && ParserMacroMethods_this$8.__advance()) {
                        if (ParserMacroMethods_this$8.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$8.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$8.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseAuthority"), start);
        }
    }

    private final Rule parseAuthority$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$8(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.authority() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private static final boolean liftedTree1$1(UriParser ParserMacroMethods_this$12) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$12.cursorChar() == ':' && ParserMacroMethods_this$12.__advance() && ParserMacroMethods_this$12.__updateMaxCursor() || ParserMacroMethods_this$12.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$12.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    private final boolean liftedTree2$1(UriParser ParserMacroMethods_this$11, int start$2) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.scheme() != null;
            bl = ll ? UriParser.liftedTree1$1(ParserMacroMethods_this$11) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$2);
        }
        return bl;
    }

    private final boolean liftedTree3$1(UriParser ParserMacroMethods_this$10, int start$1) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$10.cursor();
            boolean ll = this.liftedTree2$1(ParserMacroMethods_this$10, start);
            bl = ll ? this.hier$minuspart() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$1);
        }
        return bl;
    }

    private static final boolean liftedTree4$1(UriParser ParserMacroMethods_this$14) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$14.cursorChar() == '?' && ParserMacroMethods_this$14.__advance() && ParserMacroMethods_this$14.__updateMaxCursor() || ParserMacroMethods_this$14.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$14.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('?'));
        }
        return bl;
    }

    private final boolean liftedTree5$1(UriParser ParserMacroMethods_this$13, int start$3) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree4$1(ParserMacroMethods_this$13);
            bl = ll ? this.rawQueryString() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$3);
        }
        return bl;
    }

    private static final boolean liftedTree6$1(UriParser ParserMacroMethods_this$15) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$15.cursorChar() == '#' && ParserMacroMethods_this$15.__advance() && ParserMacroMethods_this$15.__updateMaxCursor() || ParserMacroMethods_this$15.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$15.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('#'));
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$9(UriParser ParserMacroMethods_this$9) {
        int start = ParserMacroMethods_this$9.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$9.cursor();
            int start3 = ParserMacroMethods_this$9.cursor();
            try {
                int start4 = ParserMacroMethods_this$9.cursor();
                boolean ll = this.liftedTree3$1(ParserMacroMethods_this$9, start4);
                if (!ll) return false;
                int start5 = ParserMacroMethods_this$9.cursor();
                try {
                    long mark = ParserMacroMethods_this$9.__saveState();
                    int start6 = ParserMacroMethods_this$9.cursor();
                    boolean matched = this.liftedTree5$1(ParserMacroMethods_this$9, start6);
                    if (!matched) {
                        ParserMacroMethods_this$9.__restoreState(mark);
                    }
                    bl2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start5);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start7 = ParserMacroMethods_this$9.cursor();
            long mark = ParserMacroMethods_this$9.__saveState();
            int start8 = ParserMacroMethods_this$9.cursor();
            try {
                boolean ll2 = UriParser.liftedTree6$1(ParserMacroMethods_this$9);
                bl = ll2 ? this.fragment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start8);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start7);
                }
            }
            boolean matched = bl;
            if (!matched) {
                ParserMacroMethods_this$9.__restoreState(mark);
            }
            boolean bl3 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
                }
            }
            return bl3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("URI"), start);
        }
    }

    private static final boolean liftedTree7$1(UriParser ParserMacroMethods_this$19) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$19.cursorChar() == ':' && ParserMacroMethods_this$19.__advance() && ParserMacroMethods_this$19.__updateMaxCursor() || ParserMacroMethods_this$19.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$19.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    private final boolean liftedTree8$1(UriParser ParserMacroMethods_this$18, int start$5) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.scheme() != null;
            bl = ll ? UriParser.liftedTree7$1(ParserMacroMethods_this$18) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$5);
        }
        return bl;
    }

    private static final boolean liftedTree9$1(UriParser ParserMacroMethods_this$20) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$20.cursorChar() == '/' && ParserMacroMethods_this$20.__advance() && ParserMacroMethods_this$20.__updateMaxCursor() || ParserMacroMethods_this$20.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$20.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private final boolean liftedTree10$1(UriParser ParserMacroMethods_this$17, int start$4) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$17.cursor();
            boolean ll = this.liftedTree8$1(ParserMacroMethods_this$17, start);
            bl = ll ? UriParser.liftedTree9$1(ParserMacroMethods_this$17) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$4);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$10(UriParser ParserMacroMethods_this$16) {
        int start = ParserMacroMethods_this$16.cursor();
        try {
            int start2 = ParserMacroMethods_this$16.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$16.cursor();
                try {
                    int start4 = ParserMacroMethods_this$16.cursor();
                    boolean ll = this.liftedTree10$1(ParserMacroMethods_this$16, start4);
                    if (!ll) return false;
                    try {
                        if (ParserMacroMethods_this$16.cursorChar() != '/' || !ParserMacroMethods_this$16.__advance() || !ParserMacroMethods_this$16.__updateMaxCursor()) {
                            if (!ParserMacroMethods_this$16.__registerMismatch()) return false;
                        }
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$16.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) {
                    return false;
                }
                if (this.hostAndPort() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("origin"), start);
        }
    }

    private static final boolean liftedTree11$1(UriParser ParserMacroMethods_this$25) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$25.cursorChar() == '/' && ParserMacroMethods_this$25.__advance() && ParserMacroMethods_this$25.__updateMaxCursor() || ParserMacroMethods_this$25.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$25.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private static final boolean liftedTree12$1(UriParser ParserMacroMethods_this$26) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$26.cursorChar() == '/' && ParserMacroMethods_this$26.__advance() && ParserMacroMethods_this$26.__updateMaxCursor() || ParserMacroMethods_this$26.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$26.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private static final boolean liftedTree13$1(UriParser ParserMacroMethods_this$24, int start$8) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree11$1(ParserMacroMethods_this$24);
            bl = ll ? UriParser.liftedTree12$1(ParserMacroMethods_this$24) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$8);
        }
        return bl;
    }

    private final boolean liftedTree14$1(UriParser ParserMacroMethods_this$23, int start$7) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$23.cursor();
            boolean ll = UriParser.liftedTree13$1(ParserMacroMethods_this$23, start);
            bl = ll ? this.authority() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$7);
        }
        return bl;
    }

    private final boolean liftedTree15$1(UriParser ParserMacroMethods_this$22, int start$6) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$22.cursor();
            boolean ll = this.liftedTree14$1(ParserMacroMethods_this$22, start);
            bl = ll ? this.path$minusabempty() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$6);
        }
        return bl;
    }

    private final boolean wrapped$11(UriParser ParserMacroMethods_this$21) {
        boolean bl;
        int start = ParserMacroMethods_this$21.cursor();
        try {
            int start2 = ParserMacroMethods_this$21.cursor();
            try {
                boolean l;
                boolean bl2;
                boolean l2;
                boolean bl3;
                long mark = ParserMacroMethods_this$21.__saveState();
                int start3 = ParserMacroMethods_this$21.cursor();
                boolean l3 = this.liftedTree15$1(ParserMacroMethods_this$21, start3);
                if (!l3) {
                    ParserMacroMethods_this$21.__restoreState(mark);
                    bl3 = this.path$minusabsolute() != null;
                } else {
                    bl3 = l2 = true;
                }
                if (!l2) {
                    ParserMacroMethods_this$21.__restoreState(mark);
                    bl2 = this.path$minusrootless() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$21.__restoreState(mark);
                    bl = this.path$minusempty() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("hier-part"), start);
        }
        return bl;
    }

    private final boolean wrapped$12(UriParser ParserMacroMethods_this$27) {
        boolean bl;
        int start = ParserMacroMethods_this$27.cursor();
        try {
            int start2 = ParserMacroMethods_this$27.cursor();
            try {
                boolean l;
                long mark = ParserMacroMethods_this$27.__saveState();
                boolean bl2 = l = this.URI() != null;
                if (!l) {
                    ParserMacroMethods_this$27.__restoreState(mark);
                    bl = this.relative$minusref() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("URI-reference"), start);
        }
        return bl;
    }

    private final boolean wrapped$13(UriParser ParserMacroMethods_this$28) {
        boolean bl;
        int start = ParserMacroMethods_this$28.cursor();
        try {
            int start2 = ParserMacroMethods_this$28.cursor();
            try {
                boolean ll;
                boolean bl2 = ll = this.URI$minusreference() != null;
                if (ll) {
                    ParserMacroMethods_this$28.valueStack().push(this.createUriReference());
                    bl = true;
                } else {
                    bl = false;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("URI-reference-pushed"), start);
        }
        return bl;
    }

    private static final boolean liftedTree16$1(UriParser ParserMacroMethods_this$31) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$31.cursorChar() == ':' && ParserMacroMethods_this$31.__advance() && ParserMacroMethods_this$31.__updateMaxCursor() || ParserMacroMethods_this$31.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$31.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    private final boolean liftedTree17$1(UriParser ParserMacroMethods_this$30, int start$9) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.scheme() != null;
            bl = ll ? UriParser.liftedTree16$1(ParserMacroMethods_this$30) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$9);
        }
        return bl;
    }

    private static final boolean liftedTree18$1(UriParser ParserMacroMethods_this$32) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$32.cursorChar() == '?' && ParserMacroMethods_this$32.__advance() && ParserMacroMethods_this$32.__updateMaxCursor() || ParserMacroMethods_this$32.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$32.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('?'));
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$14(UriParser ParserMacroMethods_this$29) {
        int start = ParserMacroMethods_this$29.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$29.cursor();
            int start3 = ParserMacroMethods_this$29.cursor();
            try {
                int start4 = ParserMacroMethods_this$29.cursor();
                boolean ll = this.liftedTree17$1(ParserMacroMethods_this$29, start4);
                if (!ll) return false;
                if (this.hier$minuspart() == null) return false;
                bl2 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start5 = ParserMacroMethods_this$29.cursor();
            long mark = ParserMacroMethods_this$29.__saveState();
            int start6 = ParserMacroMethods_this$29.cursor();
            try {
                boolean ll2 = UriParser.liftedTree18$1(ParserMacroMethods_this$29);
                bl = ll2 ? this.rawQueryString() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start6);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start5);
                }
            }
            boolean matched = bl;
            if (!matched) {
                ParserMacroMethods_this$29.__restoreState(mark);
            }
            boolean bl3 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
                }
            }
            return bl3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("absolute-URI"), start);
        }
    }

    private static final boolean liftedTree19$1(UriParser ParserMacroMethods_this$35) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$35.cursorChar() == '?' && ParserMacroMethods_this$35.__advance() && ParserMacroMethods_this$35.__updateMaxCursor() || ParserMacroMethods_this$35.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$35.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('?'));
        }
        return bl;
    }

    private final boolean liftedTree20$1(UriParser ParserMacroMethods_this$34, int start$10) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree19$1(ParserMacroMethods_this$34);
            bl = ll ? this.rawQueryString() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$10);
        }
        return bl;
    }

    private static final boolean liftedTree21$1(UriParser ParserMacroMethods_this$36) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$36.cursorChar() == '#' && ParserMacroMethods_this$36.__advance() && ParserMacroMethods_this$36.__updateMaxCursor() || ParserMacroMethods_this$36.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$36.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('#'));
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$15(UriParser ParserMacroMethods_this$33) {
        int start = ParserMacroMethods_this$33.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$33.cursor();
            int start3 = ParserMacroMethods_this$33.cursor();
            try {
                if (this.relative$minuspart() == null) return false;
                boolean bl3 = true;
                boolean ll = bl3;
                if (!ll) return false;
                int start4 = ParserMacroMethods_this$33.cursor();
                try {
                    long mark = ParserMacroMethods_this$33.__saveState();
                    int start5 = ParserMacroMethods_this$33.cursor();
                    boolean matched = this.liftedTree20$1(ParserMacroMethods_this$33, start5);
                    if (!matched) {
                        ParserMacroMethods_this$33.__restoreState(mark);
                    }
                    bl2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start4);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start6 = ParserMacroMethods_this$33.cursor();
            long mark = ParserMacroMethods_this$33.__saveState();
            int start7 = ParserMacroMethods_this$33.cursor();
            try {
                boolean ll2 = UriParser.liftedTree21$1(ParserMacroMethods_this$33);
                bl = ll2 ? this.fragment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start7);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start6);
                }
            }
            boolean matched = bl;
            if (!matched) {
                ParserMacroMethods_this$33.__restoreState(mark);
            }
            boolean bl4 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
                }
            }
            return bl4;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("relative-ref"), start);
        }
    }

    private static final boolean liftedTree22$1(UriParser ParserMacroMethods_this$41) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$41.cursorChar() == '/' && ParserMacroMethods_this$41.__advance() && ParserMacroMethods_this$41.__updateMaxCursor() || ParserMacroMethods_this$41.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$41.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private static final boolean liftedTree23$1(UriParser ParserMacroMethods_this$42) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$42.cursorChar() == '/' && ParserMacroMethods_this$42.__advance() && ParserMacroMethods_this$42.__updateMaxCursor() || ParserMacroMethods_this$42.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$42.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private static final boolean liftedTree24$1(UriParser ParserMacroMethods_this$40, int start$13) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree22$1(ParserMacroMethods_this$40);
            bl = ll ? UriParser.liftedTree23$1(ParserMacroMethods_this$40) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$13);
        }
        return bl;
    }

    private final boolean liftedTree25$1(UriParser ParserMacroMethods_this$39, int start$12) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$39.cursor();
            boolean ll = UriParser.liftedTree24$1(ParserMacroMethods_this$39, start);
            bl = ll ? this.authority() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$12);
        }
        return bl;
    }

    private final boolean liftedTree26$1(UriParser ParserMacroMethods_this$38, int start$11) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$38.cursor();
            boolean ll = this.liftedTree25$1(ParserMacroMethods_this$38, start);
            bl = ll ? this.path$minusabempty() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$11);
        }
        return bl;
    }

    private final boolean wrapped$16(UriParser ParserMacroMethods_this$37) {
        boolean bl;
        int start = ParserMacroMethods_this$37.cursor();
        try {
            int start2 = ParserMacroMethods_this$37.cursor();
            try {
                boolean l;
                boolean bl2;
                boolean l2;
                boolean bl3;
                long mark = ParserMacroMethods_this$37.__saveState();
                int start3 = ParserMacroMethods_this$37.cursor();
                boolean l3 = this.liftedTree26$1(ParserMacroMethods_this$37, start3);
                if (!l3) {
                    ParserMacroMethods_this$37.__restoreState(mark);
                    bl3 = this.path$minusabsolute() != null;
                } else {
                    bl3 = l2 = true;
                }
                if (!l2) {
                    ParserMacroMethods_this$37.__restoreState(mark);
                    bl2 = this.path$minusnoscheme() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$37.__restoreState(mark);
                    bl = this.path$minusempty() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("relative-part"), start);
        }
        return bl;
    }

    private static final boolean liftedTree27$1(UriParser ParserMacroMethods_this$47) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$47.cursorChar() == 'h' && ParserMacroMethods_this$47.__advance() && ParserMacroMethods_this$47.__updateMaxCursor() || ParserMacroMethods_this$47.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$47.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('h'));
        }
        return bl;
    }

    private static final boolean liftedTree28$1(UriParser ParserMacroMethods_this$48) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$48.cursorChar() == 't' && ParserMacroMethods_this$48.__advance() && ParserMacroMethods_this$48.__updateMaxCursor() || ParserMacroMethods_this$48.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$48.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('t'));
        }
        return bl;
    }

    private static final boolean liftedTree29$1(UriParser ParserMacroMethods_this$46, int start$16) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree27$1(ParserMacroMethods_this$46);
            bl = ll ? UriParser.liftedTree28$1(ParserMacroMethods_this$46) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$16);
        }
        return bl;
    }

    private static final boolean liftedTree30$1(UriParser ParserMacroMethods_this$49) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$49.cursorChar() == 't' && ParserMacroMethods_this$49.__advance() && ParserMacroMethods_this$49.__updateMaxCursor() || ParserMacroMethods_this$49.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$49.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('t'));
        }
        return bl;
    }

    private static final boolean liftedTree31$1(UriParser ParserMacroMethods_this$45, int start$15) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$45.cursor();
            boolean ll = UriParser.liftedTree29$1(ParserMacroMethods_this$45, start);
            bl = ll ? UriParser.liftedTree30$1(ParserMacroMethods_this$45) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$15);
        }
        return bl;
    }

    private static final boolean liftedTree32$1(UriParser ParserMacroMethods_this$50) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$50.cursorChar() == 'p' && ParserMacroMethods_this$50.__advance() && ParserMacroMethods_this$50.__updateMaxCursor() || ParserMacroMethods_this$50.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$50.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('p'));
        }
        return bl;
    }

    private static final boolean liftedTree33$1(UriParser ParserMacroMethods_this$44, int start$14) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$44.cursor();
            boolean ll = UriParser.liftedTree31$1(ParserMacroMethods_this$44, start);
            bl = ll ? UriParser.liftedTree32$1(ParserMacroMethods_this$44) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$14);
        }
        return bl;
    }

    private static final boolean liftedTree34$1(UriParser ParserMacroMethods_this$53) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$53.cursorChar() == ':' && ParserMacroMethods_this$53.__advance() && ParserMacroMethods_this$53.__updateMaxCursor() || ParserMacroMethods_this$53.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$53.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    private static final boolean liftedTree35$1(UriParser ParserMacroMethods_this$52, int start$18) {
        boolean bl;
        try {
            long mark = ParserMacroMethods_this$52.__saveState();
            boolean matched = UriParser.liftedTree34$1(ParserMacroMethods_this$52);
            ParserMacroMethods_this$52.__restoreState(mark);
            bl = matched;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$AndPredicate$.MODULE$, start$18);
        }
        return bl;
    }

    private final boolean liftedTree36$1(int start$19) {
        boolean bl;
        try {
            this.setScheme("http");
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Run$.MODULE$, start$19);
        }
        return bl;
    }

    private final boolean liftedTree37$1(UriParser ParserMacroMethods_this$51, int start$17) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$51.cursor();
            boolean ll = UriParser.liftedTree35$1(ParserMacroMethods_this$51, start);
            if (ll) {
                int start2 = ParserMacroMethods_this$51.cursor();
                bl = this.liftedTree36$1(start2);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$17);
        }
        return bl;
    }

    private static final boolean liftedTree38$1(UriParser ParserMacroMethods_this$55) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$55.cursorChar() == 's' && ParserMacroMethods_this$55.__advance() && ParserMacroMethods_this$55.__updateMaxCursor() || ParserMacroMethods_this$55.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$55.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('s'));
        }
        return bl;
    }

    private static final boolean liftedTree39$1(UriParser ParserMacroMethods_this$57) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$57.cursorChar() == ':' && ParserMacroMethods_this$57.__advance() && ParserMacroMethods_this$57.__updateMaxCursor() || ParserMacroMethods_this$57.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$57.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    private static final boolean liftedTree40$1(UriParser ParserMacroMethods_this$56, int start$21) {
        boolean bl;
        try {
            long mark = ParserMacroMethods_this$56.__saveState();
            boolean matched = UriParser.liftedTree39$1(ParserMacroMethods_this$56);
            ParserMacroMethods_this$56.__restoreState(mark);
            bl = matched;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$AndPredicate$.MODULE$, start$21);
        }
        return bl;
    }

    private static final boolean liftedTree41$1(UriParser ParserMacroMethods_this$54, int start$20) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree38$1(ParserMacroMethods_this$54);
            if (ll) {
                int start = ParserMacroMethods_this$54.cursor();
                bl = UriParser.liftedTree40$1(ParserMacroMethods_this$54, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$20);
        }
        return bl;
    }

    private static final boolean liftedTree42$1(UriParser ParserMacroMethods_this$61) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.ALPHA().apply(ParserMacroMethods_this$61.cursorChar()) && ParserMacroMethods_this$61.__advance() && ParserMacroMethods_this$61.__updateMaxCursor() || ParserMacroMethods_this$61.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("ALPHA"), 0);
            throw ParserMacroMethods_this$61.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.ALPHA()));
        }
        return bl;
    }

    private final boolean liftedTree43$1(UriParser ParserMacroMethods_this$60, int start$24) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSB() != null;
            bl = ll ? UriParser.liftedTree42$1(ParserMacroMethods_this$60) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$24);
        }
        return bl;
    }

    private final boolean liftedTree44$1(UriParser ParserMacroMethods_this$59, int start$23) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$59.cursor();
            boolean ll = this.liftedTree43$1(ParserMacroMethods_this$59, start);
            bl = ll ? this.appendLowered() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$23);
        }
        return bl;
    }

    private static final boolean liftedTree45$1(UriParser ParserMacroMethods_this$64) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$64.cursorChar()) && ParserMacroMethods_this$64.__advance() && ParserMacroMethods_this$64.__updateMaxCursor() || ParserMacroMethods_this$64.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("scheme-char"), 0);
            throw ParserMacroMethods_this$64.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.scheme$minuschar()));
        }
        return bl;
    }

    private final long rec$1(UriParser ParserMacroMethods_this$63, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$63.cursor();
            try {
                boolean ll = UriParser.liftedTree45$1(ParserMacroMethods_this$63);
                bl = ll ? this.appendLowered() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$63.__saveState();
        }
        return mark;
    }

    private final boolean liftedTree46$1(UriParser ParserMacroMethods_this$62, int start$25) {
        boolean bl;
        try {
            ParserMacroMethods_this$62.__restoreState(this.rec$1(ParserMacroMethods_this$62, ParserMacroMethods_this$62.__saveState()));
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$ZeroOrMore$.MODULE$, start$25);
        }
        return bl;
    }

    private final boolean liftedTree47$1(UriParser ParserMacroMethods_this$58, int start$22) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$58.cursor();
            boolean ll = this.liftedTree44$1(ParserMacroMethods_this$58, start);
            if (ll) {
                int start2 = ParserMacroMethods_this$58.cursor();
                bl = this.liftedTree46$1(ParserMacroMethods_this$58, start2);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$22);
        }
        return bl;
    }

    private static final boolean liftedTree48$1(UriParser ParserMacroMethods_this$65) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$65.cursorChar() == ':' && ParserMacroMethods_this$65.__advance() && ParserMacroMethods_this$65.__updateMaxCursor() || ParserMacroMethods_this$65.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$65.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$17(UriParser ParserMacroMethods_this$43) {
        start = ParserMacroMethods_this$43.cursor();
        try {
            block39: {
                block38: {
                    block37: {
                        start = ParserMacroMethods_this$43.cursor();
                        mark = ParserMacroMethods_this$43.__saveState();
                        start = ParserMacroMethods_this$43.cursor();
                        try {
                            start = ParserMacroMethods_this$43.cursor();
                            ll = UriParser.liftedTree33$1(ParserMacroMethods_this$43, start);
                            if (ll) {
                                start = ParserMacroMethods_this$43.cursor();
                                try {
                                    mark = ParserMacroMethods_this$43.__saveState();
                                    start = ParserMacroMethods_this$43.cursor();
                                    l = this.liftedTree37$1(ParserMacroMethods_this$43, start);
                                    if (l != false) return true;
                                    ParserMacroMethods_this$43.__restoreState(mark);
                                    start = ParserMacroMethods_this$43.cursor();
                                    try {
                                        start = ParserMacroMethods_this$43.cursor();
                                        ll = UriParser.liftedTree41$1(ParserMacroMethods_this$43, start);
                                        if (ll) {
                                            start = ParserMacroMethods_this$43.cursor();
                                            try {
                                                this.setScheme("https");
                                                return true;
                                            }
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start);
                                            }
                                        }
                                        v0 = false;
                                        break block37;
                                    }
                                    catch (Parser.TracingBubbleException e) {
                                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                                    }
                                }
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
                                }
                            }
                            v0 = false;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                        }
                    }
                    l = v0;
                    if (l != false) return true;
                    ParserMacroMethods_this$43.__restoreState(mark);
                    start = ParserMacroMethods_this$43.cursor();
                    start = ParserMacroMethods_this$43.cursor();
                    try {
                        start = ParserMacroMethods_this$43.cursor();
                        ll = this.liftedTree47$1(ParserMacroMethods_this$43, start);
                        if (ll) {
                            start = ParserMacroMethods_this$43.cursor();
                            try {
                                mark = ParserMacroMethods_this$43.__saveState();
                                matched = UriParser.liftedTree48$1(ParserMacroMethods_this$43);
                                ParserMacroMethods_this$43.__restoreState(mark);
                                v1 = matched;
                                break block38;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp(RuleTrace$AndPredicate$.MODULE$, start);
                            }
                        }
                        v1 = false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                    }
                }
                ll = v1;
                if (!ll) ** GOTO lbl78
                start = ParserMacroMethods_this$43.cursor();
                try {
                    this.setScheme(this.sb().toString());
                    v2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Run$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                    }
                }
                break block39;
lbl78:
                // 1 sources

                v2 = false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
                    }
                }
            }
            return v2;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("scheme"), start);
        }
    }

    private final long rec$2(UriParser ParserMacroMethods_this$66, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean bl = ll = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$66.cursorChar()) && ParserMacroMethods_this$66.__advance();
            boolean bl2 = ll ? this.appendLowered() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$66.__saveState();
        }
        return mark;
    }

    private static final boolean liftedTree49$1(UriParser ParserMacroMethods_this$70) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$70.cursorChar()) && ParserMacroMethods_this$70.__advance() && ParserMacroMethods_this$70.__updateMaxCursor() || ParserMacroMethods_this$70.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("scheme-char"), 0);
            throw ParserMacroMethods_this$70.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.scheme$minuschar()));
        }
        return bl;
    }

    private final long rec$3(UriParser ParserMacroMethods_this$69, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$69.cursor();
            try {
                boolean ll = UriParser.liftedTree49$1(ParserMacroMethods_this$69);
                bl = ll ? this.appendLowered() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$69.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean liftedTree50$1(UriParser ParserMacroMethods_this$68, int start$26) {
        try {
            long firstMark = ParserMacroMethods_this$68.__saveState();
            long mark = this.rec$3(ParserMacroMethods_this$68, firstMark);
            if (mark == firstMark) return false;
            ParserMacroMethods_this$68.__restoreState(mark);
            if (!true) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start$26);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$18(UriParser ParserMacroMethods_this$67) {
        int start = ParserMacroMethods_this$67.cursor();
        try {
            int start2 = ParserMacroMethods_this$67.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$67.cursor();
                try {
                    int start4 = ParserMacroMethods_this$67.cursor();
                    boolean ll = this.liftedTree50$1(ParserMacroMethods_this$67, start4);
                    if (!ll) return false;
                    int start5 = ParserMacroMethods_this$67.cursor();
                    try {
                        this.setScheme(this.sb().toString());
                        bl = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Run$.MODULE$, start5);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) return false;
                ParserMacroMethods_this$67.valueStack().push(this._scheme);
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("scheme-pushed"), start);
        }
    }

    private final long rec$4(UriParser ParserMacroMethods_this$71, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean bl = ll = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$71.cursorChar()) && ParserMacroMethods_this$71.__advance();
            boolean bl2 = ll ? this.appendLowered() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$71.__saveState();
        }
        return mark;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$19(UriParser ParserMacroMethods_this$72) {
        boolean bl;
        int start = ParserMacroMethods_this$72.cursor();
        try {
            int start2 = ParserMacroMethods_this$72.cursor();
            try {
                int start3 = ParserMacroMethods_this$72.cursor();
                try {
                    boolean matched;
                    long mark = ParserMacroMethods_this$72.__saveState();
                    boolean bl2 = matched = this.userinfo() != null;
                    if (!matched) {
                        ParserMacroMethods_this$72.__restoreState(mark);
                    }
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("authority"), start);
        }
        {
            boolean ll = bl;
            if (!ll) {
                return false;
            }
            if (this.hostAndPort() == null) return false;
            return true;
        }
    }

    private static final boolean liftedTree51$1(UriParser ParserMacroMethods_this$78) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.userinfo$minuschar().apply(ParserMacroMethods_this$78.cursorChar()) && ParserMacroMethods_this$78.__advance() && ParserMacroMethods_this$78.__updateMaxCursor() || ParserMacroMethods_this$78.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("userinfo-char"), 0);
            throw ParserMacroMethods_this$78.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.userinfo$minuschar()));
        }
        return bl;
    }

    private final boolean liftedTree52$1(UriParser ParserMacroMethods_this$77, int start$29) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree51$1(ParserMacroMethods_this$77);
            bl = ll ? this.appendSB() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$29);
        }
        return bl;
    }

    private final long rec$5(UriParser ParserMacroMethods_this$76, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$76.cursor();
            try {
                long mark2 = ParserMacroMethods_this$76.__saveState();
                int start2 = ParserMacroMethods_this$76.cursor();
                boolean l = this.liftedTree52$1(ParserMacroMethods_this$76, start2);
                if (!l) {
                    ParserMacroMethods_this$76.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$76.__saveState();
        }
        return mark;
    }

    private final boolean liftedTree53$1(UriParser ParserMacroMethods_this$75, int start$28) {
        boolean bl;
        try {
            ParserMacroMethods_this$75.__restoreState(this.rec$5(ParserMacroMethods_this$75, ParserMacroMethods_this$75.__saveState()));
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$ZeroOrMore$.MODULE$, start$28);
        }
        return bl;
    }

    private final boolean liftedTree54$1(UriParser ParserMacroMethods_this$74, int start$27) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSBForDecoding() != null;
            if (ll) {
                int start = ParserMacroMethods_this$74.cursor();
                bl = this.liftedTree53$1(ParserMacroMethods_this$74, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$27);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$20(UriParser ParserMacroMethods_this$73) {
        int start = ParserMacroMethods_this$73.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$73.cursor();
            int start3 = ParserMacroMethods_this$73.cursor();
            try {
                int start4 = ParserMacroMethods_this$73.cursor();
                boolean ll = this.liftedTree54$1(ParserMacroMethods_this$73, start4);
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$73.cursorChar() != '@' || !ParserMacroMethods_this$73.__advance() || !ParserMacroMethods_this$73.__updateMaxCursor()) {
                        if (!ParserMacroMethods_this$73.__registerMismatch()) return false;
                    }
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$73.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('@'));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start5 = ParserMacroMethods_this$73.cursor();
            try {
                this.setUserInfo(this.getDecodedString(this.getDecodedString$default$1()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start5);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("userinfo"), start);
        }
    }

    private final long rec$6(UriParser ParserMacroMethods_this$79, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean ll;
            long mark2 = ParserMacroMethods_this$79.__saveState();
            boolean bl2 = ll = CharacterClasses$.MODULE$.userinfo$minuschar().apply(ParserMacroMethods_this$79.cursorChar()) && ParserMacroMethods_this$79.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this$79.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$79.__saveState();
        }
        return mark;
    }

    private static final boolean liftedTree55$1(UriParser ParserMacroMethods_this$81) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$81.cursorChar() == ':' && ParserMacroMethods_this$81.__advance() && ParserMacroMethods_this$81.__updateMaxCursor() || ParserMacroMethods_this$81.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$81.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$21(UriParser ParserMacroMethods_this$80) {
        int start = ParserMacroMethods_this$80.cursor();
        try {
            int start2 = ParserMacroMethods_this$80.cursor();
            try {
                if (this.host() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$80.cursor();
                try {
                    boolean bl2;
                    long mark = ParserMacroMethods_this$80.__saveState();
                    int start4 = ParserMacroMethods_this$80.cursor();
                    try {
                        boolean ll2 = UriParser.liftedTree55$1(ParserMacroMethods_this$80);
                        if (ll2) {
                            if (this.port() != null) {
                                return true;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start4);
                    }
                    boolean matched = bl2;
                    if (!matched) {
                        ParserMacroMethods_this$80.__restoreState(mark);
                    }
                    return true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("hostAndPort"), start);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$22(UriParser ParserMacroMethods_this$82) {
        boolean bl;
        int start = ParserMacroMethods_this$82.cursor();
        try {
            int start2 = ParserMacroMethods_this$82.cursor();
            try {
                int start3 = ParserMacroMethods_this$82.cursor();
                try {
                    if (this.hostAndPort() == null) return false;
                    boolean bl2 = true;
                    boolean ll = bl2;
                    if (!ll) return false;
                    ParserMacroMethods_this$82.valueStack().push(this._host);
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("hostAndPort-pushed"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            ParserMacroMethods_this$82.valueStack().push(BoxesRunTime.boxToInteger(this._port));
            return true;
        }
    }

    private final boolean wrapped$23(UriParser ParserMacroMethods_this$83) {
        boolean bl;
        int start = ParserMacroMethods_this$83.cursor();
        try {
            int start2 = ParserMacroMethods_this$83.cursor();
            try {
                boolean l;
                boolean bl2;
                boolean l2;
                long mark = ParserMacroMethods_this$83.__saveState();
                boolean bl3 = l2 = this.IP$minusliteral() != null;
                if (!l2) {
                    ParserMacroMethods_this$83.__restoreState(mark);
                    bl2 = this.ipv4Host() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$83.__restoreState(mark);
                    bl = this.reg$minusname() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("host"), start);
        }
        return bl;
    }

    private final boolean wrapped$24(UriParser ParserMacroMethods_this$84) {
        boolean bl;
        int start = ParserMacroMethods_this$84.cursor();
        try {
            int start2 = ParserMacroMethods_this$84.cursor();
            try {
                boolean l;
                boolean bl2;
                boolean l2;
                boolean bl3;
                boolean l3;
                long mark = ParserMacroMethods_this$84.__saveState();
                boolean bl4 = l3 = this.IP$minusliteral() != null;
                if (!l3) {
                    ParserMacroMethods_this$84.__restoreState(mark);
                    bl3 = this.ipv6Host() != null;
                } else {
                    bl3 = l2 = true;
                }
                if (!l2) {
                    ParserMacroMethods_this$84.__restoreState(mark);
                    bl2 = this.ipv4Host() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$84.__restoreState(mark);
                    bl = this.reg$minusname() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("relaxedHost"), start);
        }
        return bl;
    }

    private static final boolean liftedTree56$1(UriParser ParserMacroMethods_this$86) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$86.cursorChar()) && ParserMacroMethods_this$86.__advance() && ParserMacroMethods_this$86.__updateMaxCursor() || ParserMacroMethods_this$86.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("DIGIT"), 0);
            throw ParserMacroMethods_this$86.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
        }
        return bl;
    }

    private static final boolean liftedTree57$1(UriParser ParserMacroMethods_this$88) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$88.cursorChar()) && ParserMacroMethods_this$88.__advance() && ParserMacroMethods_this$88.__updateMaxCursor() || ParserMacroMethods_this$88.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("DIGIT"), 0);
            throw ParserMacroMethods_this$88.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
        }
        return bl;
    }

    private final boolean liftedTree58$1(int start$31) {
        boolean bl;
        try {
            this.setPort(10 * this._port + this.lastChar() - 48);
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Run$.MODULE$, start$31);
        }
        return bl;
    }

    private final boolean liftedTree59$1(UriParser ParserMacroMethods_this$87, int start$30) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree57$1(ParserMacroMethods_this$87);
            if (ll) {
                int start = ParserMacroMethods_this$87.cursor();
                bl = this.liftedTree58$1(start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$30);
        }
        return bl;
    }

    private static final boolean liftedTree60$1(UriParser ParserMacroMethods_this$91) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$91.cursorChar()) && ParserMacroMethods_this$91.__advance() && ParserMacroMethods_this$91.__updateMaxCursor() || ParserMacroMethods_this$91.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("DIGIT"), 0);
            throw ParserMacroMethods_this$91.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
        }
        return bl;
    }

    private final boolean liftedTree61$1(int start$34) {
        boolean bl;
        try {
            this.setPort(10 * this._port + this.lastChar() - 48);
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Run$.MODULE$, start$34);
        }
        return bl;
    }

    private final boolean liftedTree62$1(UriParser ParserMacroMethods_this$90, int start$33) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree60$1(ParserMacroMethods_this$90);
            if (ll) {
                int start = ParserMacroMethods_this$90.cursor();
                bl = this.liftedTree61$1(start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$33);
        }
        return bl;
    }

    private static final boolean liftedTree63$1(UriParser ParserMacroMethods_this$95) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$95.cursorChar()) && ParserMacroMethods_this$95.__advance() && ParserMacroMethods_this$95.__updateMaxCursor() || ParserMacroMethods_this$95.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("DIGIT"), 0);
            throw ParserMacroMethods_this$95.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
        }
        return bl;
    }

    private final boolean liftedTree64$1(int start$38) {
        boolean bl;
        try {
            this.setPort(10 * this._port + this.lastChar() - 48);
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Run$.MODULE$, start$38);
        }
        return bl;
    }

    private final boolean liftedTree65$1(UriParser ParserMacroMethods_this$94, int start$37) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree63$1(ParserMacroMethods_this$94);
            if (ll) {
                int start = ParserMacroMethods_this$94.cursor();
                bl = this.liftedTree64$1(start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$37);
        }
        return bl;
    }

    private static final boolean liftedTree66$1(UriParser ParserMacroMethods_this$98) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$98.cursorChar()) && ParserMacroMethods_this$98.__advance() && ParserMacroMethods_this$98.__updateMaxCursor() || ParserMacroMethods_this$98.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("DIGIT"), 0);
            throw ParserMacroMethods_this$98.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
        }
        return bl;
    }

    private final boolean liftedTree67$1(int start$41) {
        boolean bl;
        try {
            this.setPort(10 * this._port + this.lastChar() - 48);
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Run$.MODULE$, start$41);
        }
        return bl;
    }

    private final boolean liftedTree68$1(UriParser ParserMacroMethods_this$97, int start$40) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree66$1(ParserMacroMethods_this$97);
            if (ll) {
                int start = ParserMacroMethods_this$97.cursor();
                bl = this.liftedTree67$1(start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$40);
        }
        return bl;
    }

    private final boolean liftedTree69$1(UriParser ParserMacroMethods_this$96, int start$39) {
        boolean bl;
        try {
            long mark = ParserMacroMethods_this$96.__saveState();
            int start = ParserMacroMethods_this$96.cursor();
            boolean matched = this.liftedTree68$1(ParserMacroMethods_this$96, start);
            if (!matched) {
                ParserMacroMethods_this$96.__restoreState(mark);
            }
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start$39);
        }
        return bl;
    }

    private final boolean liftedTree70$1(UriParser ParserMacroMethods_this$93, int start$36) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$93.cursor();
            boolean ll = this.liftedTree65$1(ParserMacroMethods_this$93, start);
            if (ll) {
                int start2 = ParserMacroMethods_this$93.cursor();
                bl = this.liftedTree69$1(ParserMacroMethods_this$93, start2);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$36);
        }
        return bl;
    }

    private final boolean liftedTree71$1(UriParser ParserMacroMethods_this$92, int start$35) {
        boolean bl;
        try {
            long mark = ParserMacroMethods_this$92.__saveState();
            int start = ParserMacroMethods_this$92.cursor();
            boolean matched = this.liftedTree70$1(ParserMacroMethods_this$92, start);
            if (!matched) {
                ParserMacroMethods_this$92.__restoreState(mark);
            }
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start$35);
        }
        return bl;
    }

    private final boolean liftedTree72$1(UriParser ParserMacroMethods_this$89, int start$32) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$89.cursor();
            boolean ll = this.liftedTree62$1(ParserMacroMethods_this$89, start);
            if (ll) {
                int start2 = ParserMacroMethods_this$89.cursor();
                bl = this.liftedTree71$1(ParserMacroMethods_this$89, start2);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$32);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$25(UriParser ParserMacroMethods_this$85) {
        int start = ParserMacroMethods_this$85.cursor();
        try {
            boolean bl;
            long mark;
            int start2;
            block27: {
                boolean bl2;
                start2 = ParserMacroMethods_this$85.cursor();
                int start3 = ParserMacroMethods_this$85.cursor();
                try {
                    boolean ll = UriParser.liftedTree56$1(ParserMacroMethods_this$85);
                    if (!ll) return false;
                    int start4 = ParserMacroMethods_this$85.cursor();
                    try {
                        this.setPort(this.lastChar() - 48);
                        bl2 = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Run$.MODULE$, start4);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
                boolean ll = bl2;
                if (!ll) return false;
                int start5 = ParserMacroMethods_this$85.cursor();
                mark = ParserMacroMethods_this$85.__saveState();
                int start6 = ParserMacroMethods_this$85.cursor();
                try {
                    int start7 = ParserMacroMethods_this$85.cursor();
                    boolean ll2 = this.liftedTree59$1(ParserMacroMethods_this$85, start7);
                    if (ll2) {
                        int start8 = ParserMacroMethods_this$85.cursor();
                        try {
                            long mark2 = ParserMacroMethods_this$85.__saveState();
                            int start9 = ParserMacroMethods_this$85.cursor();
                            boolean matched = this.liftedTree72$1(ParserMacroMethods_this$85, start9);
                            if (!matched) {
                                ParserMacroMethods_this$85.__restoreState(mark2);
                            }
                            bl = true;
                            break block27;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start8);
                        }
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start6);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start5);
                    }
                }
            }
            boolean matched = bl;
            if (!matched) {
                ParserMacroMethods_this$85.__restoreState(mark);
            }
            boolean bl3 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
                }
            }
            return bl3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("port"), start);
        }
    }

    private static final boolean liftedTree73$1(UriParser ParserMacroMethods_this$100) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$100.cursorChar() == '[' && ParserMacroMethods_this$100.__advance() && ParserMacroMethods_this$100.__updateMaxCursor() || ParserMacroMethods_this$100.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$100.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('['));
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$26(UriParser ParserMacroMethods_this$99) {
        boolean bl;
        int start = ParserMacroMethods_this$99.cursor();
        try {
            int start2 = ParserMacroMethods_this$99.cursor();
            try {
                int start3 = ParserMacroMethods_this$99.cursor();
                try {
                    boolean ll = UriParser.liftedTree73$1(ParserMacroMethods_this$99);
                    if (!ll) return false;
                    if (this.ipv6Host() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("IP-literal"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            try {
                if (ParserMacroMethods_this$99.cursorChar() == ']' && ParserMacroMethods_this$99.__advance()) {
                    if (ParserMacroMethods_this$99.__updateMaxCursor()) return true;
                }
                if (!ParserMacroMethods_this$99.__registerMismatch()) return false;
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                throw ParserMacroMethods_this$99.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(']'));
            }
        }
    }

    private final boolean liftedTree74$1(int start$42, UriParser ParserMacroMethods_this$102) {
        boolean bl;
        try {
            boolean matched;
            int start1 = start$42;
            boolean bl2 = matched = this.ip$minusv4$minusaddress() != null;
            if (matched) {
                ParserMacroMethods_this$102.valueStack().push(ParserMacroMethods_this$102.input().sliceString(start1, ParserMacroMethods_this$102.cursor()));
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Capture$.MODULE$, start$42);
        }
        return bl;
    }

    private static final boolean liftedTree75$1(UriParser ParserMacroMethods_this$103) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.colonSlashEOI().apply(ParserMacroMethods_this$103.cursorChar()) && ParserMacroMethods_this$103.__advance() && ParserMacroMethods_this$103.__updateMaxCursor() || ParserMacroMethods_this$103.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("colonSlashEOI"), 0);
            throw ParserMacroMethods_this$103.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.colonSlashEOI()));
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$27(UriParser ParserMacroMethods_this$101) {
        boolean bl;
        int start = ParserMacroMethods_this$101.cursor();
        try {
            int start2 = ParserMacroMethods_this$101.cursor();
            try {
                int start3 = ParserMacroMethods_this$101.cursor();
                boolean ll = this.liftedTree74$1(start3, ParserMacroMethods_this$101);
                if (!ll) return false;
                int start4 = ParserMacroMethods_this$101.cursor();
                try {
                    long mark = ParserMacroMethods_this$101.__saveState();
                    boolean matched = UriParser.liftedTree75$1(ParserMacroMethods_this$101);
                    ParserMacroMethods_this$101.__restoreState(mark);
                    bl = matched;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$AndPredicate$.MODULE$, start4);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("ipv4Host"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            int start5 = ParserMacroMethods_this$101.cursor();
            try {
                String a = (String)ParserMacroMethods_this$101.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this$101.valueStack().pop();
                this._host = Uri$IPv4Host$.MODULE$.apply(b, a);
                boolean bl2 = ParserMacroMethods_this$101.__push(BoxedUnit.UNIT);
                return bl2;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Action$.MODULE$, start5);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$28(UriParser ParserMacroMethods_this$104) {
        boolean bl;
        int start = ParserMacroMethods_this$104.cursor();
        try {
            int start2 = ParserMacroMethods_this$104.cursor();
            try {
                int start3 = ParserMacroMethods_this$104.cursor();
                try {
                    int start1 = start3;
                    if (this.ip$minusv6$minusaddress() == null) return false;
                    boolean bl2 = true;
                    boolean matched = bl2;
                    if (!matched) return false;
                    ParserMacroMethods_this$104.valueStack().push(ParserMacroMethods_this$104.input().sliceString(start1, ParserMacroMethods_this$104.cursor()));
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Capture$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("ipv6Host"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            int start4 = ParserMacroMethods_this$104.cursor();
            try {
                String a = (String)ParserMacroMethods_this$104.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this$104.valueStack().pop();
                this.setHost(Uri$IPv6Host$.MODULE$.apply(b, a));
                boolean bl3 = ParserMacroMethods_this$104.__push(BoxedUnit.UNIT);
                return bl3;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Action$.MODULE$, start4);
            }
        }
    }

    private static final boolean liftedTree76$1(UriParser ParserMacroMethods_this$110) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.lower$minusreg$minusname$minuschar().apply(ParserMacroMethods_this$110.cursorChar()) && ParserMacroMethods_this$110.__advance() && ParserMacroMethods_this$110.__updateMaxCursor() || ParserMacroMethods_this$110.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("lower-reg-name-char"), 0);
            throw ParserMacroMethods_this$110.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.lower$minusreg$minusname$minuschar()));
        }
        return bl;
    }

    private final boolean liftedTree77$1(UriParser ParserMacroMethods_this$109, int start$45) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree76$1(ParserMacroMethods_this$109);
            bl = ll ? this.appendSB() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$45);
        }
        return bl;
    }

    private static final boolean liftedTree78$1(UriParser ParserMacroMethods_this$112) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.UPPER_ALPHA().apply(ParserMacroMethods_this$112.cursorChar()) && ParserMacroMethods_this$112.__advance() && ParserMacroMethods_this$112.__updateMaxCursor() || ParserMacroMethods_this$112.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("UPPER_ALPHA"), 0);
            throw ParserMacroMethods_this$112.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.UPPER_ALPHA()));
        }
        return bl;
    }

    private final boolean liftedTree79$1(UriParser ParserMacroMethods_this$111, int start$46) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree78$1(ParserMacroMethods_this$111);
            bl = ll ? this.appendLowered() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$46);
        }
        return bl;
    }

    private final long rec$7(UriParser ParserMacroMethods_this$108, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$108.cursor();
            try {
                boolean l;
                boolean bl2;
                long mark2 = ParserMacroMethods_this$108.__saveState();
                int start2 = ParserMacroMethods_this$108.cursor();
                boolean l2 = this.liftedTree77$1(ParserMacroMethods_this$108, start2);
                if (!l2) {
                    ParserMacroMethods_this$108.__restoreState(mark2);
                    int start3 = ParserMacroMethods_this$108.cursor();
                    bl2 = this.liftedTree79$1(ParserMacroMethods_this$108, start3);
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$108.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$108.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean liftedTree80$1(UriParser ParserMacroMethods_this$107, int start$44) {
        try {
            long firstMark = ParserMacroMethods_this$107.__saveState();
            long mark = this.rec$7(ParserMacroMethods_this$107, firstMark);
            if (mark == firstMark) return false;
            ParserMacroMethods_this$107.__restoreState(mark);
            if (!true) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start$44);
        }
    }

    private final boolean liftedTree81$1(UriParser ParserMacroMethods_this$106, int start$43) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSBForDecoding() != null;
            if (ll) {
                int start = ParserMacroMethods_this$106.cursor();
                bl = this.liftedTree80$1(ParserMacroMethods_this$106, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$43);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$29(UriParser ParserMacroMethods_this$105) {
        int start = ParserMacroMethods_this$105.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$105.cursor();
            long mark = ParserMacroMethods_this$105.__saveState();
            int start3 = ParserMacroMethods_this$105.cursor();
            try {
                int start4 = ParserMacroMethods_this$105.cursor();
                boolean ll = this.liftedTree81$1(ParserMacroMethods_this$105, start4);
                if (ll) {
                    int start5 = ParserMacroMethods_this$105.cursor();
                    try {
                        this.setHost(Uri$NamedHost$.MODULE$.apply(this.getDecodedStringAndLowerIfEncoded(org.parboiled2.package$.MODULE$.UTF8())));
                        return true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Run$.MODULE$, start5);
                    }
                }
                bl2 = false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean l = bl2;
            if (l) return true;
            ParserMacroMethods_this$105.__restoreState(mark);
            int start6 = ParserMacroMethods_this$105.cursor();
            try {
                this.setHost(Uri$Host$Empty$.MODULE$);
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start6);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("reg-name"), start);
        }
    }

    private final long rec$8(UriParser ParserMacroMethods_this$113, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean bl2;
            boolean l2;
            boolean ll;
            long mark2 = ParserMacroMethods_this$113.__saveState();
            boolean bl3 = ll = CharacterClasses$.MODULE$.lower$minusreg$minusname$minuschar().apply(ParserMacroMethods_this$113.cursorChar()) && ParserMacroMethods_this$113.__advance();
            boolean bl4 = ll ? this.appendSB() != null : (l2 = false);
            if (!l2) {
                boolean ll2;
                ParserMacroMethods_this$113.__restoreState(mark2);
                boolean bl5 = ll2 = CharacterClasses$.MODULE$.UPPER_ALPHA().apply(ParserMacroMethods_this$113.cursorChar()) && ParserMacroMethods_this$113.__advance();
                bl2 = ll2 ? this.appendLowered() != null : false;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this$113.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$113.__saveState();
        }
        return mark;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$30(UriParser ParserMacroMethods_this$114) {
        boolean bl;
        int start = ParserMacroMethods_this$114.cursor();
        try {
            int start2 = ParserMacroMethods_this$114.cursor();
            try {
                int start3 = ParserMacroMethods_this$114.cursor();
                try {
                    if (this.clearSB() == null) return false;
                    boolean bl2 = true;
                    boolean ll = bl2;
                    if (!ll) return false;
                    if (this.slashSegments() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("path-abempty"), start);
        }
        {
            boolean ll = bl;
            if (!ll) {
                return false;
            }
            if (this.savePath() == null) return false;
            return true;
        }
    }

    private static final boolean liftedTree82$1(UriParser ParserMacroMethods_this$118) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$118.cursorChar() == '/' && ParserMacroMethods_this$118.__advance() && ParserMacroMethods_this$118.__updateMaxCursor() || ParserMacroMethods_this$118.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$118.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private final boolean liftedTree83$1(UriParser ParserMacroMethods_this$117, int start$48) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSB() != null;
            bl = ll ? UriParser.liftedTree82$1(ParserMacroMethods_this$117) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$48);
        }
        return bl;
    }

    private final boolean liftedTree84$1(UriParser ParserMacroMethods_this$116, int start$47) {
        boolean bl;
        try {
            int start = ParserMacroMethods_this$116.cursor();
            boolean ll = this.liftedTree83$1(ParserMacroMethods_this$116, start);
            bl = ll ? this.appendSB('/') != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$47);
        }
        return bl;
    }

    private final boolean liftedTree85$1(int start$49) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.segment$minusnz() != null;
            bl = ll ? this.slashSegments() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$49);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$31(UriParser ParserMacroMethods_this$115) {
        int start = ParserMacroMethods_this$115.cursor();
        try {
            int start2 = ParserMacroMethods_this$115.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$115.cursor();
                try {
                    int start4 = ParserMacroMethods_this$115.cursor();
                    boolean ll = this.liftedTree84$1(ParserMacroMethods_this$115, start4);
                    if (!ll) return false;
                    int start5 = ParserMacroMethods_this$115.cursor();
                    try {
                        long mark = ParserMacroMethods_this$115.__saveState();
                        int start6 = ParserMacroMethods_this$115.cursor();
                        boolean matched = this.liftedTree85$1(start6);
                        if (!matched) {
                            ParserMacroMethods_this$115.__restoreState(mark);
                        }
                        bl = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start5);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) {
                    return false;
                }
                if (this.savePath() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("path-absolute"), start);
        }
    }

    private final boolean liftedTree86$1(int start$50) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSB() != null;
            bl = ll ? this.segment$minusnz$minusnc() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$50);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$32(UriParser ParserMacroMethods_this$119) {
        boolean bl;
        int start = ParserMacroMethods_this$119.cursor();
        try {
            int start2 = ParserMacroMethods_this$119.cursor();
            try {
                int start3 = ParserMacroMethods_this$119.cursor();
                try {
                    int start4 = ParserMacroMethods_this$119.cursor();
                    boolean ll = this.liftedTree86$1(start4);
                    if (!ll) return false;
                    if (this.slashSegments() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("path-noscheme"), start);
        }
        {
            boolean ll = bl;
            if (!ll) {
                return false;
            }
            if (this.savePath() == null) return false;
            return true;
        }
    }

    private final boolean liftedTree87$1(int start$51) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSB() != null;
            bl = ll ? this.segment$minusnz() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$51);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$33(UriParser ParserMacroMethods_this$120) {
        boolean bl;
        int start = ParserMacroMethods_this$120.cursor();
        try {
            int start2 = ParserMacroMethods_this$120.cursor();
            try {
                int start3 = ParserMacroMethods_this$120.cursor();
                try {
                    int start4 = ParserMacroMethods_this$120.cursor();
                    boolean ll = this.liftedTree87$1(start4);
                    if (!ll) return false;
                    if (this.slashSegments() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("path-rootless"), start);
        }
        {
            boolean ll = bl;
            if (!ll) {
                return false;
            }
            if (this.savePath() == null) return false;
            return true;
        }
    }

    private final boolean wrapped$34(UriParser ParserMacroMethods_this$121) {
        boolean bl;
        int start = ParserMacroMethods_this$121.cursor();
        try {
            bl = this.MATCH() != null;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("path-empty"), start);
        }
        return bl;
    }

    private static final boolean liftedTree88$1(UriParser ParserMacroMethods_this$125) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$125.cursorChar() == '/' && ParserMacroMethods_this$125.__advance() && ParserMacroMethods_this$125.__updateMaxCursor() || ParserMacroMethods_this$125.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$125.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private final boolean liftedTree89$1(UriParser ParserMacroMethods_this$124, int start$52) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree88$1(ParserMacroMethods_this$124);
            bl = ll ? this.appendSB('/') != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$52);
        }
        return bl;
    }

    private final long rec$9(UriParser ParserMacroMethods_this$123, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$123.cursor();
            try {
                int start2 = ParserMacroMethods_this$123.cursor();
                boolean ll = this.liftedTree89$1(ParserMacroMethods_this$123, start2);
                bl = ll ? this.segment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$123.__saveState();
        }
        return mark;
    }

    private final boolean wrapped$35(UriParser ParserMacroMethods_this$122) {
        boolean bl;
        int start = ParserMacroMethods_this$122.cursor();
        try {
            int start2 = ParserMacroMethods_this$122.cursor();
            try {
                ParserMacroMethods_this$122.__restoreState(this.rec$9(ParserMacroMethods_this$122, ParserMacroMethods_this$122.__saveState()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$ZeroOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("slashSegments"), start);
        }
        return bl;
    }

    private final long rec$10(UriParser ParserMacroMethods_this$126, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean ll2;
            boolean bl = ll2 = ParserMacroMethods_this$126.cursorChar() == '/' && ParserMacroMethods_this$126.__advance();
            boolean bl2 = ll2 ? this.appendSB('/') != null : (ll = false);
            boolean bl3 = ll ? this.segment() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$126.__saveState();
        }
        return mark;
    }

    private final long rec$11(UriParser ParserMacroMethods_this$128, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$128.__saveState();
        }
        return mark;
    }

    private final boolean wrapped$36(UriParser ParserMacroMethods_this$127) {
        boolean bl;
        int start = ParserMacroMethods_this$127.cursor();
        try {
            int start2 = ParserMacroMethods_this$127.cursor();
            try {
                ParserMacroMethods_this$127.__restoreState(this.rec$11(ParserMacroMethods_this$127, ParserMacroMethods_this$127.__saveState()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$ZeroOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("segment"), start);
        }
        return bl;
    }

    private final long rec$12(UriParser ParserMacroMethods_this$129, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$129.__saveState();
        }
        return mark;
    }

    private final long rec$13(UriParser ParserMacroMethods_this$131, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$131.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean wrapped$37(UriParser ParserMacroMethods_this$130) {
        int start = ParserMacroMethods_this$130.cursor();
        try {
            int start2 = ParserMacroMethods_this$130.cursor();
            try {
                long firstMark = ParserMacroMethods_this$130.__saveState();
                long mark = this.rec$13(ParserMacroMethods_this$130, firstMark);
                if (mark == firstMark) return false;
                ParserMacroMethods_this$130.__restoreState(mark);
                if (!true) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("segment-nz"), start);
        }
    }

    private final long rec$14(UriParser ParserMacroMethods_this$132, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$132.__saveState();
        }
        return mark;
    }

    private static final boolean liftedTree90$1(UriParser ParserMacroMethods_this$136) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$136.cursorChar() == ':' && ParserMacroMethods_this$136.__advance() && ParserMacroMethods_this$136.__updateMaxCursor() || ParserMacroMethods_this$136.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$136.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(':'));
        }
        return bl;
    }

    private static final boolean liftedTree91$1(UriParser ParserMacroMethods_this$135, IntRef matchEnd$1) {
        boolean bl;
        try {
            int n;
            long mark = ParserMacroMethods_this$135.__saveState();
            Object saved = ParserMacroMethods_this$135.__enterNotPredicate();
            boolean matched = UriParser.liftedTree90$1(ParserMacroMethods_this$135);
            ParserMacroMethods_this$135.__exitNotPredicate(saved);
            matchEnd$1.elem = n = ParserMacroMethods_this$135.cursor();
            ParserMacroMethods_this$135.__restoreState(mark);
            bl = !matched || ParserMacroMethods_this$135.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$135.__bubbleUp(RuleTrace$NotPredicate$.MODULE$.apply(RuleTrace$NotPredicate$Terminal$.MODULE$.apply(RuleTrace$CharMatch$.MODULE$.apply(':')), matchEnd$1.elem - ParserMacroMethods_this$135.cursor()));
        }
        return bl;
    }

    private final long rec$15(UriParser ParserMacroMethods_this$134, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$134.cursor();
            try {
                IntRef matchEnd = IntRef.create(0);
                boolean ll = UriParser.liftedTree91$1(ParserMacroMethods_this$134, matchEnd);
                bl = ll ? this.pchar() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$134.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean wrapped$38(UriParser ParserMacroMethods_this$133) {
        int start = ParserMacroMethods_this$133.cursor();
        try {
            int start2 = ParserMacroMethods_this$133.cursor();
            try {
                long firstMark = ParserMacroMethods_this$133.__saveState();
                long mark = this.rec$15(ParserMacroMethods_this$133, firstMark);
                if (mark == firstMark) return false;
                ParserMacroMethods_this$133.__restoreState(mark);
                if (!true) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("segment-nz-nc"), start);
        }
    }

    private final long rec$16(UriParser ParserMacroMethods_this$137, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            long mark2 = ParserMacroMethods_this$137.__saveState();
            Object saved = ParserMacroMethods_this$137.__enterNotPredicate();
            boolean matched2 = ParserMacroMethods_this$137.cursorChar() == ':' && ParserMacroMethods_this$137.__advance();
            ParserMacroMethods_this$137.__exitNotPredicate(saved);
            ParserMacroMethods_this$137.__restoreState(mark2);
            boolean bl = ll = !matched2;
            boolean bl2 = ll ? this.pchar() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$137.__saveState();
        }
        return mark;
    }

    private final boolean liftedTree92$1(UriParser ParserMacroMethods_this$139) {
        boolean bl;
        try {
            bl = this.path$minussegment$minuschar.apply(ParserMacroMethods_this$139.cursorChar()) && ParserMacroMethods_this$139.__advance() && ParserMacroMethods_this$139.__updateMaxCursor() || ParserMacroMethods_this$139.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("path-segment-char"), 0);
            throw ParserMacroMethods_this$139.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(this.path$minussegment$minuschar));
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$39(UriParser ParserMacroMethods_this$138) {
        boolean bl;
        long mark;
        int start = ParserMacroMethods_this$138.cursor();
        try {
            int start2 = ParserMacroMethods_this$138.cursor();
            try {
                mark = ParserMacroMethods_this$138.__saveState();
                int start3 = ParserMacroMethods_this$138.cursor();
                try {
                    boolean ll = this.liftedTree92$1(ParserMacroMethods_this$138);
                    if (ll) {
                        if (this.appendSB() != null) {
                            return true;
                        }
                        bl = false;
                    } else {
                        bl = false;
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("pchar"), start);
        }
        {
            boolean l = bl;
            if (l) {
                return true;
            }
            ParserMacroMethods_this$138.__restoreState(mark);
            if (this.pct$minusencoded() == null) return false;
            return true;
        }
    }

    private final boolean liftedTree93$1(UriParser ParserMacroMethods_this$145) {
        boolean bl;
        try {
            bl = this.query$minuschar.apply(ParserMacroMethods_this$145.cursorChar()) && ParserMacroMethods_this$145.__advance() && ParserMacroMethods_this$145.__updateMaxCursor() || ParserMacroMethods_this$145.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("query-char"), 0);
            throw ParserMacroMethods_this$145.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(this.query$minuschar));
        }
        return bl;
    }

    private final boolean liftedTree94$1(UriParser ParserMacroMethods_this$144, int start$55) {
        boolean bl;
        try {
            boolean ll = this.liftedTree93$1(ParserMacroMethods_this$144);
            bl = ll ? this.appendSB() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$55);
        }
        return bl;
    }

    private final long rec$17(UriParser ParserMacroMethods_this$143, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$143.cursor();
            try {
                long mark2 = ParserMacroMethods_this$143.__saveState();
                int start2 = ParserMacroMethods_this$143.cursor();
                boolean l = this.liftedTree94$1(ParserMacroMethods_this$143, start2);
                if (!l) {
                    ParserMacroMethods_this$143.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$143.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean liftedTree95$1(UriParser ParserMacroMethods_this$142, int start$54) {
        try {
            long firstMark = ParserMacroMethods_this$142.__saveState();
            long mark = this.rec$17(ParserMacroMethods_this$142, firstMark);
            if (mark == firstMark) return false;
            ParserMacroMethods_this$142.__restoreState(mark);
            if (!true) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start$54);
        }
    }

    private final boolean liftedTree96$1(UriParser ParserMacroMethods_this$141, int start$53) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSB() != null;
            if (ll) {
                int start = ParserMacroMethods_this$141.cursor();
                bl = this.liftedTree95$1(ParserMacroMethods_this$141, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$53);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$40(UriParser ParserMacroMethods_this$140) {
        int start = ParserMacroMethods_this$140.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$140.cursor();
            long mark = ParserMacroMethods_this$140.__saveState();
            int start3 = ParserMacroMethods_this$140.cursor();
            try {
                int start4 = ParserMacroMethods_this$140.cursor();
                boolean ll = this.liftedTree96$1(ParserMacroMethods_this$140, start4);
                if (ll) {
                    int start5 = ParserMacroMethods_this$140.cursor();
                    try {
                        this.setRawQueryString(this.sb().toString());
                        return true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Run$.MODULE$, start5);
                    }
                }
                bl2 = false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean l = bl2;
            if (l) return true;
            ParserMacroMethods_this$140.__restoreState(mark);
            int start6 = ParserMacroMethods_this$140.cursor();
            try {
                this.setRawQueryString("");
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start6);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("rawQueryString"), start);
        }
    }

    private final long rec$18(UriParser ParserMacroMethods_this$146, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean ll;
            long mark2 = ParserMacroMethods_this$146.__saveState();
            boolean bl2 = ll = this.query$minuschar.apply(ParserMacroMethods_this$146.cursorChar()) && ParserMacroMethods_this$146.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this$146.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$146.__saveState();
        }
        return mark;
    }

    private static final boolean liftedTree97$1(UriParser ParserMacroMethods_this$152) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$152.cursorChar() == '+' && ParserMacroMethods_this$152.__advance() && ParserMacroMethods_this$152.__updateMaxCursor() || ParserMacroMethods_this$152.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$152.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('+'));
        }
        return bl;
    }

    private final boolean liftedTree98$1(UriParser ParserMacroMethods_this$151, int start$58) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree97$1(ParserMacroMethods_this$151);
            bl = ll ? this.appendSB(' ') != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$58);
        }
        return bl;
    }

    private static final boolean liftedTree99$1(CharPredicate query$minuschar$6, UriParser ParserMacroMethods_this$154) {
        boolean bl;
        try {
            bl = query$minuschar$6.apply(ParserMacroMethods_this$154.cursorChar()) && ParserMacroMethods_this$154.__advance() && ParserMacroMethods_this$154.__updateMaxCursor() || ParserMacroMethods_this$154.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("query-char"), 0);
            throw ParserMacroMethods_this$154.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(query$minuschar$6));
        }
        return bl;
    }

    private final boolean liftedTree100$1(CharPredicate query$minuschar$5, UriParser ParserMacroMethods_this$153, int start$59) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree99$1(query$minuschar$5, ParserMacroMethods_this$153);
            bl = ll ? this.appendSB() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$59);
        }
        return bl;
    }

    private final long rec$19(UriParser ParserMacroMethods_this$150, CharPredicate query$minuschar$4, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$150.cursor();
            try {
                boolean l;
                boolean bl2;
                long mark2 = ParserMacroMethods_this$150.__saveState();
                int start2 = ParserMacroMethods_this$150.cursor();
                boolean l2 = this.liftedTree98$1(ParserMacroMethods_this$150, start2);
                if (!l2) {
                    ParserMacroMethods_this$150.__restoreState(mark2);
                    int start3 = ParserMacroMethods_this$150.cursor();
                    bl2 = this.liftedTree100$1(query$minuschar$4, ParserMacroMethods_this$150, start3);
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$150.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$150.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean liftedTree101$1(UriParser ParserMacroMethods_this$149, CharPredicate query$minuschar$3, int start$57) {
        try {
            long firstMark = ParserMacroMethods_this$149.__saveState();
            long mark = this.rec$19(ParserMacroMethods_this$149, query$minuschar$3, firstMark);
            if (mark == firstMark) return false;
            ParserMacroMethods_this$149.__restoreState(mark);
            if (!true) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start$57);
        }
    }

    private final boolean liftedTree102$1(UriParser ParserMacroMethods_this$148, CharPredicate query$minuschar$2, int start$56) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSBForDecoding() != null;
            if (ll) {
                int start = ParserMacroMethods_this$148.cursor();
                bl = this.liftedTree101$1(ParserMacroMethods_this$148, query$minuschar$2, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$56);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$41(UriParser ParserMacroMethods_this$147, CharPredicate query$minuschar$1) {
        boolean bl;
        long mark;
        int start = ParserMacroMethods_this$147.cursor();
        try {
            int start2 = ParserMacroMethods_this$147.cursor();
            try {
                mark = ParserMacroMethods_this$147.__saveState();
                int start3 = ParserMacroMethods_this$147.cursor();
                try {
                    int start4 = ParserMacroMethods_this$147.cursor();
                    boolean ll = this.liftedTree102$1(ParserMacroMethods_this$147, query$minuschar$1, start4);
                    if (ll) {
                        ParserMacroMethods_this$147.valueStack().push(this.getDecodedString(this.getDecodedString$default$1()));
                        return true;
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("part"), start);
        }
        {
            boolean l = bl;
            if (l) return true;
            ParserMacroMethods_this$147.__restoreState(mark);
            ParserMacroMethods_this$147.valueStack().push("");
            return true;
        }
    }

    private final long rec$20(UriParser ParserMacroMethods_this$155, CharPredicate query$minuschar$7, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean bl2;
            boolean l2;
            boolean ll;
            long mark2 = ParserMacroMethods_this$155.__saveState();
            boolean bl3 = ll = ParserMacroMethods_this$155.cursorChar() == '+' && ParserMacroMethods_this$155.__advance();
            boolean bl4 = ll ? this.appendSB(' ') != null : (l2 = false);
            if (!l2) {
                boolean ll2;
                ParserMacroMethods_this$155.__restoreState(mark2);
                boolean bl5 = ll2 = query$minuschar$7.apply(ParserMacroMethods_this$155.cursorChar()) && ParserMacroMethods_this$155.__advance();
                bl2 = ll2 ? this.appendSB() != null : false;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this$155.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$155.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Rule part$1(CharPredicate query$minuschar) {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$41(ParserMacroMethods_this, query$minuschar);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSBForDecoding() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$20(ParserMacroMethods_this, query$minuschar, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                ParserMacroMethods_this.valueStack().push(this.getDecodedString(this.getDecodedString$default$1()));
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                ParserMacroMethods_this.valueStack().push("");
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private static final boolean liftedTree103$1(UriParser ParserMacroMethods_this$157) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$157.cursorChar() == '=' && ParserMacroMethods_this$157.__advance() && ParserMacroMethods_this$157.__updateMaxCursor() || ParserMacroMethods_this$157.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$157.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('='));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$42(UriParser ParserMacroMethods_this$156) {
        int start = ParserMacroMethods_this$156.cursor();
        try {
            int start2 = ParserMacroMethods_this$156.cursor();
            try {
                if (this.part$1(this.query$minuskey$minuschar) == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$156.cursor();
                try {
                    boolean bl2;
                    long mark = ParserMacroMethods_this$156.__saveState();
                    int start4 = ParserMacroMethods_this$156.cursor();
                    try {
                        boolean ll2 = UriParser.liftedTree103$1(ParserMacroMethods_this$156);
                        if (ll2) {
                            if (this.part$1(this.query$minusvalue$minuschar) != null) {
                                return true;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start4);
                    }
                    boolean l = bl2;
                    if (l) return true;
                    ParserMacroMethods_this$156.__restoreState(mark);
                    ParserMacroMethods_this$156.valueStack().push(Uri$Query$.MODULE$.EmptyValue());
                    return true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("keyValuePair"), start);
        }
    }

    private final Rule keyValuePair$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$42(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.part$1(this.query$minuskey$minuschar) != null;
            if (ll) {
                boolean l;
                boolean ll2;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl3 = ll2 = ParserMacroMethods_this.cursorChar() == '=' && ParserMacroMethods_this.__advance();
                boolean bl4 = ll2 ? this.part$1(this.query$minusvalue$minuschar) != null : (l = false);
                if (!l) {
                    ParserMacroMethods_this.__restoreState(mark);
                    ParserMacroMethods_this.valueStack().push(Uri$Query$.MODULE$.EmptyValue());
                    bl = true;
                } else {
                    bl = true;
                }
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private static final boolean liftedTree104$1(UriParser ParserMacroMethods_this$160) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$160.cursorChar() == '&' && ParserMacroMethods_this$160.__advance() && ParserMacroMethods_this$160.__updateMaxCursor() || ParserMacroMethods_this$160.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$160.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('&'));
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$21(UriParser ParserMacroMethods_this$159, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            block8: {
                int start = ParserMacroMethods_this$159.cursor();
                try {
                    boolean ll;
                    boolean ll2 = UriParser.liftedTree104$1(ParserMacroMethods_this$159);
                    boolean bl2 = ll2 ? this.keyValuePair$1() != null : (ll = false);
                    if (ll) {
                        int start2 = ParserMacroMethods_this$159.cursor();
                        try {
                            String value = (String)ParserMacroMethods_this$159.valueStack().pop();
                            String key2 = (String)ParserMacroMethods_this$159.valueStack().pop();
                            Uri.Query.Cons prefix = (Uri.Query.Cons)ParserMacroMethods_this$159.valueStack().pop();
                            bl = ParserMacroMethods_this$159.__push(Uri$Query$Cons$.MODULE$.apply(key2, value, prefix));
                            break block8;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp(RuleTrace$Action$.MODULE$, start2);
                        }
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                }
                {
                    bl = false;
                }
            }
            if (!(matched = bl)) {
                return mark;
            }
            mark = ParserMacroMethods_this$159.__saveState();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$43(UriParser ParserMacroMethods_this$158) {
        start = ParserMacroMethods_this$158.cursor();
        try {
            block23: {
                start = ParserMacroMethods_this$158.cursor();
                start = ParserMacroMethods_this$158.cursor();
                try {
                    if (this.keyValuePair$1() == null) return false;
                    v0 = true;
                    ll = v0;
                    if (ll == false) return false;
                    start = ParserMacroMethods_this$158.cursor();
                    try {
                        value = (String)ParserMacroMethods_this$158.valueStack().pop();
                        key = (String)ParserMacroMethods_this$158.valueStack().pop();
                        v1 = ParserMacroMethods_this$158.__push(Uri$Query$Cons$.MODULE$.apply(key, value, Uri$Query$Empty$.MODULE$));
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Action$.MODULE$, start);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                }
                ll = v1;
                if (ll == false) return false;
                start = ParserMacroMethods_this$158.cursor();
                start = ParserMacroMethods_this$158.cursor();
                try {
                    ParserMacroMethods_this$158.__restoreState(this.rec$21(ParserMacroMethods_this$158, ParserMacroMethods_this$158.__saveState()));
                    v2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$ZeroOrMore$.MODULE$, start);
                }
                ll = v2;
                if (!ll) ** GOTO lbl47
                start = ParserMacroMethods_this$158.cursor();
                try {
                    var17_17 = (Uri.Query.Cons)ParserMacroMethods_this$158.valueStack().pop();
                    v3 = ParserMacroMethods_this$158.__push(var17_17.reverse());
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Action$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                    }
                }
                break block23;
lbl47:
                // 1 sources

                v3 = false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
                    }
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("keyValuePairsWithLimitedStackUse"), start);
        }
    }

    private final long rec$22(UriParser ParserMacroMethods_this$161, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean ll;
            boolean ll2;
            boolean bl2 = ll2 = ParserMacroMethods_this$161.cursorChar() == '&' && ParserMacroMethods_this$161.__advance();
            boolean bl3 = ll2 ? this.keyValuePair$1() != null : (ll = false);
            if (ll) {
                String value = (String)ParserMacroMethods_this$161.valueStack().pop();
                String key2 = (String)ParserMacroMethods_this$161.valueStack().pop();
                Uri.Query.Cons prefix = (Uri.Query.Cons)ParserMacroMethods_this$161.valueStack().pop();
                bl = ParserMacroMethods_this$161.__push(Uri$Query$Cons$.MODULE$.apply(key2, value, prefix));
            } else {
                bl = matched = false;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$161.__saveState();
        }
        return mark;
    }

    private final Rule keyValuePairsWithLimitedStackUse$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$43(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.keyValuePair$1() != null;
            if (ll2) {
                String value = (String)ParserMacroMethods_this.valueStack().pop();
                String key2 = (String)ParserMacroMethods_this.valueStack().pop();
                bl2 = ParserMacroMethods_this.__push(Uri$Query$Cons$.MODULE$.apply(key2, value, Uri$Query$Empty$.MODULE$));
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                ParserMacroMethods_this.__restoreState(this.rec$22(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
                boolean ll3 = true;
                if (ll3) {
                    Uri.Query.Cons cons = (Uri.Query.Cons)ParserMacroMethods_this.valueStack().pop();
                    bl = ParserMacroMethods_this.__push(cons.reverse());
                } else {
                    bl = false;
                }
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private static final boolean liftedTree105$1(UriParser ParserMacroMethods_this$164) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$164.cursorChar() == '&' && ParserMacroMethods_this$164.__advance() && ParserMacroMethods_this$164.__updateMaxCursor() || ParserMacroMethods_this$164.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$164.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('&'));
        }
        return bl;
    }

    private final boolean liftedTree106$1(UriParser ParserMacroMethods_this$163, int start$60) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree105$1(ParserMacroMethods_this$163);
            bl = ll ? this.keyValuePairs$1() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$60);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$44(UriParser ParserMacroMethods_this$162) {
        boolean bl;
        int start = ParserMacroMethods_this$162.cursor();
        try {
            int start2 = ParserMacroMethods_this$162.cursor();
            try {
                if (this.keyValuePair$1() == null) return false;
                boolean bl2 = true;
                boolean ll = bl2;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$162.cursor();
                try {
                    long mark = ParserMacroMethods_this$162.__saveState();
                    int start4 = ParserMacroMethods_this$162.cursor();
                    boolean l = this.liftedTree106$1(ParserMacroMethods_this$162, start4);
                    if (!l) {
                        ParserMacroMethods_this$162.__restoreState(mark);
                        ParserMacroMethods_this$162.valueStack().push(Uri$Query$Empty$.MODULE$);
                        bl = true;
                    } else {
                        bl = true;
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("keyValuePairsWithReversalAvoidance"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            int start5 = ParserMacroMethods_this$162.cursor();
            try {
                Uri.Query tail = (Uri.Query)ParserMacroMethods_this$162.valueStack().pop();
                String value = (String)ParserMacroMethods_this$162.valueStack().pop();
                String key2 = (String)ParserMacroMethods_this$162.valueStack().pop();
                boolean bl3 = ParserMacroMethods_this$162.__push(Uri$Query$Cons$.MODULE$.apply(key2, value, tail));
                return bl3;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Action$.MODULE$, start5);
            }
        }
    }

    private final Rule keyValuePairsWithReversalAvoidance$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$44(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.keyValuePair$1() != null;
            if (ll2) {
                boolean l;
                boolean ll3;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '&' && ParserMacroMethods_this.__advance();
                boolean bl5 = ll3 ? this.keyValuePairs$1() != null : (l = false);
                if (!l) {
                    ParserMacroMethods_this.__restoreState(mark);
                    ParserMacroMethods_this.valueStack().push(Uri$Query$Empty$.MODULE$);
                    bl2 = true;
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                Uri.Query tail = (Uri.Query)ParserMacroMethods_this.valueStack().pop();
                String value = (String)ParserMacroMethods_this.valueStack().pop();
                String key2 = (String)ParserMacroMethods_this.valueStack().pop();
                bl = ParserMacroMethods_this.__push(Uri$Query$Cons$.MODULE$.apply(key2, value, tail));
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private final Rule keyValuePairs$1() {
        if (this.valueStack().size() + 5 <= this.maxValueStackSize()) {
            return this.keyValuePairsWithReversalAvoidance$1();
        }
        return this.keyValuePairsWithLimitedStackUse$1();
    }

    private final boolean liftedTree107$1(UriParser ParserMacroMethods_this$166) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$166.cursorChar() == this.EOI() && ParserMacroMethods_this$166.__advance() && ParserMacroMethods_this$166.__updateMaxCursor() || ParserMacroMethods_this$166.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$166.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$45(UriParser ParserMacroMethods_this$165) {
        boolean bl;
        long mark;
        int start = ParserMacroMethods_this$165.cursor();
        try {
            int start2 = ParserMacroMethods_this$165.cursor();
            try {
                mark = ParserMacroMethods_this$165.__saveState();
                int start3 = ParserMacroMethods_this$165.cursor();
                try {
                    boolean ll = this.liftedTree107$1(ParserMacroMethods_this$165);
                    if (ll) {
                        ParserMacroMethods_this$165.valueStack().push(Uri$Query$Empty$.MODULE$);
                        return true;
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("query"), start);
        }
        {
            boolean l = bl;
            if (l) {
                return true;
            }
            ParserMacroMethods_this$165.__restoreState(mark);
            if (this.keyValuePairs$1() == null) return false;
            return true;
        }
    }

    private final boolean liftedTree108$1(UriParser ParserMacroMethods_this$172) {
        boolean bl;
        try {
            bl = this.fragment$minuschar.apply(ParserMacroMethods_this$172.cursorChar()) && ParserMacroMethods_this$172.__advance() && ParserMacroMethods_this$172.__updateMaxCursor() || ParserMacroMethods_this$172.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("fragment-char"), 0);
            throw ParserMacroMethods_this$172.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(this.fragment$minuschar));
        }
        return bl;
    }

    private final boolean liftedTree109$1(UriParser ParserMacroMethods_this$171, int start$63) {
        boolean bl;
        try {
            boolean ll = this.liftedTree108$1(ParserMacroMethods_this$171);
            bl = ll ? this.appendSB() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$63);
        }
        return bl;
    }

    private final long rec$23(UriParser ParserMacroMethods_this$170, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$170.cursor();
            try {
                long mark2 = ParserMacroMethods_this$170.__saveState();
                int start2 = ParserMacroMethods_this$170.cursor();
                boolean l = this.liftedTree109$1(ParserMacroMethods_this$170, start2);
                if (!l) {
                    ParserMacroMethods_this$170.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$170.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean liftedTree110$1(UriParser ParserMacroMethods_this$169, int start$62) {
        try {
            long firstMark = ParserMacroMethods_this$169.__saveState();
            long mark = this.rec$23(ParserMacroMethods_this$169, firstMark);
            if (mark == firstMark) return false;
            ParserMacroMethods_this$169.__restoreState(mark);
            if (!true) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start$62);
        }
    }

    private final boolean liftedTree111$1(UriParser ParserMacroMethods_this$168, int start$61) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.clearSBForDecoding() != null;
            if (ll) {
                int start = ParserMacroMethods_this$168.cursor();
                bl = this.liftedTree110$1(ParserMacroMethods_this$168, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$61);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$46(UriParser ParserMacroMethods_this$167) {
        int start = ParserMacroMethods_this$167.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$167.cursor();
            long mark = ParserMacroMethods_this$167.__saveState();
            int start3 = ParserMacroMethods_this$167.cursor();
            try {
                int start4 = ParserMacroMethods_this$167.cursor();
                boolean ll = this.liftedTree111$1(ParserMacroMethods_this$167, start4);
                if (ll) {
                    int start5 = ParserMacroMethods_this$167.cursor();
                    try {
                        this.setFragment(this.getDecodedString(this.getDecodedString$default$1()));
                        return true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Run$.MODULE$, start5);
                    }
                }
                bl2 = false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean l = bl2;
            if (l) return true;
            ParserMacroMethods_this$167.__restoreState(mark);
            int start6 = ParserMacroMethods_this$167.cursor();
            try {
                this.setFragment("");
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start6);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("fragment"), start);
        }
    }

    private final long rec$24(UriParser ParserMacroMethods_this$173, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean ll;
            long mark2 = ParserMacroMethods_this$173.__saveState();
            boolean bl2 = ll = this.fragment$minuschar.apply(ParserMacroMethods_this$173.cursorChar()) && ParserMacroMethods_this$173.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this$173.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$173.__saveState();
        }
        return mark;
    }

    private static final boolean liftedTree112$1(UriParser ParserMacroMethods_this$176) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$176.cursorChar() == '%' && ParserMacroMethods_this$176.__advance() && ParserMacroMethods_this$176.__updateMaxCursor() || ParserMacroMethods_this$176.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$176.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('%'));
        }
        return bl;
    }

    private static final boolean liftedTree113$1(UriParser ParserMacroMethods_this$177) {
        boolean bl;
        try {
            bl = CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this$177.cursorChar()) && ParserMacroMethods_this$177.__advance() && ParserMacroMethods_this$177.__updateMaxCursor() || ParserMacroMethods_this$177.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("HEXDIG"), 0);
            throw ParserMacroMethods_this$177.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.HEXDIG()));
        }
        return bl;
    }

    private static final boolean liftedTree114$1(UriParser ParserMacroMethods_this$175, int start$64) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree112$1(ParserMacroMethods_this$175);
            bl = ll ? UriParser.liftedTree113$1(ParserMacroMethods_this$175) : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$64);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$47(UriParser ParserMacroMethods_this$174) {
        int start = ParserMacroMethods_this$174.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$174.cursor();
            int start3 = ParserMacroMethods_this$174.cursor();
            try {
                int start4 = ParserMacroMethods_this$174.cursor();
                boolean ll = UriParser.liftedTree114$1(ParserMacroMethods_this$174, start4);
                if (!ll) return false;
                try {
                    if (!(CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this$174.cursorChar()) && ParserMacroMethods_this$174.__advance() && ParserMacroMethods_this$174.__updateMaxCursor())) {
                        if (!ParserMacroMethods_this$174.__registerMismatch()) return false;
                    }
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    RuleTrace.NonTerminal nonTerminal = RuleTrace$NonTerminal$.MODULE$.apply(RuleTrace$Named$.MODULE$.apply("HEXDIG"), 0);
                    throw ParserMacroMethods_this$174.__bubbleUp(package$.MODULE$.Nil().$colon$colon(nonTerminal), RuleTrace$CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.HEXDIG()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start5 = ParserMacroMethods_this$174.cursor();
            try {
                if (this._firstPercentIx == -1) {
                    this._firstPercentIx = this.sb().length();
                }
                this.sb().append('%').append(this.charAt(-2)).append(this.lastChar());
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start5);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("pct-encoded"), start);
        }
    }

    private static final boolean liftedTree115$1(UriParser ParserMacroMethods_this$181) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$181.cursorChar() == '/' && ParserMacroMethods_this$181.__advance() && ParserMacroMethods_this$181.__updateMaxCursor() || ParserMacroMethods_this$181.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$181.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('/'));
        }
        return bl;
    }

    private final boolean liftedTree116$1(UriParser ParserMacroMethods_this$180, int start$65) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree115$1(ParserMacroMethods_this$180);
            bl = ll ? this.appendSB('/') != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$65);
        }
        return bl;
    }

    private final long rec$25(UriParser ParserMacroMethods_this$179, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$179.cursor();
            try {
                int start2 = ParserMacroMethods_this$179.cursor();
                boolean ll = this.liftedTree116$1(ParserMacroMethods_this$179, start2);
                bl = ll ? this.segment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) break;
            mark = ParserMacroMethods_this$179.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$48(UriParser ParserMacroMethods_this$178) {
        int start = ParserMacroMethods_this$178.cursor();
        try {
            int start2 = ParserMacroMethods_this$178.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$178.cursor();
                try {
                    if (this.clearSB() == null) return false;
                    boolean bl2 = true;
                    boolean ll = bl2;
                    if (!ll) return false;
                    int start4 = ParserMacroMethods_this$178.cursor();
                    try {
                        long firstMark = ParserMacroMethods_this$178.__saveState();
                        long mark = this.rec$25(ParserMacroMethods_this$178, firstMark);
                        if (mark == firstMark) return false;
                        ParserMacroMethods_this$178.__restoreState(mark);
                        bl = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$OneOrMore$.MODULE$, start4);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) {
                    return false;
                }
                if (this.savePath() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("absolute-path"), start);
        }
    }

    private final long rec$26(UriParser ParserMacroMethods_this$182, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean ll2;
            boolean bl = ll2 = ParserMacroMethods_this$182.cursorChar() == '/' && ParserMacroMethods_this$182.__advance();
            boolean bl2 = ll2 ? this.appendSB('/') != null : (ll = false);
            boolean bl3 = ll ? this.segment() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$182.__saveState();
        }
        return mark;
    }

    private static final boolean liftedTree117$1(UriParser ParserMacroMethods_this$187) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$187.cursorChar() == '?' && ParserMacroMethods_this$187.__advance() && ParserMacroMethods_this$187.__updateMaxCursor() || ParserMacroMethods_this$187.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$187.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('?'));
        }
        return bl;
    }

    private final boolean liftedTree118$1(UriParser ParserMacroMethods_this$186, int start$68) {
        boolean bl;
        try {
            boolean ll = UriParser.liftedTree117$1(ParserMacroMethods_this$186);
            bl = ll ? this.rawQueryString() != null : false;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$68);
        }
        return bl;
    }

    private final boolean liftedTree119$1(UriParser ParserMacroMethods_this$185, int start$67) {
        boolean bl;
        try {
            long mark = ParserMacroMethods_this$185.__saveState();
            int start = ParserMacroMethods_this$185.cursor();
            boolean matched = this.liftedTree118$1(ParserMacroMethods_this$185, start);
            if (!matched) {
                ParserMacroMethods_this$185.__restoreState(mark);
            }
            bl = true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start$67);
        }
        return bl;
    }

    private final boolean liftedTree120$1(UriParser ParserMacroMethods_this$184, int start$66) {
        boolean bl;
        try {
            boolean ll;
            boolean bl2 = ll = this.absolute$minuspath() != null;
            if (ll) {
                int start = ParserMacroMethods_this$184.cursor();
                bl = this.liftedTree119$1(ParserMacroMethods_this$184, start);
            } else {
                bl = false;
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start$66);
        }
        return bl;
    }

    private final boolean wrapped$49(UriParser ParserMacroMethods_this$183) {
        boolean bl;
        int start = ParserMacroMethods_this$183.cursor();
        try {
            int start2 = ParserMacroMethods_this$183.cursor();
            try {
                boolean l;
                boolean bl2;
                long mark = ParserMacroMethods_this$183.__saveState();
                int start3 = ParserMacroMethods_this$183.cursor();
                boolean l2 = this.liftedTree120$1(ParserMacroMethods_this$183, start3);
                if (!l2) {
                    ParserMacroMethods_this$183.__restoreState(mark);
                    bl2 = this.absolute$minusURI() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$183.__restoreState(mark);
                    bl = this.authority() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("request-target"), start);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$50(UriParser ParserMacroMethods_this$188) {
        int start = ParserMacroMethods_this$188.cursor();
        try {
            int start2 = ParserMacroMethods_this$188.cursor();
            try {
                if (this.request$minustarget() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$188.cursorChar() == this.EOI() && ParserMacroMethods_this$188.__advance()) {
                        if (ParserMacroMethods_this$188.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$188.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$188.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseHttpRequestTarget"), start);
        }
    }

    private final Rule parseHttpRequestTarget$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$50(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.request$minustarget() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$51(UriParser ParserMacroMethods_this$189) {
        int start = ParserMacroMethods_this$189.cursor();
        try {
            int start2 = ParserMacroMethods_this$189.cursor();
            try {
                if (this.http2$minusauthority$minuspseudo$minusheader() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$189.cursorChar() == this.EOI() && ParserMacroMethods_this$189.__advance()) {
                        if (ParserMacroMethods_this$189.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$189.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$189.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseHttp2AuthorityPseudoHeader"), start);
        }
    }

    private final Rule parseHttp2AuthorityPseudoHeader$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$51(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.http2$minusauthority$minuspseudo$minusheader() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private static final boolean liftedTree121$1(UriParser ParserMacroMethods_this$191) {
        boolean bl;
        try {
            bl = ParserMacroMethods_this$191.cursorChar() == '?' && ParserMacroMethods_this$191.__advance() && ParserMacroMethods_this$191.__updateMaxCursor() || ParserMacroMethods_this$191.__registerMismatch();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) {
                throw throwable;
            }
            throw ParserMacroMethods_this$191.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply('?'));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$52(UriParser ParserMacroMethods_this$190) {
        int start = ParserMacroMethods_this$190.cursor();
        try {
            int start2 = ParserMacroMethods_this$190.cursor();
            try {
                if (this.absolute$minuspath() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$190.cursor();
                try {
                    boolean bl2;
                    long mark = ParserMacroMethods_this$190.__saveState();
                    int start4 = ParserMacroMethods_this$190.cursor();
                    try {
                        boolean ll2 = UriParser.liftedTree121$1(ParserMacroMethods_this$190);
                        if (ll2) {
                            if (this.rawQueryString() != null) {
                                return true;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start4);
                    }
                    boolean matched = bl2;
                    if (!matched) {
                        ParserMacroMethods_this$190.__restoreState(mark);
                    }
                    return true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp(RuleTrace$Optional$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("http2-path-pseudo-header"), start);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$53(UriParser ParserMacroMethods_this$192) {
        int start = ParserMacroMethods_this$192.cursor();
        try {
            int start2 = ParserMacroMethods_this$192.cursor();
            try {
                if (this.http2$minuspath$minuspseudo$minusheader() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$192.cursorChar() == this.EOI() && ParserMacroMethods_this$192.__advance()) {
                        if (ParserMacroMethods_this$192.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$192.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser$StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$192.__bubbleUp(RuleTrace$CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("parseHttp2PathPseudoHeader"), start);
        }
    }

    private final Rule parseHttp2PathPseudoHeader$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$53(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.http2$minuspath$minuspseudo$minusheader() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return Rule$.MODULE$;
        }
        return null;
    }

    private final boolean wrapped$54(UriParser ParserMacroMethods_this$193) {
        boolean bl;
        int start = ParserMacroMethods_this$193.cursor();
        try {
            int start2 = ParserMacroMethods_this$193.cursor();
            try {
                this.sb().append(CharUtils$.MODULE$.toLowerCase(this.lastChar()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("appendLowered"), start);
        }
        return bl;
    }

    private final boolean wrapped$55(UriParser ParserMacroMethods_this$194) {
        boolean bl;
        int start = ParserMacroMethods_this$194.cursor();
        try {
            int start2 = ParserMacroMethods_this$194.cursor();
            try {
                this.setPath(Uri$Path$.MODULE$.apply(this.sb().toString(), this.uriParsingCharset()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("savePath"), start);
        }
        return bl;
    }

    private final boolean wrapped$56(UriParser ParserMacroMethods_this$195) {
        boolean bl;
        int start = ParserMacroMethods_this$195.cursor();
        try {
            int start2 = ParserMacroMethods_this$195.cursor();
            try {
                this.sb().setLength(0);
                this._firstPercentIx = -1;
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp(RuleTrace$Run$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend(RuleTrace$RuleCall$.MODULE$, start).bubbleUp(RuleTrace$Named$.MODULE$.apply("clearSBForDecoding"), start);
        }
        return bl;
    }
}

