/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Char$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class Utf8Encoder$
extends GraphStage<FlowShape<String, ByteString>> {
    private static final int SurrogateHighMask;
    private static final int SurrogateLowMask;
    private static final long Utf8OneByteLimit;
    private static final long Utf8TwoByteLimit;
    private static final long Utf8ThreeByteLimit;
    private static final Inlet stringIn;
    private static final Outlet byteStringOut;
    private static final FlowShape shape;
    private static final Attributes initialAttributes;
    public static final Utf8Encoder$ MODULE$;

    private Utf8Encoder$() {
    }

    static {
        MODULE$ = new Utf8Encoder$();
        SurrogateHighMask = 55296;
        SurrogateLowMask = 56320;
        Utf8OneByteLimit = MODULE$.lowerNBitsSet(7);
        Utf8TwoByteLimit = MODULE$.lowerNBitsSet(11);
        Utf8ThreeByteLimit = MODULE$.lowerNBitsSet(16);
        stringIn = Inlet$.MODULE$.apply("Utf8Encoder.stringIn");
        byteStringOut = Outlet$.MODULE$.apply("Utf8Encoder.byteStringOut");
        shape = FlowShape$.MODULE$.apply(MODULE$.stringIn(), MODULE$.byteStringOut());
        initialAttributes = Attributes$.MODULE$.name("utf8Encoder");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Utf8Encoder$.class);
    }

    public int SurrogateHighMask() {
        return SurrogateHighMask;
    }

    public int SurrogateLowMask() {
        return SurrogateLowMask;
    }

    public long Utf8OneByteLimit() {
        return Utf8OneByteLimit;
    }

    public long Utf8TwoByteLimit() {
        return Utf8TwoByteLimit;
    }

    public long Utf8ThreeByteLimit() {
        return Utf8ThreeByteLimit;
    }

    public long lowerNBitsSet(int n) {
        return (1L << n) - 1L;
    }

    public Inlet<String> stringIn() {
        return stringIn;
    }

    public Outlet<ByteString> byteStringOut() {
        return byteStringOut;
    }

    @Override
    public FlowShape<String, ByteString> shape() {
        return shape;
    }

    @Override
    public Attributes initialAttributes() {
        return initialAttributes;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private int surrogateValue;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(Utf8Encoder$.MODULE$.shape());
                this.surrogateValue = 0;
                this.setHandlers(Utf8Encoder$.MODULE$.stringIn(), Utf8Encoder$.MODULE$.byteStringOut(), this);
            }

            public int surrogateValue() {
                return this.surrogateValue;
            }

            public void surrogateValue_$eq(int x$1) {
                this.surrogateValue = x$1;
            }

            public boolean inSurrogatePair() {
                return this.surrogateValue() != 0;
            }

            public void onPush() {
                ByteStringBuilder builder = new ByteStringBuilder();
                String input = this.grab(Utf8Encoder$.MODULE$.stringIn());
                for (int offset = 0; offset < input.length(); ++offset) {
                    this.step$1(builder, Char$.MODULE$.char2int(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), offset)));
                }
                if (builder.length() > 0) {
                    this.push(Utf8Encoder$.MODULE$.byteStringOut(), builder.result());
                    return;
                }
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            public void onUpstreamFinish() {
                if (this.inSurrogatePair()) {
                    this.failStage(new IllegalArgumentException("Truncated String input (ends in the middle of surrogate pair)"));
                    return;
                }
                this.completeStage();
            }

            public void onPull() {
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            private final void step$1(ByteStringBuilder builder$2, int n) {
                if (!this.inSurrogatePair()) {
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8OneByteLimit()) {
                        builder$2.$plus$eq(BoxesRunTime.boxToByte((byte)n));
                        return;
                    }
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8TwoByteLimit()) {
                        Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0xC0 | (n & 0x7C0) >> 6);
                        Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0x80 | n & 0x3F);
                        return;
                    }
                    if (n >= Utf8Encoder$.MODULE$.SurrogateHighMask() && n < Utf8Encoder$.MODULE$.SurrogateLowMask()) {
                        this.surrogateValue_$eq(65536 + ((n & 0x3FF) << 10));
                        return;
                    }
                    if (n >= Utf8Encoder$.MODULE$.SurrogateLowMask() && n < 57343) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("Unexpected UTF-16 surrogate continuation", ScalaRunTime$.MODULE$.genericWrapArray(new Object[0])));
                    }
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8ThreeByteLimit()) {
                        Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0xE0 | (n & 0xF000) >> 12);
                        Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0x80 | (n & 0xFC0) >> 6);
                        Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0x80 | n & 0x3F);
                        return;
                    }
                    throw new IllegalStateException("Char cannot be >= 2^16");
                }
                if (n >= Utf8Encoder$.MODULE$.SurrogateLowMask() && n <= 57343) {
                    this.surrogateValue_$eq(this.surrogateValue() | n & 0x3FF);
                    Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0xF0 | (this.surrogateValue() & 0x1C0000) >> 18);
                    Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0x80 | (this.surrogateValue() & 0x3F000) >> 12);
                    Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0x80 | (this.surrogateValue() & 0xFC0) >> 6);
                    Utf8Encoder$.org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(builder$2, 0x80 | this.surrogateValue() & 0x3F);
                    this.surrogateValue_$eq(0);
                    return;
                }
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("Expected UTF-16 surrogate continuation", ScalaRunTime$.MODULE$.genericWrapArray(new Object[0])));
            }
        };
    }

    public String toString() {
        return "Utf8Encoder";
    }

    public static final void org$apache$pekko$http$impl$engine$ws$Utf8Encoder$$anon$1$$_$b$1(ByteStringBuilder builder$1, int v) {
        builder$1.$plus$eq(BoxesRunTime.boxToByte((byte)v));
    }
}

