/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.util.Random;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameError$;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventOrError;
import org.apache.pekko.http.impl.engine.ws.FrameEventParser$;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.FrameStart$;
import org.apache.pekko.http.impl.engine.ws.Masking$;
import org.apache.pekko.http.impl.engine.ws.Masking$Masker$;
import org.apache.pekko.http.impl.engine.ws.Protocol;
import org.apache.pekko.http.impl.engine.ws.ProtocolException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.MatchError;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class Masking {
    public static BidiFlow<FrameEvent, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> apply(boolean bl, Function0<Random> function0) {
        return Masking$.MODULE$.apply(bl, function0);
    }

    public static Flow<FrameEvent, FrameEvent, NotUsed> maskIf(boolean bl, Function0<Random> function0) {
        return Masking$.MODULE$.maskIf(bl, function0);
    }

    public static Flow<FrameEvent, FrameEventOrError, NotUsed> unmaskIf(boolean bl) {
        return Masking$.MODULE$.unmaskIf(bl);
    }

    public static abstract class Masker
    extends GraphStage<FlowShape<FrameEvent, FrameEventOrError>> {
        private final Inlet in = Inlet$.MODULE$.apply(new StringBuilder(3).append(this.toString()).append("-in").toString());
        private final Outlet out = Outlet$.MODULE$.apply(new StringBuilder(4).append(this.toString()).append("-out").toString());
        private final FlowShape shape = FlowShape$.MODULE$.apply(this.in(), this.out());

        public abstract int extractMask(FrameHeader var1);

        public abstract FrameHeader setNewMask(FrameHeader var1, int var2);

        public Inlet<FrameEvent> in() {
            return this.in;
        }

        public Outlet<FrameEventOrError> out() {
            return this.out;
        }

        @Override
        public FlowShape<FrameEvent, FrameEventOrError> shape() {
            return this.shape;
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new OutHandler(this){
                private final /* synthetic */ Masker $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandler($outer.in(), this);
                    this.setHandler($outer.out(), this);
                }

                public void onPush() {
                    FrameEvent frameEvent = this.grab(this.$outer.in());
                    if (frameEvent instanceof FrameStart) {
                        FrameStart frameStart = (FrameStart)frameEvent;
                        FrameStart frameStart2 = FrameStart$.MODULE$.unapply(frameStart);
                        FrameHeader frameHeader = frameStart2._1();
                        ByteString byteString = frameStart2._2();
                        FrameHeader header = frameHeader;
                        ByteString data = byteString;
                        FrameStart start = frameStart;
                        try {
                            int mask = this.$outer.extractMask(header);
                            Tuple2<ByteString, Object> tuple2 = FrameEventParser$.MODULE$.mask(data, mask);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = tuple2._1();
                            int newMask = BoxesRunTime.unboxToInt(tuple2._2());
                            Tuple2<ByteString, Integer> tuple22 = Tuple2$.MODULE$.apply(masked, BoxesRunTime.boxToInteger(newMask));
                            ByteString masked2 = tuple22._1();
                            int newMask2 = BoxesRunTime.unboxToInt(tuple22._2());
                            if (!start.lastPart()) {
                                this.setHandler(this.$outer.in(), this.runningHandler(newMask2, this));
                            }
                            this.push(this.$outer.out(), start.copy(this.$outer.setNewMask(header, mask), masked2));
                        }
                        catch (ProtocolException p) {
                            this.setHandler(this.$outer.in(), this.doneHandler());
                            this.push(this.$outer.out(), FrameError$.MODULE$.apply(p));
                        }
                        return;
                    }
                    if (frameEvent instanceof FrameData) {
                        this.fail(this.$outer.out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                        return;
                    }
                    throw new MatchError(frameEvent);
                }

                private InHandler doneHandler() {
                    return new InHandler(this){
                        private final /* synthetic */ Masker$$anon$1 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void onPush() {
                            this.$outer.protected$pull(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$_$$anon$$$outer().in());
                        }
                    };
                }

                private InHandler runningHandler(int initialMask, InHandler nextState) {
                    return new InHandler(initialMask, nextState, this){
                        private final InHandler nextState$2;
                        private int mask;
                        private final /* synthetic */ Masker$$anon$1 $outer;
                        {
                            this.nextState$2 = nextState$1;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.mask = initialMask$1;
                        }

                        public int mask() {
                            return this.mask;
                        }

                        public void mask_$eq(int x$1) {
                            this.mask = x$1;
                        }

                        public void onPush() {
                            Tuple2<ByteString, Object> tuple2;
                            FrameEvent part = (FrameEvent)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$_$$anon$$$outer().in());
                            if (part.lastPart()) {
                                this.$outer.protected$setHandler(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$_$$anon$$$outer().in(), this.nextState$2);
                            }
                            if ((tuple2 = FrameEventParser$.MODULE$.mask(part.data(), this.mask())) == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = tuple2._1();
                            int newMask = BoxesRunTime.unboxToInt(tuple2._2());
                            Tuple2<ByteString, Integer> tuple22 = Tuple2$.MODULE$.apply(masked, BoxesRunTime.boxToInteger(newMask));
                            ByteString masked2 = tuple22._1();
                            int newMask2 = BoxesRunTime.unboxToInt(tuple22._2());
                            this.mask_$eq(newMask2);
                            this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$_$$anon$$$outer().out(), part.withData(masked2));
                        }
                    };
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public void protected$pull(Inlet in) {
                    this.pull(in);
                }

                public Object protected$grab(Inlet in) {
                    return this.grab(in);
                }

                public void protected$setHandler(Inlet in, InHandler handler) {
                    this.setHandler(in, handler);
                }

                public void protected$push(Outlet out, Object elem) {
                    this.push(out, elem);
                }

                public final /* synthetic */ Masker org$apache$pekko$http$impl$engine$ws$Masking$Masker$_$$anon$$$outer() {
                    return this.$outer;
                }
            };
        }
    }

    public static final class Masking
    extends Masker {
        private final Random random;

        public Masking(Random random) {
            this.random = random;
        }

        @Override
        public int extractMask(FrameHeader header) {
            return this.random.nextInt();
        }

        @Override
        public FrameHeader setNewMask(FrameHeader header, int mask) {
            if (header.mask().isDefined()) {
                throw new ProtocolException("Frame mustn't already be masked");
            }
            Some<Object> some = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(mask));
            Protocol.Opcode opcode = header.copy$default$1();
            long l = header.copy$default$3();
            boolean bl = header.copy$default$4();
            boolean bl2 = header.copy$default$5();
            boolean bl3 = header.copy$default$6();
            boolean bl4 = header.copy$default$7();
            return header.copy(opcode, some, l, bl, bl2, bl3, bl4);
        }

        public String toString() {
            return new StringBuilder(9).append("Masking(").append(this.random).append(")").toString();
        }
    }
}

