/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameData$;
import org.apache.pekko.http.impl.engine.ws.FrameError;
import org.apache.pekko.http.impl.engine.ws.FrameError$;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventOrError;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.FrameStart$;
import org.apache.pekko.http.impl.engine.ws.ProtocolException;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Attributes$LogLevels$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class FrameLogger$
implements Serializable {
    public static final FrameLogger$ MODULE$ = new FrameLogger$();

    private FrameLogger$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FrameLogger$.class);
    }

    public final int maxBytes() {
        return 16;
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> logFramesIfEnabled(boolean shouldLog) {
        if (shouldLog) {
            return this.bidi();
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> bidi() {
        Flow flow = Flow$.MODULE$.apply();
        String string2 = new StringBuilder(13).append("\u001b[31m").append("DOWN").append("\u001b[0m").toString();
        Function1<FrameEventOrError, Object> & Serializable intersect = (Function1<FrameEventOrError, Object> & Serializable)frameEvent -> this.logEvent((FrameEventOrError)frameEvent);
        Flow flow2 = Flow$.MODULE$.apply();
        String string3 = new StringBuilder(13).append("\u001b[32m").append(" UP ").append("\u001b[0m").toString();
        Function1<FrameEvent, Object> & Serializable intersect2 = (Function1<FrameEvent, Object> & Serializable)frameEvent -> this.logEvent((FrameEventOrError)frameEvent);
        return BidiFlow$.MODULE$.fromFlows((Graph)((Object)flow.log(string2, intersect, flow.log$default$3(string2, intersect))), (Graph)((Object)flow2.log(string3, intersect2, flow2.log$default$3(string3, intersect2)))).addAttributes(Attributes$.MODULE$.apply(Attributes$LogLevels$.MODULE$.apply(Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel())));
    }

    public String logEvent(FrameEventOrError frameEvent) {
        FrameEventOrError frameEventOrError = frameEvent;
        if (frameEventOrError instanceof FrameStart) {
            FrameStart frameStart = (FrameStart)frameEventOrError;
            FrameStart frameStart2 = FrameStart$.MODULE$.unapply(frameStart);
            FrameHeader frameHeader = frameStart2._1();
            ByteString byteString = frameStart2._2();
            FrameHeader header = frameHeader;
            ByteString data = byteString;
            FrameStart f = frameStart;
            return this.displayLogEntry$1(header.opcode().short(), header.length(), this.hex$1(data), f.lastPart(), ScalaRunTime$.MODULE$.wrapRefArray(new Option[]{this.flag$1(header.fin(), "FIN"), this.flag$1(header.rsv1(), "RSV1"), this.flag$1(header.rsv2(), "RSV2"), this.flag$1(header.rsv3(), "RSV3")}));
        }
        if (frameEventOrError instanceof FrameData) {
            FrameData frameData = FrameData$.MODULE$.unapply((FrameData)frameEventOrError);
            ByteString byteString = frameData._1();
            boolean bl = frameData._2();
            ByteString data = byteString;
            boolean lastPart = bl;
            return this.displayLogEntry$1("DATA", 0L, this.hex$1(data), lastPart, ScalaRunTime$.MODULE$.wrapRefArray(new Option[0]));
        }
        if (frameEventOrError instanceof FrameError) {
            ProtocolException protocolException;
            FrameError frameError = FrameError$.MODULE$.unapply((FrameError)frameEventOrError);
            ProtocolException ex = protocolException = frameError._1();
            return StringOps$.MODULE$.format$extension("%sError: %s%s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{"\u001b[31m", ex.getMessage(), "\u001b[0m"}));
        }
        throw new MatchError(frameEventOrError);
    }

    private final String displayLogEntry$1(String frameType, long length, String data, boolean lastPart, Seq flags) {
        String f = flags.nonEmpty() ? new StringBuilder(6).append(" ").append("\u001b[31m").append(((IterableOnceOps)flags.flatten(Predef$.MODULE$.$conforms())).mkString(" ")).toString() : "";
        String l = length > 0L ? StringOps$.MODULE$.format$extension(" %s%d bytes", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{"\u001b[33m", BoxesRunTime.boxToLong(length)})) : "";
        return StringOps$.MODULE$.format$extension("%s%s%s%s%s %s%s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{"\u001b[32m", frameType, f, l, "\u001b[0m", data, !lastPart ? " ..." : ""}));
    }

    private final Option flag$1(boolean value, String name) {
        if (value) {
            return Some$.MODULE$.apply(name);
        }
        return None$.MODULE$;
    }

    private final /* synthetic */ String $anonfun$3(byte _$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToByte(_$1)}));
    }

    private final /* synthetic */ char $anonfun$4(byte b) {
        return LogByteStringTools$.MODULE$.asASCII(b);
    }

    private final String hex$1(ByteString bytes) {
        int num = package$.MODULE$.min(16, bytes.size());
        String ellipsis = num < bytes.size() ? new StringBuilder(18).append(" [... ").append(bytes.size() - num).append(" more bytes]").toString() : "";
        ByteString first = bytes.take(num);
        String h = ((IterableOnceOps)first.map((Function1<Object, String> & Serializable)_$1 -> this.$anonfun$3(BoxesRunTime.unboxToByte(_$1)))).mkString(" ");
        String ascii = ((IterableOnceOps)first.map((Function1<Object, char> & Serializable)b -> this.$anonfun$4(BoxesRunTime.unboxToByte(b)))).mkString();
        return new StringBuilder(21).append("\u001b[37m").append(h).append("\u001b[0m").append(" | ").append("\u001b[37m").append(ascii).append("\u001b[0m").append(ellipsis).toString();
    }
}

