/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.server;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.server.MasterServerTerminator$AliveConnectionTerminators$;
import org.apache.pekko.http.impl.engine.server.MasterServerTerminator$Terminating$;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$HttpServerTerminated$;
import org.apache.pekko.util.PrettyDuration$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class MasterServerTerminator
implements ServerTerminator {
    public final LoggingAdapter org$apache$pekko$http$impl$engine$server$MasterServerTerminator$$log;
    private final AtomicReference<State> terminators;
    private final Promise<Http.HttpTerminated> termination;

    public MasterServerTerminator(LoggingAdapter log) {
        this.org$apache$pekko$http$impl$engine$server$MasterServerTerminator$$log = log;
        this.terminators = new AtomicReference<AliveConnectionTerminators>(MasterServerTerminator$AliveConnectionTerminators$.MODULE$.apply((Set<ServerTerminator>)Predef$.MODULE$.Set().empty()));
        this.termination = Promise$.MODULE$.apply();
    }

    public boolean registerConnection(ServerTerminator terminator, ExecutionContext ec) {
        State state;
        while ((state = this.terminators.get()) instanceof AliveConnectionTerminators) {
            AliveConnectionTerminators aliveConnectionTerminators = (AliveConnectionTerminators)state;
            AliveConnectionTerminators v = aliveConnectionTerminators;
            AliveConnectionTerminators aliveConnectionTerminators2 = MasterServerTerminator$AliveConnectionTerminators$.MODULE$.unapply(aliveConnectionTerminators);
            Set<ServerTerminator> set = aliveConnectionTerminators2._1();
            Set<ServerTerminator> ts = set;
            if (!this.terminators.compareAndSet(v, v.copy((Set)ts.$plus(terminator)))) continue;
            return true;
        }
        if (state instanceof Terminating) {
            Deadline deadline;
            Terminating terminating = MasterServerTerminator$Terminating$.MODULE$.unapply((Terminating)state);
            Deadline deadline2 = deadline = terminating._1();
            terminator.terminate(deadline2.timeLeft(), ec);
            return false;
        }
        throw new MatchError(state);
    }

    public void removeConnection(ServerTerminator terminator) {
        State state;
        while ((state = this.terminators.get()) instanceof AliveConnectionTerminators) {
            AliveConnectionTerminators aliveConnectionTerminators = (AliveConnectionTerminators)state;
            AliveConnectionTerminators v = aliveConnectionTerminators;
            AliveConnectionTerminators aliveConnectionTerminators2 = MasterServerTerminator$AliveConnectionTerminators$.MODULE$.unapply(aliveConnectionTerminators);
            Set<ServerTerminator> set = aliveConnectionTerminators2._1();
            Set<ServerTerminator> ts = set;
            if (!this.terminators.compareAndSet(v, v.copy((Set)ts.$minus(terminator)))) continue;
            return;
        }
        if (state instanceof Terminating) {
            return;
        }
        throw new MatchError(state);
    }

    @Override
    public Future<Http.HttpTerminated> terminate(FiniteDuration timeout, ExecutionContext ex) {
        State state;
        while ((state = this.terminators.get()) instanceof AliveConnectionTerminators) {
            Set<ServerTerminator> set;
            AliveConnectionTerminators aliveConnectionTerminators = (AliveConnectionTerminators)state;
            AliveConnectionTerminators aliveConnectionTerminators2 = MasterServerTerminator$AliveConnectionTerminators$.MODULE$.unapply(aliveConnectionTerminators);
            Set<ServerTerminator> emptyTs = set = aliveConnectionTerminators2._1();
            AliveConnectionTerminators v = aliveConnectionTerminators;
            if (emptyTs.isEmpty()) {
                if (!this.terminators.compareAndSet(v, MasterServerTerminator$Terminating$.MODULE$.apply(timeout.fromNow()))) continue;
                this.termination.trySuccess(Http$HttpServerTerminated$.MODULE$);
                return this.termination.future();
            }
            Set<ServerTerminator> ts = set;
            AliveConnectionTerminators v2 = aliveConnectionTerminators;
            if (!this.terminators.compareAndSet(v2, MasterServerTerminator$Terminating$.MODULE$.apply(timeout.fromNow()))) continue;
            Future connectionsTerminated = Future$.MODULE$.sequence((IterableOnce)ts.map((Function1<ServerTerminator, Future> & Serializable)t -> t.terminate(timeout, ex).recover(new Serializable((ServerTerminator)t, this){
                private final ServerTerminator t$1;
                private final /* synthetic */ MasterServerTerminator $outer;
                {
                    this.t$1 = t$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable ex = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable ex = throwable = x;
                    this.$outer.org$apache$pekko$http$impl$engine$server$MasterServerTerminator$$log.warning("Ignoring termination failure of {}, failure was: {}", this.t$1, (Object)ex.getMessage());
                    return Http$HttpServerTerminated$.MODULE$;
                }
            }, ex)), BuildFrom$.MODULE$.buildFromIterableOps(), ex);
            Future serverTerminated = connectionsTerminated.map((Function1<Set, Http$HttpServerTerminated$> & Serializable)_$1 -> Http$HttpServerTerminated$.MODULE$, ex);
            this.termination.completeWith(serverTerminated);
            return this.termination.future();
        }
        if (state instanceof Terminating) {
            Deadline deadline;
            Terminating terminating = MasterServerTerminator$Terminating$.MODULE$.unapply((Terminating)state);
            Deadline existingDeadline = deadline = terminating._1();
            this.org$apache$pekko$http$impl$engine$server$MasterServerTerminator$$log.warning(new StringBuilder(87).append("Issued terminate(").append(timeout).append(") while termination is in progress already (with deadline: time left: ").append(PrettyDuration$.MODULE$.format(existingDeadline.timeLeft())).toString());
            return this.termination.future();
        }
        throw new MatchError(state);
    }

    public static final class AliveConnectionTerminators
    implements State,
    Product,
    Serializable {
        private final Set ts;

        public static AliveConnectionTerminators apply(Set<ServerTerminator> set) {
            return MasterServerTerminator$AliveConnectionTerminators$.MODULE$.apply(set);
        }

        public static AliveConnectionTerminators fromProduct(Product product) {
            return MasterServerTerminator$AliveConnectionTerminators$.MODULE$.fromProduct(product);
        }

        public static AliveConnectionTerminators unapply(AliveConnectionTerminators aliveConnectionTerminators) {
            return MasterServerTerminator$AliveConnectionTerminators$.MODULE$.unapply(aliveConnectionTerminators);
        }

        public AliveConnectionTerminators(Set<ServerTerminator> ts) {
            this.ts = ts;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AliveConnectionTerminators)) return false;
            AliveConnectionTerminators aliveConnectionTerminators = (AliveConnectionTerminators)object;
            Set<ServerTerminator> set = this.ts();
            Set<ServerTerminator> set2 = aliveConnectionTerminators.ts();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof AliveConnectionTerminators;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "AliveConnectionTerminators";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ts";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Set<ServerTerminator> ts() {
            return this.ts;
        }

        public AliveConnectionTerminators copy(Set<ServerTerminator> ts) {
            return new AliveConnectionTerminators(ts);
        }

        public Set<ServerTerminator> copy$default$1() {
            return this.ts();
        }

        public Set<ServerTerminator> _1() {
            return this.ts();
        }
    }

    public static interface State {
    }

    public static final class Terminating
    implements State,
    Product,
    Serializable {
        private final Deadline deadline;

        public static Terminating apply(Deadline deadline) {
            return MasterServerTerminator$Terminating$.MODULE$.apply(deadline);
        }

        public static Terminating fromProduct(Product product) {
            return MasterServerTerminator$Terminating$.MODULE$.fromProduct(product);
        }

        public static Terminating unapply(Terminating terminating) {
            return MasterServerTerminator$Terminating$.MODULE$.unapply(terminating);
        }

        public Terminating(Deadline deadline) {
            this.deadline = deadline;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Terminating)) return false;
            Terminating terminating = (Terminating)object;
            Deadline deadline = this.deadline();
            Deadline deadline2 = terminating.deadline();
            if (deadline != null) {
                if (!((Object)deadline).equals(deadline2)) return false;
                return true;
            }
            if (deadline2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Terminating;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Terminating";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "deadline";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Deadline deadline() {
            return this.deadline;
        }

        public Terminating copy(Deadline deadline) {
            return new Terminating(deadline);
        }

        public Deadline copy$default$1() {
            return this.deadline();
        }

        public Deadline _1() {
            return this.deadline();
        }
    }
}

