/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.server;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpRequestParser;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$MessageStartError$;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.impl.engine.rendering.HttpResponseRendererFactory;
import org.apache.pekko.http.impl.engine.rendering.ResponseRenderingContext;
import org.apache.pekko.http.impl.engine.rendering.ResponseRenderingOutput;
import org.apache.pekko.http.impl.engine.server.HttpAttributes;
import org.apache.pekko.http.impl.engine.server.HttpServerBluePrint;
import org.apache.pekko.http.impl.engine.server.HttpServerBluePrint$DummyCancellable$;
import org.apache.pekko.http.impl.engine.server.HttpServerBluePrint$SubscriptionTimeout$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.impl.util.One2OneBidiFlow$;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.TimeoutAccess;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.IllegalUriException;
import org.apache.pekko.http.scaladsl.model.RemoteAddress$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.TLSProtocol$SendBytes$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class HttpServerBluePrint$
implements Serializable {
    private static final BidiFlow tlsSupport;
    public static final HttpServerBluePrint$DummyCancellable$ org$apache$pekko$http$impl$engine$server$HttpServerBluePrint$$$DummyCancellable;
    public static final HttpServerBluePrint$SubscriptionTimeout$ org$apache$pekko$http$impl$engine$server$HttpServerBluePrint$$$SubscriptionTimeout;
    public static final HttpServerBluePrint$ MODULE$;

    private HttpServerBluePrint$() {
    }

    static {
        MODULE$ = new HttpServerBluePrint$();
        tlsSupport = BidiFlow$.MODULE$.fromFlows((Graph)((Object)Flow$.MODULE$.apply().map((Function1<ByteString, TLSProtocol.SendBytes> & Serializable)_$1 -> TLSProtocol$SendBytes$.MODULE$.apply((ByteString)_$1))), (Graph)((Object)Flow$.MODULE$.apply().collect((PartialFunction)((Object)new Serializable(){

            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x;
                if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                    TLSProtocol.SessionBytes x2 = (TLSProtocol.SessionBytes)sslTlsInbound;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(TLSProtocol.SslTlsInbound x, Function1 function1) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x;
                if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                    TLSProtocol.SessionBytes x2 = (TLSProtocol.SessionBytes)sslTlsInbound;
                    return x2;
                }
                return function1.apply(x);
            }
        }))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpServerBluePrint$.class);
    }

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> apply(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection, DateHeaderRendering dateHeaderRendering) {
        return this.userHandlerGuard(settings.pipeliningLimit()).atop(this.requestTimeoutSupport(settings.timeouts().requestTimeout(), log)).atop(this.requestPreparation(settings)).atop(this.controller(settings, log)).atop(this.parsingRendering(settings, log, isSecureConnection, dateHeaderRendering)).atop(this.websocketSupport(settings, log)).atop(this.tlsSupport()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport() {
        return tlsSupport;
    }

    public BidiFlow<ResponseRenderingOutput, ByteString, TLSProtocol.SessionBytes, TLSProtocol.SessionBytes, NotUsed> websocketSupport(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph(new HttpServerBluePrint.ProtocolSwitchStage(settings, log));
    }

    public BidiFlow<ResponseRenderingContext, ResponseRenderingOutput, TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsingRendering(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection, DateHeaderRendering dateHeaderRendering) {
        return BidiFlow$.MODULE$.fromFlows(this.rendering(settings, log, dateHeaderRendering), this.parsing(settings, log, isSecureConnection));
    }

    public BidiFlow<HttpResponse, ResponseRenderingContext, ParserOutput.RequestOutput, ParserOutput.RequestOutput, NotUsed> controller(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph(new HttpServerBluePrint.ControllerStage(settings, log)).reversed();
    }

    public BidiFlow<HttpResponse, HttpResponse, ParserOutput.RequestOutput, HttpRequest, NotUsed> requestPreparation(ServerSettings settings) {
        return BidiFlow$.MODULE$.fromFlows(Flow$.MODULE$.apply(), new HttpServerBluePrint.PrepareRequests(settings));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> requestTimeoutSupport(Duration timeout, LoggingAdapter log) {
        Duration duration = timeout;
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        if (!(duration != null ? !duration.equals(finiteDuration) : finiteDuration != null)) {
            return BidiFlow$.MODULE$.identity();
        }
        return BidiFlow$.MODULE$.fromGraph(new HttpServerBluePrint.RequestTimeoutSupport(timeout, log)).reversed();
    }

    public Flow<TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsing(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection) {
        HttpRequestParser rootParser = new HttpRequestParser(settings.parserSettings(), settings.websocketSettings(), settings.rawRequestUriHeader(), HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log));
        return (Flow)((Flow)Flow$.MODULE$.apply().via((Graph)rootParser)).map((Function1<ParserOutput.RequestOutput, ParserOutput.RequestOutput> & Serializable)requestOutput -> this.establishAbsoluteUri$1(isSecureConnection, settings, (ParserOutput.RequestOutput)requestOutput));
    }

    public Flow<ResponseRenderingContext, ResponseRenderingOutput, NotUsed> rendering(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        HttpResponseRendererFactory responseRendererFactory = new HttpResponseRendererFactory(settings.serverHeader(), settings.responseHeaderSizeHint(), log, dateHeaderRendering);
        return Flow$.MODULE$.apply().via(responseRendererFactory.renderer().named("renderer"));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> userHandlerGuard(int pipeliningLimit) {
        return One2OneBidiFlow$.MODULE$.apply(pipeliningLimit, One2OneBidiFlow$.MODULE$.apply$default$2(), One2OneBidiFlow$.MODULE$.apply$default$3()).reversed();
    }

    public static final /* synthetic */ InetSocketAddress org$apache$pekko$http$impl$engine$server$HttpServerBluePrint$PrepareRequests$$anon$2$$_$$lessinit$greater$$anonfun$2(HttpAttributes.RemoteAddress _$2) {
        return _$2.address();
    }

    public static final HttpRequest org$apache$pekko$http$impl$engine$server$HttpServerBluePrint$PrepareRequests$$anon$2$$_$_$$anonfun$1(HttpRequest httpRequest$1) {
        return httpRequest$1;
    }

    public static final /* synthetic */ HttpRequest org$apache$pekko$http$impl$engine$server$HttpServerBluePrint$PrepareRequests$$anon$2$$_$_$$anonfun$2(HttpRequest httpRequest$2, InetSocketAddress remoteAddress) {
        return (HttpRequest)httpRequest$2.addAttribute((AttributeKey)AttributeKeys$.MODULE$.remoteAddress(), RemoteAddress$.MODULE$.apply(remoteAddress));
    }

    private final ParserOutput.RequestOutput establishAbsoluteUri$1(boolean isSecureConnection$1, ServerSettings settings$1, ParserOutput.RequestOutput requestOutput) {
        ParserOutput.RequestOutput requestOutput2 = requestOutput;
        if (requestOutput2 instanceof ParserOutput.RequestStart) {
            ParserOutput.MessageStart messageStart;
            ParserOutput.RequestStart requestStart;
            ParserOutput.RequestStart connect = requestStart = (ParserOutput.RequestStart)requestOutput2;
            HttpMethod httpMethod = connect.method();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.CONNECT();
            if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                return ParserOutput$MessageStartError$.MODULE$.apply(StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("CONNECT requests are not supported", new StringBuilder(31).append("Rejecting CONNECT request to '").append(connect.uri()).append("'").toString()));
            }
            ParserOutput.RequestStart start = requestStart;
            try {
                Uri effectiveUri = HttpRequest$.MODULE$.effectiveUri(start.uri(), start.headers(), isSecureConnection$1, settings$1.defaultHostHeader());
                messageStart = start.copy(start.copy$default$1(), effectiveUri, start.copy$default$3(), start.copy$default$4(), start.copy$default$5(), start.copy$default$6(), start.copy$default$7(), start.copy$default$8());
            }
            catch (IllegalUriException e) {
                messageStart = ParserOutput$MessageStartError$.MODULE$.apply(StatusCodes$.MODULE$.BadRequest(), e.info());
            }
            return messageStart;
        }
        ParserOutput.RequestOutput x = requestOutput2;
        return x;
    }

    public static final /* synthetic */ boolean org$apache$pekko$http$impl$engine$server$HttpServerBluePrint$RequestTimeoutSupport$$anon$4$$_$$lessinit$greater$$anonfun$3$$anonfun$1(TimeoutAccess timeout$1, HttpServerBluePrint.TimeoutAccessImpl _$4) {
        return _$4 == timeout$1;
    }
}

