/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.server;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.server.GracefulTerminatorStage$;
import org.apache.pekko.http.impl.engine.server.ServerTerminationDeadlineReached;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$HttpConnectionTerminated$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$HttpEntityScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Connection$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BidiShape;
import org.apache.pekko.stream.BidiShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.stream.stage.TimerGraphStageLogic;
import org.apache.pekko.util.PrettyDuration$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class GracefulTerminatorStage
extends GraphStageWithMaterializedValue<BidiShape<HttpResponse, HttpResponse, HttpRequest, HttpRequest>, ServerTerminator> {
    public final ServerSettings org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$settings;
    private final Inlet fromNet;
    private final Outlet toUser;
    private final Inlet fromUser;
    private final Outlet toNet;

    public static BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, ServerTerminator> apply(ActorSystem actorSystem, ServerSettings serverSettings) {
        return GracefulTerminatorStage$.MODULE$.apply(actorSystem, serverSettings);
    }

    public GracefulTerminatorStage(ServerSettings settings) {
        this.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$settings = settings;
        this.fromNet = Inlet$.MODULE$.apply("netIn");
        this.toUser = Outlet$.MODULE$.apply("userOut");
        this.fromUser = Inlet$.MODULE$.apply("userIn");
        this.toNet = Outlet$.MODULE$.apply("netOut");
    }

    public Inlet<HttpRequest> fromNet() {
        return this.fromNet;
    }

    public Outlet<HttpRequest> toUser() {
        return this.toUser;
    }

    public Inlet<HttpResponse> fromUser() {
        return this.fromUser;
    }

    public Outlet<HttpResponse> toNet() {
        return this.toNet;
    }

    @Override
    public BidiShape<HttpResponse, HttpResponse, HttpRequest, HttpRequest> shape() {
        return BidiShape$.MODULE$.apply(this.fromUser(), this.toNet(), this.fromNet(), this.toUser());
    }

    public final String TerminationDeadlineTimerKey() {
        return "TerminationDeadlineTimerKey";
    }

    @Override
    public Tuple2<GraphStageLogic, ServerTerminator> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise<Function1<FiniteDuration, Future<Http.HttpTerminated>>> triggerTermination = Promise$.MODULE$.apply();
        ConnectionTerminator selfTerminator = new ConnectionTerminator(this, triggerTermination);
        StageLogging logic = new StageLogging(triggerTermination, this){
            private final Promise triggerTermination$1;
            public static final long OFFSET$0;
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final Promise terminationOfConnectionDone;
            private volatile Object failureCallback$lzy1;
            private boolean pendingUserHandlerResponse;
            private final /* synthetic */ GracefulTerminatorStage $outer;
            {
                this.triggerTermination$1 = triggerTermination$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$(this);
                this.terminationOfConnectionDone = Promise$.MODULE$.apply();
                this.pendingUserHandlerResponse = false;
                this.setHandler($outer.fromUser(), new InHandler(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        HttpResponse response = (HttpResponse)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromUser());
                        this.$outer.pendingUserHandlerResponse_$eq(false);
                        this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().toNet(), response);
                    }

                    public void onUpstreamFinish() {
                        this.$outer.protected$complete(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().toNet());
                    }
                });
                this.setHandler($outer.toUser(), new OutHandler(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        this.$outer.protected$pull(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromNet());
                    }
                });
                this.setHandler($outer.fromNet(), new InHandler(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        HttpRequest request = (HttpRequest)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromNet());
                        this.$outer.pendingUserHandlerResponse_$eq(true);
                        this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().toUser(), request);
                    }

                    public void onUpstreamFinish() {
                        this.$outer.protected$complete(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().toUser());
                    }
                });
                this.setHandler($outer.toNet(), new OutHandler(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        this.$outer.protected$pull(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromUser());
                    }
                });
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$2.class.getDeclaredField("failureCallback$lzy1"));
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public Class logSource() {
                return GracefulTerminatorStage.class;
            }

            public Promise terminationOfConnectionDone() {
                return this.terminationOfConnectionDone;
            }

            public AsyncCallback failureCallback() {
                Object object = this.failureCallback$lzy1;
                if (object instanceof AsyncCallback) {
                    return (AsyncCallback)object;
                }
                if (object == LazyVals$NullValue$.MODULE$) {
                    return null;
                }
                return (AsyncCallback)this.failureCallback$lzyINIT1();
            }

            private Object failureCallback$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.failureCallback$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            AsyncCallback<T> asyncCallback = null;
                            try {
                                asyncCallback = this.getAsyncCallback(ex -> this.failStage((Throwable)ex));
                                object2 = asyncCallback == null ? LazyVals$NullValue$.MODULE$ : asyncCallback;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.failureCallback$lzy1;
                                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return asyncCallback;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals$Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public boolean pendingUserHandlerResponse() {
                return this.pendingUserHandlerResponse;
            }

            public void pendingUserHandlerResponse_$eq(boolean x$1) {
                this.pendingUserHandlerResponse = x$1;
            }

            public void preStart() {
                AsyncCallback<T> terminateSignal = this.getAsyncCallback(deadline -> {
                    this.log().debug("[terminator] Initializing termination of server, deadline: {}", PrettyDuration$.MODULE$.format((Duration)deadline));
                    this.installTerminationHandlers(deadline.fromNow());
                    this.scheduleOnce((Object)"TerminationDeadlineTimerKey", (FiniteDuration)deadline);
                });
                AsyncCallback asyncCallback = this.failureCallback();
                this.triggerTermination$1.success((Function1<FiniteDuration, Future> & Serializable)d -> {
                    terminateSignal.invoke(d);
                    return this.terminationOfConnectionDone().future();
                });
            }

            public void installTerminationHandlers(Deadline deadline) {
                if (!this.pendingUserHandlerResponse()) {
                    this.failStage(new ServerTerminationDeadlineReached());
                }
                this.setHandler(this.$outer.fromUser(), new InHandler(deadline, this){
                    private final Deadline deadline$2;
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        this.deadline$2 = deadline$4;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        HttpResponse httpResponse;
                        boolean overdue = this.deadline$2.isOverdue();
                        if (overdue) {
                            this.$outer.log().warning("Terminating server ({}), discarding user reply since arrived after deadline expiration", (Object)this.$outer.formatTimeLeft(this.deadline$2));
                            httpResponse = this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$settings.terminationDeadlineExceededResponse();
                        } else {
                            httpResponse = (HttpResponse)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromUser());
                        }
                        HttpResponse response = httpResponse;
                        this.$outer.pendingUserHandlerResponse_$eq(false);
                        Connection connection = Connection$.MODULE$.apply("close", ScalaRunTime$.MODULE$.wrapRefArray(new String[0]));
                        this.$outer.protected$emit(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().toNet(), response.withHeaders((Seq)((SeqOps)response.headers().filterNot(GracefulTerminatorStage::org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$anon$7$$_$onPush$$anonfun$1)).$plus$colon(connection)), () -> this.$outer.completeStage());
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$anon$7$$_$onPush$$anonfun$1(org.apache.pekko.http.scaladsl.model.HttpHeader ), onPush$$anonfun$2()}, serializedLambda);
                    }
                });
                this.setHandler(this.$outer.toUser(), new OutHandler(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        this.$outer.protected$pull(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromNet());
                    }
                });
                this.setHandler(this.$outer.fromNet(), new InHandler(deadline, this){
                    private final Deadline deadline$3;
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        this.deadline$3 = deadline$5;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        HttpRequest request = (HttpRequest)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromNet());
                        this.$outer.log().warning("Terminating server ({}), attempting to send termination reply to incoming [{} {}]", (Object)this.$outer.formatTimeLeft(this.deadline$3), (Object)request.method(), (Object)request.uri().path());
                        HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar(request.entity()), this.$outer.interpreter().subFusingMaterializer()).future().onComplete(x$1 -> {
                            Try try_ = x$1;
                            if (try_ instanceof Success) {
                                return;
                            }
                            if (try_ instanceof Failure) {
                                Throwable ex = ((Failure)try_).exception();
                                this.$outer.failureCallback().invoke(ex);
                                return;
                            }
                            throw new MatchError(try_);
                        }, this.$outer.interpreter().materializer().executionContext());
                        this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().toNet(), this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$settings.terminationDeadlineExceededResponse().withHeaders((HttpHeader)Connection$.MODULE$.apply("close", ScalaRunTime$.MODULE$.wrapRefArray(new String[0])), ScalaRunTime$.MODULE$.wrapRefArray(new HttpHeader[0])));
                        this.$outer.completeStage();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onPush$$anonfun$3(scala.util.Try )}, serializedLambda);
                    }
                });
                this.setHandler(this.$outer.toNet(), new OutHandler(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        if (this.$outer.pendingUserHandlerResponse()) {
                            if (this.$outer.protected$isAvailable(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromUser())) {
                                this.$outer.protected$pull(this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer().fromUser());
                                return;
                            }
                            return;
                        }
                    }
                });
            }

            public void postStop() {
                this.terminationOfConnectionDone().success(Http$HttpConnectionTerminated$.MODULE$);
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                if ("TerminationDeadlineTimerKey".equals(object)) {
                    ServerTerminationDeadlineReached ex = new ServerTerminationDeadlineReached();
                    if (this.pendingUserHandlerResponse()) {
                        this.emit(this.$outer.toNet(), this.$outer.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$settings.terminationDeadlineExceededResponse(), () -> this.failStage(ex));
                        return;
                    }
                    this.failStage(ex);
                    return;
                }
                Object unexpected = object;
                throw new IllegalArgumentException(new StringBuilder(28).append("Unexpected timer key [").append(unexpected).append("] in ").append(this.getClass().getName()).append("!").toString());
            }

            public String formatTimeLeft(Deadline d) {
                FiniteDuration left = d.timeLeft();
                if (left.toMillis() < 0L) {
                    return "deadline exceeded";
                }
                return new StringBuilder(10).append(PrettyDuration$.MODULE$.format(left)).append(" remaining").toString();
            }

            public Object protected$grab(Inlet in) {
                return this.grab(in);
            }

            public void protected$push(Outlet out, Object elem) {
                this.push(out, elem);
            }

            public void protected$complete(Outlet out) {
                this.complete(out);
            }

            public void protected$pull(Inlet in) {
                this.pull(in);
            }

            public void protected$emit(Outlet out, Object elem, Function0 andThen) {
                this.emit(out, elem, andThen);
            }

            public boolean protected$isAvailable(Inlet in) {
                return this.isAvailable(in);
            }

            public final /* synthetic */ GracefulTerminatorStage org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$_$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{failureCallback$lzyINIT1$$anonfun$1(java.lang.Throwable ), $anonfun$3(scala.concurrent.duration.FiniteDuration ), preStart$$anonfun$1(org.apache.pekko.stream.stage.AsyncCallback scala.concurrent.duration.FiniteDuration ), onTimer$$anonfun$1(org.apache.pekko.http.impl.engine.server.ServerTerminationDeadlineReached )}, serializedLambda);
            }
        };
        TimerGraphStageLogic timerGraphStageLogic = Predef$.MODULE$.ArrowAssoc(logic);
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(timerGraphStageLogic, selfTerminator);
    }

    public static final /* synthetic */ Future org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$ConnectionTerminator$$_$terminate$$anonfun$1(FiniteDuration deadline$1, Function1 callback) {
        return (Future)callback.apply(deadline$1);
    }

    public static final /* synthetic */ boolean org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$$anon$7$$_$onPush$$anonfun$1(HttpHeader _$2) {
        return _$2.is(Connection$.MODULE$.lowercaseName());
    }

    public final class ConnectionTerminator
    implements ServerTerminator {
        private final Promise<Function1<FiniteDuration, Future<Http.HttpTerminated>>> triggerTermination;
        private final /* synthetic */ GracefulTerminatorStage $outer;

        public ConnectionTerminator(GracefulTerminatorStage $outer, Promise<Function1<FiniteDuration, Future<Http.HttpTerminated>>> triggerTermination) {
            this.triggerTermination = triggerTermination;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Future<Http.HttpTerminated> terminate(FiniteDuration deadline, ExecutionContext ec) {
            return this.triggerTermination.future().flatMap(arg_0 -> GracefulTerminatorStage.org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$ConnectionTerminator$$_$terminate$$anonfun$1(deadline, arg_0), ec);
        }

        public final /* synthetic */ GracefulTerminatorStage org$apache$pekko$http$impl$engine$server$GracefulTerminatorStage$ConnectionTerminator$$$outer() {
            return this.$outer;
        }
    }
}

