/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import org.apache.pekko.http.impl.util.Renderer;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.InvalidContentLengthException$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import scala.collection.immutable.Iterable;

@InternalApi
public final class RenderSupport {
    public static <T, Mat> Source<T, Mat> CancelSecond(Source<T, Mat> source, Source<T, Object> source2) {
        return RenderSupport$.MODULE$.CancelSecond(source, source2);
    }

    public static byte[] ChunkedBytes() {
        return RenderSupport$.MODULE$.ChunkedBytes();
    }

    public static byte[] CloseBytes() {
        return RenderSupport$.MODULE$.CloseBytes();
    }

    public static byte[] ContentLengthBytes() {
        return RenderSupport$.MODULE$.ContentLengthBytes();
    }

    public static byte[] CrLf() {
        return RenderSupport$.MODULE$.CrLf();
    }

    public static byte[] DefaultStatusLineBytes() {
        return RenderSupport$.MODULE$.DefaultStatusLineBytes();
    }

    public static byte[] KeepAliveBytes() {
        return RenderSupport$.MODULE$.KeepAliveBytes();
    }

    public static byte[] StatusLineStartBytes() {
        return RenderSupport$.MODULE$.StatusLineStartBytes();
    }

    public static ByteString defaultLastChunkBytes() {
        return RenderSupport$.MODULE$.defaultLastChunkBytes();
    }

    public static Rendering renderEntityContentType(Rendering rendering, HttpEntity httpEntity) {
        return RenderSupport$.MODULE$.renderEntityContentType(rendering, httpEntity);
    }

    public static void suppressionWarning(LoggingAdapter loggingAdapter, HttpHeader httpHeader, String string2) {
        RenderSupport$.MODULE$.suppressionWarning(loggingAdapter, httpHeader, string2);
    }

    public static Renderer<Iterable<HttpHeader>> trailerRenderer() {
        return RenderSupport$.MODULE$.trailerRenderer();
    }

    public static String suppressionWarning$default$3() {
        return RenderSupport$.MODULE$.suppressionWarning$default$3();
    }

    public static final class CheckContentLengthTransformer
    extends GraphStages.SimpleLinearGraphStage<ByteString> {
        public final long org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length;

        public static Flow<ByteString, ByteString, NotUsed> flow(long l) {
            return RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(l);
        }

        public CheckContentLengthTransformer(long length) {
            this.org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length = length;
        }

        @Override
        public Attributes initialAttributes() {
            return Attributes$.MODULE$.name("CheckContentLength");
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private long sent;
                private final /* synthetic */ CheckContentLengthTransformer $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.sent = 0L;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public String toString() {
                    return new StringBuilder(25).append("CheckContentLength(sent=").append(this.sent).append(")").toString();
                }

                public void onPush() {
                    ByteString elem = (ByteString)this.grab(this.$outer.in());
                    this.sent += (long)elem.length();
                    if (this.sent <= this.$outer.org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length) {
                        this.push(this.$outer.out(), elem);
                        return;
                    }
                    this.failStage(InvalidContentLengthException$.MODULE$.apply(new StringBuilder(86).append("HTTP message had declared Content-Length ").append(this.$outer.org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length).append(" but entity data stream amounts to more bytes").toString(), InvalidContentLengthException$.MODULE$.apply$default$2()));
                }

                public void onUpstreamFinish() {
                    if (this.sent < this.$outer.org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length) {
                        this.failStage(InvalidContentLengthException$.MODULE$.apply(new StringBuilder(87).append("HTTP message had declared Content-Length ").append(this.$outer.org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length).append(" but entity data stream amounts to ").append(this.$outer.org$apache$pekko$http$impl$engine$rendering$RenderSupport$CheckContentLengthTransformer$$length - this.sent).append(" bytes less").toString(), InvalidContentLengthException$.MODULE$.apply$default$2()));
                        return;
                    }
                    this.completeStage();
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }
            };
        }

        public String toString() {
            return "CheckContentLength";
        }
    }

    public static class ChunkTransformer
    extends GraphStage<FlowShape<HttpEntity.ChunkStreamPart, ByteString>> {
        private final Inlet in = Inlet$.MODULE$.apply("ChunkTransformer.in");
        private final Outlet out = Outlet$.MODULE$.apply("ChunkTransformer.out");
        private final FlowShape shape = FlowShape$.MODULE$.of(this.in(), this.out());

        public static Flow<HttpEntity.ChunkStreamPart, ByteString, NotUsed> flow() {
            return RenderSupport$ChunkTransformer$.MODULE$.flow();
        }

        public Inlet<HttpEntity.ChunkStreamPart> in() {
            return this.in;
        }

        public Outlet<ByteString> out() {
            return this.out;
        }

        @Override
        public FlowShape<HttpEntity.ChunkStreamPart, ByteString> shape() {
            return this.shape;
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private final /* synthetic */ ChunkTransformer $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    HttpEntity.ChunkStreamPart chunk = this.grab(this.$outer.in());
                    ByteString bytes = RenderSupport$.MODULE$.org$apache$pekko$http$impl$engine$rendering$RenderSupport$$$renderChunk(chunk);
                    this.push(this.$outer.out(), bytes);
                    if (chunk.isLastChunk()) {
                        this.completeStage();
                        return;
                    }
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public void onUpstreamFinish() {
                    this.emit(this.$outer.out(), RenderSupport$.MODULE$.defaultLastChunkBytes());
                    this.completeStage();
                }
            };
        }
    }
}

