/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import org.apache.pekko.http.impl.util.ByteArrayRendering;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.Renderer;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.Rendering$CrLf$;
import org.apache.pekko.http.impl.util.Rendering$Empty$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$LastChunk$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.GraphDSL$Implicits$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.parboiled2.CharUtils$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class RenderSupport$
implements Serializable {
    private static final byte[] DefaultStatusLineBytes;
    private static final byte[] StatusLineStartBytes;
    private static final byte[] ChunkedBytes;
    private static final byte[] KeepAliveBytes;
    private static final byte[] CloseBytes;
    private static final byte[] CrLf;
    private static final byte[] ContentLengthBytes;
    private static final byte[] ApplicationJsonContentType;
    private static final byte[] TextPlainContentType;
    private static final byte[] TextXmlContentType;
    private static final byte[] TextHtmlContentType;
    private static final byte[] TextCsvContentType;
    private static final Renderer trailerRenderer;
    private static final ByteString defaultLastChunkBytes;
    public static final RenderSupport$ChunkTransformer$ ChunkTransformer;
    public static final RenderSupport$CheckContentLengthTransformer$ CheckContentLengthTransformer;
    public static final RenderSupport$ MODULE$;

    private RenderSupport$() {
    }

    static {
        MODULE$ = new RenderSupport$();
        DefaultStatusLineBytes = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("HTTP/1.1 200 OK\r\n"));
        StatusLineStartBytes = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("HTTP/1.1 "));
        ChunkedBytes = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("chunked"));
        KeepAliveBytes = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("Keep-Alive"));
        CloseBytes = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("close"));
        CrLf = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("\r\n"));
        ContentLengthBytes = EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("Content-Length: "));
        ApplicationJsonContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.application$divjson());
        TextPlainContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029());
        TextXmlContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029());
        TextHtmlContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029());
        TextCsvContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029());
        trailerRenderer = Renderer$.MODULE$.genericSeqRenderer(Rendering$CrLf$.MODULE$, Rendering$Empty$.MODULE$, Renderer$.MODULE$.renderableRenderer(), Renderer$.MODULE$.renderableRenderer());
        defaultLastChunkBytes = MODULE$.org$apache$pekko$http$impl$engine$rendering$RenderSupport$$$renderChunk(HttpEntity$LastChunk$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenderSupport$.class);
    }

    public byte[] DefaultStatusLineBytes() {
        return DefaultStatusLineBytes;
    }

    public byte[] StatusLineStartBytes() {
        return StatusLineStartBytes;
    }

    public byte[] ChunkedBytes() {
        return ChunkedBytes;
    }

    public byte[] KeepAliveBytes() {
        return KeepAliveBytes;
    }

    public byte[] CloseBytes() {
        return CloseBytes;
    }

    public byte[] CrLf() {
        return CrLf;
    }

    public byte[] ContentLengthBytes() {
        return ContentLengthBytes;
    }

    private byte[] preRenderContentType(ContentType ct) {
        return ((ByteArrayRendering)new ByteArrayRendering(64).$tilde$tilde(Content$minusType$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ct, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(this.CrLf()).get();
    }

    public Renderer<Iterable<HttpHeader>> trailerRenderer() {
        return trailerRenderer;
    }

    public ByteString defaultLastChunkBytes() {
        return defaultLastChunkBytes;
    }

    public <T, Mat> Source<T, Mat> CancelSecond(Source<T, Mat> first, Source<T, Object> second) {
        return Source$.MODULE$.fromGraph(GraphDSL$.MODULE$.createGraph(first, (Function1<GraphDSL.Builder, Function1> & Serializable)b -> (Function1<SourceShape, SourceShape> & Serializable)frst -> {
            new GraphDSL.Implicits.SourceArrow(GraphDSL$Implicits$.MODULE$.SourceArrow(second)).$tilde$greater((Graph)Sink$.MODULE$.cancelled(), (GraphDSL.Builder)b);
            return SourceShape$.MODULE$.apply(frst.out());
        }));
    }

    public Rendering renderEntityContentType(Rendering r, HttpEntity entity) {
        ContentType ct = entity.contentType();
        if (ct == ContentTypes$.MODULE$.NoContentType()) {
            return r;
        }
        if (ct == ContentTypes$.MODULE$.application$divjson()) {
            return r.$tilde$tilde(ApplicationJsonContentType);
        }
        if (ct == ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(TextPlainContentType);
        }
        if (ct == ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(TextXmlContentType);
        }
        if (ct == ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(TextHtmlContentType);
        }
        if (ct == ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(TextCsvContentType);
        }
        return r.$tilde$tilde(Content$minusType$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ct, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(this.CrLf());
    }

    public ByteString org$apache$pekko$http$impl$engine$rendering$RenderSupport$$$renderChunk(HttpEntity.ChunkStreamPart chunk) {
        Object object;
        int renderedSize = CharUtils$.MODULE$.numberOfHexDigits(Int$.MODULE$.int2long(chunk.data().length())) + (chunk.extension().isEmpty() ? 0 : chunk.extension().length() + 1) + chunk.data().length() + 2 + 2;
        ByteStringRendering r = new ByteStringRendering(renderedSize);
        r.$tilde$tilde$percent(chunk.data().length());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(chunk.extension()))) {
            r.$tilde$tilde(';').$tilde$tilde(chunk.extension());
        }
        r.$tilde$tilde(this.CrLf());
        HttpEntity.ChunkStreamPart chunkStreamPart = chunk;
        if (chunkStreamPart instanceof HttpEntity.Chunk) {
            HttpEntity.Chunk chunk2 = HttpEntity$Chunk$.MODULE$.unapply((HttpEntity.Chunk)chunkStreamPart);
            ByteString byteString = chunk2._1();
            String string2 = chunk2._2();
            ByteString data = byteString;
            object = r.$tilde$tilde(data);
        } else if (chunkStreamPart instanceof HttpEntity.LastChunk) {
            HttpEntity.LastChunk lastChunk = HttpEntity$LastChunk$.MODULE$.unapply((HttpEntity.LastChunk)chunkStreamPart);
            String string3 = lastChunk._1();
            Seq<HttpHeader> seq = lastChunk._2();
            Nil$ nil$ = package$.MODULE$.Nil();
            Seq<HttpHeader> seq2 = seq;
            if (!(nil$ != null ? !((Object)nil$).equals(seq2) : seq2 != null)) {
                object = BoxedUnit.UNIT;
            } else {
                Seq<HttpHeader> trailer = seq;
                object = ((ByteStringRendering)r.$tilde$tilde(trailer, (Renderer)this.trailerRenderer())).$tilde$tilde(this.CrLf());
            }
        } else {
            throw new MatchError(chunkStreamPart);
        }
        r.$tilde$tilde(this.CrLf());
        return r.get();
    }

    public void suppressionWarning(LoggingAdapter log, HttpHeader h, String msg) {
        log.warning("Explicitly set HTTP header '{}' is ignored, {}", h, (Object)msg);
    }

    public String suppressionWarning$default$3() {
        return "the pekko-http-core layer sets this header automatically!";
    }
}

