/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import org.apache.pekko.http.impl.engine.rendering.HttpRequestRendererFactory;
import org.apache.pekko.http.impl.engine.rendering.HttpRequestRendererFactory$RequestRenderingOutput$;
import org.apache.pekko.http.impl.engine.rendering.HttpRequestRendererFactory$RequestRenderingOutput$Streamed$;
import org.apache.pekko.http.impl.engine.rendering.HttpRequestRendererFactory$RequestRenderingOutput$Strict$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RequestRenderingContext;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunked$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Default$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import org.apache.pekko.http.scaladsl.model.UriRendering$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding$;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxedUnit;

@InternalApi
public class HttpRequestRendererFactory {
    private final Option<User$minusAgent> userAgentHeader;
    private final int requestHeaderSizeHint;
    private final LoggingAdapter log;

    public HttpRequestRendererFactory(Option<User$minusAgent> userAgentHeader, int requestHeaderSizeHint, LoggingAdapter log) {
        this.userAgentHeader = userAgentHeader;
        this.requestHeaderSizeHint = requestHeaderSizeHint;
        this.log = log;
    }

    public Source<ByteString, Object> renderToSource(RequestRenderingContext ctx) {
        return this.render(ctx).byteStream();
    }

    public RequestRenderingOutput render(RequestRenderingContext ctx) {
        ByteStringRendering r = new ByteStringRendering(this.requestHeaderSizeHint, message -> this.log.warning((String)message));
        HttpRequestRendererFactory.renderRequestLine$1(r, ctx);
        this.renderHeaders$1(ctx, r, ctx.request().headers().toList(), HttpRequestRendererFactory.renderHeaders$default$2$1(), HttpRequestRendererFactory.renderHeaders$default$3$1(), HttpRequestRendererFactory.renderHeaders$default$4$1());
        RenderSupport$.MODULE$.renderEntityContentType(r, ctx.request().entity());
        return HttpRequestRendererFactory.completeRequestRendering$1(ctx, r);
    }

    public ByteString renderStrict(RequestRenderingContext ctx) {
        RequestRenderingOutput requestRenderingOutput = this.render(ctx);
        if (requestRenderingOutput instanceof RequestRenderingOutput.Strict) {
            ByteString byteString;
            RequestRenderingOutput.Strict strict = HttpRequestRendererFactory$RequestRenderingOutput$Strict$.MODULE$.unapply((RequestRenderingOutput.Strict)requestRenderingOutput);
            ByteString bytes = byteString = strict._1();
            return bytes;
        }
        if (requestRenderingOutput instanceof RequestRenderingOutput.Streamed) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Request entity was not Strict but ").append(ctx.request().entity().getClass().getSimpleName()).toString());
        }
        throw new MatchError(requestRenderingOutput);
    }

    private static final void renderRequestLine$1(ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        ((ByteStringRendering)r$1.$tilde$tilde(ctx$1.request().method(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(' ');
        boolean rawRequestUriRendered = ctx$1.request().headers().exists((Function1<HttpHeader, boolean> & Serializable)x$1 -> {
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Raw$minusRequest$minusURI) {
                String string2;
                Raw$minusRequest$minusURI raw$minusRequest$minusURI = Raw$minusRequest$minusURI$.MODULE$.unapply((Raw$minusRequest$minusURI)httpHeader);
                String rawUri = string2 = raw$minusRequest$minusURI._1();
                r$1.$tilde$tilde(rawUri);
                return true;
            }
            return false;
        });
        if (!rawRequestUriRendered) {
            UriRendering$.MODULE$.renderUriWithoutFragment(r$1, ctx$1.request().uri(), org.apache.pekko.http.impl.util.package$.MODULE$.UTF8());
        }
        ((ByteStringRendering)r$1.$tilde$tilde(' ').$tilde$tilde(ctx$1.request().protocol(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
    }

    private static final ByteStringRendering render$1(ByteStringRendering r$3, HttpHeader h) {
        return (ByteStringRendering)r$3.$tilde$tilde(h);
    }

    private final void renderHeaders$1(RequestRenderingContext ctx$2, ByteStringRendering r$4, List remaining, boolean hostHeaderSeen, boolean userAgentSeen, boolean transferEncodingSeen) {
        List list;
        while ((list = remaining) instanceof $colon$colon) {
            Object object;
            HttpHeader x;
            $colon$colon $colon$colon = ($colon$colon)list;
            List list2 = $colon$colon.next$access$1();
            HttpHeader head = (HttpHeader)$colon$colon.head();
            List tail = list2;
            HttpHeader httpHeader = head;
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength x2 = (Content$minusLength)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, x2, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType x3 = (Content$minusType)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, x3, "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding x4 = (Transfer$minusEncoding)httpHeader;
                Option<Transfer$minusEncoding> option = x4.withChunkedPeeled();
                if (None$.MODULE$.equals(option)) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, head, RenderSupport$.MODULE$.suppressionWarning$default$3());
                    remaining = tail;
                    continue;
                }
                if (option instanceof Some) {
                    Transfer$minusEncoding te = (Transfer$minusEncoding)((Some)option).value();
                    HttpRequestRendererFactory.render$1(r$4, ctx$2.request().entity().isChunked() && !ctx$2.request().entity().isKnownEmpty() ? te.withChunked() : te);
                    List list3 = tail;
                    boolean bl = true;
                    remaining = list3;
                    transferEncodingSeen = bl;
                    continue;
                }
                throw new MatchError(option);
            }
            if (httpHeader instanceof Host) {
                Host x5 = (Host)httpHeader;
                HttpRequestRendererFactory.render$1(r$4, x5);
                List list4 = tail;
                boolean bl = true;
                remaining = list4;
                hostHeaderSeen = bl;
                continue;
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent x6 = (User$minusAgent)httpHeader;
                HttpRequestRendererFactory.render$1(r$4, x6);
                List list5 = tail;
                boolean bl = true;
                remaining = list5;
                userAgentSeen = bl;
                continue;
            }
            if (httpHeader instanceof Raw$minusRequest$minusURI) {
                Raw$minusRequest$minusURI x7 = (Raw$minusRequest$minusURI)httpHeader;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader x8 = (CustomHeader)httpHeader;
                if (x8.renderInRequests()) {
                    HttpRequestRendererFactory.render$1(r$4, x8);
                }
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof RawHeader) {
                RawHeader rawHeader = (RawHeader)httpHeader;
                RawHeader x9 = rawHeader;
                if (x9.is("content-type") || x9.is("content-length") || x9.is("transfer-encoding")) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, x9, "illegal RawHeader");
                    remaining = tail;
                    continue;
                }
                RawHeader x10 = rawHeader;
                if (x10.is("user-agent")) {
                    HttpRequestRendererFactory.render$1(r$4, x10);
                    List list6 = tail;
                    boolean bl = true;
                    remaining = list6;
                    userAgentSeen = bl;
                    continue;
                }
                RawHeader x11 = rawHeader;
                if (x11.is("host")) {
                    HttpRequestRendererFactory.render$1(r$4, x11);
                    List list7 = tail;
                    boolean bl = true;
                    remaining = list7;
                    hostHeaderSeen = bl;
                    continue;
                }
            }
            if ((x = httpHeader).renderInRequests()) {
                object = HttpRequestRendererFactory.render$1(r$4, x);
            } else {
                this.log.warning("HTTP header '{}' is not allowed in requests", x);
                object = BoxedUnit.UNIT;
            }
            remaining = tail;
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list8 = list;
        if (!(nil$ != null ? !((Object)nil$).equals(list8) : list8 != null)) {
            if (!hostHeaderSeen) {
                r$4.$tilde$tilde(ctx$2.hostHeader());
            }
            if (!userAgentSeen && this.userAgentHeader.isDefined()) {
                r$4.$tilde$tilde(this.userAgentHeader.get());
            }
            if (ctx$2.request().entity().isChunked() && !ctx$2.request().entity().isKnownEmpty() && !transferEncodingSeen) {
                ((ByteStringRendering)r$4.$tilde$tilde(Transfer$minusEncoding$.MODULE$, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.ChunkedBytes()).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
                return;
            }
            return;
        }
        throw new MatchError(list);
    }

    private static final boolean renderHeaders$default$2$1() {
        return false;
    }

    private static final boolean renderHeaders$default$3$1() {
        return false;
    }

    private static final boolean renderHeaders$default$4$1() {
        return false;
    }

    private static final ByteStringRendering renderContentLength$1(RequestRenderingContext ctx$3, ByteStringRendering r$5, long contentLength) {
        block2: {
            block3: {
                if (!ctx$3.request().method().isEntityAccepted()) break block2;
                if (contentLength > 0L) break block3;
                RequestEntityAcceptance requestEntityAcceptance = ctx$3.request().method().requestEntityAcceptance();
                RequestEntityAcceptance$Expected$ requestEntityAcceptance$Expected$ = RequestEntityAcceptance$Expected$.MODULE$;
                if (requestEntityAcceptance != null ? !requestEntityAcceptance.equals(requestEntityAcceptance$Expected$) : requestEntityAcceptance$Expected$ != null) break block2;
            }
            return ((ByteStringRendering)r$5.$tilde$tilde(Content$minusLength$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(contentLength)).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
        }
        return r$5;
    }

    private static final RequestRenderingOutput renderStreamed$1(ByteStringRendering r$6, RequestRenderingContext ctx$4, Source body) {
        Source source;
        Source<ByteString, NotUsed> headerPart = Source$.MODULE$.single(r$6.get());
        Option<Future<NotUsed>> option = ctx$4.sendEntityTrigger();
        if (None$.MODULE$.equals(option)) {
            source = (Source)headerPart.$plus$plus((Graph)body);
        } else if (option instanceof Some) {
            Future future = (Future)((Some)option).value();
            Source barrier = (Source)Source$.MODULE$.fromFuture(future).drop(1L);
            source = (Source)headerPart.$plus$plus((Graph)barrier).$plus$plus(body).recoverWithRetries(-1, new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return HttpResponseParser$OneHundredContinueError$.MODULE$.equals(throwable);
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (HttpResponseParser$OneHundredContinueError$.MODULE$.equals(throwable)) {
                        return Source$.MODULE$.empty();
                    }
                    return function1.apply(x);
                }
            });
        } else {
            throw new MatchError(option);
        }
        Source stream = source;
        return HttpRequestRendererFactory$RequestRenderingOutput$Streamed$.MODULE$.apply(stream);
    }

    private static final RequestRenderingOutput completeRequestRendering$1(RequestRenderingContext ctx$5, ByteStringRendering r$7) {
        RequestEntity requestEntity = ctx$5.request().entity();
        RequestEntity x = requestEntity;
        if (x.isKnownEmpty()) {
            HttpRequestRendererFactory.renderContentLength$1(ctx$5, r$7, 0L).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory$RequestRenderingOutput$Strict$.MODULE$.apply(r$7.get());
        }
        if (requestEntity instanceof HttpEntity.Strict) {
            ByteString byteString;
            HttpEntity.Strict strict = HttpEntity$Strict$.MODULE$.unapply((HttpEntity.Strict)requestEntity);
            ContentType contentType = strict._1();
            ByteString data = byteString = strict._2();
            HttpRequestRendererFactory.renderContentLength$1(ctx$5, r$7, Int$.MODULE$.int2long(data.length())).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            if (ctx$5.sendEntityTrigger().isDefined()) {
                return HttpRequestRendererFactory.renderStreamed$1(r$7, ctx$5, Source$.MODULE$.single(data));
            }
            return HttpRequestRendererFactory$RequestRenderingOutput$Strict$.MODULE$.apply(r$7.get().$plus$plus(data));
        }
        if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = HttpEntity$Default$.MODULE$.unapply((HttpEntity.Default)requestEntity);
            ContentType contentType = default_._1();
            long l = default_._2();
            Source<ByteString, Object> source = default_._3();
            long contentLength = l;
            Source<ByteString, Object> data = source;
            HttpRequestRendererFactory.renderContentLength$1(ctx$5, r$7, contentLength).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(r$7, ctx$5, (Source)data.via(RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(contentLength)));
        }
        if (requestEntity instanceof HttpEntity.Chunked) {
            Source<HttpEntity.ChunkStreamPart, Object> source;
            HttpEntity.Chunked chunked = HttpEntity$Chunked$.MODULE$.unapply((HttpEntity.Chunked)requestEntity);
            ContentType contentType = chunked._1();
            Source<HttpEntity.ChunkStreamPart, Object> chunks = source = chunked._2();
            r$7.$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(r$7, ctx$5, (Source)chunks.via(RenderSupport$ChunkTransformer$.MODULE$.flow()));
        }
        throw new MatchError(requestEntity);
    }

    public static interface RequestRenderingOutput {
        public static int ordinal(RequestRenderingOutput requestRenderingOutput) {
            return HttpRequestRendererFactory$RequestRenderingOutput$.MODULE$.ordinal(requestRenderingOutput);
        }

        public Source<ByteString, Object> byteStream();
    }
}

