/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.BodyPartRenderer$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.StageLoggingWithOverride;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Default$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$IndefiniteLength$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.parboiled2.util.Base64$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class BodyPartRenderer$
implements Serializable {
    public static final BodyPartRenderer$ MODULE$ = new BodyPartRenderer$();

    private BodyPartRenderer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BodyPartRenderer$.class);
    }

    public GraphStage<FlowShape<Multipart.BodyPart, Source<HttpEntity.ChunkStreamPart, Object>>> streamed(String boundary2, int partHeadersSizeHint, LoggingAdapter _log) {
        return new GraphStage<FlowShape<Multipart.BodyPart, Source<HttpEntity.ChunkStreamPart, Object>>>(_log, partHeadersSizeHint, boundary2, this){
            public final LoggingAdapter org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$_log$1;
            public final int org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$partHeadersSizeHint$1;
            public final String org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$boundary$1;
            private boolean firstBoundaryRendered;
            private final Inlet in;
            private final Outlet out;
            private final FlowShape shape;
            {
                this.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$_log$1 = _log$2;
                this.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$partHeadersSizeHint$1 = partHeadersSizeHint$2;
                this.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$boundary$1 = boundary$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.firstBoundaryRendered = false;
                this.in = Inlet$.MODULE$.apply("BodyPartRenderer.in");
                this.out = Outlet$.MODULE$.apply("BodyPartRenderer.out");
                this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
            }

            public boolean firstBoundaryRendered() {
                return this.firstBoundaryRendered;
            }

            public void firstBoundaryRendered_$eq(boolean x$1) {
                this.firstBoundaryRendered = x$1;
            }

            public Inlet in() {
                return this.in;
            }

            public Outlet out() {
                return this.out;
            }

            public FlowShape shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return (GraphStageLogic)((Object)new InHandler(this){
                    private LoggingAdapter org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log;
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        StageLoggingWithOverride.$init$(this);
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public LoggingAdapter org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log() {
                        return this.org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log;
                    }

                    public void org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log_$eq(LoggingAdapter x$1) {
                        this.org$apache$pekko$http$impl$util$StageLoggingWithOverride$$_log = x$1;
                    }

                    public LoggingAdapter logOverride() {
                        return this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$_log$1;
                    }

                    public void onPush() {
                        ByteStringRendering r = new ByteStringRendering(this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$partHeadersSizeHint$1);
                        BodyPartRenderer$.MODULE$.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderBoundary(r, this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$boundary$1, !this.$outer.firstBoundaryRendered());
                        this.$outer.firstBoundaryRendered_$eq(true);
                        Multipart.BodyPart bodyPart = (Multipart.BodyPart)this.grab(this.$outer.in());
                        RenderSupport$.MODULE$.renderEntityContentType(r, bodyPart.entity());
                        BodyPartRenderer$.MODULE$.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderHeaders(r, bodyPart.headers(), this.log());
                        this.push(this.$outer.out(), this.completePartRendering$1(r, bodyPart.entity()));
                    }

                    public void onPull() {
                        if (this.isClosed(this.$outer.in()) && this.$outer.firstBoundaryRendered()) {
                            this.completeRendering();
                            return;
                        }
                        if (this.isClosed(this.$outer.in())) {
                            this.completeStage();
                            return;
                        }
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFinish() {
                        if (this.isAvailable(this.$outer.out()) && this.$outer.firstBoundaryRendered()) {
                            this.completeRendering();
                            return;
                        }
                    }

                    private void completeRendering() {
                        ByteStringRendering r = new ByteStringRendering(this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$boundary$1.length() + 4);
                        BodyPartRenderer$.MODULE$.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderFinalBoundary(r, this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$boundary$1);
                        this.push(this.$outer.out(), this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$chunkStream(r.get()));
                        this.completeStage();
                    }

                    private final Source bodyPartChunks$1(ByteStringRendering r$1, Source data) {
                        Source entityChunks = (Source)data.map(BodyPartRenderer$::org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$anon$2$$_$_$$anonfun$1);
                        return ((Source)this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$chunkStream(r$1.get()).$plus$plus((Graph)entityChunks)).mapMaterializedValue(BodyPartRenderer$::org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$anon$2$$_$bodyPartChunks$1$$anonfun$1);
                    }

                    private final Source completePartRendering$1(ByteStringRendering r$2, HttpEntity entity) {
                        HttpEntity httpEntity = entity;
                        HttpEntity x = httpEntity;
                        if (x.isKnownEmpty()) {
                            return this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$chunkStream(r$2.get());
                        }
                        if (httpEntity instanceof HttpEntity.Strict) {
                            ByteString byteString;
                            HttpEntity.Strict strict = HttpEntity$Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
                            ContentType contentType = strict._1();
                            ByteString data = byteString = strict._2();
                            return this.$outer.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$chunkStream(r$2.$tilde$tilde(data).get());
                        }
                        if (httpEntity instanceof HttpEntity.Default) {
                            Source<ByteString, Object> source;
                            HttpEntity.Default default_ = HttpEntity$Default$.MODULE$.unapply((HttpEntity.Default)httpEntity);
                            ContentType contentType = default_._1();
                            long l = default_._2();
                            Source<ByteString, Object> data = source = default_._3();
                            return this.bodyPartChunks$1(r$2, data);
                        }
                        if (httpEntity instanceof HttpEntity.IndefiniteLength) {
                            Source<ByteString, Object> source;
                            HttpEntity.IndefiniteLength indefiniteLength = HttpEntity$IndefiniteLength$.MODULE$.unapply((HttpEntity.IndefiniteLength)httpEntity);
                            ContentType contentType = indefiniteLength._1();
                            Source<ByteString, Object> data = source = indefiniteLength._2();
                            return this.bodyPartChunks$1(r$2, data);
                        }
                        throw new MatchError(httpEntity);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$anon$2$$_$_$$anonfun$1(org.apache.pekko.util.ByteString ), org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$anon$2$$_$bodyPartChunks$1$$anonfun$1(java.lang.Object )}, serializedLambda);
                    }
                });
            }

            public Source org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$chunkStream(ByteString byteString) {
                return Source$.MODULE$.single(HttpEntity$Chunk$.MODULE$.apply(byteString, HttpEntity$Chunk$.MODULE$.$lessinit$greater$default$2()));
            }
        };
    }

    public ByteString strict(Seq<Multipart.BodyPart.Strict> parts, String boundary2, int partHeadersSizeHint, LoggingAdapter log) {
        ByteStringRendering r = new ByteStringRendering(partHeadersSizeHint);
        if (parts.nonEmpty()) {
            parts.foreach((Function1<Multipart.BodyPart.Strict, ByteStringRendering> & Serializable)part -> {
                this.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderBoundary(r, boundary2, part == parts.head());
                RenderSupport$.MODULE$.renderEntityContentType(r, part.entity());
                this.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderHeaders(r, part.headers(), log);
                return r.$tilde$tilde(part.entity().data());
            });
        }
        this.org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderFinalBoundary(r, boundary2);
        return r.get();
    }

    public void org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderBoundary(Rendering r, String boundary2, boolean suppressInitialCrLf) {
        if (!suppressInitialCrLf) {
            r.$tilde$tilde(RenderSupport$.MODULE$.CrLf());
        }
        r.$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary2).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
    }

    public void org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderFinalBoundary(Rendering r, String boundary2) {
        r.$tilde$tilde(RenderSupport$.MODULE$.CrLf()).$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary2).$tilde$tilde('-').$tilde$tilde('-');
    }

    public void org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$$renderHeaders(Rendering r, Seq<HttpHeader> headers, LoggingAdapter log) {
        headers.foreach(this.renderHeader(r, log));
        r.$tilde$tilde(RenderSupport$.MODULE$.CrLf());
    }

    private Function1<HttpHeader, BoxedUnit> renderHeader(Rendering r, LoggingAdapter log) {
        return x$1 -> {
            RawHeader x;
            HttpHeader httpHeader = x$1;
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength x2 = (Content$minusLength)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(log, x2, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                return;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType x3 = (Content$minusType)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(log, x3, "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.");
                return;
            }
            if (httpHeader instanceof RawHeader && ((x = (RawHeader)httpHeader).is("content-type") || x.is("content-length"))) {
                RenderSupport$.MODULE$.suppressionWarning(log, x, "illegal RawHeader");
                return;
            }
            HttpHeader x4 = httpHeader;
            r.$tilde$tilde(x4);
        };
    }

    public String randomBoundary(int length, Random random) {
        byte[] array = new byte[length];
        random.nextBytes(array);
        return Base64$.MODULE$.custom().encodeToString(array, false);
    }

    public int randomBoundary$default$1() {
        return 18;
    }

    public Random randomBoundary$default$2() {
        return ThreadLocalRandom.current();
    }

    public String randomBoundaryWithDefaults() {
        return this.randomBoundary(this.randomBoundary$default$1(), this.randomBoundary$default$2());
    }

    public String randomBoundaryWithDefaultRandom(int length) {
        return this.randomBoundary(length, this.randomBoundary$default$2());
    }

    public static final /* synthetic */ HttpEntity.ChunkStreamPart org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$anon$2$$_$_$$anonfun$1(ByteString _$1) {
        return HttpEntity$Chunk$.MODULE$.apply(_$1, HttpEntity$Chunk$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ void org$apache$pekko$http$impl$engine$rendering$BodyPartRenderer$$anon$1$$anon$2$$_$bodyPartChunks$1$$anonfun$1(Object _$2) {
    }
}

