/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.NotEnoughDataException$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Full$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Off$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Simple$;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class package$
implements Serializable {
    public static final package$ MODULE$ = new package$();

    private package$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public String escape(char c) {
        char c2 = c;
        switch (c2) {
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
        }
        char x = c2;
        if (Character.isISOControl(x)) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(c)}));
        }
        char x2 = c2;
        return BoxesRunTime.boxToCharacter(x2).toString();
    }

    public char byteChar(ByteString input, int ix) {
        return (char)(this.byteAt(input, ix) & 0xFF);
    }

    public byte byteAt(ByteString input, int ix) {
        if (ix < input.length()) {
            return input.apply(ix);
        }
        throw NotEnoughDataException$.MODULE$;
    }

    public String asciiString(ByteString input, int start, int end) {
        if (start == end) {
            return "";
        }
        return this.build$1(end, input, this.build$default$1$1(start), this.build$default$2$1(end, start));
    }

    public void logParsingError(ErrorInfo info, LoggingAdapter log, ParserSettings.ErrorLoggingVerbosity settings, Set<String> ignoreHeaderNames) {
        ParserSettings.ErrorLoggingVerbosity errorLoggingVerbosity = settings;
        if (ParserSettings$ErrorLoggingVerbosity$Off$.MODULE$.equals(errorLoggingVerbosity)) {
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Simple$.MODULE$.equals(errorLoggingVerbosity)) {
            if (!ignoreHeaderNames.contains(info.errorHeaderName())) {
                log.warning(info.summary());
                return;
            }
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Full$.MODULE$.equals(errorLoggingVerbosity)) {
            if (!ignoreHeaderNames.contains(info.errorHeaderName())) {
                log.warning(info.formatPretty());
                return;
            }
            return;
        }
        throw new MatchError(errorLoggingVerbosity);
    }

    public Set<String> logParsingError$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    private final String build$1(int end$1, ByteString input$1, int ix, StringBuilder sb) {
        while (ix != end$1) {
            int n = ix + 1;
            StringBuilder stringBuilder = sb.append((char)input$1.apply(ix));
            ix = n;
            sb = stringBuilder;
        }
        return sb.toString();
    }

    private final int build$default$1$1(int start$1) {
        return start$1;
    }

    private final StringBuilder build$default$2$1(int end$2, int start$2) {
        return new StringBuilder(end$2 - start$2);
    }
}

