/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$OutOfTrieSpaceException$;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$ValueBranch$;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.SpecializedHeaderValueParsers$;
import org.apache.pekko.http.impl.engine.parsing.SpecializedHeaderValueParsers$ContentLengthParser$;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.HeaderParser$;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.EmptyHeader$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class HttpHeaderParser$
implements Serializable {
    private static final Seq<String> predefinedHeaders;
    private static final Set<String> alwaysParsedHeaders;
    public static final HttpHeaderParser$OutOfTrieSpaceException$ org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$OutOfTrieSpaceException;
    public static final HttpHeaderParser$ValueBranch$ org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$ValueBranch;
    public static final HttpHeaderParser$ MODULE$;

    private HttpHeaderParser$() {
    }

    static {
        MODULE$ = new HttpHeaderParser$();
        predefinedHeaders = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Accept: *", "Accept: */*", "Connection: Keep-Alive", "Connection: close", "Connection: keep-alive", "Content-Length: 0", "Cache-Control: max-age=0", "Cache-Control: no-cache", "Expect: 100-continue"}));
        alwaysParsedHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"connection", "content-encoding", "content-length", "content-type", "expect", "host", "sec-websocket-key", "sec-websocket-protocol", "sec-websocket-version", "transfer-encoding", "upgrade"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpHeaderParser$.class);
    }

    private char[] $lessinit$greater$default$4() {
        return new char[512];
    }

    private int $lessinit$greater$default$5() {
        return 0;
    }

    private short[] $lessinit$greater$default$6() {
        return new short[762];
    }

    private int $lessinit$greater$default$7() {
        return 0;
    }

    private Object[] $lessinit$greater$default$8() {
        return new Object[255];
    }

    private int $lessinit$greater$default$9() {
        return 0;
    }

    public boolean org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$$lessinit$greater$default$10() {
        return false;
    }

    public HttpHeaderParser apply(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return this.prime(this.unprimed(settings, log, this.defaultIllegalHeaderHandler(settings, log)));
    }

    public Function1<ErrorInfo, BoxedUnit> defaultIllegalHeaderHandler(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        if (settings.illegalHeaderWarnings()) {
            return info -> package$.MODULE$.logParsingError(info.withSummaryPrepended("Illegal header"), log, settings.errorLoggingVerbosity(), settings.ignoreIllegalHeaderFor());
        }
        return _$1 -> {};
    }

    public HttpHeaderParser unprimed(HttpHeaderParser.Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> warnOnIllegalHeader) {
        return new HttpHeaderParser(settings, log, warnOnIllegalHeader, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8(), this.$lessinit$greater$default$9(), this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$$lessinit$greater$default$10());
    }

    public HttpHeaderParser prime(HttpHeaderParser parser) {
        Function1<String, boolean> & Serializable headerParserFilter = parser.settings().modeledHeaderParsing() ? (Function1<String, boolean> & Serializable)_$2 -> true : alwaysParsedHeaders;
        Seq valueParsers = ((IterableOnce)HeaderParser$.MODULE$.ruleNames().filter(headerParserFilter)).iterator().map((Function1<String, HttpHeaderParser.ModeledHeaderValueParser> & Serializable)name -> new HttpHeaderParser.ModeledHeaderValueParser((String)name, parser.settings().maxHeaderValueLength(), parser.settings().headerValueCacheLimit((String)name), parser.log(), parser.settings())).to(IterableFactory$.MODULE$.toFactory(IndexedSeq$.MODULE$));
        Seq seq = (Seq)valueParsers.sortBy((Function1<HttpHeaderParser.HeaderValueParser, String> & Serializable)_$3 -> _$3.headerName(), Ordering$String$.MODULE$);
        this.insertInGoodOrder$1(parser, seq, this.insertInGoodOrder$default$2$1(seq), this.insertInGoodOrder$default$3$1(seq));
        Seq<SpecializedHeaderValueParsers$ContentLengthParser$> seq2 = SpecializedHeaderValueParsers$.MODULE$.specializedHeaderValueParsers();
        this.insertInGoodOrder$1(parser, seq2, this.insertInGoodOrder$default$2$1(seq2), this.insertInGoodOrder$default$3$1(seq2));
        Seq seq3 = (Seq)predefinedHeaders.sorted(Ordering$String$.MODULE$);
        this.insertInGoodOrder$1(parser, seq3, this.insertInGoodOrder$default$2$1(seq3), this.insertInGoodOrder$default$3$1(seq3));
        ByteString byteString = ByteString$.MODULE$.apply("\r\n");
        EmptyHeader$ emptyHeader$ = EmptyHeader$.MODULE$;
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(byteString, emptyHeader$, parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(byteString, emptyHeader$), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(byteString, emptyHeader$), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(byteString, emptyHeader$), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(byteString, emptyHeader$));
        ByteString byteString2 = ByteString$.MODULE$.apply("\n");
        EmptyHeader$ emptyHeader$2 = EmptyHeader$.MODULE$;
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(byteString2, emptyHeader$2, parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(byteString2, emptyHeader$2), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(byteString2, emptyHeader$2), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(byteString2, emptyHeader$2), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(byteString2, emptyHeader$2));
        return parser;
    }

    public void insert(HttpHeaderParser parser, ByteString input, Object value) {
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(input, value, parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(input, value), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(input, value), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(input, value), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(input, value));
    }

    public void insertRemainingCharsAsNewNodes(HttpHeaderParser parser, ByteString input, Object value) {
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(input, value, parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(input, value), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(input, value), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(input, value), parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(input, value));
    }

    public Tuple2<String, Object> org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode, StringBuilder sb, int ix) {
        while (true) {
            StringBuilder nsb;
            StringBuilder stringBuilder;
            hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().clear();
            if (ix >= limit) break;
            char c = package$.MODULE$.byteChar(input, ix);
            if ('\t' == c) {
                StringBuilder stringBuilder2 = this.appended$1(sb, input, start, ix, ' ');
                int n = ix + 1;
                sb = stringBuilder2;
                ix = n;
                continue;
            }
            if ('\r' == c && package$.MODULE$.byteChar(input, ix + 1) == '\n') {
                if (CharacterClasses$.MODULE$.WSP().apply(package$.MODULE$.byteChar(input, ix + 2))) {
                    StringBuilder stringBuilder3 = this.appended$1(sb, input, start, ix, ' ');
                    int n = ix + 3;
                    sb = stringBuilder3;
                    ix = n;
                    continue;
                }
                return Tuple2$.MODULE$.apply(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix), BoxesRunTime.boxToInteger(ix + 2));
            }
            if ('\n' == c) {
                if (CharacterClasses$.MODULE$.WSP().apply(package$.MODULE$.byteChar(input, ix + 1))) {
                    StringBuilder stringBuilder4 = this.appended$1(sb, input, start, ix, ' ');
                    int n = ix + 2;
                    sb = stringBuilder4;
                    ix = n;
                    continue;
                }
                return Tuple2$.MODULE$.apply(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix), BoxesRunTime.boxToInteger(ix + 1));
            }
            char c2 = c;
            int nix = ix + 1;
            if (' ' <= c2 && c2 <= '\u007f') {
                stringBuilder = sb != null ? sb.append(c2) : null;
            } else if ((c2 & 0xE0) == 192) {
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c2);
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                nix = ix + 2;
                int n = hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                if (-1 == n) {
                    stringBuilder = sb != null ? sb.append(c2).append(package$.MODULE$.byteChar(input, ix + 1)) : null;
                } else {
                    int cc = n;
                    stringBuilder = this.appended2$1(sb, input, start, ix, cc);
                }
            } else if ((c2 & 0xF0) == 224) {
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c2);
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                nix = ix + 3;
                int n = hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                if (-1 == n) {
                    stringBuilder = sb != null ? sb.append(c2).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2)) : null;
                } else {
                    int cc = n;
                    stringBuilder = this.appended2$1(sb, input, start, ix, cc);
                }
            } else if ((c2 & 0xF8) == 240) {
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c2);
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 3));
                nix = ix + 4;
                int n = hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                if (-1 == n) {
                    stringBuilder = sb != null ? sb.append(c2).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2)).append(package$.MODULE$.byteChar(input, ix + 3)) : null;
                } else {
                    int cc = n;
                    stringBuilder = this.appended2$1(sb, input, start, ix, cc);
                }
            } else {
                ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = mode;
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    throw this.fail(new StringBuilder(36).append("Illegal character '").append(package$.MODULE$.escape(c2)).append("' in header value").toString(), this.fail$default$2());
                }
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    log.warning(new StringBuilder(36).append("Illegal character '").append(package$.MODULE$.escape(c2)).append("' in header value").toString());
                    stringBuilder = sb;
                } else if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                    stringBuilder = sb;
                } else {
                    throw new MatchError(illegalResponseHeaderValueProcessingMode);
                }
            }
            StringBuilder stringBuilder5 = nsb = stringBuilder;
            int n = nix;
            sb = stringBuilder5;
            ix = n;
        }
        throw this.fail(new StringBuilder(61).append("HTTP header value exceeds the configured limit of ").append(limit - start - 2).append(" characters").toString(), StatusCodes$.MODULE$.RequestHeaderFieldsTooLarge());
    }

    public StringBuilder org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$7(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return null;
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$8(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return start;
    }

    public Nothing$ fail(String summary, StatusCode status) {
        throw new ParsingException(status, ErrorInfo$.MODULE$.apply(summary, ErrorInfo$.MODULE$.apply$default$2()));
    }

    public StatusCode fail$default$2() {
        return StatusCodes$.MODULE$.BadRequest();
    }

    public char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private final void insertInGoodOrder$1(HttpHeaderParser parser$3, Seq items, int startIx, int endIx) {
        while (endIx - startIx > 0) {
            Serializable serializable;
            int pivot = (startIx + endIx) / 2;
            Object r = items.apply(pivot);
            if (r instanceof HttpHeaderParser.HeaderValueParser) {
                HttpHeaderParser.HeaderValueParser valueParser = (HttpHeaderParser.HeaderValueParser)r;
                String insertName = new StringBuilder(11).append(EnhancedString$.MODULE$.toRootLowerCase$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(valueParser.headerName()))).append(':').toString();
                if (parser$3.isEmpty()) {
                    ByteString byteString = ByteString$.MODULE$.apply(insertName);
                    parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(byteString, valueParser, parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(byteString, valueParser), parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(byteString, valueParser), parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(byteString, valueParser), parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(byteString, valueParser));
                    serializable = BoxedUnit.UNIT;
                } else {
                    ByteString byteString = ByteString$.MODULE$.apply(insertName);
                    parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(byteString, valueParser, parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(byteString, valueParser), parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(byteString, valueParser), parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(byteString, valueParser), parser$3.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(byteString, valueParser));
                    serializable = BoxedUnit.UNIT;
                }
            } else if (r instanceof String) {
                String header = (String)r;
                ByteString byteString = ByteString$.MODULE$.apply(new StringBuilder(3).append(header).append("\r\nx").toString());
                int n = parser$3.parseHeaderLine$default$2();
                serializable = BoxesRunTime.boxToInteger(parser$3.parseHeaderLine(byteString, n, parser$3.parseHeaderLine$default$3(byteString, n), parser$3.parseHeaderLine$default$4(byteString, n)));
            } else {
                throw new MatchError(r);
            }
            this.insertInGoodOrder$1(parser$3, items, startIx, pivot);
            startIx = pivot + 1;
        }
    }

    private final int insertInGoodOrder$default$2$1(Seq items) {
        return 0;
    }

    private final int insertInGoodOrder$default$3$1(Seq items) {
        return items.size();
    }

    private final StringBuilder appended$1(StringBuilder sb$tailLocal1$1, ByteString input$8, int start$2, int ix$tailLocal2$1, char c) {
        return (sb$tailLocal1$1 != null ? sb$tailLocal1$1 : new StringBuilder(package$.MODULE$.asciiString(input$8, start$2, ix$tailLocal2$1))).append(c);
    }

    private final StringBuilder appended2$1(StringBuilder sb$tailLocal1$2, ByteString input$9, int start$3, int ix$tailLocal2$2, int c) {
        if (c >> 16 != 0) {
            return this.appended$1(sb$tailLocal1$2, input$9, start$3, ix$tailLocal2$2, (char)c).append((char)(c >> 16));
        }
        return this.appended$1(sb$tailLocal1$2, input$9, start$3, ix$tailLocal2$2, (char)c);
    }
}

