/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.framing;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.http2.ByteFlag$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ContinuationFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$DataFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$HeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PingFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PriorityFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PushPromiseFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$RstStreamFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$Setting$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsAckFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$UnknownFrameEvent$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$WindowUpdateFrame$;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$Flags$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$SettingIdentifier$;
import org.apache.pekko.stream.impl.io.ByteStringParser;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class Http2FrameParsing$
implements Serializable {
    public static final Http2FrameParsing$ MODULE$ = new Http2FrameParsing$();

    private Http2FrameParsing$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Http2FrameParsing$.class);
    }

    public Seq<FrameEvent.Setting> readSettings(ByteStringParser.ByteReader payload, LoggingAdapter log) {
        return this.readSettings$1(payload, log, package$.MODULE$.Nil());
    }

    public FrameEvent parseFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteStringParser.ByteReader payload, LoggingAdapter log) {
        Product product;
        Http2Protocol.FrameType frameType = tpe;
        if (Http2Protocol$FrameType$GOAWAY$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireZeroStreamId(streamId);
            product = FrameEvent$GoAwayFrame$.MODULE$.apply(payload.readIntBE(), Http2Protocol$ErrorCode$.MODULE$.byId(payload.readIntBE()), payload.takeAll());
        } else if (Http2Protocol$FrameType$HEADERS$.MODULE$.equals(frameType)) {
            Option option;
            int paddingLength;
            boolean pad = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PADDED(), flags);
            boolean endStream = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), flags);
            boolean endHeaders = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), flags);
            boolean priority = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), flags);
            int n = paddingLength = pad ? payload.readByte() & 0xFF : 0;
            if (priority) {
                int dependencyAndE = payload.readIntBE();
                int weight = payload.readByte() & 0xFF;
                boolean exclusiveFlag = dependencyAndE >>> 31 == 1;
                int dependencyId = dependencyAndE & Integer.MAX_VALUE;
                Http2Compliance$.MODULE$.requireNoSelfDependency(streamId, dependencyId);
                option = Some$.MODULE$.apply(FrameEvent$PriorityFrame$.MODULE$.apply(streamId, exclusiveFlag, dependencyId, weight));
            } else {
                option = None$.MODULE$;
            }
            None$ priorityInfo = option;
            product = FrameEvent$HeadersFrame$.MODULE$.apply(streamId, endStream, endHeaders, payload.take(payload.remainingSize() - paddingLength), priorityInfo);
        } else if (Http2Protocol$FrameType$DATA$.MODULE$.equals(frameType)) {
            boolean pad = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PADDED(), flags);
            boolean endStream = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), flags);
            int paddingLength = pad ? payload.readByte() & 0xFF : 0;
            product = FrameEvent$DataFrame$.MODULE$.apply(streamId, endStream, payload.take(payload.remainingSize() - paddingLength));
        } else if (Http2Protocol$FrameType$SETTINGS$.MODULE$.equals(frameType)) {
            boolean ack = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), flags);
            Http2Compliance$.MODULE$.requireZeroStreamId(streamId);
            if (ack) {
                if (payload.hasRemaining()) {
                    throw new Http2Compliance.IllegalPayloadInSettingsAckFrame(payload.remainingSize(), "SETTINGS ACK frame MUST NOT contain payload (spec 6.5)!");
                }
                product = FrameEvent$SettingsAckFrame$.MODULE$.apply(package$.MODULE$.Nil());
            } else {
                if (payload.remainingSize() % 6 != 0) {
                    throw new Http2Compliance.IllegalPayloadLengthInSettingsFrame(payload.remainingSize(), "SETTINGS payload MUST be a multiple of multiple of 6 octets");
                }
                product = FrameEvent$SettingsFrame$.MODULE$.apply(this.readSettings(payload, log));
            }
        } else if (Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$.equals(frameType)) {
            int increment = payload.readIntBE();
            Http2Compliance$.MODULE$.requirePositiveWindowUpdateIncrement(streamId, increment);
            product = FrameEvent$WindowUpdateFrame$.MODULE$.apply(streamId, increment);
        } else if (Http2Protocol$FrameType$CONTINUATION$.MODULE$.equals(frameType)) {
            boolean endHeaders = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), flags);
            product = FrameEvent$ContinuationFrame$.MODULE$.apply(streamId, endHeaders, payload.remainingData());
        } else if (Http2Protocol$FrameType$PING$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireFrameSize(payload.remainingSize(), 8);
            Http2Compliance$.MODULE$.requireZeroStreamId(streamId);
            boolean ack = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), flags);
            product = FrameEvent$PingFrame$.MODULE$.apply(ack, payload.remainingData());
        } else if (Http2Protocol$FrameType$RST_STREAM$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireFrameSize(payload.remainingSize(), 4);
            Http2Compliance$.MODULE$.requireNonZeroStreamId(streamId);
            product = FrameEvent$RstStreamFrame$.MODULE$.apply(streamId, Http2Protocol$ErrorCode$.MODULE$.byId(payload.readIntBE()));
        } else if (Http2Protocol$FrameType$PRIORITY$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireFrameSize(payload.remainingSize(), 5);
            int streamDependency = payload.readIntBE();
            boolean exclusiveFlag = streamDependency >>> 31 == 1;
            int dependencyId = streamDependency & Integer.MAX_VALUE;
            int priority = payload.readByte() & 0xFF;
            Http2Compliance$.MODULE$.requireNoSelfDependency(streamId, dependencyId);
            product = FrameEvent$PriorityFrame$.MODULE$.apply(streamId, exclusiveFlag, dependencyId, priority);
        } else if (Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$.equals(frameType)) {
            boolean pad = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PADDED(), flags);
            boolean endHeaders = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), flags);
            int paddingLength = pad ? payload.readByte() & 0xFF : 0;
            int promisedStreamId = payload.readIntBE();
            product = FrameEvent$PushPromiseFrame$.MODULE$.apply(streamId, endHeaders, promisedStreamId, payload.take(payload.remainingSize() - paddingLength));
        } else {
            Http2Protocol.FrameType tpe2 = frameType;
            product = FrameEvent$UnknownFrameEvent$.MODULE$.apply(tpe2, flags, streamId, payload.remainingData());
        }
        return product;
    }

    private final Seq readSettings$1(ByteStringParser.ByteReader payload$1, LoggingAdapter log$1, List read) {
        while (payload$1.hasRemaining()) {
            List read0;
            List list;
            int id = payload$1.readShortBE();
            int value = payload$1.readIntBE();
            Http2Protocol.SettingIdentifier settingIdentifier = Http2Protocol$SettingIdentifier$.MODULE$.byId(id);
            Http2Protocol.SettingIdentifier settingIdentifier2 = (Http2Protocol.SettingIdentifier)OptionVal$Some$.MODULE$.unapply(settingIdentifier);
            if (!OptionVal$.MODULE$.isEmpty$extension(settingIdentifier2)) {
                Http2Protocol.SettingIdentifier settingIdentifier3;
                Http2Protocol.SettingIdentifier s2 = settingIdentifier3 = (Http2Protocol.SettingIdentifier)OptionVal$.MODULE$.get$extension(settingIdentifier2);
                FrameEvent.Setting setting = FrameEvent$Setting$.MODULE$.apply(s2, value);
                list = read.$colon$colon(setting);
            } else {
                OptionVal$.MODULE$.None();
                Http2Protocol.SettingIdentifier settingIdentifier4 = settingIdentifier;
                if (!(null != null ? !((Object)null).equals(settingIdentifier4) : settingIdentifier4 != null)) {
                    log$1.debug("Ignoring unknown setting identifier {}", BoxesRunTime.boxToInteger(id));
                    list = read;
                } else {
                    throw new MatchError(new OptionVal<Http2Protocol.SettingIdentifier>(settingIdentifier));
                }
            }
            read = read0 = list;
        }
        return read.reverse();
    }
}

